/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

import com.google.common.cache.CacheLoader;
import de.fhlintstone.accessors.model.BackboneElementAccessorR5;
import de.fhlintstone.accessors.model.BackboneTypeAccessorR5;
import de.fhlintstone.accessors.model.BaseAccessorR5;
import de.fhlintstone.accessors.model.CanonicalResourceAccessorR5;
import de.fhlintstone.accessors.model.CanonicalTypeAccessorR5;
import de.fhlintstone.accessors.model.CodeSystemAccessorR5;
import de.fhlintstone.accessors.model.ConceptDefinitionComponentAccessorR5;
import de.fhlintstone.accessors.model.ConceptPropertyComponentAccessorR5;
import de.fhlintstone.accessors.model.ConceptReferenceComponentAccessorR5;
import de.fhlintstone.accessors.model.ConceptSetComponentAccessorR5;
import de.fhlintstone.accessors.model.ConceptSetFilterComponentAccessorR5;
import de.fhlintstone.accessors.model.DomainResourceAccessorR5;
import de.fhlintstone.accessors.model.ElementAccessorR5;
import de.fhlintstone.accessors.model.ElementDefinitionAccessorR5;
import de.fhlintstone.accessors.model.ElementDefinitionBindingComponentAccessorR5;
import de.fhlintstone.accessors.model.ElementTypeRefComponentAccessorR5;
import de.fhlintstone.accessors.model.ExtensionAccessorR5;
import de.fhlintstone.accessors.model.MetadataResourceAccessorR5;
import de.fhlintstone.accessors.model.PrimitiveTypeAccessorR5;
import de.fhlintstone.accessors.model.PropertyAccessorR5;
import de.fhlintstone.accessors.model.ResourceAccessorR5;
import de.fhlintstone.accessors.model.StructureDefinitionAccessorR5;
import de.fhlintstone.accessors.model.StructureDefinitionDifferentialComponentAccessorR5;
import de.fhlintstone.accessors.model.StructureDefinitionSnapshotComponentAccessorR5;
import de.fhlintstone.accessors.model.TypeAccessorR5;
import de.fhlintstone.accessors.model.UriTypeAccessorR5;
import de.fhlintstone.accessors.model.ValueSetAccessorR5;
import de.fhlintstone.accessors.model.ValueSetComposeComponentAccessorR5;
import lombok.extern.slf4j.XSlf4j;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeSystem.ConceptDefinitionComponent;
import org.hl7.fhir.r5.model.CodeSystem.ConceptPropertyComponent;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ElementDefinition.ElementDefinitionBindingComponent;
import org.hl7.fhir.r5.model.ElementDefinition.TypeRefComponent;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureDefinition.StructureDefinitionDifferentialComponent;
import org.hl7.fhir.r5.model.StructureDefinition.StructureDefinitionSnapshotComponent;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.ValueSet.ConceptReferenceComponent;
import org.hl7.fhir.r5.model.ValueSet.ConceptSetComponent;
import org.hl7.fhir.r5.model.ValueSet.ConceptSetFilterComponent;
import org.hl7.fhir.r5.model.ValueSet.ValueSetComposeComponent;

/**
 * Implementation of {@link IAccessorCache} for FHIR release 5.
 */
@XSlf4j
public class AccessorCacheR5 extends AccessorCache {

    /** Create a new instance of AccessorCacheR5 */
    public AccessorCacheR5() {
        super();
    }

    @Override
    protected CacheLoader<Object, IAccessor> provideCacheLoader() {
        return new CacheLoader<Object, IAccessor>() {
            @Override
            @SuppressWarnings("java:S1541") // the method can not be split without impairing the readability
            public IAccessor load(Object key) throws Exception {
                logger.entry(key);
                final var result =
                        switch (key) {
                            case final Property castKey -> new PropertyAccessorR5(AccessorCacheR5.this, castKey);

                            case final CodeSystem castKey -> new CodeSystemAccessorR5(AccessorCacheR5.this, castKey);
                            case final StructureDefinition castKey -> new StructureDefinitionAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ValueSet castKey -> new ValueSetAccessorR5(AccessorCacheR5.this, castKey);

                            case final MetadataResource castKey -> new MetadataResourceAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final CanonicalResource castKey -> new CanonicalResourceAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final DomainResource castKey -> new DomainResourceAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final Resource castKey -> new ResourceAccessorR5(AccessorCacheR5.this, castKey);

                            case final ConceptDefinitionComponent castKey -> new ConceptDefinitionComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ConceptPropertyComponent castKey -> new ConceptPropertyComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ConceptReferenceComponent castKey -> new ConceptReferenceComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ConceptSetComponent castKey -> new ConceptSetComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ConceptSetFilterComponent castKey -> new ConceptSetFilterComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final StructureDefinitionDifferentialComponent
                            castKey -> new StructureDefinitionDifferentialComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final StructureDefinitionSnapshotComponent
                            castKey -> new StructureDefinitionSnapshotComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ValueSetComposeComponent castKey -> new ValueSetComposeComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);

                            case final BackboneElement castKey -> new BackboneElementAccessorR5(
                                    AccessorCacheR5.this, castKey);

                            case final ElementDefinition castKey -> new ElementDefinitionAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final ElementDefinitionBindingComponent
                            castKey -> new ElementDefinitionBindingComponentAccessorR5(AccessorCacheR5.this, castKey);
                            case final TypeRefComponent castKey -> new ElementTypeRefComponentAccessorR5(
                                    AccessorCacheR5.this, castKey);

                            case final BackboneType castKey -> new BackboneTypeAccessorR5(
                                    AccessorCacheR5.this, castKey);

                            case final Extension castKey -> new ExtensionAccessorR5(AccessorCacheR5.this, castKey);

                            case final CanonicalType castKey -> new CanonicalTypeAccessorR5(
                                    AccessorCacheR5.this, castKey);
                            case final UriType castKey -> new UriTypeAccessorR5(AccessorCacheR5.this, castKey);
                            case final PrimitiveType<?> castKey -> new PrimitiveTypeAccessorR5<>(
                                    AccessorCacheR5.this, castKey);
                            case final DataType castKey -> new TypeAccessorR5(AccessorCacheR5.this, castKey);

                            case final Element castKey -> new ElementAccessorR5(AccessorCacheR5.this, castKey);
                            case final Base castKey -> new BaseAccessorR5(AccessorCacheR5.this, castKey);

                            default -> throw logger.throwing(UnsupportedTypeException.forObjectType(key));
                        };
                return logger.exit(result);
            }
        };
    }
}
