/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

import com.google.common.cache.CacheLoader;
import de.fhlintstone.accessors.model.BackboneElementAccessorR4B;
import de.fhlintstone.accessors.model.BackboneTypeAccessorR4B;
import de.fhlintstone.accessors.model.BaseAccessorR4B;
import de.fhlintstone.accessors.model.CanonicalResourceAccessorR4B;
import de.fhlintstone.accessors.model.CanonicalTypeAccessorR4B;
import de.fhlintstone.accessors.model.CodeSystemAccessorR4B;
import de.fhlintstone.accessors.model.ConceptDefinitionComponentAccessorR4B;
import de.fhlintstone.accessors.model.ConceptPropertyComponentAccessorR4B;
import de.fhlintstone.accessors.model.ConceptReferenceComponentAccessorR4B;
import de.fhlintstone.accessors.model.ConceptSetComponentAccessorR4B;
import de.fhlintstone.accessors.model.ConceptSetFilterComponentAccessorR4B;
import de.fhlintstone.accessors.model.DomainResourceAccessorR4B;
import de.fhlintstone.accessors.model.ElementAccessorR4B;
import de.fhlintstone.accessors.model.ElementDefinitionAccessorR4B;
import de.fhlintstone.accessors.model.ElementDefinitionBindingComponentAccessorR4B;
import de.fhlintstone.accessors.model.ElementTypeRefComponentAccessorR4B;
import de.fhlintstone.accessors.model.ExtensionAccessorR4B;
import de.fhlintstone.accessors.model.PrimitiveTypeAccessorR4B;
import de.fhlintstone.accessors.model.PropertyAccessorR4B;
import de.fhlintstone.accessors.model.ResourceAccessorR4B;
import de.fhlintstone.accessors.model.StructureDefinitionAccessorR4B;
import de.fhlintstone.accessors.model.StructureDefinitionDifferentialComponentAccessorR4B;
import de.fhlintstone.accessors.model.StructureDefinitionSnapshotComponentAccessorR4B;
import de.fhlintstone.accessors.model.TypeAccessorR4B;
import de.fhlintstone.accessors.model.UriTypeAccessorR4B;
import de.fhlintstone.accessors.model.ValueSetAccessorR4B;
import de.fhlintstone.accessors.model.ValueSetComposeComponentAccessorR4B;
import lombok.extern.slf4j.XSlf4j;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.BackboneType;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.CanonicalType;
import org.hl7.fhir.r4b.model.CodeSystem;
import org.hl7.fhir.r4b.model.CodeSystem.ConceptDefinitionComponent;
import org.hl7.fhir.r4b.model.CodeSystem.ConceptPropertyComponent;
import org.hl7.fhir.r4b.model.DataType;
import org.hl7.fhir.r4b.model.DomainResource;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.ElementDefinition.ElementDefinitionBindingComponent;
import org.hl7.fhir.r4b.model.ElementDefinition.TypeRefComponent;
import org.hl7.fhir.r4b.model.Extension;
import org.hl7.fhir.r4b.model.PrimitiveType;
import org.hl7.fhir.r4b.model.Property;
import org.hl7.fhir.r4b.model.Resource;
import org.hl7.fhir.r4b.model.StructureDefinition;
import org.hl7.fhir.r4b.model.StructureDefinition.StructureDefinitionDifferentialComponent;
import org.hl7.fhir.r4b.model.StructureDefinition.StructureDefinitionSnapshotComponent;
import org.hl7.fhir.r4b.model.UriType;
import org.hl7.fhir.r4b.model.ValueSet;
import org.hl7.fhir.r4b.model.ValueSet.ConceptReferenceComponent;
import org.hl7.fhir.r4b.model.ValueSet.ConceptSetComponent;
import org.hl7.fhir.r4b.model.ValueSet.ConceptSetFilterComponent;
import org.hl7.fhir.r4b.model.ValueSet.ValueSetComposeComponent;

/**
 * Implementation of {@link IAccessorCache} for FHIR release 4B.
 */
@XSlf4j
public class AccessorCacheR4B extends AccessorCache {

    /** Create a new instance of AccessorCacheR4B */
    public AccessorCacheR4B() {
        super();
    }

    @Override
    protected CacheLoader<Object, IAccessor> provideCacheLoader() {
        return new CacheLoader<Object, IAccessor>() {
            @Override
            @SuppressWarnings("java:S1541") // the method can not be split without impairing the readability
            public IAccessor load(Object key) throws Exception {
                logger.entry(key);
                final var result =
                        switch (key) {
                            case final Property castKey -> new PropertyAccessorR4B(AccessorCacheR4B.this, castKey);

                            case final CodeSystem castKey -> new CodeSystemAccessorR4B(AccessorCacheR4B.this, castKey);
                            case final StructureDefinition castKey -> new StructureDefinitionAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ValueSet castKey -> new ValueSetAccessorR4B(AccessorCacheR4B.this, castKey);

                                // MetadataResource does not have any subclasses in R4B
                            case final CanonicalResource castKey -> new CanonicalResourceAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final DomainResource castKey -> new DomainResourceAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final Resource castKey -> new ResourceAccessorR4B(AccessorCacheR4B.this, castKey);

                            case final ConceptDefinitionComponent castKey -> new ConceptDefinitionComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ConceptPropertyComponent castKey -> new ConceptPropertyComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ConceptReferenceComponent castKey -> new ConceptReferenceComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ConceptSetComponent castKey -> new ConceptSetComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ConceptSetFilterComponent castKey -> new ConceptSetFilterComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final StructureDefinitionDifferentialComponent
                            castKey -> new StructureDefinitionDifferentialComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final StructureDefinitionSnapshotComponent
                            castKey -> new StructureDefinitionSnapshotComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ValueSetComposeComponent castKey -> new ValueSetComposeComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);

                            case final BackboneElement castKey -> new BackboneElementAccessorR4B(
                                    AccessorCacheR4B.this, castKey);

                            case final ElementDefinition castKey -> new ElementDefinitionAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final ElementDefinitionBindingComponent
                            castKey -> new ElementDefinitionBindingComponentAccessorR4B(AccessorCacheR4B.this, castKey);
                            case final TypeRefComponent castKey -> new ElementTypeRefComponentAccessorR4B(
                                    AccessorCacheR4B.this, castKey);

                            case final BackboneType castKey -> new BackboneTypeAccessorR4B(
                                    AccessorCacheR4B.this, castKey);

                            case final Extension castKey -> new ExtensionAccessorR4B(AccessorCacheR4B.this, castKey);

                            case final CanonicalType castKey -> new CanonicalTypeAccessorR4B(
                                    AccessorCacheR4B.this, castKey);
                            case final UriType castKey -> new UriTypeAccessorR4B(AccessorCacheR4B.this, castKey);
                            case final PrimitiveType<?> castKey -> new PrimitiveTypeAccessorR4B<>(
                                    AccessorCacheR4B.this, castKey);
                            case final DataType castKey -> new TypeAccessorR4B(AccessorCacheR4B.this, castKey);

                            case final Element castKey -> new ElementAccessorR4B(AccessorCacheR4B.this, castKey);
                            case final Base castKey -> new BaseAccessorR4B(AccessorCacheR4B.this, castKey);

                            default -> throw logger.throwing(UnsupportedTypeException.forObjectType(key));
                        };
                return logger.exit(result);
            }
        };
    }
}
