/*
 *
 * Fhlintstone FHIR implementation generator
 *
 * Copyright (C) 2025 Fhlintstone authors and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */
package de.fhlintstone.accessors;

import com.google.common.cache.CacheLoader;
import de.fhlintstone.accessors.model.BackboneElementAccessorR4;
import de.fhlintstone.accessors.model.BackboneTypeAccessorR4;
import de.fhlintstone.accessors.model.BaseAccessorR4;
import de.fhlintstone.accessors.model.CanonicalTypeAccessorR4;
import de.fhlintstone.accessors.model.CodeSystemAccessorR4;
import de.fhlintstone.accessors.model.ConceptDefinitionComponentAccessorR4;
import de.fhlintstone.accessors.model.ConceptPropertyComponentAccessorR4;
import de.fhlintstone.accessors.model.ConceptReferenceComponentAccessorR4;
import de.fhlintstone.accessors.model.ConceptSetComponentAccessorR4;
import de.fhlintstone.accessors.model.ConceptSetFilterComponentAccessorR4;
import de.fhlintstone.accessors.model.DomainResourceAccessorR4;
import de.fhlintstone.accessors.model.ElementAccessorR4;
import de.fhlintstone.accessors.model.ElementDefinitionAccessorR4;
import de.fhlintstone.accessors.model.ElementDefinitionBindingComponentAccessorR4;
import de.fhlintstone.accessors.model.ElementTypeRefComponentAccessorR4;
import de.fhlintstone.accessors.model.ExtensionAccessorR4;
import de.fhlintstone.accessors.model.MetadataResourceAccessorR4;
import de.fhlintstone.accessors.model.PrimitiveTypeAccessorR4;
import de.fhlintstone.accessors.model.PropertyAccessorR4;
import de.fhlintstone.accessors.model.ResourceAccessorR4;
import de.fhlintstone.accessors.model.StructureDefinitionAccessorR4;
import de.fhlintstone.accessors.model.StructureDefinitionDifferentialComponentAccessorR4;
import de.fhlintstone.accessors.model.StructureDefinitionSnapshotComponentAccessorR4;
import de.fhlintstone.accessors.model.TypeAccessorR4;
import de.fhlintstone.accessors.model.UriTypeAccessorR4;
import de.fhlintstone.accessors.model.ValueSetAccessorR4;
import de.fhlintstone.accessors.model.ValueSetComposeComponentAccessorR4;
import lombok.extern.slf4j.XSlf4j;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeSystem.ConceptDefinitionComponent;
import org.hl7.fhir.r4.model.CodeSystem.ConceptPropertyComponent;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.ElementDefinition.ElementDefinitionBindingComponent;
import org.hl7.fhir.r4.model.ElementDefinition.TypeRefComponent;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureDefinition.StructureDefinitionDifferentialComponent;
import org.hl7.fhir.r4.model.StructureDefinition.StructureDefinitionSnapshotComponent;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.ValueSet.ConceptReferenceComponent;
import org.hl7.fhir.r4.model.ValueSet.ConceptSetComponent;
import org.hl7.fhir.r4.model.ValueSet.ConceptSetFilterComponent;
import org.hl7.fhir.r4.model.ValueSet.ValueSetComposeComponent;

/**
 * Implementation of {@link IAccessorCache} for FHIR release 4.
 */
@XSlf4j
public class AccessorCacheR4 extends AccessorCache {

    /** Create a new instance of AccessorCacheR4 */
    public AccessorCacheR4() {
        super();
    }

    @Override
    protected CacheLoader<Object, IAccessor> provideCacheLoader() {
        return new CacheLoader<Object, IAccessor>() {
            @Override
            @SuppressWarnings("java:S1541") // the method can not be split without impairing the readability
            public IAccessor load(Object key) throws Exception {
                logger.entry(key);
                final var result =
                        switch (key) {
                            case final Property castKey -> new PropertyAccessorR4(AccessorCacheR4.this, castKey);

                            case final CodeSystem castKey -> new CodeSystemAccessorR4(AccessorCacheR4.this, castKey);
                            case final StructureDefinition castKey -> new StructureDefinitionAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ValueSet castKey -> new ValueSetAccessorR4(AccessorCacheR4.this, castKey);

                                // CanonicalResource does not exist in R4
                            case final MetadataResource castKey -> new MetadataResourceAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final DomainResource castKey -> new DomainResourceAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final Resource castKey -> new ResourceAccessorR4(AccessorCacheR4.this, castKey);

                            case final ConceptDefinitionComponent castKey -> new ConceptDefinitionComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ConceptPropertyComponent castKey -> new ConceptPropertyComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ConceptReferenceComponent castKey -> new ConceptReferenceComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ConceptSetComponent castKey -> new ConceptSetComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ConceptSetFilterComponent castKey -> new ConceptSetFilterComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final StructureDefinitionDifferentialComponent
                            castKey -> new StructureDefinitionDifferentialComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final StructureDefinitionSnapshotComponent
                            castKey -> new StructureDefinitionSnapshotComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ValueSetComposeComponent castKey -> new ValueSetComposeComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);

                            case final BackboneElement castKey -> new BackboneElementAccessorR4(
                                    AccessorCacheR4.this, castKey);

                            case final ElementDefinition castKey -> new ElementDefinitionAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final ElementDefinitionBindingComponent
                            castKey -> new ElementDefinitionBindingComponentAccessorR4(AccessorCacheR4.this, castKey);
                            case final TypeRefComponent castKey -> new ElementTypeRefComponentAccessorR4(
                                    AccessorCacheR4.this, castKey);

                            case final BackboneType castKey -> new BackboneTypeAccessorR4(
                                    AccessorCacheR4.this, castKey);

                            case final Extension castKey -> new ExtensionAccessorR4(AccessorCacheR4.this, castKey);

                            case final CanonicalType castKey -> new CanonicalTypeAccessorR4(
                                    AccessorCacheR4.this, castKey);
                            case final UriType castKey -> new UriTypeAccessorR4(AccessorCacheR4.this, castKey);
                            case final PrimitiveType<?> castKey -> new PrimitiveTypeAccessorR4<>(
                                    AccessorCacheR4.this, castKey);
                            case final Type castKey -> new TypeAccessorR4(AccessorCacheR4.this, castKey);

                            case final Element castKey -> new ElementAccessorR4(AccessorCacheR4.this, castKey);
                            case final Base castKey -> new BaseAccessorR4(AccessorCacheR4.this, castKey);

                            default -> throw logger.throwing(UnsupportedTypeException.forObjectType(key));
                        };
                return logger.exit(result);
            }
        };
    }
}
