/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.process.config;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.collect.ImmutableList;
import de.fhlintstone.process.config.PackageSourceConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import de.fhlintstone.process.config.ValueSetEnumConfiguration;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public final class ProcessConfiguration {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ProcessConfiguration.class);
    private final FhirVersionEnum fhirVersion;
    private final String outputPath;
    private final Optional<String> defaultNamespace;
    private final ImmutableList<PackageSourceConfiguration> packageSources;
    private final ImmutableList<ValueSetEnumConfiguration> valueSetEnums;
    private final ImmutableList<StructureDefinitionClassConfiguration> structureDefinitionClasses;

    public Optional<StructureDefinitionClassConfiguration> getStructureDefinition(URI structureDefinitionURI) {
        logger.entry(new Object[]{structureDefinitionURI});
        return (Optional)logger.exit(this.structureDefinitionClasses.stream().filter(c -> c.getStructureDefinition().equals(structureDefinitionURI)).findAny());
    }

    @Generated
    private static Optional<String> $default$defaultNamespace() {
        return Optional.empty();
    }

    @Generated
    ProcessConfiguration(FhirVersionEnum fhirVersion, String outputPath, Optional<String> defaultNamespace, ImmutableList<PackageSourceConfiguration> packageSources, ImmutableList<ValueSetEnumConfiguration> valueSetEnums, ImmutableList<StructureDefinitionClassConfiguration> structureDefinitionClasses) {
        this.fhirVersion = fhirVersion;
        this.outputPath = outputPath;
        this.defaultNamespace = defaultNamespace;
        this.packageSources = packageSources;
        this.valueSetEnums = valueSetEnums;
        this.structureDefinitionClasses = structureDefinitionClasses;
    }

    @Generated
    public static ProcessConfigurationBuilder builder() {
        return new ProcessConfigurationBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProcessConfiguration)) {
            return false;
        }
        ProcessConfiguration other = (ProcessConfiguration)o;
        FhirVersionEnum this$fhirVersion = this.getFhirVersion();
        FhirVersionEnum other$fhirVersion = other.getFhirVersion();
        if (this$fhirVersion == null ? other$fhirVersion != null : !this$fhirVersion.equals(other$fhirVersion)) {
            return false;
        }
        String this$outputPath = this.getOutputPath();
        String other$outputPath = other.getOutputPath();
        if (this$outputPath == null ? other$outputPath != null : !this$outputPath.equals(other$outputPath)) {
            return false;
        }
        Optional<String> this$defaultNamespace = this.getDefaultNamespace();
        Optional<String> other$defaultNamespace = other.getDefaultNamespace();
        if (this$defaultNamespace == null ? other$defaultNamespace != null : !((Object)this$defaultNamespace).equals(other$defaultNamespace)) {
            return false;
        }
        ImmutableList<PackageSourceConfiguration> this$packageSources = this.getPackageSources();
        ImmutableList<PackageSourceConfiguration> other$packageSources = other.getPackageSources();
        if (this$packageSources == null ? other$packageSources != null : !this$packageSources.equals(other$packageSources)) {
            return false;
        }
        ImmutableList<ValueSetEnumConfiguration> this$valueSetEnums = this.getValueSetEnums();
        ImmutableList<ValueSetEnumConfiguration> other$valueSetEnums = other.getValueSetEnums();
        if (this$valueSetEnums == null ? other$valueSetEnums != null : !this$valueSetEnums.equals(other$valueSetEnums)) {
            return false;
        }
        ImmutableList<StructureDefinitionClassConfiguration> this$structureDefinitionClasses = this.getStructureDefinitionClasses();
        ImmutableList<StructureDefinitionClassConfiguration> other$structureDefinitionClasses = other.getStructureDefinitionClasses();
        return !(this$structureDefinitionClasses == null ? other$structureDefinitionClasses != null : !this$structureDefinitionClasses.equals(other$structureDefinitionClasses));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FhirVersionEnum $fhirVersion = this.getFhirVersion();
        result = result * 59 + ($fhirVersion == null ? 43 : $fhirVersion.hashCode());
        String $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : $outputPath.hashCode());
        Optional<String> $defaultNamespace = this.getDefaultNamespace();
        result = result * 59 + ($defaultNamespace == null ? 43 : ((Object)$defaultNamespace).hashCode());
        ImmutableList<PackageSourceConfiguration> $packageSources = this.getPackageSources();
        result = result * 59 + ($packageSources == null ? 43 : $packageSources.hashCode());
        ImmutableList<ValueSetEnumConfiguration> $valueSetEnums = this.getValueSetEnums();
        result = result * 59 + ($valueSetEnums == null ? 43 : $valueSetEnums.hashCode());
        ImmutableList<StructureDefinitionClassConfiguration> $structureDefinitionClasses = this.getStructureDefinitionClasses();
        result = result * 59 + ($structureDefinitionClasses == null ? 43 : $structureDefinitionClasses.hashCode());
        return result;
    }

    @Generated
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Generated
    public String getOutputPath() {
        return this.outputPath;
    }

    @Generated
    public Optional<String> getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Generated
    public ImmutableList<PackageSourceConfiguration> getPackageSources() {
        return this.packageSources;
    }

    @Generated
    public ImmutableList<ValueSetEnumConfiguration> getValueSetEnums() {
        return this.valueSetEnums;
    }

    @Generated
    public ImmutableList<StructureDefinitionClassConfiguration> getStructureDefinitionClasses() {
        return this.structureDefinitionClasses;
    }

    @Generated
    public static class ProcessConfigurationBuilder {
        @Generated
        private FhirVersionEnum fhirVersion;
        @Generated
        private String outputPath;
        @Generated
        private boolean defaultNamespace$set;
        @Generated
        private Optional<String> defaultNamespace$value;
        @Generated
        private ImmutableList.Builder<PackageSourceConfiguration> packageSources;
        @Generated
        private ImmutableList.Builder<ValueSetEnumConfiguration> valueSetEnums;
        @Generated
        private ImmutableList.Builder<StructureDefinitionClassConfiguration> structureDefinitionClasses;

        @Generated
        ProcessConfigurationBuilder() {
        }

        @Generated
        public ProcessConfigurationBuilder withFhirVersion(FhirVersionEnum fhirVersion) {
            this.fhirVersion = fhirVersion;
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withOutputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withDefaultNamespace(Optional<String> defaultNamespace) {
            this.defaultNamespace$value = defaultNamespace;
            this.defaultNamespace$set = true;
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withPackageSource(PackageSourceConfiguration packageSource) {
            if (this.packageSources == null) {
                this.packageSources = ImmutableList.builder();
            }
            this.packageSources.add((Object)packageSource);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withPackageSources(Iterable<? extends PackageSourceConfiguration> packageSources) {
            if (packageSources == null) {
                throw new NullPointerException("packageSources cannot be null");
            }
            if (this.packageSources == null) {
                this.packageSources = ImmutableList.builder();
            }
            this.packageSources.addAll(packageSources);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder clearPackageSources() {
            this.packageSources = null;
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withValueSetEnum(ValueSetEnumConfiguration valueSetEnum) {
            if (this.valueSetEnums == null) {
                this.valueSetEnums = ImmutableList.builder();
            }
            this.valueSetEnums.add((Object)valueSetEnum);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withValueSetEnums(Iterable<? extends ValueSetEnumConfiguration> valueSetEnums) {
            if (valueSetEnums == null) {
                throw new NullPointerException("valueSetEnums cannot be null");
            }
            if (this.valueSetEnums == null) {
                this.valueSetEnums = ImmutableList.builder();
            }
            this.valueSetEnums.addAll(valueSetEnums);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder clearValueSetEnums() {
            this.valueSetEnums = null;
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withStructureDefinitionClass(StructureDefinitionClassConfiguration structureDefinitionClass) {
            if (this.structureDefinitionClasses == null) {
                this.structureDefinitionClasses = ImmutableList.builder();
            }
            this.structureDefinitionClasses.add((Object)structureDefinitionClass);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder withStructureDefinitionClasses(Iterable<? extends StructureDefinitionClassConfiguration> structureDefinitionClasses) {
            if (structureDefinitionClasses == null) {
                throw new NullPointerException("structureDefinitionClasses cannot be null");
            }
            if (this.structureDefinitionClasses == null) {
                this.structureDefinitionClasses = ImmutableList.builder();
            }
            this.structureDefinitionClasses.addAll(structureDefinitionClasses);
            return this;
        }

        @Generated
        public ProcessConfigurationBuilder clearStructureDefinitionClasses() {
            this.structureDefinitionClasses = null;
            return this;
        }

        @Generated
        public ProcessConfiguration build() {
            ImmutableList packageSources = this.packageSources == null ? ImmutableList.of() : this.packageSources.build();
            ImmutableList valueSetEnums = this.valueSetEnums == null ? ImmutableList.of() : this.valueSetEnums.build();
            ImmutableList structureDefinitionClasses = this.structureDefinitionClasses == null ? ImmutableList.of() : this.structureDefinitionClasses.build();
            Optional<String> defaultNamespace$value = this.defaultNamespace$value;
            if (!this.defaultNamespace$set) {
                defaultNamespace$value = ProcessConfiguration.$default$defaultNamespace();
            }
            return new ProcessConfiguration(this.fhirVersion, this.outputPath, defaultNamespace$value, (ImmutableList<PackageSourceConfiguration>)packageSources, (ImmutableList<ValueSetEnumConfiguration>)valueSetEnums, (ImmutableList<StructureDefinitionClassConfiguration>)structureDefinitionClasses);
        }

        @Generated
        public String toString() {
            return "ProcessConfiguration.ProcessConfigurationBuilder(fhirVersion=" + String.valueOf(this.fhirVersion) + ", outputPath=" + this.outputPath + ", defaultNamespace$value=" + String.valueOf(this.defaultNamespace$value) + ", packageSources=" + String.valueOf(this.packageSources) + ", valueSetEnums=" + String.valueOf(this.valueSetEnums) + ", structureDefinitionClasses=" + String.valueOf(this.structureDefinitionClasses) + ")";
        }
    }
}

