/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.process;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.fhlintstone.accessors.UnsupportedFHIRVersionException;
import de.fhlintstone.fhir.dependencies.DependencyException;
import de.fhlintstone.fhir.dependencies.IDependency;
import de.fhlintstone.fhir.dependencies.IDependencyGraph;
import de.fhlintstone.fhir.dependencies.IDependencyGraphBuilder;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.IGeneratedTypeNameRegistry;
import de.fhlintstone.generator.structuredefinition.IStructureDefinitionGenerator;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformation;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformationBuilder;
import de.fhlintstone.generator.valueset.IValueSetGenerator;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import de.fhlintstone.packages.PackageFileException;
import de.fhlintstone.process.IContextProvider;
import de.fhlintstone.process.IProcessor;
import de.fhlintstone.process.ProcessException;
import de.fhlintstone.process.config.PackageSourceConfiguration;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import de.fhlintstone.process.config.ValueSetEnumConfiguration;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class Processor
implements IProcessor {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(Processor.class);
    private final IContextProvider contextProvider;
    private final IPackageRegistry packageRegistry;
    private final IDependencyGraphBuilder dependencyGraphBuilder;
    private final IGeneratedTypeNameRegistry generatedTypeNameRegistry;
    private final IValueSetGenerator valueSetGenerator;
    private final ITypeInformationBuilder typeInformationBuilder;
    private final IStructureDefinitionGenerator structureDefinitionGenerator;

    @Inject
    public Processor(IContextProvider contextProvider, IPackageRegistry packageRegistry, IDependencyGraphBuilder dependencyGraphBuilder, IGeneratedTypeNameRegistry generatedTypeNameRegistry, IValueSetGenerator valueSetGenerator, ITypeInformationBuilder typeInformationBuilder, IStructureDefinitionGenerator structureDefinitionGenerator) {
        this.contextProvider = contextProvider;
        this.packageRegistry = packageRegistry;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
        this.generatedTypeNameRegistry = generatedTypeNameRegistry;
        this.valueSetGenerator = valueSetGenerator;
        this.typeInformationBuilder = typeInformationBuilder;
        this.structureDefinitionGenerator = structureDefinitionGenerator;
    }

    @Override
    public void execute(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        this.configureFhirVersion(configuration);
        this.registerPackages(configuration);
        this.generateTypeNames(configuration);
        IDependencyGraph dependencyGraph = this.checkDependencies(configuration);
        this.generateEnums(configuration);
        this.generateClasses(configuration, dependencyGraph);
        logger.exit();
    }

    private void configureFhirVersion(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        FhirVersionEnum fhirVersion = configuration.getFhirVersion();
        if (fhirVersion == null) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException("FHIR version is not configured"));
        }
        switch (fhirVersion) {
            case R4: 
            case R4B: 
            case R5: {
                logger.debug("Using FHIR version {}", (Object)fhirVersion);
                this.contextProvider.setFhirVersion(fhirVersion);
                break;
            }
            default: {
                throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
            }
        }
        logger.exit();
    }

    private void registerPackages(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        ImmutableList<PackageSourceConfiguration> packageSources = configuration.getPackageSources();
        if (packageSources.isEmpty()) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException("No source packages have been specified"));
        }
        this.packageRegistry.clear();
        for (PackageSourceConfiguration packageSource : packageSources) {
            Optional<File> sourceFile = packageSource.getSourceFile();
            if (sourceFile.isPresent()) {
                try {
                    this.packageRegistry.register(sourceFile.get());
                    continue;
                }
                catch (PackageFileException e) {
                    throw (ProcessException)logger.throwing((Throwable)new ProcessException("Unable to register a source package", e));
                }
            }
            throw (ProcessException)logger.throwing((Throwable)new ProcessException("Unable to register a source package"));
        }
        ImmutableList<String> unmetDependencies = this.packageRegistry.getUnmetPackageDependencies();
        if (!unmetDependencies.isEmpty()) {
            logger.warn("The following package-level dependencies can not be resolved: {}", (Object)String.join((CharSequence)", ", unmetDependencies));
        }
        logger.exit();
    }

    private void generateTypeNames(ProcessConfiguration configuration) throws ProcessException {
        try {
            this.generatedTypeNameRegistry.setConfiguration(configuration);
        }
        catch (GeneratorException e) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException("The configuration contains invalid namespace or target name settings", e));
        }
    }

    private IDependencyGraph checkDependencies(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        ImmutableSet relevantOrigins = ImmutableSet.of((Object)((Object)IDependency.Origin.BASE_DEFINITION), (Object)((Object)IDependency.Origin.BINDING_VALUE_SET), (Object)((Object)IDependency.Origin.TYPE_CODE), (Object)((Object)IDependency.Origin.TYPE_PROFILE));
        ImmutableSet<URI> configuredResources = this.collectConfiguredResources(configuration);
        IDependencyGraph dependencyGraph = this.buildDependencyGraph(configuration);
        ArrayList<IDependencyNode> missingDependencies = new ArrayList<IDependencyNode>();
        List<IDependencyNode> nodesWithoutFrameworkImplementation = dependencyGraph.getNodes().stream().filter(n -> n.getFrameworkType().isEmpty()).toList();
        for (IDependencyNode node : nodesWithoutFrameworkImplementation) {
            ImmutableSet<IDependency.Origin> origins;
            URI resourceURI = node.getResourceURI();
            if (configuredResources.contains((Object)resourceURI) || Collections.disjoint(origins = dependencyGraph.getDependentOrigins(node), relevantOrigins)) continue;
            missingDependencies.add(node);
        }
        if (!missingDependencies.isEmpty()) {
            missingDependencies.sort((o1, o2) -> o1.getResourceURI().toString().compareTo(o2.getResource().toString()));
            logger.warn("The following {} resource(s) are a dependency of the configured resources, but not covered by the configuration or the HAPI base classes.", (Object)missingDependencies.size());
            for (IDependencyNode node : missingDependencies) {
                logger.warn("  {}", (Object)node.getResourceURI());
                ArrayList<IDependency> deps = new ArrayList<IDependency>((Collection<IDependency>)dependencyGraph.getDependents(node));
                deps.sort((o1, o2) -> {
                    String k1 = o1.getOrigin().toString() + "|" + String.valueOf(o1.getDependent().getResourceURI());
                    String k2 = o2.getOrigin().toString() + "|" + String.valueOf(o2.getDependent().getResourceURI());
                    return k1.compareTo(k2);
                });
                for (IDependency dep : deps) {
                    logger.warn("    used as {} by {}", (Object)dep.getOrigin(), (Object)dep.getDependent().getResourceURI());
                }
            }
        }
        return (IDependencyGraph)logger.exit((Object)dependencyGraph);
    }

    private ImmutableSet<URI> collectConfiguredResources(ProcessConfiguration configuration) {
        logger.entry(new Object[]{configuration});
        HashSet result = new HashSet();
        configuration.getValueSetEnums().stream().map(c -> c.getValueSet()).forEach(result::add);
        configuration.getStructureDefinitionClasses().stream().map(c -> c.getStructureDefinition()).forEach(result::add);
        return (ImmutableSet)logger.exit((Object)ImmutableSet.copyOf(result));
    }

    private IDependencyGraph buildDependencyGraph(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        for (ValueSetEnumConfiguration valueSetConfig : configuration.getValueSetEnums()) {
            this.addResourceToDependencyGraph(valueSetConfig.getValueSet());
        }
        for (StructureDefinitionClassConfiguration structureDefinitionConfig : configuration.getStructureDefinitionClasses()) {
            this.addResourceToDependencyGraph(structureDefinitionConfig.getStructureDefinition());
        }
        try {
            return (IDependencyGraph)logger.exit((Object)this.dependencyGraphBuilder.build());
        }
        catch (DependencyException e) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException("Error building dependency graph", e));
        }
    }

    private void addResourceToDependencyGraph(URI resourceURI) throws ProcessException {
        Optional<IBaseResource> resource;
        logger.entry(new Object[]{resourceURI});
        try {
            resource = this.packageRegistry.getUniqueResource(resourceURI);
        }
        catch (AmbiguousResourceURIException e) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException(String.format("Unable to load Resource %s", resourceURI), e));
        }
        if (resource.isEmpty()) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException(String.format("Unable to load Resource %s", resourceURI)));
        }
        try {
            this.dependencyGraphBuilder.addResource(resource.get());
        }
        catch (DependencyException e) {
            throw (ProcessException)logger.throwing((Throwable)new ProcessException(String.format("Unable to add Resource %s to the dependency graph builder", resourceURI), e));
        }
        logger.exit();
    }

    private void generateEnums(ProcessConfiguration configuration) throws ProcessException {
        logger.entry(new Object[]{configuration});
        ImmutableList<ValueSetEnumConfiguration> valueSetEnumConfigurations = configuration.getValueSetEnums();
        if (valueSetEnumConfigurations.isEmpty()) {
            logger.info("No ValueSet / enum generation rules configured.");
        } else {
            for (ValueSetEnumConfiguration valueSetEnumConfiguration : valueSetEnumConfigurations) {
                try {
                    this.valueSetGenerator.generate(configuration, valueSetEnumConfiguration);
                }
                catch (GeneratorException e) {
                    throw (ProcessException)logger.throwing((Throwable)new ProcessException(String.format("Unable to generate an enum to represent the value set %s", valueSetEnumConfiguration.getValueSet()), e));
                }
            }
        }
        logger.exit();
    }

    private void generateClasses(ProcessConfiguration configuration, IDependencyGraph dependencyGraph) throws ProcessException {
        logger.entry(new Object[0]);
        List<IDependencyNode> structureDefinitionNodes = dependencyGraph.getOrderedNodeList().stream().filter(n -> n.getResourceType().isPresent() && n.getResourceType().get().equals((Object)FhirResourceType.STRUCTURE_DEFINITION)).toList();
        for (IDependencyNode node : structureDefinitionNodes) {
            Optional<Object> typeInformation = Optional.empty();
            try {
                typeInformation = this.typeInformationBuilder.buildTypeInformation(configuration, node);
            }
            catch (GeneratorException e) {
                throw (ProcessException)logger.throwing((Throwable)new ProcessException("Unable to generate StructureDefinition type information", e));
            }
            if (!typeInformation.isPresent() || !((ITypeInformation)typeInformation.get()).isGenerated()) continue;
            try {
                this.structureDefinitionGenerator.generate(configuration, (ITypeInformation)typeInformation.get());
            }
            catch (GeneratorException e) {
                throw (ProcessException)logger.throwing((Throwable)new ProcessException(String.format("Unable to generate StructureDefinition class %s", ((ITypeInformation)typeInformation.get()).getTypeName()), e));
            }
        }
        logger.exit();
    }
}

