/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.process;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.parser.IParser;
import de.fhlintstone.process.IContextProvider;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
@Singleton
public class ContextProvider
implements IContextProvider {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ContextProvider.class);
    private Optional<FhirVersionEnum> fhirVersion = Optional.empty();
    private Optional<FhirContext> fhirContext = Optional.empty();

    @Override
    public Optional<FhirVersionEnum> getFhirVersion() {
        return this.fhirVersion;
    }

    @Override
    public void setFhirVersion(FhirVersionEnum fhirVersion) throws IllegalStateException {
        logger.entry(new Object[]{fhirVersion});
        if (this.fhirContext.isPresent()) {
            if (!this.fhirVersion.orElseThrow().equals((Object)fhirVersion)) {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException("Changing the FHIR version after context instantiation is not allowed."));
            }
        } else {
            this.fhirVersion = Optional.of(fhirVersion);
        }
        logger.exit();
    }

    private FhirContext get() {
        logger.entry(new Object[0]);
        if (this.fhirContext.isEmpty()) {
            if (this.fhirVersion.isEmpty()) {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException("Unable to instantiate the context without a FHIR version set."));
            }
            this.fhirContext = Optional.of(this.fhirVersion.get().newContext());
        }
        return (FhirContext)logger.exit((Object)this.fhirContext.get());
    }

    @Override
    public IParser newJsonParser() {
        return this.get().newJsonParser();
    }

    @Override
    public Optional<BaseRuntimeElementDefinition<?>> getElementDefinition(String theElementName) {
        logger.entry(new Object[]{theElementName});
        try {
            return (Optional)logger.exit(Optional.ofNullable(this.get().getElementDefinition(theElementName)));
        }
        catch (Exception e) {
            logger.debug("Unable to load element definition for {}", (Object)theElementName, (Object)e);
            return (Optional)logger.exit(Optional.empty());
        }
    }

    @Override
    public Optional<BaseRuntimeElementDefinition<?>> getElementDefinition(Class<? extends IBase> theElementType) {
        logger.entry(new Object[]{theElementType});
        try {
            return (Optional)logger.exit(Optional.ofNullable(this.get().getElementDefinition(theElementType)));
        }
        catch (Exception e) {
            logger.debug("Unable to load element definition for {}", theElementType, (Object)e);
            return (Optional)logger.exit(Optional.empty());
        }
    }

    @Override
    public Optional<RuntimeResourceDefinition> getResourceDefinition(String theResourceName) {
        logger.entry(new Object[]{theResourceName});
        try {
            return (Optional)logger.exit(Optional.ofNullable(this.get().getResourceDefinition(theResourceName)));
        }
        catch (Exception e) {
            logger.debug("Unable to load resource definition for {}: {}", (Object)theResourceName, (Object)e.getMessage());
            return (Optional)logger.exit(Optional.empty());
        }
    }

    @Override
    public Optional<RuntimeResourceDefinition> getResourceDefinition(IBaseResource theResource) {
        logger.entry(new Object[]{theResource});
        try {
            return (Optional)logger.exit(Optional.ofNullable(this.get().getResourceDefinition(theResource)));
        }
        catch (Exception e) {
            logger.debug("Unable to load resource definition for {}: {}", (Object)theResource, (Object)e.getMessage());
            return (Optional)logger.exit(Optional.empty());
        }
    }
}

