/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.packages;

import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.LenientErrorHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import de.fhlintstone.fhir.IResourceUtilities;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirPackage;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IFhirPackage;
import de.fhlintstone.packages.IPackageRegistry;
import de.fhlintstone.packages.PackageFileException;
import de.fhlintstone.process.IContextProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonProperty;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
@Singleton
public class PackageRegistry
implements IPackageRegistry {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(PackageRegistry.class);
    private final IContextProvider contextProvider;
    private final IResourceUtilities resourceUtilities;
    final Collection<IFhirPackage> packages = new ArrayList<IFhirPackage>();
    Multimap<IFhirPackage, ResourceInformation> resourcesByPackage = MultimapBuilder.hashKeys().linkedListValues().build();
    Multimap<URI, ResourceInformation> resourcesByURI = MultimapBuilder.hashKeys().linkedListValues().build();
    Multimap<FhirResourceType, ResourceInformation> resourcesByType = MultimapBuilder.hashKeys().linkedListValues().build();

    @Inject
    public PackageRegistry(IContextProvider contextProvider, IResourceUtilities resourceUtilities) {
        this.contextProvider = contextProvider;
        this.resourceUtilities = resourceUtilities;
    }

    @Override
    public void clear() {
        logger.entry(new Object[0]);
        this.packages.clear();
        this.resourcesByPackage.clear();
        this.resourcesByURI.clear();
        this.resourcesByType.clear();
        logger.exit();
    }

    @Override
    public IFhirPackage register(File packageFile) throws PackageFileException {
        IFhirPackage iFhirPackage;
        logger.entry(new Object[]{packageFile});
        String packageFileName = packageFile.getAbsolutePath();
        if (!packageFile.isFile() || !packageFile.canRead()) {
            throw new PackageFileException(String.format("Package file %s is not a file or could not be read", packageFileName));
        }
        logger.debug("Attempting to load package file {}", (Object)packageFileName);
        FileInputStream is = new FileInputStream(packageFile);
        try {
            NpmPackage npmPackage = NpmPackage.fromPackage((InputStream)is);
            Map folders = npmPackage.getFolders();
            if (!folders.containsKey("package")) {
                throw new PackageFileException(String.format("Package file %s does not contain a package folder", packageFileName));
            }
            IFhirPackage fhirPackage = this.loadPackageHeader(packageFile, npmPackage);
            this.readPackageContents(fhirPackage, (NpmPackage.NpmPackageFolder)folders.get("package"));
            logger.info("Loaded package {} version {} from file {}", new Object[]{fhirPackage.getName(), fhirPackage.getVersion(), packageFileName});
            iFhirPackage = (IFhirPackage)logger.exit((Object)fhirPackage);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | NullPointerException e) {
                throw (PackageFileException)logger.throwing((Throwable)new PackageFileException(String.format("Package file %s is not a valid .tar.gz archive, is missing the package folder or contains an invalid manifest", packageFileName), e));
            }
        }
        is.close();
        return iFhirPackage;
    }

    private IFhirPackage loadPackageHeader(File packageFile, NpmPackage npmPackage) throws PackageFileException {
        logger.entry(new Object[]{npmPackage});
        String packageFileName = packageFile.getAbsolutePath();
        JsonObject manifest = npmPackage.getNpm();
        String name = this.readName(packageFileName, manifest);
        String version = this.readVersion(packageFileName, manifest);
        Optional<URL> canonicalURL = this.readCanonicalURL(packageFileName, manifest);
        Map<String, String> dependencies = this.readDependencies(packageFileName, manifest);
        FhirPackage fhirPackage = FhirPackage.builder().withSourceFile(packageFile).withNpmPackage(npmPackage).withName(name).withVersion(version).withCanonicalURL(canonicalURL).withDependencies(dependencies).build();
        this.packages.add(fhirPackage);
        return (IFhirPackage)logger.exit((Object)fhirPackage);
    }

    private String readName(String packageFileName, JsonObject manifest) throws PackageFileException {
        logger.entry(new Object[]{manifest});
        List entries = manifest.getStrings("name");
        if (entries.size() != 1) {
            throw (PackageFileException)logger.throwing((Throwable)new PackageFileException(String.format("Manifest of package file %s contains an invalid name", packageFileName)));
        }
        return (String)logger.exit((Object)((String)entries.getFirst()));
    }

    private String readVersion(String packageFileName, JsonObject manifest) throws PackageFileException {
        logger.entry(new Object[]{manifest});
        List entries = manifest.getStrings("version");
        if (entries.size() != 1) {
            throw new PackageFileException(String.format("Manifest of package file %s contains an invalid version", packageFileName));
        }
        return (String)logger.exit((Object)((String)entries.getFirst()));
    }

    private Optional<URL> readCanonicalURL(String packageFileName, JsonObject manifest) throws PackageFileException {
        logger.entry(new Object[]{manifest});
        List entries = manifest.getStrings("canonical");
        switch (entries.size()) {
            case 0: {
                logger.debug("Manifest of package file {} does not contain a canonical URL", (Object)packageFileName);
                return (Optional)logger.exit(Optional.empty());
            }
            case 1: {
                String canonical = (String)entries.getFirst();
                try {
                    URL canonicalURL = new URI(canonical).toURL();
                    return (Optional)logger.exit(Optional.of(canonicalURL));
                }
                catch (MalformedURLException | URISyntaxException e) {
                    throw new PackageFileException(String.format("Manifest of package file %s contains an invalid canonical URL %s", packageFileName, canonical));
                }
            }
        }
        throw new PackageFileException(String.format("Manifest of package file %s contains an invalid canonical URL", packageFileName));
    }

    private Map<String, String> readDependencies(String packageFileName, JsonObject manifest) throws PackageFileException {
        logger.entry(new Object[]{manifest});
        HashMap<String, String> result = new HashMap<String, String>();
        JsonElement deps = manifest.get("dependencies");
        if (deps == null || !deps.isJsonObject()) {
            logger.warn("Manifest file of package file {} does not contain any dependencies.", (Object)packageFileName);
        } else {
            for (JsonProperty property : deps.asJsonObject().getProperties()) {
                String dependencyName = property.getName();
                JsonElement dependencyVersion = property.getValue();
                if (!dependencyVersion.isJsonString()) {
                    logger.error("Version of dependency {} in package {} is not a string", (Object)dependencyName, (Object)packageFileName);
                    throw new PackageFileException(String.format("Manifest file of package file %s contains an invalid dependency.", packageFileName));
                }
                result.put(dependencyName, dependencyVersion.asJsonString().getValue());
            }
        }
        return (Map)logger.exit(result);
    }

    private void readPackageContents(IFhirPackage fhirPackage, NpmPackage.NpmPackageFolder packageFolder) {
        int ignoredResources = 0;
        for (String nextFile : packageFolder.listFiles()) {
            if (!nextFile.toLowerCase(Locale.US).endsWith(".json")) continue;
            String input = new String((byte[])packageFolder.getContent().get(nextFile), StandardCharsets.UTF_8);
            IParser parser = this.contextProvider.newJsonParser();
            parser.setParserErrorHandler((IParserErrorHandler)new LenientErrorHandler(false));
            try {
                IBaseResource resource = parser.parseResource(input);
                Optional<FhirResourceType> resourceType = this.readResourceType(resource, nextFile);
                if (resourceType.isPresent()) {
                    IResourceUtilities.ResourceURIContents resourceURI = this.resourceUtilities.readResourceURI(resource);
                    Optional<URI> uri = resourceURI.uri();
                    if (uri.isEmpty()) {
                        logger.debug("Unable to determine URI of resource contained in {}, file is ignored", (Object)nextFile);
                        continue;
                    }
                    ResourceInformation info = new ResourceInformation(resourceType.get(), uri.get(), resourceURI.version(), fhirPackage, resource);
                    this.resourcesByPackage.put((Object)fhirPackage, (Object)info);
                    this.resourcesByURI.put((Object)info.uri, (Object)info);
                    this.resourcesByType.put((Object)resourceType.get(), (Object)info);
                    continue;
                }
                ++ignoredResources;
            }
            catch (DataFormatException e) {
                logger.debug("Unable to parse resource contained in file {}, file is ignored", (Object)nextFile, (Object)e);
                ++ignoredResources;
            }
        }
        if (ignoredResources > 0) {
            logger.warn("{} resources in package {} were ignored because the resource could not be parsed or the resource type could not determined. For more details, check the debug log.", (Object)ignoredResources, (Object)fhirPackage.getName());
        }
    }

    private Optional<FhirResourceType> readResourceType(IBaseResource resource, String fileName) {
        logger.entry(new Object[]{resource, fileName});
        try {
            return (Optional)logger.exit(Optional.of(FhirResourceType.fromResource(resource)));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Unable to determine type of resource contained in {}, file is ignored", (Object)fileName, (Object)e);
            return (Optional)logger.exit(Optional.empty());
        }
    }

    @Override
    public ImmutableList<IBaseResource> getResources(IFhirPackage fhirPackage) {
        logger.entry(new Object[]{fhirPackage});
        if (!this.resourcesByPackage.containsKey((Object)fhirPackage)) {
            throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Package %s has not been registered", fhirPackage.getName())));
        }
        List<IBaseResource> result = this.resourcesByPackage.get((Object)fhirPackage).stream().map(info -> info.resource).toList();
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    @Override
    public ImmutableList<IBaseResource> getResources(FhirResourceType resourceType, IFhirPackage fhirPackage) {
        logger.entry(new Object[]{resourceType, fhirPackage});
        if (!this.resourcesByPackage.containsKey((Object)fhirPackage)) {
            throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Package %s has not been registered", fhirPackage.getName())));
        }
        List<IBaseResource> result = this.resourcesByPackage.get((Object)fhirPackage).stream().filter(info -> info.resourceType.equals((Object)resourceType)).map(info -> info.resource).toList();
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    @Override
    public ImmutableList<IBaseResource> getResources(URI resourceURI) {
        logger.entry(new Object[]{resourceURI});
        List<IBaseResource> result = this.resourcesByURI.get((Object)resourceURI).stream().map(info -> info.resource).toList();
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    @Override
    public ImmutableList<IBaseResource> getResources(FhirResourceType resourceType, URI resourceURI) {
        logger.entry(new Object[]{resourceType, resourceURI});
        List<IBaseResource> result = this.resourcesByURI.get((Object)resourceURI).stream().filter(info -> info.resourceType.equals((Object)resourceType)).map(info -> info.resource).toList();
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    @Override
    public Optional<IBaseResource> getUniqueResource(URI resourceURI) throws AmbiguousResourceURIException {
        logger.entry(new Object[]{resourceURI});
        List<IBaseResource> result = this.resourcesByURI.get((Object)resourceURI).stream().map(info -> info.resource).toList();
        switch (result.size()) {
            case 0: {
                return (Optional)logger.exit(Optional.empty());
            }
            case 1: {
                return (Optional)logger.exit(Optional.of(result.getFirst()));
            }
        }
        throw (AmbiguousResourceURIException)logger.throwing((Throwable)new AmbiguousResourceURIException(resourceURI));
    }

    @Override
    public Optional<IBaseResource> getUniqueResource(FhirResourceType resourceType, URI resourceURI) throws AmbiguousResourceURIException {
        logger.entry(new Object[]{resourceURI});
        List<IBaseResource> result = this.resourcesByURI.get((Object)resourceURI).stream().filter(info -> info.resourceType.equals((Object)resourceType)).map(info -> info.resource).toList();
        switch (result.size()) {
            case 0: {
                return (Optional)logger.exit(Optional.empty());
            }
            case 1: {
                return (Optional)logger.exit(Optional.of(result.getFirst()));
            }
        }
        throw (AmbiguousResourceURIException)logger.throwing((Throwable)new AmbiguousResourceURIException(resourceURI));
    }

    @Override
    public ImmutableList<String> getUnmetPackageDependencies() {
        logger.entry(new Object[0]);
        SetMultimap versionsAvailable = MultimapBuilder.hashKeys().hashSetValues().build();
        for (IFhirPackage pkg : this.packages) {
            versionsAvailable.put((Object)pkg.getName().toLowerCase(), (Object)pkg.getVersion().trim());
            String patchWildcardVersion = pkg.getVersion().replaceAll("\\.\\d+$", ".x");
            versionsAvailable.put((Object)pkg.getName(), (Object)patchWildcardVersion);
        }
        ArrayList<CallSite> result = new ArrayList<CallSite>();
        for (IFhirPackage pkg : this.packages) {
            for (Map.Entry dep : pkg.getDependencies().entrySet()) {
                String depName = ((String)dep.getKey()).toLowerCase();
                String depVersion = ((String)dep.getValue()).trim();
                if (versionsAvailable.get((Object)depName).contains(depVersion)) continue;
                result.add((CallSite)((Object)(depName + "#" + depVersion)));
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    @Override
    public Optional<IFhirPackage> getPackageOfResource(URI resourceURI) throws AmbiguousResourceURIException {
        logger.entry(new Object[]{resourceURI});
        Optional<Object> result = Optional.empty();
        Set info = this.resourcesByURI.get((Object)resourceURI).stream().map(entry -> entry.fhirPackage).collect(Collectors.toSet());
        if (info.size() > 1) {
            throw (AmbiguousResourceURIException)logger.throwing((Throwable)new AmbiguousResourceURIException(resourceURI));
        }
        if (info.size() == 1) {
            result = info.stream().findFirst();
        }
        return (Optional)logger.exit(result);
    }

    private record ResourceInformation(FhirResourceType resourceType, URI uri, Optional<String> version, IFhirPackage fhirPackage, IBaseResource resource) {
    }
}

