/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.packages;

import com.google.common.base.Strings;
import org.hl7.fhir.instance.model.api.IBaseResource;

public enum FhirResourceType {
    CAPABILITY_STATEMENT,
    CODE_SYSTEM,
    COMPARTMENT_DEFINITION,
    CONCEPT_MAP,
    IMPLEMENTATION_GUIDE,
    NAMING_SYSTEM,
    OPERATION_DEFINITION,
    SEARCH_PARAMETER,
    STRUCTURE_DEFINITION,
    STRUCTURE_MAP,
    VALUE_SET;


    public static FhirResourceType fromString(String value) {
        if (value.equals("CapabilityStatement")) {
            return CAPABILITY_STATEMENT;
        }
        if (value.equals("CodeSystem")) {
            return CODE_SYSTEM;
        }
        if (value.equals("CompartmentDefinition")) {
            return COMPARTMENT_DEFINITION;
        }
        if (value.equals("ConceptMap")) {
            return CONCEPT_MAP;
        }
        if (value.equals("ImplementationGuide")) {
            return IMPLEMENTATION_GUIDE;
        }
        if (value.equals("NamingSystem")) {
            return NAMING_SYSTEM;
        }
        if (value.equals("OperationDefinition")) {
            return OPERATION_DEFINITION;
        }
        if (value.equals("SearchParameter")) {
            return SEARCH_PARAMETER;
        }
        if (value.equals("StructureDefinition")) {
            return STRUCTURE_DEFINITION;
        }
        if (value.equals("StructureMap")) {
            return STRUCTURE_MAP;
        }
        if (value.equals("ValueSet")) {
            return VALUE_SET;
        }
        throw new IllegalArgumentException(String.format("Unknown FHIR resource type %s", value));
    }

    public static FhirResourceType fromResource(IBaseResource resource) {
        String typeString = resource.fhirType();
        if (Strings.isNullOrEmpty((String)typeString)) {
            throw new IllegalArgumentException("Resource did not provide a FHIR type");
        }
        return FhirResourceType.fromString(typeString);
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "CapabilityStatement";
            }
            case 1: {
                return "CodeSystem";
            }
            case 2: {
                return "CompartmentDefinition";
            }
            case 3: {
                return "ConceptMap";
            }
            case 4: {
                return "ImplementationGuide";
            }
            case 5: {
                return "NamingSystem";
            }
            case 6: {
                return "OperationDefinition";
            }
            case 7: {
                return "SearchParameter";
            }
            case 8: {
                return "StructureDefinition";
            }
            case 9: {
                return "StructureMap";
            }
            case 10: {
                return "ValueSet";
            }
        }
        throw new IllegalArgumentException(String.format("Unknown FHIR resource type %s", new Object[]{this}));
    }
}

