/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.valueset;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.palantir.javapoet.ClassName;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.model.IValueSetAccessor;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.IGeneratedTypeNameRegistry;
import de.fhlintstone.generator.valueset.EnumConstant;
import de.fhlintstone.generator.valueset.EnumData;
import de.fhlintstone.generator.valueset.ICodeEmitter;
import de.fhlintstone.generator.valueset.IConstantGenerator;
import de.fhlintstone.generator.valueset.IValueSetGenerator;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.ValueSetEnumConfiguration;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class ValueSetGenerator
implements IValueSetGenerator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ValueSetGenerator.class);
    private final IPackageRegistry packageRegistry;
    private final IAccessorProvider accessorProvider;
    private final IFrameworkTypeLocator frameworkTypeLocator;
    private final IGeneratedTypeNameRegistry generatedTypeNameRegistry;
    private final IConstantGenerator constantGenerator;
    private final ICodeEmitter codeEmitter;

    @Inject
    public ValueSetGenerator(IPackageRegistry packageRegistry, IAccessorProvider accessorProvider, IFrameworkTypeLocator frameworkTypeLocator, IGeneratedTypeNameRegistry generatedTypeNameRegistry, IConstantGenerator constantGenerator, ICodeEmitter codeEmitter) {
        this.packageRegistry = packageRegistry;
        this.accessorProvider = accessorProvider;
        this.frameworkTypeLocator = frameworkTypeLocator;
        this.generatedTypeNameRegistry = generatedTypeNameRegistry;
        this.constantGenerator = constantGenerator;
        this.codeEmitter = codeEmitter;
    }

    @Override
    public void generate(ProcessConfiguration globalConfiguration, ValueSetEnumConfiguration vsConfiguration) throws GeneratorException {
        logger.entry(new Object[]{vsConfiguration});
        Optional<ClassName> qualifiedName = this.generatedTypeNameRegistry.getEnumName(vsConfiguration.getValueSet());
        if (qualifiedName.isPresent()) {
            IValueSetAccessor accessor = this.createValueSetAccessor(globalConfiguration.getFhirVersion(), vsConfiguration.getValueSet());
            logger.info("Generating enum {} for ValueSet {}", (Object)qualifiedName.get().canonicalName(), (Object)vsConfiguration.getValueSet());
            EnumData enumData = EnumData.builder().withClassName(qualifiedName.get()).withValueSetName(accessor.getName().orElseThrow()).withValueSetURL(accessor.getUrl().orElseThrow()).withDescription(accessor.getDescription()).withCodingType(this.frameworkTypeLocator.getCodingType()).withOutputPath(globalConfiguration.getOutputPath()).withEnumConstants((Iterable<? extends EnumConstant>)this.constantGenerator.generateEnumConstants(accessor)).build();
            this.codeEmitter.generate(enumData);
        } else {
            logger.info("No configuration to generate an enum for ValueSet {}", (Object)vsConfiguration.getValueSet());
        }
        logger.exit();
    }

    private IValueSetAccessor createValueSetAccessor(FhirVersionEnum fhirVersion, URI valueSetURI) throws GeneratorException {
        logger.entry(new Object[]{fhirVersion, valueSetURI});
        try {
            Optional<IBaseResource> valueSetResource = this.packageRegistry.getUniqueResource(FhirResourceType.VALUE_SET, valueSetURI);
            if (valueSetResource.isEmpty()) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to locate resource for ValueSet URI %s", valueSetURI)));
            }
            if (!fhirVersion.equals((Object)valueSetResource.get().getStructureFhirVersionEnum())) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("FHIR version mismatch for ValueSet URI %s", valueSetURI)));
            }
            IValueSetAccessor result = this.accessorProvider.provideValueSetAccessor(valueSetResource.get());
            return (IValueSetAccessor)logger.exit((Object)result);
        }
        catch (AmbiguousResourceURIException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The ValueSet URI %s is ambiguous", valueSetURI), e));
        }
    }
}

