/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.valueset;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.model.FilterOperator;
import de.fhlintstone.accessors.model.ICodeSystemAccessor;
import de.fhlintstone.accessors.model.IConceptDefinitionComponentAccessor;
import de.fhlintstone.accessors.model.IConceptPropertyComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetFilterComponentAccessor;
import de.fhlintstone.accessors.model.IPrimitiveTypeAccessor;
import de.fhlintstone.accessors.model.ITypeAccessor;
import de.fhlintstone.accessors.model.PrimitiveDatatype;
import de.fhlintstone.accessors.model.StringifiedValue;
import de.fhlintstone.fhir.FhirUtilities;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.valueset.IFilterCalculator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class FilterCalculator
implements IFilterCalculator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(FilterCalculator.class);
    private static final String CODE_NAME = "code";
    private static final String CONCEPT_NAME = "concept";
    private static final String DESIGNATION_NAME = "designation";
    private static final Pattern SEARCH_SEMANTICS_PREFIX = Pattern.compile("^(eq|ne|gt|lt|ge|le|sa|eb|ap)");
    private static final Pattern COMMA_BLANK_SPLIT = Pattern.compile("\\s*,\\s*", 256);

    @Inject
    public FilterCalculator() {
    }

    @Override
    public ImmutableList<IConceptDefinitionComponentAccessor> getMatchingConcepts(String valueSetUrl, IConceptSetFilterComponentAccessor filterAccessor, ICodeSystemAccessor codeSystemAccessor) throws GeneratorException {
        logger.entry(new Object[0]);
        Optional<FilterOperator> optFilterAccessorOp = filterAccessor.getOp();
        Optional<String> optFilterAccessorProperty = filterAccessor.getProperty();
        Optional<String> optFilterAccessorValue = filterAccessor.getValue();
        if (optFilterAccessorOp.isEmpty() || optFilterAccessorProperty.isEmpty() || optFilterAccessorValue.isEmpty()) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Filter %s on ValueSet %s is invalid", filterAccessor, valueSetUrl)));
        }
        String filterProperty = optFilterAccessorProperty.get();
        String filterValue = optFilterAccessorValue.get();
        ImmutableList<IConceptDefinitionComponentAccessor> conceptAccessors = FhirUtilities.flattenConceptHierarchy(codeSystemAccessor.getConcept());
        return (ImmutableList)logger.exit(switch (optFilterAccessorOp.get()) {
            default -> throw new MatchException(null, null);
            case FilterOperator.EQUAL -> this.calculateEqualFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.ISA -> this.calculateIsAFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.DESCENDENTOF -> this.calculateDescendentOfFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.ISNOTA -> this.calculateIsNotAFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.REGEX -> this.calculateRegexFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.IN -> this.calculateInFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.NOTIN -> this.calculateNotInFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.GENERALIZES -> this.calculateGeneralizesFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.CHILDOF -> this.calculateChildOfFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.DESCENDENTLEAF -> this.calculateDescendentLeafFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
            case FilterOperator.EXISTS -> this.calculateExistsFilter(valueSetUrl, filterProperty, filterValue, conceptAccessors);
        });
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateEqualFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        if (filterProperty.equals(DESIGNATION_NAME)) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Equal filter on designations are currently not supported", valueSetUrl)));
        }
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            for (IConceptPropertyComponentAccessor property : concept.getProperty()) {
                if (!this.checkPropertyEquality(property, valueSetUrl, filterProperty, filterValue)) continue;
                result.add(concept);
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private boolean checkPropertyEquality(IConceptPropertyComponentAccessor property, String valueSetUrl, String filterProperty, String filterValue) throws GeneratorException {
        ITypeAccessor iTypeAccessor;
        Optional<String> propertyCode = property.getCode();
        Optional<ITypeAccessor> propertyValue = property.getValue();
        if (propertyValue.isPresent() && (iTypeAccessor = propertyValue.get()) instanceof IPrimitiveTypeAccessor) {
            IPrimitiveTypeAccessor primitiveValue = (IPrimitiveTypeAccessor)iTypeAccessor;
            if (propertyCode.isPresent() && propertyCode.get().equals(filterProperty)) {
                if (!primitiveValue.isType(PrimitiveDatatype.STRING) && !primitiveValue.isType(PrimitiveDatatype.INTEGER)) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Currently only StringType and IntegerType are supported for filter", valueSetUrl, filterProperty)));
                }
                if (primitiveValue.isType(PrimitiveDatatype.INTEGER) && SEARCH_SEMANTICS_PREFIX.matcher(propertyCode.get()).matches()) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Search semantics are currently not supported", valueSetUrl, filterProperty)));
                }
                Optional<StringifiedValue> stringifiedValue = primitiveValue.getStringifiedValue();
                return stringifiedValue.isPresent() && stringifiedValue.get().getValue().equals(filterValue);
            }
        } else {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Non-primitive values are not supported", valueSetUrl, filterProperty)));
        }
        return false;
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateIsAFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.ISA.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.add(concept);
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)this.calculateTransitiveChildren(concept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateDescendentOfFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.DESCENDENTOF.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)this.calculateTransitiveChildren(concept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateIsNotAFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.ISNOTA.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>((Collection<IConceptDefinitionComponentAccessor>)concepts);
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.remove(concept);
            result.removeAll((Collection<?>)this.calculateTransitiveChildren(concept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateRegexFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        Pattern regex;
        logger.entry(new Object[]{filterProperty, filterValue});
        try {
            regex = Pattern.compile(filterValue);
        }
        catch (PatternSyntaxException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: The provided value %s for the regex filter on %s is not a valid regex", valueSetUrl, filterValue, filterProperty), e));
        }
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            if (filterProperty.equals(DESIGNATION_NAME)) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Regex filter on designations are currently not supported", valueSetUrl)));
            }
            if (filterProperty.equals(CODE_NAME)) {
                Optional<String> conceptCode = concept.getCode();
                if (!conceptCode.isPresent() || !regex.matcher(conceptCode.get()).matches()) continue;
                result.add(concept);
                continue;
            }
            for (IConceptPropertyComponentAccessor property : concept.getProperty()) {
                if (!this.checkPropertyRegexMatch(property, valueSetUrl, filterProperty, regex)) continue;
                result.add(concept);
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private boolean checkPropertyRegexMatch(IConceptPropertyComponentAccessor property, String valueSetUrl, String filterProperty, Pattern regex) throws GeneratorException {
        ITypeAccessor iTypeAccessor;
        Optional<String> propertyCode = property.getCode();
        Optional<ITypeAccessor> propertyValue = property.getValue();
        if (propertyValue.isPresent() && (iTypeAccessor = propertyValue.get()) instanceof IPrimitiveTypeAccessor) {
            IPrimitiveTypeAccessor primitiveValue = (IPrimitiveTypeAccessor)iTypeAccessor;
            if (propertyCode.isPresent() && propertyCode.get().equals(filterProperty)) {
                if (!primitiveValue.isType(PrimitiveDatatype.STRING) && !primitiveValue.isType(PrimitiveDatatype.INTEGER)) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Currently only StringType and IntegerType are supported for filter", valueSetUrl, filterProperty)));
                }
                Optional<StringifiedValue> stringifiedValue = primitiveValue.getStringifiedValue();
                return stringifiedValue.isPresent() && regex.matcher(stringifiedValue.get().getValue()).matches();
            }
        } else {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Non-primitive values are not supported", valueSetUrl, filterProperty)));
        }
        return false;
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateInFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        List<String> valueList = Arrays.stream(COMMA_BLANK_SPLIT.split(filterValue.trim())).toList();
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            for (IConceptPropertyComponentAccessor property : concept.getProperty()) {
                if (!this.checkPropertyInValueList(property, valueSetUrl, filterProperty, valueList)) continue;
                result.add(concept);
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateNotInFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        List<String> valueList = Arrays.stream(COMMA_BLANK_SPLIT.split(filterValue.trim())).toList();
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            for (IConceptPropertyComponentAccessor property : concept.getProperty()) {
                if (this.checkPropertyInValueList(property, valueSetUrl, filterProperty, valueList)) continue;
                result.add(concept);
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private boolean checkPropertyInValueList(IConceptPropertyComponentAccessor property, String valueSetUrl, String filterProperty, List<String> valueList) throws GeneratorException {
        ITypeAccessor iTypeAccessor;
        Optional<String> propertyCode = property.getCode();
        Optional<ITypeAccessor> propertyValue = property.getValue();
        if (propertyValue.isPresent() && (iTypeAccessor = propertyValue.get()) instanceof IPrimitiveTypeAccessor) {
            IPrimitiveTypeAccessor primitiveValue = (IPrimitiveTypeAccessor)iTypeAccessor;
            if (propertyCode.isPresent() && propertyCode.get().equals(filterProperty)) {
                if (!primitiveValue.isType(PrimitiveDatatype.STRING) && !primitiveValue.isType(PrimitiveDatatype.INTEGER)) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Currently only StringType and IntegerType are supported for filter", valueSetUrl, filterProperty)));
                }
                Optional<StringifiedValue> stringifiedValue = primitiveValue.getStringifiedValue();
                return stringifiedValue.isPresent() && valueList.contains(stringifiedValue.get().getValue());
            }
        } else {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: Filter on %s: Non-primitive values are not supported", valueSetUrl, filterProperty)));
        }
        return false;
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateGeneralizesFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.GENERALIZES.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.add(concept);
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)this.calculateParentsForChild(concepts, concept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateExistsFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        boolean shouldExist;
        logger.entry(new Object[]{filterProperty, filterValue});
        if ("true".equalsIgnoreCase(filterValue)) {
            shouldExist = true;
        } else if ("false".equalsIgnoreCase(filterValue)) {
            shouldExist = false;
        } else {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: The provided value for the exists filter on %s must be 'true' or 'false', was '%s'", valueSetUrl, filterProperty, filterValue)));
        }
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            for (IConceptPropertyComponentAccessor property : concept.getProperty()) {
                if (!this.checkPropertyMatchesExists(property, filterProperty, shouldExist)) continue;
                result.add(concept);
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private boolean checkPropertyMatchesExists(IConceptPropertyComponentAccessor property, String filterProperty, boolean shouldExist) {
        Optional<String> propertyCode = property.getCode();
        if (shouldExist && propertyCode.isPresent() && propertyCode.get().equals(filterProperty)) {
            return true;
        }
        return !shouldExist && (propertyCode.isEmpty() || !propertyCode.get().equals(filterProperty));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateChildOfFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty, filterValue});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.CHILDOF.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)concept.getChildConcept());
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateDescendentLeafFilter(String valueSetUrl, String filterProperty, String filterValue, ImmutableList<IConceptDefinitionComponentAccessor> concepts) throws GeneratorException {
        logger.entry(new Object[]{filterProperty});
        this.checkFilterPropertyIsOnlyConcept(valueSetUrl, filterProperty, FilterOperator.DESCENDENTLEAF.toString());
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor concept : concepts) {
            Optional<String> conceptCode = concept.getCode();
            if (!conceptCode.isPresent() || !conceptCode.get().equals(filterValue)) continue;
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)this.calculateLeafChildren(concept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateTransitiveChildren(IConceptDefinitionComponentAccessor parent) {
        logger.entry(new Object[]{parent});
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        ArrayDeque<IConceptDefinitionComponentAccessor> children = new ArrayDeque<IConceptDefinitionComponentAccessor>((Collection<IConceptDefinitionComponentAccessor>)parent.getChildConcept());
        while (!children.isEmpty()) {
            IConceptDefinitionComponentAccessor current = children.pop();
            result.add(current);
            children.addAll((Collection<IConceptDefinitionComponentAccessor>)current.getChildConcept());
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateLeafChildren(IConceptDefinitionComponentAccessor parent) {
        logger.entry(new Object[]{parent});
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        ArrayDeque<IConceptDefinitionComponentAccessor> children = new ArrayDeque<IConceptDefinitionComponentAccessor>((Collection<IConceptDefinitionComponentAccessor>)parent.getChildConcept());
        while (!children.isEmpty()) {
            IConceptDefinitionComponentAccessor current = children.pop();
            if (current.getChildConcept().isEmpty()) {
                result.add(current);
                continue;
            }
            children.addAll((Collection<IConceptDefinitionComponentAccessor>)current.getChildConcept());
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private ImmutableList<IConceptDefinitionComponentAccessor> calculateParentsForChild(ImmutableList<IConceptDefinitionComponentAccessor> concepts, IConceptDefinitionComponentAccessor childConcept) {
        logger.entry(new Object[]{childConcept});
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        for (IConceptDefinitionComponentAccessor parentConcept : concepts) {
            if (!parentConcept.getChildConcept().contains((Object)childConcept)) continue;
            result.add(parentConcept);
            result.addAll((Collection<IConceptDefinitionComponentAccessor>)this.calculateParentsForChild(concepts, parentConcept));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private void checkFilterPropertyIsOnlyConcept(String valueSetUrl, String filterProperty, String filterName) throws GeneratorException {
        logger.entry(new Object[]{filterProperty});
        if (!filterProperty.equals(CONCEPT_NAME)) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("ValueSet %s: %s filter are only allowed for property '%s', but provided '%s'", valueSetUrl, filterName, CONCEPT_NAME, filterProperty)));
        }
        logger.exit();
    }
}

