/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.valueset;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.model.ICanonicalTypeAccessor;
import de.fhlintstone.accessors.model.ICodeSystemAccessor;
import de.fhlintstone.accessors.model.IConceptDefinitionComponentAccessor;
import de.fhlintstone.accessors.model.IConceptReferenceComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetFilterComponentAccessor;
import de.fhlintstone.accessors.model.IValueSetAccessor;
import de.fhlintstone.accessors.model.IValueSetComposeComponentAccessor;
import de.fhlintstone.fhir.FhirUtilities;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.valueset.EnumConstant;
import de.fhlintstone.generator.valueset.IConstantGenerator;
import de.fhlintstone.generator.valueset.IFilterCalculator;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class ConstantGenerator
implements IConstantGenerator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ConstantGenerator.class);
    private static final Pattern HYPHEN_DOT_PATTERN = Pattern.compile("[-.]");
    private final IPackageRegistry packageRegistry;
    private final IAccessorProvider accessorProvider;
    private final IFilterCalculator filterCalculator;

    @Inject
    public ConstantGenerator(IPackageRegistry packageRegistry, IAccessorProvider accessorProvider, IFilterCalculator filterCalculator) {
        this.packageRegistry = packageRegistry;
        this.accessorProvider = accessorProvider;
        this.filterCalculator = filterCalculator;
    }

    @Override
    public ImmutableList<EnumConstant> generateEnumConstants(IValueSetAccessor valueSetAccessor) throws GeneratorException {
        logger.entry(new Object[]{valueSetAccessor});
        String valueSetUrl = valueSetAccessor.getUrl().orElseThrow();
        Set<Object> result = Set.of();
        Optional<IValueSetComposeComponentAccessor> compose = valueSetAccessor.getCompose();
        if (compose.isPresent()) {
            ImmutableList<IConceptSetComponentAccessor> excludes;
            ImmutableList<IConceptSetComponentAccessor> includes = compose.get().getInclude();
            if (!includes.isEmpty()) {
                result = this.generateEnumConstantsForIncludes(valueSetAccessor, includes);
            }
            if (!(excludes = compose.get().getExclude()).isEmpty()) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The ValueSet %s uses exclusions, which are currently not supported", valueSetUrl)));
            }
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private Set<EnumConstant> generateEnumConstantsForIncludes(IValueSetAccessor accessor, ImmutableList<IConceptSetComponentAccessor> includes) throws GeneratorException {
        logger.entry(new Object[0]);
        String valueSetUrl = accessor.getUrl().orElseThrow();
        HashSet<EnumConstant> constants = new HashSet<EnumConstant>();
        for (IConceptSetComponentAccessor include : includes) {
            Set<EnumConstant> valueSetConstants = this.collectReferencedValueSetConstants(valueSetUrl, include);
            Set<EnumConstant> codeSystemConstants = this.collectCodeSystemConstants(valueSetUrl, include);
            ImmutableList<ICanonicalTypeAccessor> valueSetReferences = include.getValueSet();
            Optional<String> codeSystemReference = include.getSystem();
            Set<EnumConstant> includeConstants = !valueSetReferences.isEmpty() && codeSystemReference.isPresent() ? this.calculateConstantIntersections(valueSetConstants, codeSystemConstants) : (codeSystemReference.isPresent() ? codeSystemConstants : valueSetConstants);
            constants.addAll(includeConstants);
        }
        return (Set)logger.exit(constants);
    }

    private Set<EnumConstant> collectReferencedValueSetConstants(String valueSetUrl, IConceptSetComponentAccessor conceptSetAccessor) throws GeneratorException {
        logger.entry(new Object[]{conceptSetAccessor});
        Set<Object> result = new HashSet();
        ImmutableList<ICanonicalTypeAccessor> valueSetReferences = conceptSetAccessor.getValueSet();
        if (!valueSetReferences.isEmpty()) {
            boolean isFirst = true;
            for (ICanonicalTypeAccessor valueSetReference : valueSetReferences) {
                IValueSetAccessor referencedValueSet = this.loadValueSet(valueSetUrl, valueSetReference.getValue().orElseThrow());
                HashSet<EnumConstant> valueSetEnumConstants = new HashSet<EnumConstant>((Collection<EnumConstant>)this.generateEnumConstants(referencedValueSet));
                if (isFirst) {
                    result = valueSetEnumConstants;
                    isFirst = false;
                    continue;
                }
                result = this.calculateConstantIntersections(result, valueSetEnumConstants);
            }
        }
        return (Set)logger.exit(result);
    }

    private Set<EnumConstant> collectCodeSystemConstants(String valueSetUrl, IConceptSetComponentAccessor conceptSetAccessor) throws GeneratorException {
        logger.entry(new Object[]{conceptSetAccessor});
        Set<Object> result = new HashSet();
        Optional<String> codeSystemUrl = conceptSetAccessor.getSystem();
        if (codeSystemUrl.isPresent()) {
            ICodeSystemAccessor codeSystem = this.loadCodeSystem(valueSetUrl, codeSystemUrl.get());
            ImmutableList<IConceptSetFilterComponentAccessor> filters = conceptSetAccessor.getFilter();
            if (!filters.isEmpty()) {
                boolean isFirst = true;
                for (IConceptSetFilterComponentAccessor filter : filters) {
                    ImmutableList<IConceptDefinitionComponentAccessor> filteredConcepts = this.filterCalculator.getMatchingConcepts(valueSetUrl, filter, codeSystem);
                    Set<EnumConstant> filterEnumConstants = this.getConstantsFromCodeSystemConcepts((List<IConceptDefinitionComponentAccessor>)filteredConcepts, codeSystemUrl.get());
                    if (isFirst) {
                        result = filterEnumConstants;
                        isFirst = false;
                        continue;
                    }
                    result = this.calculateConstantIntersections(result, filterEnumConstants);
                }
            } else {
                ImmutableList<IConceptReferenceComponentAccessor> valueSetConcepts = conceptSetAccessor.getConcept();
                ImmutableList<IConceptDefinitionComponentAccessor> codeSystemConcepts = FhirUtilities.flattenConceptHierarchy(codeSystem.getConcept());
                result = !valueSetConcepts.isEmpty() ? this.getConstantsFromValueSetConcepts((List<IConceptReferenceComponentAccessor>)valueSetConcepts, (List<IConceptDefinitionComponentAccessor>)codeSystemConcepts, codeSystemUrl.get()) : this.getConstantsFromCodeSystemConcepts((List<IConceptDefinitionComponentAccessor>)codeSystemConcepts, codeSystemUrl.get());
            }
        }
        return (Set)logger.exit(result);
    }

    private Set<EnumConstant> getConstantsFromValueSetConcepts(List<IConceptReferenceComponentAccessor> valueSetConcepts, List<IConceptDefinitionComponentAccessor> codeSystemConcepts, String codeSystemUrl) {
        logger.entry(new Object[]{valueSetConcepts, codeSystemConcepts});
        HashSet<EnumConstant> constants = new HashSet<EnumConstant>();
        for (IConceptReferenceComponentAccessor valueSetConcept : valueSetConcepts) {
            constants.add(EnumConstant.builder().withConstantName(this.convertCodeToConstantName(valueSetConcept.getCode().orElseThrow())).withCode(valueSetConcept.getCode().orElseThrow()).withDisplay(Optional.of(this.getDisplayForValueSetConcept(valueSetConcept, codeSystemConcepts).orElse("(no description available)"))).withSystem(codeSystemUrl).build());
        }
        return (Set)logger.exit(constants);
    }

    private Optional<String> getDisplayForValueSetConcept(IConceptReferenceComponentAccessor valueSetConcept, List<IConceptDefinitionComponentAccessor> codeSystemConcepts) {
        Optional<IConceptDefinitionComponentAccessor> relatedCodeSystemConcept;
        Optional<String> description = valueSetConcept.getDisplay();
        if (description.isEmpty() && (relatedCodeSystemConcept = this.findRelatedCodeSystemConceptForValueSetConcept(valueSetConcept, codeSystemConcepts)).isPresent()) {
            description = relatedCodeSystemConcept.get().getDisplay();
        }
        return description;
    }

    private Optional<IConceptDefinitionComponentAccessor> findRelatedCodeSystemConceptForValueSetConcept(IConceptReferenceComponentAccessor valueSetConcept, List<IConceptDefinitionComponentAccessor> codeSystemConcepts) {
        return codeSystemConcepts.stream().filter(codeSytemConcept -> codeSytemConcept.getCode().isPresent() && codeSytemConcept.getCode().get().equals(valueSetConcept.getCode().orElseThrow())).findFirst();
    }

    private Set<EnumConstant> getConstantsFromCodeSystemConcepts(List<IConceptDefinitionComponentAccessor> codeSystemConcepts, String codeSystemUrl) {
        logger.entry(new Object[]{codeSystemConcepts});
        HashSet<EnumConstant> constants = new HashSet<EnumConstant>();
        for (IConceptDefinitionComponentAccessor concept : codeSystemConcepts) {
            constants.add(EnumConstant.builder().withConstantName(this.convertCodeToConstantName(concept.getCode().orElseThrow())).withCode(concept.getCode().orElseThrow()).withDisplay(Optional.of(concept.getDisplay().orElse("(no description available)"))).withSystem(codeSystemUrl).build());
        }
        return (Set)logger.exit(constants);
    }

    private ICodeSystemAccessor loadCodeSystem(String valueSetUrl, String codeSystemUrl) throws GeneratorException {
        logger.entry(new Object[]{codeSystemUrl});
        IBaseResource codeSystem = this.loadResource(valueSetUrl, codeSystemUrl, FhirResourceType.CODE_SYSTEM);
        return (ICodeSystemAccessor)logger.exit((Object)this.accessorProvider.provideCodeSystemAccessor(codeSystem));
    }

    private IValueSetAccessor loadValueSet(String valueSetUrl, String referencedValueSetUrl) throws GeneratorException {
        logger.entry(new Object[]{referencedValueSetUrl});
        IBaseResource valueSet = this.loadResource(valueSetUrl, referencedValueSetUrl, FhirResourceType.VALUE_SET);
        return (IValueSetAccessor)logger.exit((Object)this.accessorProvider.provideValueSetAccessor(valueSet));
    }

    private IBaseResource loadResource(String valueSetUrl, String resourceUrl, FhirResourceType resourceType) throws GeneratorException {
        Optional<IBaseResource> resource;
        try {
            resource = this.packageRegistry.getUniqueResource(resourceType, new URI(resourceUrl));
            if (resource.isEmpty()) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The ValueSet %s references the %s %s which is not available", new Object[]{valueSetUrl, resourceType, resourceUrl})));
            }
        }
        catch (AmbiguousResourceURIException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The ValueSet %s references the %s %s which is ambiguous", new Object[]{valueSetUrl, resourceType, resourceUrl}), e));
        }
        catch (URISyntaxException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The ValueSet %s uses the invalid %s reference %s", new Object[]{valueSetUrl, resourceType, resourceUrl}), e));
        }
        return (IBaseResource)logger.exit((Object)resource.orElseThrow());
    }

    private String convertCodeToConstantName(String code) {
        logger.entry(new Object[]{code});
        Object constantName = HYPHEN_DOT_PATTERN.matcher(code).replaceAll("_").toUpperCase();
        char c = ((String)constantName).charAt(0);
        if (c >= '0' && c <= '9') {
            constantName = "_" + (String)constantName;
        }
        return (String)logger.exit(constantName);
    }

    private Set<EnumConstant> calculateConstantIntersections(Set<EnumConstant> set1, Set<EnumConstant> set2) {
        return set1.stream().filter(constant1 -> set2.stream().anyMatch(constant2 -> constant2.equalsOnSystemAndCode((EnumConstant)constant1))).collect(Collectors.toSet());
    }
}

