/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.valueset;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.valueset.EnumConstant;
import de.fhlintstone.generator.valueset.EnumData;
import de.fhlintstone.generator.valueset.ICodeEmitter;
import jakarta.annotation.Generated;
import java.io.File;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.lang.model.element.Modifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class CodeEmitter
implements ICodeEmitter {
    @lombok.Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(CodeEmitter.class);

    @Override
    public void generate(EnumData enumData) throws GeneratorException {
        ClassName qualifiedName = enumData.getClassName();
        logger.debug("Generating code of enum {} for ValueSet {}", (Object)qualifiedName.canonicalName(), (Object)enumData.getValueSetName());
        List<EnumConstant> sortedConstants = enumData.getEnumConstants().stream().sorted((c1, c2) -> c1.getConstantName().compareTo(c2.getConstantName())).toList();
        TypeSpec.Builder enumBuilder = this.initializeBuilder(enumData);
        this.addConstants(enumBuilder, sortedConstants);
        this.generateMethodFromCode(enumBuilder, enumData, sortedConstants);
        this.generateMethodToCode(enumBuilder, sortedConstants);
        this.generateMethodFromCoding(enumBuilder, enumData, sortedConstants);
        this.generateMethodToCoding(enumBuilder, enumData, sortedConstants);
        this.generateMethodGetSystem(enumBuilder, sortedConstants);
        this.generateMethodGetDisplay(enumBuilder, sortedConstants);
        this.writeEnumToFile(enumBuilder, enumData);
        logger.exit();
    }

    private TypeSpec.Builder initializeBuilder(EnumData enumData) {
        logger.entry(new Object[]{enumData});
        TypeSpec.Builder enumBuilder = TypeSpec.enumBuilder((ClassName)enumData.getClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"fhlintstone"}).addMember("date", "$S", new Object[]{ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT)}).build()).addJavadoc("Representation of the HL7 FHIR ValueSet $L.\n($L)\n", new Object[]{enumData.getValueSetName(), enumData.getValueSetURL()});
        Optional<String> valueSetDescription = enumData.getDescription();
        if (valueSetDescription.isPresent()) {
            enumBuilder.addJavadoc(valueSetDescription.get(), new Object[0]);
        }
        return (TypeSpec.Builder)logger.exit((Object)enumBuilder);
    }

    private void addConstants(TypeSpec.Builder enumBuilder, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        for (EnumConstant constant : sortedConstants) {
            enumBuilder.addEnumConstant(constant.getConstantName(), TypeSpec.anonymousClassBuilder((CodeBlock)CodeBlock.of((String)"", (Object[])new Object[0])).addJavadoc("$L ($L)", new Object[]{constant.getCode(), constant.getDisplay().orElse("?")}).build());
        }
        logger.exit();
    }

    private void generateMethodFromCode(TypeSpec.Builder enumBuilder, EnumData enumData, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"fromCode").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)enumData.getClassName()).addParameter(String.class, "codeString", new Modifier[0]).addException(FHIRException.class).addJavadoc("Attempts to determine the {@link $1T} value from the code provided.\n@param codeString the code to interpret\n@return the {@link $1T} value if the code could be interpreted\n@throws FHIRException if the code does not match any of the known values\n", new Object[]{enumData.getClassName()}).beginControlFlow("if (codeString == null || \"\".equals(codeString))", new Object[0]).addStatement("return null", new Object[0]).endControlFlow();
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.beginControlFlow("if ($S.equals(codeString))", new Object[]{constant.getCode()}).addStatement("return $L", new Object[]{constant.getConstantName()}).endControlFlow();
        }
        methodBuilder.addStatement("throw new $T(String.format($S, codeString))", new Object[]{FHIRException.class, String.format("Unknown %s code %%s", enumData.getValueSetName())});
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void generateMethodToCode(TypeSpec.Builder enumBuilder, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"toCode").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addJavadoc("Returns the code associated with the enum value.\n@return the code associated with the enum value\n", new Object[0]).beginControlFlow("switch(this)", new Object[0]);
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.addStatement("case $L: return $S", new Object[]{constant.getConstantName(), constant.getCode()});
        }
        methodBuilder.addStatement("default: return \"?\"", new Object[0]);
        methodBuilder.endControlFlow();
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void generateMethodFromCoding(TypeSpec.Builder enumBuilder, EnumData enumData, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"fromCoding").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)enumData.getClassName()).addParameter(enumData.getCodingType(), "coding", new Modifier[0]).addException(FHIRException.class).addJavadoc("Attempts to determine the {@link $1T} value from the Coding instance provided.\n@param coding the Coding to interpret\n@return the {@link $1T} value if the Coding could be interpreted\n@throws FHIRException if the Coding system or code does not match any of the known values\n", new Object[]{enumData.getClassName()});
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.beginControlFlow("if (coding.is($S, $S))", new Object[]{constant.getSystem(), constant.getCode()}).addStatement("return $L", new Object[]{constant.getConstantName()}).endControlFlow();
        }
        methodBuilder.addStatement("throw new $T(String.format($S, coding))", new Object[]{FHIRException.class, String.format("Unknown %s coding %%s", enumData.getValueSetName())});
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void generateMethodToCoding(TypeSpec.Builder enumBuilder, EnumData enumData, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"toCoding").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(enumData.getCodingType()).addJavadoc("Returns a Coding instance representing the enum value.\n@return a Coding instance representing the enum value\n", new Object[0]).beginControlFlow("switch(this)", new Object[0]);
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.addStatement("case $L: return new $T($S, $S, $S)", new Object[]{constant.getConstantName(), enumData.getCodingType(), constant.getSystem(), constant.getCode(), constant.getDisplay().orElse("?")});
        }
        methodBuilder.addStatement("default:throw new $T(\"Unexpected enum value\")", new Object[]{FHIRException.class});
        methodBuilder.endControlFlow();
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void generateMethodGetSystem(TypeSpec.Builder enumBuilder, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getSystem").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addJavadoc("Returns the code system associated with the enum value.\n@return the code system associated with the enum value\n", new Object[0]).beginControlFlow("switch(this)", new Object[0]);
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.addStatement("case $L: return $S", new Object[]{constant.getConstantName(), constant.getSystem()});
        }
        methodBuilder.addStatement("default: return \"?\"", new Object[0]);
        methodBuilder.endControlFlow();
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void generateMethodGetDisplay(TypeSpec.Builder enumBuilder, List<EnumConstant> sortedConstants) {
        logger.entry(new Object[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"getDisplay").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addJavadoc("Returns the display text associated with the enum value.\n@return the display text associated with the enum value\n", new Object[0]).beginControlFlow("switch(this)", new Object[0]);
        for (EnumConstant constant : sortedConstants) {
            methodBuilder.addStatement("case $L: return $S", new Object[]{constant.getConstantName(), constant.getDisplay().orElse("?")});
        }
        methodBuilder.addStatement("default: return \"?\"", new Object[0]);
        methodBuilder.endControlFlow();
        enumBuilder.addMethod(methodBuilder.build());
        logger.exit();
    }

    private void writeEnumToFile(TypeSpec.Builder enumBuilder, EnumData enumData) throws GeneratorException {
        logger.entry(new Object[0]);
        TypeSpec enumSpec = enumBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)enumData.getClassName().packageName(), (TypeSpec)enumSpec).skipJavaLangImports(true).indent("\t").build();
        try {
            javaFile.writeTo(new File(enumData.getOutputPath()));
        }
        catch (IOException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to write generated implementation %s to output path %s", enumData.getClassName().canonicalName(), enumData.getOutputPath()), e));
        }
        logger.exit();
    }
}

