/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.structuredefinition.intermediate;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.accessors.implementations.MappedType;
import de.fhlintstone.accessors.implementations.TypeLocatorException;
import de.fhlintstone.accessors.model.IBaseAccessor;
import de.fhlintstone.accessors.model.ICanonicalTypeAccessor;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IElementDefinitionBindingComponentAccessor;
import de.fhlintstone.accessors.model.IElementTypeRefComponentAccessor;
import de.fhlintstone.accessors.model.IPrimitiveTypeAccessor;
import de.fhlintstone.accessors.model.IPropertyAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.accessors.model.ITypeAccessor;
import de.fhlintstone.accessors.model.StringifiedValue;
import de.fhlintstone.fhir.ClassAnnotation;
import de.fhlintstone.fhir.ExtensionType;
import de.fhlintstone.fhir.IStructureDefinitionIntrospector;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import de.fhlintstone.fhir.elements.ElementBaseRelationship;
import de.fhlintstone.fhir.elements.IElementTree;
import de.fhlintstone.fhir.elements.IElementTreeBuilder;
import de.fhlintstone.fhir.elements.IElementTreeNode;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.IGeneratedTypeNameRegistry;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeFixedValue;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformation;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformationBuilder;
import de.fhlintstone.generator.structuredefinition.intermediate.TypeAttribute;
import de.fhlintstone.generator.structuredefinition.intermediate.TypeFixedValue;
import de.fhlintstone.generator.structuredefinition.intermediate.TypeInformation;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import de.fhlintstone.process.config.NestedClassConfiguration;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import de.fhlintstone.utilities.StringUtilities;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.SourceVersion;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class TypeInformationBuilder
implements ITypeInformationBuilder {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(TypeInformationBuilder.class);
    private final IPackageRegistry packageRegistry;
    private final IAccessorProvider accessorProvider;
    private final IFrameworkTypeLocator frameworkTypeLocator;
    private final IGeneratedTypeNameRegistry generatedTypeNameRegistry;
    private final IStructureDefinitionIntrospector structureDefinitionIntrospector;
    private final IElementTreeBuilder elementTreeBuilder;

    @Inject
    public TypeInformationBuilder(IPackageRegistry packageRegistry, IAccessorProvider accessorProvider, IFrameworkTypeLocator frameworkTypeLocator, IGeneratedTypeNameRegistry generatedTypeNameRegistry, IStructureDefinitionIntrospector structureDefinitionIntrospector, IElementTreeBuilder elementTreeBuilder) {
        this.packageRegistry = packageRegistry;
        this.accessorProvider = accessorProvider;
        this.frameworkTypeLocator = frameworkTypeLocator;
        this.generatedTypeNameRegistry = generatedTypeNameRegistry;
        this.structureDefinitionIntrospector = structureDefinitionIntrospector;
        this.elementTreeBuilder = elementTreeBuilder;
    }

    @Override
    public Optional<ITypeInformation> buildTypeInformation(ProcessConfiguration configuration, IDependencyNode dependencyNode) throws GeneratorException {
        logger.entry(new Object[]{dependencyNode});
        Optional<IBaseResource> resource = this.resolveResource(dependencyNode);
        if (resource.isPresent()) {
            FhirResourceType resourceType = dependencyNode.getResourceType().orElse(FhirResourceType.fromResource(resource.get()));
            if (resourceType != FhirResourceType.STRUCTURE_DEFINITION) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("TypeInformationBuilder for Structure Definitions called for unsupported resource type %s", new Object[]{resourceType})));
            }
        } else {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Resource %s can not be resolved", dependencyNode.getResourceURI())));
        }
        Optional<? extends ITypeInformation> typeInformation = this.buildTopLevelType(configuration, dependencyNode, resource.get());
        return (Optional)logger.exit(typeInformation.map(t -> t));
    }

    private Optional<IBaseResource> resolveResource(IDependencyNode dependencyNode) {
        logger.entry(new Object[]{dependencyNode});
        URI uri = dependencyNode.getResourceURI();
        Optional<Object> resource = dependencyNode.getResource();
        if (!resource.isPresent()) {
            try {
                resource = this.packageRegistry.getUniqueResource(uri);
            }
            catch (AmbiguousResourceURIException e) {
                logger.warn("Unable to resolve resource {}", (Object)uri, (Object)e);
                resource = Optional.empty();
            }
        }
        if (resource.isEmpty()) {
            logger.warn("Ignoring unresolvable resource {}", (Object)uri);
        }
        return (Optional)logger.exit(resource);
    }

    private Optional<? extends ITypeInformation> buildTopLevelType(ProcessConfiguration configuration, IDependencyNode dependencyNode, IBaseResource resource) throws GeneratorException {
        logger.entry(new Object[]{dependencyNode, resource});
        TypeInformation newType = null;
        URI uri = dependencyNode.getResourceURI();
        IStructureDefinitionAccessor accessor = this.accessorProvider.provideStructureDefinitionAccessor(resource);
        Optional<StructureDefinitionClassConfiguration> classConfiguration = configuration.getStructureDefinition(uri);
        Optional<TypeName> frameworkType = dependencyNode.getFrameworkType();
        if (frameworkType.isPresent()) {
            newType = this.buildTopLevelFrameworkType(resource, uri, accessor, frameworkType.get());
        } else {
            ExtensionType extensionType = this.determineExtensionType(accessor);
            if (extensionType == ExtensionType.SIMPLE) {
                newType = this.buildTopLevelSimpleExtension(resource, uri, accessor);
            } else if (classConfiguration.isPresent()) {
                IElementTree elementTree = this.createElementTree(accessor);
                newType = extensionType == ExtensionType.COMPLEX ? this.buildTopLevelComplexExtension(classConfiguration.get(), resource, uri, accessor, elementTree) : this.buildTopLevelStructure(classConfiguration.get(), resource, uri, accessor, elementTree);
                for (NestedClassConfiguration nestedConfiguration : classConfiguration.get().getNestedClasses()) {
                    newType.addNestedType(this.buildNestedType(classConfiguration.get(), nestedConfiguration, resource, uri, accessor, elementTree));
                }
                this.generateFixedValues(newType, elementTree);
            } else {
                logger.warn("No configuration entry found for StructureDefinition {}. No class will be generated for this StructureDefinition.", (Object)uri);
            }
        }
        return (Optional)logger.exit(Optional.ofNullable(newType));
    }

    private ITypeInformation buildNestedType(StructureDefinitionClassConfiguration topLevelConfiguration, NestedClassConfiguration nestedConfiguration, IBaseResource resource, URI uri, IStructureDefinitionAccessor topLevelAccessor, IElementTree elementTree) throws GeneratorException {
        Optional<ClassAnnotation> classAnnotation;
        String elementId = nestedConfiguration.getElementId();
        logger.entry(new Object[]{uri, elementId});
        logger.info("Adding nested type information for element {} of StructureDefinition {}", (Object)elementId, (Object)uri);
        IElementTreeNode elementNode = elementTree.getNode(elementId).orElseThrow(() -> new GeneratorException(String.format("Unable to locate element %s in element tree of StructureDefinition %s", elementId, topLevelAccessor.getName().orElse("(none)"))));
        String typeCode = this.determineNestedElementTypeCode(uri, topLevelAccessor, elementId, elementNode);
        try {
            URI structureDefinitionReference = this.frameworkTypeLocator.makeAbsoluteStructureDefinitionReference(typeCode);
            IStructureDefinitionAccessor structureDefinition = this.accessorProvider.provideStructureDefinitionAccessor(structureDefinitionReference);
            classAnnotation = this.structureDefinitionIntrospector.getClassAnnotation(structureDefinition);
        }
        catch (URISyntaxException e) {
            throw new GeneratorException(String.format("Unable to determine StructureDefinition URI from type code %s for element %s in element tree of StructureDefinition %s", typeCode, elementId, topLevelAccessor.getName().orElse("(none)")));
        }
        ClassName nestedTypeName = this.generatedTypeNameRegistry.getNestedClassName(uri, elementId).orElseThrow();
        ClassName parentType = ClassName.bestGuess((String)nestedConfiguration.getSuperClass());
        TypeInformation newType = TypeInformation.builder().withResourceURI(uri).withResource(resource).withElementId(Optional.of(elementId)).withGenerated(true).withDefinitionName(typeCode).withTypeName((TypeName)nestedTypeName).withClassAnnotation(classAnnotation).withTopLevelConfiguration(Optional.of(topLevelConfiguration)).withNestedConfiguration(Optional.of(nestedConfiguration)).withParentTypeName(Optional.of(parentType)).build();
        this.generateStructureAttributes(newType, elementNode);
        return (ITypeInformation)logger.exit((Object)newType);
    }

    private String determineNestedElementTypeCode(URI uri, IStructureDefinitionAccessor topLevelAccessor, String elementId, IElementTreeNode elementNode) throws GeneratorException {
        logger.entry(new Object[]{elementNode});
        Set typeCodes = elementNode.getSnapshotElement().getType().stream().map(type -> type.getCode()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        if (typeCodes.isEmpty()) {
            throw new GeneratorException(String.format("Unable to determine type code of element %s in element tree of StructureDefinition %s", elementId, topLevelAccessor.getName().orElse("(none)")));
        }
        if (typeCodes.size() > 1) {
            throw new GeneratorException(String.format("Unable to process multiple type codes of element %s in element tree of StructureDefinition %s", elementId, topLevelAccessor.getName().orElse("(none)")));
        }
        String typeCode = (String)typeCodes.iterator().next();
        logger.debug("Type code of element {} of StructureDefinition {} is {}", new Object[]{elementId, uri, typeCode});
        return (String)logger.exit((Object)typeCode);
    }

    private ExtensionType determineExtensionType(IStructureDefinitionAccessor accessor) {
        logger.entry(new Object[]{accessor});
        ExtensionType extensionType = ExtensionType.NONE;
        try {
            extensionType = this.structureDefinitionIntrospector.getExtensionType(accessor);
        }
        catch (GeneratorException e) {
            logger.warn("Unable to determine extension type of StructureDefinition {}, assuming this is not an Extension", (Object)accessor.getUrl().orElseThrow(), (Object)e);
        }
        return (ExtensionType)((Object)logger.exit((Object)extensionType));
    }

    private TypeInformation buildTopLevelFrameworkType(IBaseResource resource, URI uri, IStructureDefinitionAccessor accessor, TypeName frameworkType) throws GeneratorException {
        logger.entry(new Object[]{uri});
        Optional<ClassAnnotation> classAnnotation = this.structureDefinitionIntrospector.getClassAnnotationForFrameworkType(frameworkType);
        if (accessor.getSnapshot().isEmpty()) {
            throw new GeneratorException("Unable to work with framework types where the FHIR package does not contain a snapshot.");
        }
        logger.debug("StructureDefinition {} is a framework type that does not require a generated class", (Object)uri);
        TypeInformation newType = TypeInformation.builder().withResourceURI(uri).withResource(resource).withDefinitionName(accessor.getName().orElseThrow()).withDescription(accessor.getDescription()).withGenerated(false).withTypeName(frameworkType).withClassAnnotation(classAnnotation).build();
        return (TypeInformation)logger.exit((Object)newType);
    }

    private TypeInformation buildTopLevelSimpleExtension(IBaseResource resource, URI uri, IStructureDefinitionAccessor accessor) {
        logger.entry(new Object[]{uri});
        logger.debug("StructureDefinition {} is a simple extension that does not require a generated class", (Object)uri);
        TypeInformation newType = TypeInformation.builder().withResourceURI(uri).withResource(resource).withDefinitionName(accessor.getName().orElseThrow()).withDescription(accessor.getDescription()).withGenerated(false).withTypeName(this.frameworkTypeLocator.getExtensionType()).build();
        return (TypeInformation)logger.exit((Object)newType);
    }

    private TypeInformation buildTopLevelComplexExtension(StructureDefinitionClassConfiguration classConfiguration, IBaseResource resource, URI uri, IStructureDefinitionAccessor accessor, IElementTree elementTree) throws GeneratorException {
        logger.entry(new Object[]{uri});
        TypeInformation newType = this.prepareTopLevelClassInformation(classConfiguration, resource, uri, accessor, this.frameworkTypeLocator.getBackboneElementType());
        this.generateExtensionAttributes(newType, elementTree.getRootNode());
        return (TypeInformation)logger.exit((Object)newType);
    }

    private TypeInformation buildTopLevelStructure(StructureDefinitionClassConfiguration classConfiguration, IBaseResource resource, URI uri, IStructureDefinitionAccessor accessor, IElementTree elementTree) throws GeneratorException {
        logger.entry(new Object[]{uri});
        TypeInformation newType = this.prepareTopLevelClassInformation(classConfiguration, resource, uri, accessor, this.determineParentTypeName(accessor));
        this.generateStructureAttributes(newType, elementTree.getRootNode());
        return (TypeInformation)logger.exit((Object)newType);
    }

    private TypeInformation prepareTopLevelClassInformation(StructureDefinitionClassConfiguration classConfiguration, IBaseResource resource, URI uri, IStructureDefinitionAccessor accessor, TypeName parentTypeName) throws GeneratorException {
        logger.entry(new Object[]{uri});
        ClassName typeName = this.generatedTypeNameRegistry.getClassName(classConfiguration.getStructureDefinition()).orElseThrow();
        Optional<ClassAnnotation> classAnnotation = this.structureDefinitionIntrospector.getClassAnnotation(accessor);
        this.ensureSnapshotExists(uri, accessor);
        logger.debug("Building type information for class {} from StructureDefinition {}", (Object)typeName.canonicalName(), (Object)uri);
        TypeInformation newType = TypeInformation.builder().withResourceURI(uri).withResource(resource).withDefinitionName(accessor.getName().orElseThrow()).withDescription(accessor.getDescription()).withGenerated(true).withTypeName((TypeName)typeName).withTopLevelConfiguration(Optional.of(classConfiguration)).withParentTypeName(Optional.of(parentTypeName)).withClassAnnotation(classAnnotation).build();
        return (TypeInformation)logger.exit((Object)newType);
    }

    private TypeName determineParentTypeName(IStructureDefinitionAccessor accessor) throws GeneratorException {
        logger.entry(new Object[]{accessor});
        Optional<String> baseDefinition = accessor.getBaseDefinition();
        if (baseDefinition.isPresent()) {
            URI baseDefinitionURI;
            try {
                baseDefinitionURI = this.frameworkTypeLocator.makeAbsoluteStructureDefinitionReference(baseDefinition.get());
            }
            catch (URISyntaxException e) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to resolve BaseDefinition %s of StructureDefinition %s.", baseDefinition.get(), accessor.getUrl().orElse("(unknown)")), e));
            }
            Optional<ClassName> generatedType = this.generatedTypeNameRegistry.getClassName(baseDefinitionURI);
            if (generatedType.isPresent()) {
                return (TypeName)logger.exit((Object)generatedType.get());
            }
            Optional<TypeName> frameworkType = this.frameworkTypeLocator.determineType(baseDefinitionURI);
            if (frameworkType.isPresent()) {
                return (TypeName)logger.exit((Object)frameworkType.get());
            }
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("BaseDefinition %s of StructureDefinition %s is neither a framework type nor configured for class generation", baseDefinitionURI, accessor.getUrl().orElse("(unknown)"))));
        }
        throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("StructureDefinition %s has no baseDefinition, unable to determine parent type", accessor.getUrl().orElse("(unknown)"))));
    }

    private void ensureSnapshotExists(URI uri, IStructureDefinitionAccessor accessor) throws GeneratorException {
        logger.entry(new Object[]{uri});
        if (accessor.getSnapshot().isEmpty()) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("StructureDefinition %s does not have a snapshot", uri)));
        }
        logger.exit();
    }

    private IElementTree createElementTree(IStructureDefinitionAccessor accessor) throws GeneratorException {
        Optional<IBaseResource> baseResource;
        logger.entry(new Object[]{accessor});
        try {
            baseResource = this.packageRegistry.getUniqueResource(URI.create(accessor.getBaseDefinition().orElseThrow(() -> new GeneratorException("StructureDefinition must have a baseDefinition set"))));
        }
        catch (AmbiguousResourceURIException e) {
            throw new GeneratorException("Resource URI is not unique", e);
        }
        IStructureDefinitionAccessor baseAccessor = this.accessorProvider.provideStructureDefinitionAccessor(baseResource.orElseThrow(() -> new GeneratorException("Unable to load resource")));
        IElementTree elementTree = this.elementTreeBuilder.buildElementTree(accessor, baseAccessor);
        return (IElementTree)logger.exit((Object)elementTree);
    }

    private void generateExtensionAttributes(TypeInformation information, IElementTreeNode elementTreeNode) throws GeneratorException {
        logger.entry(new Object[]{elementTreeNode});
        IElementTreeNode extensionNode = elementTreeNode.getChild("extension").orElseThrow(() -> new GeneratorException("A complex extension must have an Extension.extension element"));
        for (IElementTreeNode slice : extensionNode.getSlices()) {
            ImmutableCollection<IMappedType> modelTypes;
            String fhirName = slice.getSliceName().orElseThrow();
            ImmutableList<IElementTypeRefComponentAccessor> sliceTypes = slice.getSnapshotElement().getType();
            if (sliceTypes.size() != 1) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Slice %s has no or multiple type entries, expected exactly one", slice.getId())));
            }
            String sliceTypeCode = ((IElementTypeRefComponentAccessor)sliceTypes.get(0)).getCode().orElse("(not set)");
            if (!sliceTypeCode.equals("Extension")) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Slice %s has type code %s, expected Extension", slice.getId(), sliceTypeCode)));
            }
            ImmutableList<ICanonicalTypeAccessor> sliceTypeProfiles = ((IElementTypeRefComponentAccessor)sliceTypes.get(0)).getProfile();
            if (sliceTypeProfiles.isEmpty()) {
                IElementTreeNode valueNode = slice.getChild("value[x]").orElseThrow(() -> new GeneratorException(String.format("Element Extension.value[x] is missing in element %s", slice.getId())));
                modelTypes = this.getModelTypes(valueNode.getSnapshotElement(), information.getResourceURI());
                Optional<String> valueSet = this.getBindingValueSet(valueNode.getSnapshotElement());
                IElementDefinitionAccessor element = slice.getSnapshotElement();
                TypeName attributeType = this.getAttributeType(slice.getId(), modelTypes);
                logger.debug("Generating attribute for inline extension element {}", (Object)slice.getId());
                information.addAttribute(TypeAttribute.builder().withJavaName(this.mapFhirNameToAttributeName(fhirName)).withFhirName(fhirName).withElementId(slice.getId()).withElement(element).withMin(this.mapMinCardinality(element)).withMax(this.mapMaxCardinality(element)).withAttributeType(attributeType).withModelTypes((Iterable<? extends IMappedType>)modelTypes).withExtensionUrl(Optional.of(fhirName)).withExtension(true).withModifier(false).withDefinition(element.getDefinition()).withShortDefinition(element.getShort()).withBindingValueSet(valueSet).build());
                continue;
            }
            List<String> profileStrings = sliceTypeProfiles.stream().map(canonical -> canonical.getValue().orElse("")).filter(s -> !Strings.isNullOrEmpty((String)s)).toList();
            modelTypes = this.getModelTypes(slice.getId(), profileStrings);
            IElementDefinitionAccessor element = slice.getSnapshotElement();
            TypeName attributeType = this.getAttributeType(slice.getId(), modelTypes);
            Optional<String> typeProfile = element.getType().stream().flatMap(t -> t.getProfile().stream()).map(canonical -> canonical.getValue().orElse("")).filter(s -> !Strings.isNullOrEmpty((String)s)).findFirst();
            logger.debug("Generating attribute for nested extension element {}", (Object)slice.getId());
            information.addAttribute(TypeAttribute.builder().withJavaName(this.mapFhirNameToAttributeName(fhirName)).withFhirName(fhirName).withElementId(slice.getId()).withElement(element).withMin(this.mapMinCardinality(element)).withMax(this.mapMaxCardinality(element)).withAttributeType(attributeType).withModelTypes((Iterable<? extends IMappedType>)modelTypes).withExtensionUrl(typeProfile).withExtension(true).withModifier(false).withDefinition(element.getDefinition()).withShortDefinition(element.getShort()).build());
        }
        logger.exit();
    }

    private void generateStructureAttributes(TypeInformation information, IElementTreeNode elementTreeNode) throws GeneratorException {
        logger.entry(new Object[]{elementTreeNode});
        for (IElementTreeNode node : elementTreeNode.getChildren()) {
            String fhirName = node.getLocalName();
            if (node.getBaseRelationship() == ElementBaseRelationship.ADDED) {
                ImmutableCollection<IMappedType> modelTypes = this.getModelTypes(node.getSnapshotElement(), information.getResourceURI());
                Optional<String> valueSet = this.getBindingValueSet(node.getSnapshotElement());
                IElementDefinitionAccessor element = node.getSnapshotElement();
                TypeName attributeType = this.getAttributeType(node.getId(), modelTypes);
                logger.debug("Generating attribute for added element {}", (Object)node.getId());
                information.addAttribute(TypeAttribute.builder().withJavaName(this.mapFhirNameToAttributeName(fhirName)).withFhirName(fhirName).withElementId(node.getId()).withElement(element).withMin(this.mapMinCardinality(element)).withMax(this.mapMaxCardinality(element)).withAttributeType(attributeType).withModelTypes((Iterable<? extends IMappedType>)modelTypes).withExtension(false).withModifier(false).withDefinition(element.getDefinition()).withShortDefinition(element.getShort()).withBindingValueSet(valueSet).build());
            }
            boolean isExtension = fhirName.equals("extension");
            boolean isModifierExtension = fhirName.equals("modifierExtension");
            if (!isExtension && !isModifierExtension) continue;
            for (IElementTreeNode extensionNode : node.getSlices()) {
                if (extensionNode.getBaseRelationship() == ElementBaseRelationship.UNCHANGED) continue;
                this.generateAttributeForExtension(information, isExtension, isModifierExtension, extensionNode);
            }
        }
        logger.exit();
    }

    private void generateAttributeForExtension(TypeInformation information, boolean isExtension, boolean isModifierExtension, IElementTreeNode extensionNode) throws GeneratorException {
        logger.entry(new Object[]{extensionNode});
        logger.debug("Generating attribute for{}extension {}", (Object)(isModifierExtension ? " modifier " : " "), (Object)extensionNode.getId());
        String fhirName = extensionNode.getSliceName().orElseThrow();
        IElementDefinitionAccessor element = extensionNode.getSnapshotElement();
        List<String> extensionProfiles = element.getType().stream().filter(type -> type.getCode().orElse("").equals("Extension")).flatMap(type -> type.getProfile().stream()).map(canonical -> canonical.getValue().orElse("")).filter(s -> !Strings.isNullOrEmpty((String)s)).toList();
        if (extensionProfiles.size() != 1) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Type of extension %s is not present or not unique", element.getId())));
        }
        ImmutableCollection<IMappedType> modelTypes = this.getModelTypes(extensionNode.getId(), extensionProfiles);
        TypeName attributeType = this.getAttributeType(extensionNode.getId(), modelTypes);
        Optional<String> valueSet = this.getBindingValueSet(element);
        information.addAttribute(TypeAttribute.builder().withJavaName(this.mapFhirNameToAttributeName(fhirName)).withFhirName(fhirName).withElement(element).withElementId(extensionNode.getId()).withMin(this.mapMinCardinality(element)).withMax(this.mapMaxCardinality(element)).withAttributeType(attributeType).withModelTypes((Iterable<? extends IMappedType>)modelTypes).withExtension(isExtension || isModifierExtension).withModifier(isModifierExtension).withExtensionUrl(Optional.of(extensionProfiles.getFirst())).withDefinition(element.getDefinition()).withShortDefinition(element.getShort()).withBindingValueSet(valueSet).build());
        logger.exit();
    }

    private int mapMinCardinality(IElementDefinitionAccessor element) throws GeneratorException {
        logger.entry(new Object[]{element});
        Optional<Integer> min = element.getMin();
        if (min.isEmpty()) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("min cardinality of element %s is missing", element.getId())));
        }
        return (Integer)logger.exit((Object)min.get());
    }

    private int mapMaxCardinality(IElementDefinitionAccessor element) throws GeneratorException {
        Optional<String> max = element.getMax();
        if (max.isEmpty()) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("max cardinality of element %s is missing", element.getId())));
        }
        String maxValue = max.get();
        if (maxValue.equals("*")) {
            return (Integer)logger.exit((Object)-1);
        }
        try {
            return (Integer)logger.exit((Object)Integer.parseInt(maxValue));
        }
        catch (NumberFormatException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("max cardinality of element %s is not * or a valid number", element.getId()), e));
        }
    }

    private String mapFhirNameToAttributeName(String localName) throws GeneratorException {
        logger.entry(new Object[]{localName});
        Object newName = StringUtilities.toFirstLower(localName);
        newName = StringUtilities.separatorToCamelCase((String)newName, "-");
        if (SourceVersion.isKeyword((CharSequence)newName)) {
            newName = "_" + (String)newName;
        }
        if (!SourceVersion.isIdentifier((CharSequence)newName)) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to determine valid identifier for FHIR attribute %s", localName)));
        }
        return (String)logger.exit(newName);
    }

    private Optional<String> getBindingValueSet(IElementDefinitionAccessor element) {
        logger.entry(new Object[]{element});
        Optional<Object> result = Optional.empty();
        Optional<IElementDefinitionBindingComponentAccessor> binding = element.getBinding();
        if (binding.isPresent()) {
            result = binding.get().getValueSet();
        }
        return (Optional)logger.exit(result);
    }

    private ImmutableCollection<IMappedType> getModelTypes(IElementDefinitionAccessor element, URI topLevelTypeURI) throws GeneratorException {
        logger.entry(new Object[]{element});
        String elementId = element.getId().orElseThrow();
        try {
            ImmutableCollection<IMappedType> modelTypes = this.frameworkTypeLocator.determineModelTypes(element, uri -> {
                ClassName preferredType = null;
                preferredType = this.generatedTypeNameRegistry.getNestedClassName(topLevelTypeURI, elementId).orElse(null);
                if (preferredType == null) {
                    preferredType = this.generatedTypeNameRegistry.getClassName((URI)uri).orElse(null);
                }
                return Optional.ofNullable(preferredType);
            });
            return (ImmutableCollection)logger.exit(modelTypes);
        }
        catch (TypeLocatorException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(e.getMessage(), e));
        }
    }

    private ImmutableCollection<IMappedType> getModelTypes(String id, List<String> extensionProfiles) throws GeneratorException {
        ImmutableSet modelTypes;
        IBaseResource extensionResource;
        logger.entry(new Object[]{id});
        String extensionProfile = extensionProfiles.getFirst();
        URI extensionURI = URI.create(extensionProfile);
        try {
            extensionResource = this.packageRegistry.getUniqueResource(FhirResourceType.STRUCTURE_DEFINITION, extensionURI).orElseThrow(() -> (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Type of extension %s could not be located", id))));
        }
        catch (AmbiguousResourceURIException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Type of extension %s could not be located", id), e));
        }
        IStructureDefinitionAccessor extensionAccessor = this.accessorProvider.provideStructureDefinitionAccessor(extensionResource);
        ExtensionType extensionType = this.structureDefinitionIntrospector.getExtensionType(extensionAccessor);
        switch (extensionType) {
            case SIMPLE: {
                IElementTree extensionElementTree = this.elementTreeBuilder.buildElementTree(extensionAccessor);
                IElementTreeNode valueNode = extensionElementTree.getNode("Extension.value[x]").orElseThrow(() -> new GeneratorException(String.format("Element Extension.value[x] is missing in Extension %s", extensionURI)));
                modelTypes = this.getModelTypes(valueNode.getSnapshotElement(), extensionURI);
                break;
            }
            case COMPLEX: {
                Optional<ClassName> generatedType = this.generatedTypeNameRegistry.getClassName(extensionURI);
                if (generatedType.isPresent()) {
                    modelTypes = ImmutableSet.of((Object)MappedType.builder().withTypeCode(Optional.of("Extension")).withTypeCodeURI(Optional.of(URI.create("http://hl7.org/fhir/StructureDefinition/Extension"))).withProfile(Optional.of(extensionProfile)).withProfileURI(Optional.of(extensionURI)).withPreferredType(Optional.of((TypeName)generatedType.get())).build());
                    break;
                }
                logger.warn("No generated type for Extension {}, defaulting to generic implementation", (Object)extensionURI);
                try {
                    modelTypes = ImmutableSet.of((Object)MappedType.builder().withTypeCode(Optional.of("Extension")).withTypeCodeURI(Optional.of(this.frameworkTypeLocator.makeAbsoluteStructureDefinitionReference("Extension"))).withPreferredType(Optional.of(this.frameworkTypeLocator.getExtensionType())).build());
                    break;
                }
                catch (URISyntaxException e) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(e.getMessage(), e));
                }
            }
            default: {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException("Extension type must be SIMPLE or COMPLEX at this point"));
            }
        }
        return (ImmutableCollection)logger.exit(modelTypes);
    }

    private TypeName getAttributeType(String id, ImmutableCollection<IMappedType> modelTypes) throws GeneratorException {
        logger.entry(new Object[]{id});
        if (modelTypes.isEmpty()) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("No type for element %s found", id)));
        }
        if (modelTypes.size() > 1) {
            return this.frameworkTypeLocator.getGenericType();
        }
        return ((IMappedType)modelTypes.stream().findFirst().orElseThrow()).getType().orElseThrow();
    }

    private void generateFixedValues(TypeInformation newType, IElementTree elementTree) {
        logger.entry(new Object[]{newType, elementTree});
        Map<String, TypeInformation> targetTypes = newType.getNestedTypes().stream().map(nt -> (TypeInformation)nt).collect(Collectors.toMap(nt -> nt.getElementId().orElseThrow(), nt -> nt));
        this.generateFixedValuesForType(newType, elementTree.getRootNode(), targetTypes);
        logger.exit();
    }

    private void generateFixedValuesForType(TypeInformation newType, IElementTreeNode rootNode, Map<String, TypeInformation> targetTypes) {
        logger.entry(new Object[]{newType, rootNode});
        logger.info("Generating fixed values for type {}", (Object)newType.getTypeName());
        for (IElementTreeNode childNode : rootNode.getChildren()) {
            this.generateFixedValuesForNode(childNode, targetTypes).forEach(newType::addFixedValue);
        }
        if (rootNode.hasSlices()) {
            logger.warn("Root element {} of type {} has slices - don't know how to handle these, ignoring them for now", (Object)rootNode.getId(), (Object)newType.getTypeName());
        }
        logger.exit();
    }

    private ImmutableList<ITypeFixedValue> generateFixedValuesForNode(IElementTreeNode node, Map<String, TypeInformation> targetTypes) {
        logger.entry(new Object[]{node});
        if (targetTypes.containsKey(node.getId())) {
            this.generateFixedValuesForType(targetTypes.get(node.getId()), node, targetTypes);
            return (ImmutableList)logger.exit((Object)ImmutableList.of());
        }
        ArrayList result = new ArrayList();
        if (node.hasChildren()) {
            this.generateFixedValuesForChildNodes(node, targetTypes).ifPresent(result::add);
        }
        if (!this.isElementExcludedFromFixedValues(node)) {
            this.generateFixedValueForNodeValue(node).ifPresent(result::add);
        }
        if (node.hasSlices()) {
            logger.warn("Slices of element {} are currently not included in fixed / pattern value determination", (Object)node.getId());
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    private Optional<ITypeFixedValue> generateFixedValuesForChildNodes(IElementTreeNode node, Map<String, TypeInformation> targetTypes) {
        Optional<IMappedType> mappedType;
        logger.entry(new Object[]{node});
        URI topLevelTypeURI = node.getTree().getStructureDefinition().getUrl().map(URI::create).orElseThrow();
        IElementDefinitionAccessor snapshotElement = node.getSnapshotElement();
        List childValues = node.getChildren().stream().map(n -> this.generateFixedValuesForNode((IElementTreeNode)n, targetTypes)).flatMap(Collection::stream).toList();
        if (!childValues.isEmpty() && (mappedType = this.getTypeForFixedValue(snapshotElement, topLevelTypeURI)).isPresent()) {
            TypeFixedValue nodeValue = TypeFixedValue.builder().withElementId(snapshotElement.getId().orElseThrow()).withElementPath(snapshotElement.getPath().orElseThrow()).withLocalName(node.getLocalName()).withType(mappedType.get().getType().orElseThrow()).build();
            childValues.forEach(nodeValue::addComponentValue);
            return (Optional)logger.exit(Optional.of(nodeValue));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    private boolean isElementExcludedFromFixedValues(IElementTreeNode node) {
        logger.entry(new Object[]{node});
        String elementId = node.getId();
        if (elementId.endsWith(".meta.profile") || elementId.equals("Extension.url")) {
            return (Boolean)logger.exit((Object)true);
        }
        return (Boolean)logger.exit((Object)false);
    }

    private Optional<ITypeFixedValue> generateFixedValueForNodeValue(IElementTreeNode node) {
        logger.entry(new Object[]{node});
        URI topLevelTypeURI = node.getTree().getStructureDefinition().getUrl().map(URI::create).orElseThrow();
        IElementDefinitionAccessor snapshotElement = node.getSnapshotElement();
        Optional<ITypeAccessor> nodeFixedOrPattern = snapshotElement.getFixed().or(snapshotElement::getPattern);
        if (nodeFixedOrPattern.isPresent()) {
            ITypeAccessor iTypeAccessor = nodeFixedOrPattern.get();
            if (iTypeAccessor instanceof IPrimitiveTypeAccessor) {
                IPrimitiveTypeAccessor primitiveAccessor = (IPrimitiveTypeAccessor)iTypeAccessor;
                Optional<IMappedType> mappedType = this.getTypeForFixedValue(snapshotElement, topLevelTypeURI);
                if (mappedType.isPresent()) {
                    return (Optional)logger.exit(Optional.of(TypeFixedValue.builder().withElementId(snapshotElement.getId().orElseThrow()).withElementPath(snapshotElement.getPath().orElseThrow()).withLocalName(node.getLocalName()).withType(mappedType.get().getType().orElseThrow()).withValue(primitiveAccessor.getStringifiedValue()).build()));
                }
            } else {
                Optional<IMappedType> mappedType;
                List<IPropertyAccessor> properties = nodeFixedOrPattern.get().children().stream().filter(IPropertyAccessor::hasValues).toList();
                if (!properties.isEmpty() && (mappedType = this.getTypeForFixedValue(snapshotElement, topLevelTypeURI)).isPresent()) {
                    TypeFixedValue nodeValue = TypeFixedValue.builder().withElementId(snapshotElement.getId().orElseThrow()).withElementPath(snapshotElement.getPath().orElseThrow()).withLocalName(node.getLocalName()).withType(mappedType.get().getType().orElseThrow()).build();
                    for (IPropertyAccessor property : properties) {
                        IBaseAccessor propertyValue;
                        if (property.getValues().size() > 1) {
                            logger.warn("Multiple values of property {} found - only first value will be used for code generation", (Object)property.getName());
                        }
                        if ((propertyValue = (IBaseAccessor)property.getValues().get(0)) instanceof IPrimitiveTypeAccessor) {
                            IPrimitiveTypeAccessor primitiveValue = (IPrimitiveTypeAccessor)propertyValue;
                            Optional<StringifiedValue> stringifiedValue = primitiveValue.getStringifiedValue();
                            nodeValue.addComponentValue(TypeFixedValue.builder().withElementId(snapshotElement.getId().orElseThrow() + "." + property.getName()).withElementPath(snapshotElement.getPath().orElseThrow() + "." + property.getName()).withLocalName(property.getName()).withType(this.frameworkTypeLocator.getPrimitiveType(stringifiedValue.orElseThrow().getDatatype())).withValue(stringifiedValue).build());
                            continue;
                        }
                        logger.warn("Property {} has non-primitive value of type {} and will be ignored", (Object)property.getName(), (Object)propertyValue.getClass().getCanonicalName());
                    }
                    return (Optional)logger.exit(Optional.of(nodeValue));
                }
            }
        }
        return (Optional)logger.exit(Optional.empty());
    }

    private Optional<IMappedType> getTypeForFixedValue(IElementDefinitionAccessor element, URI topLevelTypeURI) {
        logger.entry(new Object[]{element});
        try {
            ImmutableCollection<IMappedType> types = this.getModelTypes(element, topLevelTypeURI);
            switch (types.size()) {
                case 0: {
                    logger.warn("Unable to determine type to represent element {} as a fixed value, ignoring subtree", (Object)element.getId().orElse("?"));
                    return (Optional)logger.exit(Optional.empty());
                }
                case 1: {
                    return (Optional)logger.exit(Optional.of((IMappedType)types.iterator().next()));
                }
            }
            logger.warn("Unable to uniquely determine type to represent element {} as a fixed value, ignoring subtree", (Object)element.getId().orElse("?"));
            return (Optional)logger.exit(Optional.empty());
        }
        catch (GeneratorException e) {
            logger.warn("Unable to determine types to represent element {} as a fixed value, ignoring subtree", (Object)element.getId().orElse("?"), (Object)e);
            return (Optional)logger.exit(Optional.empty());
        }
    }
}

