/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.structuredefinition.intermediate;

import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.fhir.ClassAnnotation;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeAttribute;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeFixedValue;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformation;
import de.fhlintstone.process.config.NestedClassConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;

public final class TypeInformation
implements ITypeInformation {
    private final URI resourceURI;
    private final IBaseResource resource;
    private final Optional<String> elementId;
    private final boolean generated;
    private final TypeName typeName;
    private final String definitionName;
    private final Optional<String> description;
    private final Optional<ClassAnnotation> classAnnotation;
    private final Optional<StructureDefinitionClassConfiguration> topLevelConfiguration;
    private final Optional<NestedClassConfiguration> nestedConfiguration;
    private final Optional<TypeName> parentTypeName;
    private final List<ITypeAttribute> attributeList = new ArrayList<ITypeAttribute>();
    private final List<ITypeFixedValue> fixedValueList = new ArrayList<ITypeFixedValue>();
    private final List<ITypeInformation> nestedTypeList = new ArrayList<ITypeInformation>();

    @Override
    public ImmutableList<ITypeAttribute> getAttributes() {
        return ImmutableList.copyOf(this.attributeList);
    }

    @Override
    public ImmutableList<ITypeFixedValue> getFixedValues() {
        return ImmutableList.copyOf(this.fixedValueList);
    }

    @Override
    public ImmutableList<ITypeInformation> getNestedTypes() {
        return ImmutableList.copyOf(this.nestedTypeList);
    }

    public void addAttribute(ITypeAttribute attribute) {
        this.attributeList.add(attribute);
    }

    public void addFixedValue(ITypeFixedValue value) {
        this.fixedValueList.add(value);
    }

    public void addNestedType(ITypeInformation nestedType) {
        this.nestedTypeList.add(nestedType);
    }

    @Generated
    private static Optional<String> $default$elementId() {
        return Optional.empty();
    }

    @Generated
    private static Optional<String> $default$description() {
        return Optional.empty();
    }

    @Generated
    private static Optional<ClassAnnotation> $default$classAnnotation() {
        return Optional.empty();
    }

    @Generated
    private static Optional<StructureDefinitionClassConfiguration> $default$topLevelConfiguration() {
        return Optional.empty();
    }

    @Generated
    private static Optional<NestedClassConfiguration> $default$nestedConfiguration() {
        return Optional.empty();
    }

    @Generated
    private static Optional<TypeName> $default$parentTypeName() {
        return Optional.empty();
    }

    @Generated
    TypeInformation(URI resourceURI, IBaseResource resource, Optional<String> elementId, boolean generated, TypeName typeName, String definitionName, Optional<String> description, Optional<ClassAnnotation> classAnnotation, Optional<StructureDefinitionClassConfiguration> topLevelConfiguration, Optional<NestedClassConfiguration> nestedConfiguration, Optional<TypeName> parentTypeName) {
        this.resourceURI = resourceURI;
        this.resource = resource;
        this.elementId = elementId;
        this.generated = generated;
        this.typeName = typeName;
        this.definitionName = definitionName;
        this.description = description;
        this.classAnnotation = classAnnotation;
        this.topLevelConfiguration = topLevelConfiguration;
        this.nestedConfiguration = nestedConfiguration;
        this.parentTypeName = parentTypeName;
    }

    @Generated
    public static TypeInformationBuilder builder() {
        return new TypeInformationBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeInformation)) {
            return false;
        }
        TypeInformation other = (TypeInformation)o;
        if (this.isGenerated() != other.isGenerated()) {
            return false;
        }
        URI this$resourceURI = this.getResourceURI();
        URI other$resourceURI = other.getResourceURI();
        if (this$resourceURI == null ? other$resourceURI != null : !((Object)this$resourceURI).equals(other$resourceURI)) {
            return false;
        }
        IBaseResource this$resource = this.getResource();
        IBaseResource other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        Optional<String> this$elementId = this.getElementId();
        Optional<String> other$elementId = other.getElementId();
        if (this$elementId == null ? other$elementId != null : !((Object)this$elementId).equals(other$elementId)) {
            return false;
        }
        TypeName this$typeName = this.getTypeName();
        TypeName other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$definitionName = this.getDefinitionName();
        String other$definitionName = other.getDefinitionName();
        if (this$definitionName == null ? other$definitionName != null : !this$definitionName.equals(other$definitionName)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Optional<ClassAnnotation> this$classAnnotation = this.getClassAnnotation();
        Optional<ClassAnnotation> other$classAnnotation = other.getClassAnnotation();
        if (this$classAnnotation == null ? other$classAnnotation != null : !((Object)this$classAnnotation).equals(other$classAnnotation)) {
            return false;
        }
        Optional<StructureDefinitionClassConfiguration> this$topLevelConfiguration = this.getTopLevelConfiguration();
        Optional<StructureDefinitionClassConfiguration> other$topLevelConfiguration = other.getTopLevelConfiguration();
        if (this$topLevelConfiguration == null ? other$topLevelConfiguration != null : !((Object)this$topLevelConfiguration).equals(other$topLevelConfiguration)) {
            return false;
        }
        Optional<NestedClassConfiguration> this$nestedConfiguration = this.getNestedConfiguration();
        Optional<NestedClassConfiguration> other$nestedConfiguration = other.getNestedConfiguration();
        if (this$nestedConfiguration == null ? other$nestedConfiguration != null : !((Object)this$nestedConfiguration).equals(other$nestedConfiguration)) {
            return false;
        }
        Optional<TypeName> this$parentTypeName = this.getParentTypeName();
        Optional<TypeName> other$parentTypeName = other.getParentTypeName();
        if (this$parentTypeName == null ? other$parentTypeName != null : !((Object)this$parentTypeName).equals(other$parentTypeName)) {
            return false;
        }
        List<ITypeAttribute> this$attributeList = this.attributeList;
        List<ITypeAttribute> other$attributeList = other.attributeList;
        if (this$attributeList == null ? other$attributeList != null : !((Object)this$attributeList).equals(other$attributeList)) {
            return false;
        }
        List<ITypeFixedValue> this$fixedValueList = this.fixedValueList;
        List<ITypeFixedValue> other$fixedValueList = other.fixedValueList;
        if (this$fixedValueList == null ? other$fixedValueList != null : !((Object)this$fixedValueList).equals(other$fixedValueList)) {
            return false;
        }
        List<ITypeInformation> this$nestedTypeList = this.nestedTypeList;
        List<ITypeInformation> other$nestedTypeList = other.nestedTypeList;
        return !(this$nestedTypeList == null ? other$nestedTypeList != null : !((Object)this$nestedTypeList).equals(other$nestedTypeList));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGenerated() ? 79 : 97);
        URI $resourceURI = this.getResourceURI();
        result = result * 59 + ($resourceURI == null ? 43 : ((Object)$resourceURI).hashCode());
        IBaseResource $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        Optional<String> $elementId = this.getElementId();
        result = result * 59 + ($elementId == null ? 43 : ((Object)$elementId).hashCode());
        TypeName $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $definitionName = this.getDefinitionName();
        result = result * 59 + ($definitionName == null ? 43 : $definitionName.hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Optional<ClassAnnotation> $classAnnotation = this.getClassAnnotation();
        result = result * 59 + ($classAnnotation == null ? 43 : ((Object)$classAnnotation).hashCode());
        Optional<StructureDefinitionClassConfiguration> $topLevelConfiguration = this.getTopLevelConfiguration();
        result = result * 59 + ($topLevelConfiguration == null ? 43 : ((Object)$topLevelConfiguration).hashCode());
        Optional<NestedClassConfiguration> $nestedConfiguration = this.getNestedConfiguration();
        result = result * 59 + ($nestedConfiguration == null ? 43 : ((Object)$nestedConfiguration).hashCode());
        Optional<TypeName> $parentTypeName = this.getParentTypeName();
        result = result * 59 + ($parentTypeName == null ? 43 : ((Object)$parentTypeName).hashCode());
        List<ITypeAttribute> $attributeList = this.attributeList;
        result = result * 59 + ($attributeList == null ? 43 : ((Object)$attributeList).hashCode());
        List<ITypeFixedValue> $fixedValueList = this.fixedValueList;
        result = result * 59 + ($fixedValueList == null ? 43 : ((Object)$fixedValueList).hashCode());
        List<ITypeInformation> $nestedTypeList = this.nestedTypeList;
        result = result * 59 + ($nestedTypeList == null ? 43 : ((Object)$nestedTypeList).hashCode());
        return result;
    }

    @Override
    @Generated
    public URI getResourceURI() {
        return this.resourceURI;
    }

    @Override
    @Generated
    public IBaseResource getResource() {
        return this.resource;
    }

    @Override
    @Generated
    public Optional<String> getElementId() {
        return this.elementId;
    }

    @Override
    @Generated
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    @Generated
    public TypeName getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public String getDefinitionName() {
        return this.definitionName;
    }

    @Override
    @Generated
    public Optional<String> getDescription() {
        return this.description;
    }

    @Override
    @Generated
    public Optional<ClassAnnotation> getClassAnnotation() {
        return this.classAnnotation;
    }

    @Override
    @Generated
    public Optional<StructureDefinitionClassConfiguration> getTopLevelConfiguration() {
        return this.topLevelConfiguration;
    }

    @Override
    @Generated
    public Optional<NestedClassConfiguration> getNestedConfiguration() {
        return this.nestedConfiguration;
    }

    @Override
    @Generated
    public Optional<TypeName> getParentTypeName() {
        return this.parentTypeName;
    }

    @Generated
    public static class TypeInformationBuilder {
        @Generated
        private URI resourceURI;
        @Generated
        private IBaseResource resource;
        @Generated
        private boolean elementId$set;
        @Generated
        private Optional<String> elementId$value;
        @Generated
        private boolean generated;
        @Generated
        private TypeName typeName;
        @Generated
        private String definitionName;
        @Generated
        private boolean description$set;
        @Generated
        private Optional<String> description$value;
        @Generated
        private boolean classAnnotation$set;
        @Generated
        private Optional<ClassAnnotation> classAnnotation$value;
        @Generated
        private boolean topLevelConfiguration$set;
        @Generated
        private Optional<StructureDefinitionClassConfiguration> topLevelConfiguration$value;
        @Generated
        private boolean nestedConfiguration$set;
        @Generated
        private Optional<NestedClassConfiguration> nestedConfiguration$value;
        @Generated
        private boolean parentTypeName$set;
        @Generated
        private Optional<TypeName> parentTypeName$value;

        @Generated
        TypeInformationBuilder() {
        }

        @Generated
        public TypeInformationBuilder withResourceURI(URI resourceURI) {
            this.resourceURI = resourceURI;
            return this;
        }

        @Generated
        public TypeInformationBuilder withResource(IBaseResource resource) {
            this.resource = resource;
            return this;
        }

        @Generated
        public TypeInformationBuilder withElementId(Optional<String> elementId) {
            this.elementId$value = elementId;
            this.elementId$set = true;
            return this;
        }

        @Generated
        public TypeInformationBuilder withGenerated(boolean generated) {
            this.generated = generated;
            return this;
        }

        @Generated
        public TypeInformationBuilder withTypeName(TypeName typeName) {
            this.typeName = typeName;
            return this;
        }

        @Generated
        public TypeInformationBuilder withDefinitionName(String definitionName) {
            this.definitionName = definitionName;
            return this;
        }

        @Generated
        public TypeInformationBuilder withDescription(Optional<String> description) {
            this.description$value = description;
            this.description$set = true;
            return this;
        }

        @Generated
        public TypeInformationBuilder withClassAnnotation(Optional<ClassAnnotation> classAnnotation) {
            this.classAnnotation$value = classAnnotation;
            this.classAnnotation$set = true;
            return this;
        }

        @Generated
        public TypeInformationBuilder withTopLevelConfiguration(Optional<StructureDefinitionClassConfiguration> topLevelConfiguration) {
            this.topLevelConfiguration$value = topLevelConfiguration;
            this.topLevelConfiguration$set = true;
            return this;
        }

        @Generated
        public TypeInformationBuilder withNestedConfiguration(Optional<NestedClassConfiguration> nestedConfiguration) {
            this.nestedConfiguration$value = nestedConfiguration;
            this.nestedConfiguration$set = true;
            return this;
        }

        @Generated
        public TypeInformationBuilder withParentTypeName(Optional<TypeName> parentTypeName) {
            this.parentTypeName$value = parentTypeName;
            this.parentTypeName$set = true;
            return this;
        }

        @Generated
        public TypeInformation build() {
            Optional<String> elementId$value = this.elementId$value;
            if (!this.elementId$set) {
                elementId$value = TypeInformation.$default$elementId();
            }
            Optional<String> description$value = this.description$value;
            if (!this.description$set) {
                description$value = TypeInformation.$default$description();
            }
            Optional<ClassAnnotation> classAnnotation$value = this.classAnnotation$value;
            if (!this.classAnnotation$set) {
                classAnnotation$value = TypeInformation.$default$classAnnotation();
            }
            Optional<StructureDefinitionClassConfiguration> topLevelConfiguration$value = this.topLevelConfiguration$value;
            if (!this.topLevelConfiguration$set) {
                topLevelConfiguration$value = TypeInformation.$default$topLevelConfiguration();
            }
            Optional<NestedClassConfiguration> nestedConfiguration$value = this.nestedConfiguration$value;
            if (!this.nestedConfiguration$set) {
                nestedConfiguration$value = TypeInformation.$default$nestedConfiguration();
            }
            Optional<TypeName> parentTypeName$value = this.parentTypeName$value;
            if (!this.parentTypeName$set) {
                parentTypeName$value = TypeInformation.$default$parentTypeName();
            }
            return new TypeInformation(this.resourceURI, this.resource, elementId$value, this.generated, this.typeName, this.definitionName, description$value, classAnnotation$value, topLevelConfiguration$value, nestedConfiguration$value, parentTypeName$value);
        }

        @Generated
        public String toString() {
            return "TypeInformation.TypeInformationBuilder(resourceURI=" + String.valueOf(this.resourceURI) + ", resource=" + String.valueOf(this.resource) + ", elementId$value=" + String.valueOf(this.elementId$value) + ", generated=" + this.generated + ", typeName=" + String.valueOf(this.typeName) + ", definitionName=" + this.definitionName + ", description$value=" + String.valueOf(this.description$value) + ", classAnnotation$value=" + String.valueOf(this.classAnnotation$value) + ", topLevelConfiguration$value=" + String.valueOf(this.topLevelConfiguration$value) + ", nestedConfiguration$value=" + String.valueOf(this.nestedConfiguration$value) + ", parentTypeName$value=" + String.valueOf(this.parentTypeName$value) + ")";
        }
    }
}

