/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.structuredefinition.code;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ArrayTypeName;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.JavaFile;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.fhir.ClassAnnotation;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.structuredefinition.code.IClassAttribute;
import de.fhlintstone.generator.structuredefinition.code.IClassAttributeAnnotation;
import de.fhlintstone.generator.structuredefinition.code.IClassData;
import de.fhlintstone.generator.structuredefinition.code.ICodeEmitter;
import de.fhlintstone.generator.structuredefinition.code.IFixedValueRule;
import de.fhlintstone.generator.structuredefinition.code.INestedClass;
import de.fhlintstone.generator.structuredefinition.code.ITopLevelClass;
import de.fhlintstone.utilities.StringUtilities;
import jakarta.annotation.Generated;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.lang.model.element.Modifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class CodeEmitter
implements ICodeEmitter {
    @lombok.Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(CodeEmitter.class);
    private final IAccessorProvider accessorProvider;
    private final IFrameworkTypeLocator frameworkTypeLocator;

    @Inject
    public CodeEmitter(IAccessorProvider accessorProvider, IFrameworkTypeLocator frameworkTypeLocator) {
        this.accessorProvider = accessorProvider;
        this.frameworkTypeLocator = frameworkTypeLocator;
    }

    @Override
    public void generate(ITopLevelClass topLevelClass) throws GeneratorException {
        logger.debug("Generating code of class {} for StructureDefinition {}", (Object)topLevelClass.getClassName().canonicalName(), (Object)topLevelClass.getStructureDefinitionName());
        TypeSpec.Builder topLevelClassBuilder = this.initializeTopLevelBuilder(topLevelClass);
        this.generateCommonMethods(topLevelClassBuilder, topLevelClass);
        this.generateMethodFhirType(topLevelClassBuilder, topLevelClass);
        for (INestedClass nestedClass : topLevelClass.getNestedClasses()) {
            logger.info("Adding nested class {} for element {}", (Object)nestedClass.getClassName().canonicalName(), (Object)nestedClass.getElementId());
            TypeSpec.Builder nestedClassBuilder = this.initializeNestedBuilder(topLevelClass, nestedClass);
            this.generateCommonMethods(nestedClassBuilder, nestedClass);
            topLevelClassBuilder.addType(nestedClassBuilder.build());
        }
        this.writeClassToFile(topLevelClassBuilder, topLevelClass);
        logger.exit();
    }

    private TypeSpec.Builder initializeTopLevelBuilder(ITopLevelClass classData) {
        Optional<ClassAnnotation> classAnnotation;
        logger.entry(new Object[]{classData});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)classData.getClassName()).superclass(classData.getSuperclassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"fhlintstone"}).addMember("date", "$S", new Object[]{ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT)}).build()).addJavadoc("Representation of the HL7 FHIR StructureDefinition $L.\n($L)\n", new Object[]{classData.getStructureDefinitionName(), classData.getStructureDefinitionURL()});
        Optional<String> structureDefinitionDescription = classData.getDescription();
        if (structureDefinitionDescription.isPresent()) {
            classBuilder.addJavadoc(structureDefinitionDescription.get(), new Object[0]);
        }
        if (classData.isAbstractClass()) {
            classBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if ((classAnnotation = classData.getClassAnnotation()).isPresent()) {
            switch (classAnnotation.get()) {
                case RESOURCE: {
                    classBuilder.addAnnotation(AnnotationSpec.builder(ResourceDef.class).addMember("profile", "$S", new Object[]{classData.getStructureDefinitionURL()}).build());
                    break;
                }
                case DATATYPE: {
                    classBuilder.addAnnotation(AnnotationSpec.builder(DatatypeDef.class).addMember("name", "$S", new Object[]{classData.getStructureDefinitionName()}).build());
                    break;
                }
                case BLOCK: {
                    classBuilder.addAnnotation(AnnotationSpec.builder(Block.class).build());
                    break;
                }
            }
        }
        return (TypeSpec.Builder)logger.exit((Object)classBuilder);
    }

    private TypeSpec.Builder initializeNestedBuilder(ITopLevelClass topLevelClass, INestedClass nestedClass) throws GeneratorException {
        Optional<ClassAnnotation> classAnnotation;
        logger.entry(new Object[]{topLevelClass, nestedClass});
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)nestedClass.getClassName()).superclass(nestedClass.getSuperclassName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Representation of the element $L.\n", new Object[]{nestedClass.getElementId()});
        if (nestedClass.isAbstractClass()) {
            classBuilder.addModifiers(new Modifier[]{Modifier.ABSTRACT});
        }
        if ((classAnnotation = nestedClass.getClassAnnotation()).isPresent()) {
            switch (classAnnotation.get()) {
                case RESOURCE: {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException("Adding @ResourceDef annotations to nested classes is not supported at the moment."));
                }
                case DATATYPE: {
                    classBuilder.addAnnotation(AnnotationSpec.builder(DatatypeDef.class).addMember("name", "$S", new Object[]{nestedClass.getStructureDefinitionName()}).build());
                    break;
                }
                case BLOCK: {
                    classBuilder.addAnnotation(AnnotationSpec.builder(Block.class).build());
                }
            }
        }
        return (TypeSpec.Builder)logger.exit((Object)classBuilder);
    }

    private void generateCommonMethods(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        this.addAttributes(classBuilder, classData);
        this.addAccessors(classBuilder, classData);
        this.generateMethodAddChild(classBuilder, classData);
        this.generateMethodCopy(classBuilder, classData);
        this.generateMethodEqualsDeep(classBuilder, classData);
        this.generateMethodEqualsShallow(classBuilder, classData);
        this.generateMethodIsEmpty(classBuilder, classData);
        this.generateMethodGetNamedProperty(classBuilder, classData);
        this.generateMethodGetProperty(classBuilder, classData);
        this.generateMethodGetTypesForProperty(classBuilder, classData);
        this.generateMethodListChildren(classBuilder, classData);
        this.generateMethodMakeProperty(classBuilder, classData);
        this.generateMethodRemoveChild(classBuilder, classData);
        this.generateMethodSetPropertyByHash(classBuilder, classData);
        this.generateMethodSetPropertyByName(classBuilder, classData);
        if (classData.isDerivedFromPrimitiveType()) {
            this.generateMethodGetExtension(classBuilder, classData);
            this.generateMethodHasExtension(classBuilder, classData);
            this.generateMethodGetModifierExtension(classBuilder, classData);
            this.generateMethodHasModifierExtension(classBuilder, classData);
        }
        this.generateMethodCreate(classBuilder, classData);
    }

    private void addAttributes(TypeSpec.Builder classBuilder, IClassData classData) {
        logger.entry(new Object[0]);
        for (IClassAttribute attribute : classData.getAttributes()) {
            logger.debug("Adding attribute {}", (Object)attribute.getName());
            FieldSpec.Builder attributeBuilder = FieldSpec.builder((TypeName)attribute.getActualType(), (String)attribute.getName(), (Modifier[])new Modifier[]{Modifier.PRIVATE});
            Optional<String> description = attribute.getDescription();
            if (description.isPresent()) {
                attributeBuilder.addJavadoc(description.get(), new Object[0]);
            }
            for (IClassAttributeAnnotation annotation : attribute.getAnnotations()) {
                AnnotationSpec.Builder annotationBuilder = AnnotationSpec.builder((ClassName)annotation.getAnnotation());
                for (Map.Entry parameter : annotation.getParameters().entrySet()) {
                    Object value = parameter.getValue();
                    if (value.getClass().isArray()) {
                        Object[] values = (Object[])value;
                        String formatString = this.getFormatString(values);
                        annotationBuilder.addMember((String)parameter.getKey(), formatString, values);
                        continue;
                    }
                    String formatString = this.getFormatString(value);
                    annotationBuilder.addMember((String)parameter.getKey(), formatString, new Object[]{value});
                }
                attributeBuilder.addAnnotation(annotationBuilder.build());
            }
            classBuilder.addField(attributeBuilder.build());
        }
        logger.exit();
    }

    private void addAccessors(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[0]);
        for (IClassAttribute attribute : classData.getAttributes()) {
            logger.debug("Using accessor generation mode {} for attribute {}", (Object)attribute.getAccessorGenerationMode(), (Object)attribute.getName());
            switch (attribute.getAccessorGenerationMode()) {
                case SINGLE_TYPE_NON_REPEATING_PRIMITIVE: {
                    this.addGetterForSinglePrimitiveType(classBuilder, attribute);
                    this.addGetterForSingleElementType(classBuilder, attribute);
                    this.addCheckerForSingle(classBuilder, attribute, "");
                    this.addCheckerForSingle(classBuilder, attribute, "Element");
                    this.addSetterForElement(classBuilder, classData, attribute, "Element");
                    this.addSetterForSinglePrimitiveType(classBuilder, classData, attribute);
                    break;
                }
                case SINGLE_TYPE_NON_REPEATING_ELEMENT: {
                    this.addGetterForSingleElementType(classBuilder, attribute);
                    this.addCheckerForSingle(classBuilder, attribute, "");
                    this.addSetterForElement(classBuilder, classData, attribute, "");
                    break;
                }
                case SINGLE_TYPE_REPEATING_PRIMITIVE: {
                    this.addAdderForNewSingleType(classBuilder, attribute);
                    this.addAdderForExistingSinglePrimitiveType(classBuilder, classData, attribute);
                    this.addGetterForRepeatingElement(classBuilder, attribute);
                    this.addGetterForRepeatingElementFirst(classBuilder, attribute);
                    this.addCheckerForRepeating(classBuilder, attribute);
                    this.addSetterForElement(classBuilder, classData, attribute, "");
                    break;
                }
                case SINGLE_TYPE_REPEATING_ELEMENT: {
                    this.addAdderForNewSingleType(classBuilder, attribute);
                    this.addAdderForExistingSingleElementType(classBuilder, classData, attribute);
                    this.addGetterForRepeatingElement(classBuilder, attribute);
                    this.addGetterForRepeatingElementFirst(classBuilder, attribute);
                    this.addCheckerForRepeating(classBuilder, attribute);
                    this.addSetterForElement(classBuilder, classData, attribute, "");
                    break;
                }
                case MULTI_TYPE_NON_REPEATING: {
                    this.addGettersForMultiType(classBuilder, attribute);
                    this.addCheckerForSingle(classBuilder, attribute, "");
                    this.addCheckersForMultiTypes(classBuilder, attribute);
                    this.addSettersForGenericTypeWithCheck(classBuilder, classData, attribute);
                    this.addSettersForMultiTypes(classBuilder, classData, attribute);
                    break;
                }
                case MULTI_TYPE_REPEATING: {
                    this.addAddersForNewMultiType(classBuilder, attribute);
                    this.addAddersForRepeatingMultiType(classBuilder, classData, attribute);
                    this.addGetterForRepeatingElement(classBuilder, attribute);
                    this.addCheckerForRepeating(classBuilder, attribute);
                    this.addSetterForElement(classBuilder, classData, attribute, "");
                }
            }
        }
        logger.exit();
    }

    private void addAdderForNewSingleType(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getAdderForNewSingleTypeName(attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getAttributeType()).addJavadoc("Creates a new $1L entry and adds it to the list of existing entries.\nThis method will create a new list if necessary.\n@return the newly created $1L entry\n", new Object[]{attribute.getElementId()}).addStatement("$1T t = new $1T()", new Object[]{attribute.getAttributeType()}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("this.$N.add(t)", new Object[]{attribute.getName()}).addStatement("return t", new Object[0]).build());
        logger.exit();
    }

    private String getAdderForNewSingleTypeName(IClassAttribute attribute) {
        return attribute.getPrimitiveType().isPresent() ? this.getMethodName("add", attribute, "Element") : this.getMethodName("add", attribute);
    }

    private void addAddersForNewMultiType(TypeSpec.Builder classBuilder, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            String methodName = this.getAdderForNewMultiTypeName(attribute, modelType);
            logger.debug("Generating method {}", (Object)methodName);
            classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getAttributeType()).addJavadoc("Creates a new $1L entry of type $2T and adds it to the list of existing entries.\nThis method will create a new list if necessary.\n@return the newly created $1L entry of type $2T\n", new Object[]{attribute.getElementId(), mappedModelType}).addStatement("$1T t = new $1T()", new Object[]{mappedModelType}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("this.$N.add(t)", new Object[]{attribute.getName()}).addStatement("return t", new Object[0]).build());
        }
        logger.exit();
    }

    private String getAdderForNewMultiTypeName(IClassAttribute attribute, IMappedType modelType) throws GeneratorException {
        String typeCode = modelType.getTypeCode().orElseThrow(() -> new GeneratorException(String.format("Attribute %s has a model type %s without a type code. This is currently not supported", attribute.getName(), modelType.getType().toString())));
        return this.getMethodName("add", attribute, typeCode);
    }

    private void addAdderForExistingSinglePrimitiveType(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("add", attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addJavadoc("Adds an existing $1L entry to the list of existing entries.\nThis method will create a new list if necessary.\n@param value the existing value to add to the element $1L\n@return the parent $2T object to allow for method chaining\n", new Object[]{attribute.getElementId(), classData.getClassName()}).addParameter(attribute.getPrimitiveType().orElseThrow(), "value", new Modifier[0]).addStatement("$1T t = new $1T()", new Object[]{attribute.getAttributeType()}).addStatement("t.setValue(value)", new Object[0]).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("this.$N.add(t)", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        logger.exit();
    }

    private void addAdderForExistingSingleElementType(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("add", attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter(attribute.getAttributeType(), "value", new Modifier[0]).addJavadoc("Adds an existing $1L entry to the list of existing entries.\nThis method will create a new list if necessary.\n@param value the existing value to add to the element $1L\n@return the parent $2T object to allow for method chaining\n", new Object[]{attribute.getElementId(), classData.getClassName()}).beginControlFlow("if (value == null)", new Object[0]).addStatement("return this", new Object[0]).endControlFlow().beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("this.$N.add(value)", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        logger.exit();
    }

    private void addAddersForRepeatingMultiType(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            if (!(mappedModelType instanceof ClassName)) {
                throw new GeneratorException("Model type must refer to a class");
            }
            ClassName modelClass = (ClassName)mappedModelType;
            String methodName = this.getMethodName("add", attribute);
            logger.debug("Generating method {}", (Object)methodName);
            classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter((TypeName)modelClass, "value", new Modifier[0]).addJavadoc("Adds an existing $1L entry of type $2L to the list of existing entries.\nThis method will create a new list if necessary.\n@param value the existing $2L value to add to the element $1L\n@return the parent $3T object to allow for method chaining\n", new Object[]{attribute.getElementId(), modelClass.simpleName(), classData.getClassName()}).beginControlFlow("if (value == null)", new Object[0]).addStatement("return this", new Object[0]).endControlFlow().beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("this.$N.add(value)", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        }
        logger.exit();
    }

    private void addGetterForSinglePrimitiveType(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getGetterForGenericMultiTypeName(attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getPrimitiveType().orElseThrow()).addJavadoc("Retrieves the value of the element $1L.\nThis method will return <code>null</code> if the element is empty.\n@return the value of the element $1L\n", new Object[]{attribute.getElementId()}).addStatement("return this.$1N == null || this.$1N.isEmpty() ? null : this.$1N.getValue()", new Object[]{attribute.getName()}).build());
        logger.exit();
    }

    private void addGetterForSingleElementType(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        TypeName configurationClass = this.frameworkTypeLocator.getConfigurationType();
        String methodName = this.getGetterForSingleElementTypeName(attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getAttributeType()).addException(FHIRException.class).addJavadoc("Retrieves the value of the element $1L.\nThis method will automatically create an entry or raise an error according to the\nsettings provided by $2T.\n@return the value of the element $1L\n@throws $3T if the element $1L is not yet initialized and auto-creation is disabled.\n", new Object[]{attribute.getElementId(), configurationClass, ClassName.get(FHIRException.class)}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).beginControlFlow("if ($T.errorOnAutoCreate())", new Object[]{configurationClass}).addStatement("throw new $T($S)", new Object[]{ClassName.get(FHIRException.class), String.format("Unable to auto-create element %s", attribute.getElementId())}).nextControlFlow("else if ($T.doAutoCreate())", new Object[]{configurationClass}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getAttributeType()}).endControlFlow().endControlFlow().addStatement("return this.$N", new Object[]{attribute.getName()}).build());
        logger.exit();
    }

    private String getGetterForSingleElementTypeName(IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        return (String)logger.exit((Object)(attribute.getPrimitiveType().isPresent() ? this.getMethodName("get", attribute, "Element") : this.getGetterForGenericMultiTypeName(attribute)));
    }

    private void addGetterForRepeatingElement(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getGetterForGenericMultiTypeName(attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getActualType()).addJavadoc("Retrieves the list of entries of the element $1L.\nThis method will create a new empty list if necessary.\n@return the list of entries of the element $1L\n", new Object[]{attribute.getElementId()}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).endControlFlow().addStatement("return this.$N", new Object[]{attribute.getName()}).build());
        logger.exit();
    }

    private void addGetterForRepeatingElementFirst(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String listGetterName = this.getGetterForGenericMultiTypeName(attribute);
        String listAdderName = attribute.getPrimitiveType().isPresent() ? this.getMethodName("add", attribute, "Element") : this.getMethodName("add", attribute);
        String methodName = this.getMethodName("get", attribute, "FirstRep");
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(attribute.getAttributeType()).addJavadoc("Retrieves the first entry in the list of entries of the element $1L.\nThis method will create a new list if necessary and will also create\na new $1L element if the list is empty.\n@return the first entry in the list of $1L entries\n", new Object[]{attribute.getElementId()}).beginControlFlow("if (this.$N().isEmpty())", new Object[]{listGetterName}).addStatement("$N()", new Object[]{listAdderName}).endControlFlow().addStatement("return $N().get(0)", new Object[]{listGetterName}).build());
        logger.exit();
    }

    private void addGettersForMultiType(TypeSpec.Builder classBuilder, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        String methodName = this.getGetterForGenericMultiTypeName(attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.frameworkTypeLocator.getGenericType()).addJavadoc("@return the value of the field $L", new Object[]{attribute.getElementId()}).addStatement("return this.$N", new Object[]{attribute.getName()}).build());
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            if (!(mappedModelType instanceof ClassName)) {
                throw new GeneratorException("Model type must refer to a class");
            }
            ClassName modelClass = (ClassName)mappedModelType;
            String methodName2 = this.getMethodName("get", attribute, modelClass.simpleName());
            logger.debug("Generating method {}", (Object)methodName2);
            classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName2).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)modelClass).addException(FHIRException.class).addJavadoc("Retrieves the value of the element $1L as type $2T.\nThis method will create a instance of $2T if necessary.\n@return the value of the field $1L as a $2T\n@throws $3T if the element $1L already contains an instance of a different type\n", new Object[]{attribute.getElementId(), modelClass, ClassName.get(FHIRException.class)}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), mappedModelType}).endControlFlow().beginControlFlow("if (!(this.$N instanceof $T))", new Object[]{attribute.getName(), mappedModelType}).addStatement("throw new $T(String.format($S, this.$N.getClass().getName()))", new Object[]{ClassName.get(FHIRException.class), String.format("Type mismatch: The type %s was expected, but %%s was encountered", modelClass.simpleName()), attribute.getName()}).endControlFlow().addStatement("return ($T) this.$N", new Object[]{mappedModelType, attribute.getName()}).build());
        }
        logger.exit();
    }

    private String getGetterForGenericMultiTypeName(IClassAttribute attribute) {
        return this.getMethodName("get", attribute);
    }

    private void addCheckerForSingle(TypeSpec.Builder classBuilder, IClassAttribute attribute, String suffix) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("has", attribute, suffix);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addJavadoc("Determines whether the element $1L is present and contains a value.\n@return <code>true</code> if the element $1L is present and contains a value\n", new Object[]{attribute.getElementId()}).addStatement("return this.$1N != null && !this.$1N.isEmpty()", new Object[]{attribute.getName()}).build());
        logger.exit();
    }

    private void addCheckerForRepeating(TypeSpec.Builder classBuilder, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("has", attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addJavadoc("Determines whether the element $1L is present and contains at least one value.\nThis method will return <code>false</code> if the list only contains empty items.\n@return <code>true</code> if the element $1L is present and contains a value\n", new Object[]{attribute.getElementId()}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("return false", new Object[0]).endControlFlow().beginControlFlow("for (var item : this.$N)", new Object[]{attribute.getName()}).beginControlFlow("if (!item.isEmpty())", new Object[0]).addStatement("return true", new Object[0]).endControlFlow().endControlFlow().addStatement("return false", new Object[0]).build());
        logger.exit();
    }

    private void addCheckersForMultiTypes(TypeSpec.Builder classBuilder, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            if (!(mappedModelType instanceof ClassName)) {
                throw new GeneratorException("Model type must refer to a class");
            }
            ClassName modelClass = (ClassName)mappedModelType;
            String methodName = this.getMethodName("has", attribute, modelClass.simpleName());
            logger.debug("Generating method {}", (Object)methodName);
            classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addJavadoc("Determines whether the element $1L is present and of type $2T.\nNote that this method will return <code>true</code> even if the actual\nvalue is empty; this is in accordance with the behaviour of the HAPI\nimplementations.\n@return <code>true</code> if the element $1L is present and of type $2T\n", new Object[]{attribute.getElementId(), modelClass}).addStatement("return this.$1N instanceof $2T", new Object[]{attribute.getName(), modelClass}).build());
        }
        logger.exit();
    }

    private void addSetterForElement(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute, String suffix) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("set", attribute, suffix);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter(attribute.getActualType(), "value", new Modifier[0]).addJavadoc("Changes the value of the element $1L.\n@param value the new value of the element $1L\n@return the parent $2T object to allow for method chaining\n", new Object[]{attribute.getElementId(), classData.getClassName()}).addStatement("this.$N = value", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        logger.exit();
    }

    private void addSetterForSinglePrimitiveType(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("set", attribute);
        logger.debug("Generating method {}", (Object)methodName);
        classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter(attribute.getPrimitiveType().orElseThrow(), "value", new Modifier[0]).addJavadoc("Changes the value of the element $1L.\nThis method will create a new $2T instance if required and transfer the value.\n@param value the new value of the element $1L\n@return the parent $3T object to allow for method chaining\n", new Object[]{attribute.getElementId(), attribute.getAttributeType(), classData.getClassName()}).beginControlFlow("if (this.$N == null)", new Object[]{attribute.getName()}).addStatement("this.$N = new $T()", new Object[]{attribute.getName(), attribute.getAttributeType()}).endControlFlow().addStatement("this.$N.setValue(value)", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        logger.exit();
    }

    private void addSettersForMultiTypes(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            String methodName = this.getMethodName("set", attribute);
            logger.debug("Generating method {}", (Object)methodName);
            classBuilder.addMethod(MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter(mappedModelType, "value", new Modifier[0]).addJavadoc("Changes the value of the element $1L.\n@param value the new value of the element $1L of type $2T\n@return the parent $3T object to allow for method chaining\n", new Object[]{attribute.getElementId(), mappedModelType, classData.getClassName()}).addStatement("this.$N = value", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).build());
        }
        logger.exit();
    }

    private void addSettersForGenericTypeWithCheck(TypeSpec.Builder classBuilder, IClassData classData, IClassAttribute attribute) throws GeneratorException {
        logger.entry(new Object[]{attribute});
        String methodName = this.getMethodName("set", attribute);
        logger.debug("Generating method {}", (Object)methodName);
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addParameter(attribute.getAttributeType(), "value", new Modifier[0]).addException(FHIRException.class).addJavadoc("Changes the value of the element $1L. This method accepts a generic parameter,\nbut performs a check to only allow compatible types.\n@param value the new value of the element $1L\n@return the parent $2T object to allow for method chaining\n@throws $3T if the value is of an unsupported type\n", new Object[]{attribute.getElementId(), classData.getClassName(), ClassName.get(FHIRException.class)});
        for (IMappedType modelType : attribute.getModelTypes()) {
            TypeName mappedModelType = this.getMappedModelType(modelType);
            method.beginControlFlow("if (value instanceof $T)", new Object[]{mappedModelType}).addStatement("this.$N = value", new Object[]{attribute.getName()}).addStatement("return this", new Object[0]).endControlFlow();
        }
        classBuilder.addMethod(method.addStatement("throw new $1T(String.format($2S, value.getClass().getName()))", new Object[]{ClassName.get(FHIRException.class), String.format("Unsupported type %%s for element %s", attribute.getElementId())}).build());
        logger.exit();
    }

    private void generateMethodAddChild(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            TypeName baseType = this.frameworkTypeLocator.getBaseType();
            logger.debug("Generating method addChild");
            MethodSpec.Builder addChildMethod = MethodSpec.methodBuilder((String)"addChild").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(baseType).addParameter(String.class, "name", new Modifier[0]).addException(FHIRException.class).addJavadoc("@see $1T#addChild($2T)", new Object[]{baseType, String.class});
            for (IClassAttribute attribute : attributes) {
                if (attribute.isMultiType()) {
                    for (IMappedType modelType : attribute.getModelTypes()) {
                        String typedFhirName = attribute.getFhirName() + StringUtilities.toFirstUpper(modelType.getTypeCode().orElse(""));
                        addChildMethod.beginControlFlow("if (name.equals($S))", new Object[]{typedFhirName});
                        if (attribute.isRepeating()) {
                            addChildMethod.addStatement("return $N()", new Object[]{this.getAdderForNewMultiTypeName(attribute, modelType)});
                        } else {
                            addChildMethod.addStatement("throw new $T($S)", new Object[]{ClassName.get(FHIRException.class), String.format("Cannot call addChild on singleton property %s", attribute.getElementId())});
                        }
                        addChildMethod.endControlFlow();
                    }
                    continue;
                }
                addChildMethod.beginControlFlow("if (name.equals($S))", new Object[]{attribute.getFhirName()});
                if (attribute.isRepeating()) {
                    addChildMethod.addStatement("return $N()", new Object[]{this.getAdderForNewSingleTypeName(attribute)});
                } else {
                    addChildMethod.addStatement("throw new $T($S)", new Object[]{ClassName.get(FHIRException.class), String.format("Cannot call addChild on singleton property %s", attribute.getElementId())});
                }
                addChildMethod.endControlFlow();
            }
            addChildMethod.addStatement("return super.addChild(name)", new Object[0]);
            classBuilder.addMethod(addChildMethod.build());
        }
        logger.exit();
    }

    private void generateMethodCopy(TypeSpec.Builder classBuilder, IClassData classData) {
        ImmutableList<IClassAttribute> attributes;
        logger.entry(new Object[]{classBuilder, classData});
        if (!classData.isAbstractClass()) {
            logger.debug("Generating method copy");
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"copy").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)classData.getClassName()).addJavadoc("@see $T#copy()", new Object[]{classData.getSuperclassName()}).addStatement("var dst = new $T()", new Object[]{classData.getClassName()}).addStatement("copyValues(dst)", new Object[0]).addStatement("return dst", new Object[0]).build());
        }
        if (!(attributes = classData.getAttributes()).isEmpty()) {
            logger.debug("Generating method copyValues");
            MethodSpec.Builder copyValuesMethod = MethodSpec.methodBuilder((String)"copyValues").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)classData.getClassName(), "dst", new Modifier[0]).addJavadoc("@see $1T#copyValues($1T)", new Object[]{classData.getSuperclassName()}).addStatement("super.copyValues(dst)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                if (attribute.isRepeating()) {
                    copyValuesMethod.beginControlFlow("if ($N != null)", new Object[]{attribute.getName()}).addStatement("dst.$N = new $T()", new Object[]{attribute.getName(), attribute.getCreationType()}).beginControlFlow("for (var entry : $N)", new Object[]{attribute.getName()}).addStatement("dst.$N.add(entry.copy())", new Object[]{attribute.getName()}).endControlFlow().endControlFlow();
                    continue;
                }
                copyValuesMethod.addStatement("dst.$1N = $1N == null ? null : $1N.copy()", new Object[]{attribute.getName()});
            }
            classBuilder.addMethod(copyValuesMethod.build());
        }
        logger.exit();
    }

    private void generateMethodEqualsDeep(TypeSpec.Builder classBuilder, IClassData classData) {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method equalsDeep");
            MethodSpec.Builder equalsDeepMethod = MethodSpec.methodBuilder((String)"equalsDeep").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addParameter(this.frameworkTypeLocator.getBaseType(), "other", new Modifier[0]).addAnnotation(Override.class).beginControlFlow("if (!super.equalsDeep(other))", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().beginControlFlow("if (!(other instanceof $T castOther))", new Object[]{classData.getClassName()}).addStatement("return false", new Object[0]).endControlFlow();
            for (IClassAttribute attribute : attributes) {
                equalsDeepMethod.beginControlFlow("if (!compareDeep(this.$1N, castOther.$1N, true))", new Object[]{attribute.getName()}).addStatement("return false", new Object[0]).endControlFlow();
            }
            equalsDeepMethod.addStatement("return true", new Object[0]);
            classBuilder.addMethod(equalsDeepMethod.build());
        }
        logger.exit();
    }

    private void generateMethodEqualsShallow(TypeSpec.Builder classBuilder, IClassData classData) {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method equalsShallow");
            MethodSpec.Builder equalsShallowMethod = MethodSpec.methodBuilder((String)"equalsShallow").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addParameter(this.frameworkTypeLocator.getBaseType(), "other", new Modifier[0]).addAnnotation(Override.class).beginControlFlow("if (!super.equalsShallow(other))", new Object[0]).addStatement("return false", new Object[0]).endControlFlow().beginControlFlow("if (!(other instanceof $T castOther))", new Object[]{classData.getClassName()}).addStatement("return false", new Object[0]).endControlFlow();
            attributes.stream().filter(IClassAttribute::isDerivedFromPrimitiveType).forEach(attribute -> equalsShallowMethod.beginControlFlow("if (!compareValues(this.$1N, castOther.$1N, true))", new Object[]{attribute.getName()}).addStatement("return false", new Object[0]).endControlFlow());
            equalsShallowMethod.addStatement("return true", new Object[0]);
            classBuilder.addMethod(equalsShallowMethod.build());
        }
        logger.exit();
    }

    private void generateMethodFhirType(TypeSpec.Builder classBuilder, ITopLevelClass classData) {
        logger.entry(new Object[]{classBuilder, classData});
        logger.debug("Generating method fhirType");
        classBuilder.addMethod(MethodSpec.methodBuilder((String)"fhirType").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get(String.class)).addAnnotation(Override.class).addStatement("return $S", new Object[]{classData.getStructureDefinitionName()}).build());
        logger.exit();
    }

    private void generateMethodIsEmpty(TypeSpec.Builder classBuilder, IClassData classData) {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            Object[] attributeFormatEntries = new String[attributes.size()];
            Arrays.fill(attributeFormatEntries, "$N");
            String statement = String.format("return super.isEmpty() && $T.isEmpty(%s)", String.join((CharSequence)", ", (CharSequence[])attributeFormatEntries));
            ArrayList parameters = attributes.stream().map(a -> a.getName()).collect(Collectors.toCollection(() -> new ArrayList()));
            parameters.add(0, ClassName.get(ElementUtil.class));
            logger.debug("Generating method isEmpty");
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"isEmpty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addAnnotation(Override.class).addStatement(statement, parameters.toArray()).build());
        }
        logger.exit();
    }

    private void generateMethodGetNamedProperty(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method getNamedProperty");
            MethodSpec.Builder getNamedPropertMethod = MethodSpec.methodBuilder((String)"getNamedProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.frameworkTypeLocator.getPropertyType()).addParameter(TypeName.INT, "hash", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addParameter(TypeName.BOOLEAN, "checkValid", new Modifier[0]).addAnnotation(Override.class).beginControlFlow("switch(hash)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                ImmutableCollection<IMappedType> modelTypes = attribute.getModelTypes();
                if (attribute.isMultiType()) {
                    ArrayList propertyNames = Lists.newArrayList((Object[])new String[]{attribute.getFhirName(), attribute.getFhirName() + "[x]"});
                    modelTypes.stream().map(mt -> mt.getTypeCode()).filter(Optional::isPresent).map(tc -> attribute.getFhirName() + StringUtilities.toFirstUpper((String)tc.get())).forEach(propertyNames::add);
                    String typeCodes = String.join((CharSequence)"|", attribute.getPropertyTypes().stream().toList());
                    for (String propertyName : propertyNames) {
                        getNamedPropertMethod.addCode("case $L:\n", new Object[]{propertyName.hashCode()}).addCode("$>// $N\n", new Object[]{propertyName}).addStatement("return new $T($S, $S, $S, $L, $L, this.$N)", new Object[]{this.frameworkTypeLocator.getPropertyType(), propertyName, typeCodes, attribute.getDefinition().orElse(""), attribute.getMin(), attribute.getMax(), attribute.getName()}).addCode("$<", new Object[0]);
                    }
                    continue;
                }
                IMappedType modelType = (IMappedType)modelTypes.iterator().next();
                getNamedPropertMethod.addCode("case $L:\n", new Object[]{attribute.getFhirName().hashCode()}).addCode("$>// $N\n", new Object[]{attribute.getFhirName()}).addStatement("return new $T($S, $S, $S, $L, $L, this.$N)", new Object[]{this.frameworkTypeLocator.getPropertyType(), attribute.getFhirName(), modelType.getTypeCode().orElseThrow(() -> new GeneratorException(String.format("Attribute %s has a model type %s without a type code. This is currently not supported", attribute.getName(), modelType.getType().toString()))), attribute.getDefinition().orElse(""), attribute.getMin(), attribute.getMax(), attribute.getName()}).addCode("$<", new Object[0]);
            }
            getNamedPropertMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.getNamedProperty(hash, name, checkValid)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(getNamedPropertMethod.build());
        }
        logger.exit();
    }

    private void generateMethodGetProperty(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method getProperty");
            MethodSpec.Builder getPropertMethod = MethodSpec.methodBuilder((String)"getProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of((TypeName)this.frameworkTypeLocator.getBaseType())).addParameter(TypeName.INT, "hash", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addParameter(TypeName.BOOLEAN, "checkValid", new Modifier[0]).addException((TypeName)ClassName.get(FHIRException.class)).addAnnotation(Override.class).beginControlFlow("switch(hash)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                getPropertMethod.addCode("case $L:\n", new Object[]{attribute.getFhirName().hashCode()}).addCode("$>// $N\n", new Object[]{attribute.getFhirName()});
                if (attribute.isRepeating()) {
                    getPropertMethod.addStatement("return this.$1N == null ? new $2T[0] : this.$1N.toArray(new $2T[this.$1N.size()])", new Object[]{attribute.getName(), this.frameworkTypeLocator.getBaseType()});
                } else {
                    getPropertMethod.addStatement("return this.$1N == null ? new $2T[0] : new $2T[] { this.$1N } ", new Object[]{attribute.getName(), this.frameworkTypeLocator.getBaseType()});
                }
                getPropertMethod.addCode("$<", new Object[0]);
            }
            getPropertMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.getProperty(hash, name, checkValid)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(getPropertMethod.build());
        }
        logger.exit();
    }

    private void generateMethodGetTypesForProperty(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method getTypesForProperty");
            MethodSpec.Builder getPropertMethod = MethodSpec.methodBuilder((String)"getTypesForProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ArrayTypeName.of((TypeName)ClassName.get(String.class))).addParameter(TypeName.INT, "hash", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addException((TypeName)ClassName.get(FHIRException.class)).addAnnotation(Override.class).beginControlFlow("switch(hash)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                String typeCodes = String.join((CharSequence)", ", attribute.getPropertyTypes().stream().map(s -> String.format("\"%s\"", s)).toList());
                getPropertMethod.addCode("case $L:\n", new Object[]{attribute.getFhirName().hashCode()}).addCode("$>// $N\n", new Object[]{attribute.getFhirName()}).addStatement("return new $1T[] { $2L }", new Object[]{ClassName.get(String.class), typeCodes}).addCode("$<", new Object[0]);
            }
            getPropertMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.getTypesForProperty(hash, name)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(getPropertMethod.build());
        }
        logger.exit();
    }

    private void generateMethodListChildren(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method listChildren");
            MethodSpec.Builder listChildrenMethod = MethodSpec.methodBuilder((String)"listChildren").addModifiers(new Modifier[]{Modifier.PROTECTED}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.frameworkTypeLocator.getPropertyType()}), "children", new Modifier[0]).addAnnotation(Override.class).addStatement("super.listChildren(children)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                String typeCodes = String.join((CharSequence)"|", attribute.getPropertyTypes().stream().toList());
                Object propertyName = attribute.isMultiType() ? attribute.getFhirName() + "[x]" : attribute.getFhirName();
                listChildrenMethod.addStatement("children.add(new $T($S, $S, $S, $L, $L, this.$N))", new Object[]{this.frameworkTypeLocator.getPropertyType(), propertyName, typeCodes, attribute.getDefinition().orElse(""), attribute.getMin(), attribute.getMax(), attribute.getName()});
            }
            classBuilder.addMethod(listChildrenMethod.build());
        }
        logger.exit();
    }

    private void generateMethodMakeProperty(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            logger.debug("Generating method makeProperty");
            MethodSpec.Builder makePropertyMethod = MethodSpec.methodBuilder((String)"makeProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.frameworkTypeLocator.getBaseType()).addParameter(TypeName.INT, "hash", new Modifier[0]).addParameter((TypeName)ClassName.get(String.class), "name", new Modifier[0]).addException((TypeName)ClassName.get(FHIRException.class)).addAnnotation(Override.class).beginControlFlow("switch(hash)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                ArrayList propertyNames = Lists.newArrayList((Object[])new String[]{attribute.getFhirName()});
                if (attribute.isMultiType()) {
                    propertyNames.add(attribute.getFhirName() + "[x]");
                }
                for (String propertyName : propertyNames) {
                    makePropertyMethod.addCode("case $L:\n", new Object[]{propertyName.hashCode()}).addCode("$>// $N\n", new Object[]{propertyName});
                    if (attribute.isRepeating()) {
                        if (attribute.isMultiType()) {
                            logger.warn("Not generating a makeProperty branch for multi-type repeating element {}", (Object)attribute.getElementId());
                        } else {
                            makePropertyMethod.addStatement("return $N()", new Object[]{this.getAdderForNewSingleTypeName(attribute)});
                        }
                    } else {
                        makePropertyMethod.addStatement("return $N()", new Object[]{this.getGetterForSingleElementTypeName(attribute)});
                    }
                    makePropertyMethod.addCode("$<", new Object[0]);
                }
            }
            makePropertyMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.makeProperty(hash, name)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(makePropertyMethod.build());
        }
        logger.exit();
    }

    private void generateMethodRemoveChild(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            TypeName baseType = this.frameworkTypeLocator.getBaseType();
            logger.debug("Generating method removeChild");
            MethodSpec.Builder removeChildMethod = MethodSpec.methodBuilder((String)"removeChild").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(String.class, "name", new Modifier[0]).addParameter(baseType, "value", new Modifier[0]).addException(FHIRException.class).addAnnotation(Override.class).beginControlFlow("switch(name)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                ArrayList propertyNames = Lists.newArrayList((Object[])new String[]{attribute.getFhirName()});
                if (attribute.isMultiType()) {
                    propertyNames.add(attribute.getFhirName() + "[x]");
                }
                for (String propertyName : propertyNames) {
                    removeChildMethod.addCode("case $S:\n", new Object[]{propertyName}).addCode("$>", new Object[0]);
                    if (attribute.isRepeating()) {
                        Optional<String> castingMethod = attribute.getBaseCastingMethod();
                        if (castingMethod.isPresent()) {
                            removeChildMethod.addStatement("this.$N().remove($N(value))", new Object[]{this.getGetterForGenericMultiTypeName(attribute), castingMethod.get()});
                        } else {
                            removeChildMethod.addStatement("this.$N().remove(value)", new Object[]{this.getGetterForGenericMultiTypeName(attribute)});
                        }
                    } else {
                        removeChildMethod.addStatement("this.$N = null", new Object[]{attribute.getName()});
                    }
                    removeChildMethod.addStatement("break", new Object[0]).addCode("$<", new Object[0]);
                }
            }
            removeChildMethod.addCode("default:\n", new Object[0]).addStatement("$>super.removeChild(name, value)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(removeChildMethod.build());
        }
        logger.exit();
    }

    private void generateMethodSetPropertyByHash(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            TypeName baseType = this.frameworkTypeLocator.getBaseType();
            logger.debug("Generating method setProperty");
            MethodSpec.Builder removeChildMethod = MethodSpec.methodBuilder((String)"setProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.frameworkTypeLocator.getBaseType()).addParameter(TypeName.INT, "hash", new Modifier[0]).addParameter(String.class, "name", new Modifier[0]).addParameter(baseType, "value", new Modifier[0]).addException(FHIRException.class).addJavadoc("@see $1T#setProperty(int, String, $1T)", new Object[]{baseType}).beginControlFlow("switch(hash)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                Optional<String> castingMethod = attribute.getBaseCastingMethod();
                ArrayList propertyNames = Lists.newArrayList((Object[])new String[]{attribute.getFhirName()});
                if (attribute.isMultiType()) {
                    propertyNames.add(attribute.getFhirName() + "[x]");
                }
                for (String propertyName : propertyNames) {
                    removeChildMethod.addCode("case $L:\n", new Object[]{propertyName.hashCode()}).addCode("$>// $N\n", new Object[]{propertyName});
                    if (attribute.isRepeating()) {
                        if (castingMethod.isPresent()) {
                            removeChildMethod.addStatement("this.$N().add($N(value))", new Object[]{this.getGetterForGenericMultiTypeName(attribute), castingMethod.get()});
                        } else {
                            removeChildMethod.addStatement("this.$N().add(($T)value)", new Object[]{this.getGetterForGenericMultiTypeName(attribute), attribute.getAttributeType()});
                        }
                    } else if (castingMethod.isPresent()) {
                        removeChildMethod.addStatement("this.$N = $N(value)", new Object[]{attribute.getName(), castingMethod.get()});
                    } else {
                        removeChildMethod.addStatement("this.$N = ($T)value", new Object[]{attribute.getName(), attribute.getAttributeType()});
                    }
                    removeChildMethod.addStatement("return value", new Object[0]).addCode("$<", new Object[0]);
                }
            }
            removeChildMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.setProperty(name, value)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(removeChildMethod.build());
        }
        logger.exit();
    }

    private void generateMethodSetPropertyByName(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IClassAttribute> attributes = classData.getAttributes();
        if (!attributes.isEmpty()) {
            TypeName baseType = this.frameworkTypeLocator.getBaseType();
            logger.debug("Generating method setProperty");
            MethodSpec.Builder removeChildMethod = MethodSpec.methodBuilder((String)"setProperty").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.frameworkTypeLocator.getBaseType()).addParameter(String.class, "name", new Modifier[0]).addParameter(baseType, "value", new Modifier[0]).addException(FHIRException.class).addJavadoc("@see $1T#setProperty(int, String, $1T)", new Object[]{baseType}).beginControlFlow("switch(name)", new Object[0]);
            for (IClassAttribute attribute : attributes) {
                Optional<String> castingMethod = attribute.getBaseCastingMethod();
                ArrayList propertyNames = Lists.newArrayList((Object[])new String[]{attribute.getFhirName()});
                if (attribute.isMultiType()) {
                    propertyNames.add(attribute.getFhirName() + "[x]");
                }
                for (String propertyName : propertyNames) {
                    removeChildMethod.addCode("case $S:\n", new Object[]{propertyName}).addCode("$>", new Object[0]);
                    if (attribute.isRepeating()) {
                        if (castingMethod.isPresent()) {
                            removeChildMethod.addStatement("this.$N().add($N(value))", new Object[]{this.getGetterForGenericMultiTypeName(attribute), castingMethod.get()});
                        } else {
                            removeChildMethod.addStatement("this.$N().add(($T)value)", new Object[]{this.getGetterForGenericMultiTypeName(attribute), attribute.getAttributeType()});
                        }
                    } else if (castingMethod.isPresent()) {
                        removeChildMethod.addStatement("this.$N = $N(value)", new Object[]{attribute.getName(), castingMethod.get()});
                    } else {
                        removeChildMethod.addStatement("this.$N = ($T)value", new Object[]{attribute.getName(), attribute.getAttributeType()});
                    }
                    removeChildMethod.addStatement("return value", new Object[0]).addCode("$<", new Object[0]);
                }
            }
            removeChildMethod.addCode("default:\n", new Object[0]).addStatement("$>return super.setProperty(name, value)", new Object[0]).addCode("$<", new Object[0]).endControlFlow();
            classBuilder.addMethod(removeChildMethod.build());
        }
        logger.exit();
    }

    private void generateMethodGetExtension(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        List<IClassAttribute> extensionAttributes = classData.getAttributes().stream().filter(IClassAttribute::isExtension).toList();
        if (!extensionAttributes.isEmpty()) {
            logger.debug("Generating method getExtension");
            TypeName extensionType = this.frameworkTypeLocator.getExtensionType();
            MethodSpec.Builder getExtensionMethod = MethodSpec.methodBuilder((String)"getExtension").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{extensionType})).addAnnotation(Override.class).addStatement("final var extensions = super.getExtension()", new Object[0]);
            for (IClassAttribute attribute : extensionAttributes) {
                String url = attribute.getExtensionUrl().orElseThrow(() -> new GeneratorException(String.format("Attribute %s is marked as an extension but does not provide an extension URL", attribute.getName())));
                getExtensionMethod.beginControlFlow("if (extensions.stream().noneMatch(e -> e.getUrl().equals($1S)) && (this.$2N != null))", new Object[]{url, attribute.getName()});
                if (attribute.isRepeating()) {
                    getExtensionMethod.beginControlFlow("for(var value: $N)", new Object[]{attribute.getName()}).addStatement("extensions.add(new $T($S).setValue(value))", new Object[]{extensionType, url}).endControlFlow();
                } else {
                    getExtensionMethod.addStatement("extensions.add(new $T($S).setValue(this.$N))", new Object[]{extensionType, url, attribute.getName()});
                }
                getExtensionMethod.endControlFlow();
            }
            getExtensionMethod.addStatement("return extensions", new Object[0]);
            classBuilder.addMethod(getExtensionMethod.build());
        }
        logger.exit();
    }

    private void generateMethodHasExtension(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        List<IClassAttribute> extensionAttributes = classData.getAttributes().stream().filter(IClassAttribute::isExtension).toList();
        if (!extensionAttributes.isEmpty()) {
            logger.debug("Generating method hasExtension");
            MethodSpec.Builder hasExtensionMethod = MethodSpec.methodBuilder((String)"hasExtension").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addAnnotation(Override.class).addStatement("var hasExtension = super.hasExtension()", new Object[0]);
            for (IClassAttribute attribute : extensionAttributes) {
                hasExtensionMethod.addStatement("hasExtension |= this.$N()", new Object[]{this.getMethodName("has", attribute)});
            }
            hasExtensionMethod.addStatement("return hasExtension", new Object[0]);
            classBuilder.addMethod(hasExtensionMethod.build());
        }
        logger.exit();
    }

    private void generateMethodGetModifierExtension(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        List<IClassAttribute> extensionAttributes = classData.getAttributes().stream().filter(IClassAttribute::isModifierExtension).toList();
        if (!extensionAttributes.isEmpty()) {
            logger.debug("Generating method getModifierExtension");
            TypeName extensionType = this.frameworkTypeLocator.getExtensionType();
            MethodSpec.Builder getExtensionMethod = MethodSpec.methodBuilder((String)"getModifierExtension").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{extensionType})).addAnnotation(Override.class).addStatement("final var extensions = super.getModifierExtension()", new Object[0]);
            for (IClassAttribute attribute : extensionAttributes) {
                String url = attribute.getExtensionUrl().orElseThrow(() -> new GeneratorException(String.format("Attribute %s is marked as an extension but does not provide an extension URL", attribute.getName())));
                getExtensionMethod.beginControlFlow("if (extensions.stream().noneMatch(e -> e.getUrl().equals($S)))", new Object[]{url});
                if (attribute.isRepeating()) {
                    getExtensionMethod.beginControlFlow("for(var value: $N)", new Object[]{attribute.getName()}).addStatement("extensions.add(new $T($S).setValue(value))", new Object[]{extensionType, url}).endControlFlow();
                } else {
                    getExtensionMethod.addStatement("extensions.add(new $T($S).setValue(this.$N))", new Object[]{extensionType, url, attribute.getName()});
                }
                getExtensionMethod.endControlFlow();
            }
            getExtensionMethod.addStatement("return extensions", new Object[0]);
            classBuilder.addMethod(getExtensionMethod.build());
        }
        logger.exit();
    }

    private void generateMethodHasModifierExtension(TypeSpec.Builder classBuilder, IClassData classData) throws GeneratorException {
        logger.entry(new Object[]{classBuilder, classData});
        List<IClassAttribute> extensionAttributes = classData.getAttributes().stream().filter(IClassAttribute::isModifierExtension).toList();
        if (!extensionAttributes.isEmpty()) {
            logger.debug("Generating method hasModifierExtension");
            MethodSpec.Builder hasExtensionMethod = MethodSpec.methodBuilder((String)"hasModifierExtension").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.BOOLEAN).addAnnotation(Override.class).addStatement("var hasExtension = super.hasModifierExtension()", new Object[0]);
            for (IClassAttribute attribute : extensionAttributes) {
                hasExtensionMethod.addStatement("hasExtension |= this.$N()", new Object[]{this.getMethodName("has", attribute)});
            }
            hasExtensionMethod.addStatement("return hasExtension", new Object[0]);
            classBuilder.addMethod(hasExtensionMethod.build());
        }
        logger.exit();
    }

    private void generateMethodCreate(TypeSpec.Builder classBuilder, IClassData classData) {
        logger.entry(new Object[]{classBuilder, classData});
        ImmutableList<IFixedValueRule> rules = classData.getFixedValueRules();
        if (!rules.isEmpty()) {
            logger.debug("Generating factory method create");
            ClassName generatedClassName = classData.getClassName();
            MethodSpec.Builder createMethod = MethodSpec.methodBuilder((String)"create").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)generatedClassName);
            createMethod.addJavadoc("Creates a new instance of $T with the following fixed or pattern values already preset:\n<ul>\n", new Object[]{generatedClassName});
            rules.forEach(rule -> this.addValueJavadocForCreateMethod(createMethod, (IFixedValueRule)rule));
            createMethod.addJavadoc("</ul>\n@return a new instance of $T with the fixed/pattern values preset", new Object[]{generatedClassName});
            createMethod.addStatement("final var _result = new $T()", new Object[]{generatedClassName});
            rules.forEach(rule -> this.addValueTransferForCreateMethod(createMethod, (IFixedValueRule)rule, "_result"));
            createMethod.addStatement("return _result", new Object[0]);
            classBuilder.addMethod(createMethod.build());
        }
        logger.exit();
    }

    private void addValueJavadocForCreateMethod(MethodSpec.Builder createMethod, IFixedValueRule rule) {
        logger.entry(new Object[]{rule});
        Optional<String> value = rule.getValue();
        if (value.isPresent()) {
            if (rule.isLiteral()) {
                createMethod.addJavadoc("<li>$L = $L</li>\n", new Object[]{rule.getPath(), value.get()});
            } else {
                createMethod.addJavadoc("<li>$L = $S</li>\n", new Object[]{rule.getPath(), value.get()});
            }
        } else {
            for (IFixedValueRule property : rule.getProperties()) {
                this.addValueJavadocForCreateMethod(createMethod, property);
            }
        }
        logger.exit();
    }

    private void addValueTransferForCreateMethod(MethodSpec.Builder createMethod, IFixedValueRule rule, String target) {
        logger.entry(new Object[]{rule});
        Optional<String> prefix = rule.getPrefix();
        String variableName = prefix.isPresent() ? prefix.get() + "_" + rule.getPropertyName().replace("[x]", "") : rule.getPropertyName().replace("[x]", "");
        Optional<String> value = rule.getValue();
        createMethod.addComment(rule.getPath(), new Object[0]);
        if (value.isPresent()) {
            if (rule.isLiteral()) {
                createMethod.addStatement("final var $N = new $T($L)", new Object[]{variableName, rule.getPropertyType(), value.get()});
            } else {
                createMethod.addStatement("final var $N = new $T($S)", new Object[]{variableName, rule.getPropertyType(), value.get()});
            }
        } else {
            createMethod.addStatement("final var $N = new $T()", new Object[]{variableName, rule.getPropertyType()});
            for (IFixedValueRule property : rule.getProperties()) {
                this.addValueTransferForCreateMethod(createMethod, property, variableName);
            }
        }
        createMethod.addStatement("$1N.setProperty($2S, $3N)", new Object[]{target, rule.getPropertyName(), variableName});
        logger.exit();
    }

    private String getFormatString(Object value) {
        logger.entry(new Object[]{value});
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return (String)logger.exit((Object)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, TypeName.class}, (Object)object2, n)) {
            case 0 -> {
                String s = (String)object2;
                yield "$S";
            }
            case 1 -> {
                TypeName t = (TypeName)object2;
                yield "$T.class";
            }
            default -> "$L";
        }));
    }

    private String getFormatString(Object[] value) {
        logger.entry(value);
        Class<?> arrayType = value.getClass().getComponentType();
        String elementFormat = String.class.isAssignableFrom(arrayType) ? "$S" : (TypeName.class.isAssignableFrom(arrayType) ? "$T.class" : "$L");
        Object[] elementFormats = new String[Array.getLength(value)];
        Arrays.fill(elementFormats, elementFormat);
        String formatString = String.format("{ %s }", String.join((CharSequence)", ", (CharSequence[])elementFormats));
        return (String)logger.exit((Object)formatString);
    }

    private void writeClassToFile(TypeSpec.Builder enumBuilder, ITopLevelClass classData) throws GeneratorException {
        logger.entry(new Object[0]);
        TypeSpec enumSpec = enumBuilder.build();
        JavaFile javaFile = JavaFile.builder((String)classData.getClassName().packageName(), (TypeSpec)enumSpec).skipJavaLangImports(true).indent("\t").build();
        try {
            javaFile.writeTo(new File(classData.getOutputPath()));
        }
        catch (IOException e) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to write generated implementation %s to output path %s", classData.getClassName().canonicalName(), classData.getOutputPath()), e));
        }
        logger.exit();
    }

    private TypeName getMappedModelType(IMappedType modelType) throws GeneratorException {
        logger.entry(new Object[]{modelType});
        TypeName mappedModelType = modelType.getType().orElseThrow(() -> new GeneratorException("Model type must have been mapped to a Java type"));
        return (TypeName)logger.exit((Object)mappedModelType);
    }

    private String getMethodName(String prefix, IClassAttribute attribute) {
        return StringUtilities.toFirstLower(prefix) + StringUtilities.toFirstUpper(attribute.getName());
    }

    private String getMethodName(String prefix, IClassAttribute attribute, String suffix) {
        return StringUtilities.toFirstLower(prefix) + StringUtilities.toFirstUpper(attribute.getName()) + StringUtilities.toFirstUpper(suffix);
    }

    @lombok.Generated
    private IAccessorProvider getAccessorProvider() {
        return this.accessorProvider;
    }
}

