/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.structuredefinition.code;

import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.fhir.ClassAnnotation;
import de.fhlintstone.generator.structuredefinition.code.IClassAttribute;
import de.fhlintstone.generator.structuredefinition.code.IClassData;
import de.fhlintstone.generator.structuredefinition.code.IFixedValueRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public abstract class ClassData
implements IClassData {
    private final ClassName className;
    private final TypeName superclassName;
    private final boolean abstractClass;
    private final String structureDefinitionName;
    private final String structureDefinitionURL;
    private final boolean derivedFromPrimitiveType;
    private final Optional<ClassAnnotation> classAnnotation;
    private final List<IClassAttribute> attributeList = new ArrayList<IClassAttribute>();
    private final List<IFixedValueRule> fixedValueRuleList = new ArrayList<IFixedValueRule>();

    @Override
    public ImmutableList<IClassAttribute> getAttributes() {
        return ImmutableList.copyOf(this.attributeList);
    }

    public void addAttribute(IClassAttribute attribute) {
        this.attributeList.add(attribute);
    }

    @Override
    public ImmutableList<IFixedValueRule> getFixedValueRules() {
        return ImmutableList.copyOf(this.fixedValueRuleList);
    }

    public void addFixedValueRule(IFixedValueRule rule) {
        this.fixedValueRuleList.add(rule);
    }

    @Generated
    protected ClassData(ClassDataBuilder<?, ?> b) {
        this.className = b.className;
        this.superclassName = b.superclassName;
        this.abstractClass = b.abstractClass;
        this.structureDefinitionName = b.structureDefinitionName;
        this.structureDefinitionURL = b.structureDefinitionURL;
        this.derivedFromPrimitiveType = b.derivedFromPrimitiveType;
        this.classAnnotation = b.classAnnotation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassData)) {
            return false;
        }
        ClassData other = (ClassData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAbstractClass() != other.isAbstractClass()) {
            return false;
        }
        if (this.isDerivedFromPrimitiveType() != other.isDerivedFromPrimitiveType()) {
            return false;
        }
        ClassName this$className = this.getClassName();
        ClassName other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        TypeName this$superclassName = this.getSuperclassName();
        TypeName other$superclassName = other.getSuperclassName();
        if (this$superclassName == null ? other$superclassName != null : !this$superclassName.equals(other$superclassName)) {
            return false;
        }
        String this$structureDefinitionName = this.getStructureDefinitionName();
        String other$structureDefinitionName = other.getStructureDefinitionName();
        if (this$structureDefinitionName == null ? other$structureDefinitionName != null : !this$structureDefinitionName.equals(other$structureDefinitionName)) {
            return false;
        }
        String this$structureDefinitionURL = this.getStructureDefinitionURL();
        String other$structureDefinitionURL = other.getStructureDefinitionURL();
        if (this$structureDefinitionURL == null ? other$structureDefinitionURL != null : !this$structureDefinitionURL.equals(other$structureDefinitionURL)) {
            return false;
        }
        Optional<ClassAnnotation> this$classAnnotation = this.getClassAnnotation();
        Optional<ClassAnnotation> other$classAnnotation = other.getClassAnnotation();
        if (this$classAnnotation == null ? other$classAnnotation != null : !((Object)this$classAnnotation).equals(other$classAnnotation)) {
            return false;
        }
        List<IClassAttribute> this$attributeList = this.attributeList;
        List<IClassAttribute> other$attributeList = other.attributeList;
        if (this$attributeList == null ? other$attributeList != null : !((Object)this$attributeList).equals(other$attributeList)) {
            return false;
        }
        List<IFixedValueRule> this$fixedValueRuleList = this.fixedValueRuleList;
        List<IFixedValueRule> other$fixedValueRuleList = other.fixedValueRuleList;
        return !(this$fixedValueRuleList == null ? other$fixedValueRuleList != null : !((Object)this$fixedValueRuleList).equals(other$fixedValueRuleList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAbstractClass() ? 79 : 97);
        result = result * 59 + (this.isDerivedFromPrimitiveType() ? 79 : 97);
        ClassName $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        TypeName $superclassName = this.getSuperclassName();
        result = result * 59 + ($superclassName == null ? 43 : $superclassName.hashCode());
        String $structureDefinitionName = this.getStructureDefinitionName();
        result = result * 59 + ($structureDefinitionName == null ? 43 : $structureDefinitionName.hashCode());
        String $structureDefinitionURL = this.getStructureDefinitionURL();
        result = result * 59 + ($structureDefinitionURL == null ? 43 : $structureDefinitionURL.hashCode());
        Optional<ClassAnnotation> $classAnnotation = this.getClassAnnotation();
        result = result * 59 + ($classAnnotation == null ? 43 : ((Object)$classAnnotation).hashCode());
        List<IClassAttribute> $attributeList = this.attributeList;
        result = result * 59 + ($attributeList == null ? 43 : ((Object)$attributeList).hashCode());
        List<IFixedValueRule> $fixedValueRuleList = this.fixedValueRuleList;
        result = result * 59 + ($fixedValueRuleList == null ? 43 : ((Object)$fixedValueRuleList).hashCode());
        return result;
    }

    @Override
    @Generated
    public ClassName getClassName() {
        return this.className;
    }

    @Override
    @Generated
    public TypeName getSuperclassName() {
        return this.superclassName;
    }

    @Override
    @Generated
    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    @Override
    @Generated
    public String getStructureDefinitionName() {
        return this.structureDefinitionName;
    }

    @Override
    @Generated
    public String getStructureDefinitionURL() {
        return this.structureDefinitionURL;
    }

    @Override
    @Generated
    public boolean isDerivedFromPrimitiveType() {
        return this.derivedFromPrimitiveType;
    }

    @Override
    @Generated
    public Optional<ClassAnnotation> getClassAnnotation() {
        return this.classAnnotation;
    }

    @Generated
    public static abstract class ClassDataBuilder<C extends ClassData, B extends ClassDataBuilder<C, B>> {
        @Generated
        private ClassName className;
        @Generated
        private TypeName superclassName;
        @Generated
        private boolean abstractClass;
        @Generated
        private String structureDefinitionName;
        @Generated
        private String structureDefinitionURL;
        @Generated
        private boolean derivedFromPrimitiveType;
        @Generated
        private Optional<ClassAnnotation> classAnnotation;

        @Generated
        public B withClassName(ClassName className) {
            this.className = className;
            return this.self();
        }

        @Generated
        public B withSuperclassName(TypeName superclassName) {
            this.superclassName = superclassName;
            return this.self();
        }

        @Generated
        public B withAbstractClass(boolean abstractClass) {
            this.abstractClass = abstractClass;
            return this.self();
        }

        @Generated
        public B withStructureDefinitionName(String structureDefinitionName) {
            this.structureDefinitionName = structureDefinitionName;
            return this.self();
        }

        @Generated
        public B withStructureDefinitionURL(String structureDefinitionURL) {
            this.structureDefinitionURL = structureDefinitionURL;
            return this.self();
        }

        @Generated
        public B withDerivedFromPrimitiveType(boolean derivedFromPrimitiveType) {
            this.derivedFromPrimitiveType = derivedFromPrimitiveType;
            return this.self();
        }

        @Generated
        public B withClassAnnotation(Optional<ClassAnnotation> classAnnotation) {
            this.classAnnotation = classAnnotation;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ClassData.ClassDataBuilder(className=" + String.valueOf(this.className) + ", superclassName=" + String.valueOf(this.superclassName) + ", abstractClass=" + this.abstractClass + ", structureDefinitionName=" + this.structureDefinitionName + ", structureDefinitionURL=" + this.structureDefinitionURL + ", derivedFromPrimitiveType=" + this.derivedFromPrimitiveType + ", classAnnotation=" + String.valueOf(this.classAnnotation) + ")";
        }
    }
}

