/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator.structuredefinition;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.Extension;
import com.google.common.collect.ImmutableCollection;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.accessors.model.StringifiedValue;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.structuredefinition.IStructureDefinitionGenerator;
import de.fhlintstone.generator.structuredefinition.code.AccessorGenerationMode;
import de.fhlintstone.generator.structuredefinition.code.ClassAttribute;
import de.fhlintstone.generator.structuredefinition.code.ClassAttributeAnnotation;
import de.fhlintstone.generator.structuredefinition.code.ClassData;
import de.fhlintstone.generator.structuredefinition.code.FixedValueRule;
import de.fhlintstone.generator.structuredefinition.code.IClassAttributeAnnotation;
import de.fhlintstone.generator.structuredefinition.code.ICodeEmitter;
import de.fhlintstone.generator.structuredefinition.code.IFixedValueRule;
import de.fhlintstone.generator.structuredefinition.code.NestedClass;
import de.fhlintstone.generator.structuredefinition.code.TopLevelClass;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeAttribute;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeFixedValue;
import de.fhlintstone.generator.structuredefinition.intermediate.ITypeInformation;
import de.fhlintstone.process.config.NestedClassConfiguration;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.StructureClassInstantiation;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class StructureDefinitionGenerator
implements IStructureDefinitionGenerator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(StructureDefinitionGenerator.class);
    private final IFrameworkTypeLocator frameworkTypeLocator;
    private final ICodeEmitter codeEmitter;

    @Inject
    public StructureDefinitionGenerator(IFrameworkTypeLocator frameworkTypeLocator, ICodeEmitter codeEmitter) {
        this.frameworkTypeLocator = frameworkTypeLocator;
        this.codeEmitter = codeEmitter;
    }

    @Override
    public void generate(ProcessConfiguration configuration, ITypeInformation typeInformation) throws GeneratorException {
        logger.entry(new Object[]{typeInformation});
        TypeName typeName = typeInformation.getTypeName();
        if (!(typeName instanceof ClassName)) {
            throw new GeneratorException(String.format("Target type name %s for StructureDefinition %s is not a ClassName", typeInformation.getTypeName(), typeInformation.getResourceURI()));
        }
        ClassName className = (ClassName)typeName;
        logger.info("Generating class {} for StructureDefinition {}", (Object)typeInformation.getTypeName(), (Object)typeInformation.getResourceURI());
        TopLevelClass topLevelClass = this.createTopLevelClass(configuration, typeInformation, className);
        this.createAttributes(topLevelClass, typeInformation);
        this.createFixedValues(topLevelClass, typeInformation);
        this.createNestedTypes(topLevelClass, typeInformation);
        this.codeEmitter.generate(topLevelClass);
        logger.exit();
    }

    private TopLevelClass createTopLevelClass(ProcessConfiguration configuration, ITypeInformation typeInformation, ClassName className) {
        logger.entry(new Object[]{className});
        StructureDefinitionClassConfiguration classConfig = typeInformation.getTopLevelConfiguration().orElseThrow();
        boolean isAbstract = classConfig.getInstantiation() == StructureClassInstantiation.ABSTRACT;
        TypeName superClassName = typeInformation.getParentTypeName().orElseThrow();
        ClassData classData = ((TopLevelClass.TopLevelClassBuilder)((ClassData.ClassDataBuilder)((TopLevelClass.TopLevelClassBuilder)((TopLevelClass.TopLevelClassBuilder)((TopLevelClass.TopLevelClassBuilder)((TopLevelClass.TopLevelClassBuilder)((TopLevelClass.TopLevelClassBuilder)((TopLevelClass.TopLevelClassBuilder)((ClassData.ClassDataBuilder)TopLevelClass.builder().withOutputPath(configuration.getOutputPath())).withClassName(className)).withSuperclassName(superClassName)).withAbstractClass(isAbstract)).withDerivedFromPrimitiveType(this.frameworkTypeLocator.isDerivedFromPrimitiveType(superClassName))).withStructureDefinitionURL(typeInformation.getResourceURI().toString())).withStructureDefinitionName(typeInformation.getDefinitionName())).withDescription(typeInformation.getDescription())).withClassAnnotation(typeInformation.getClassAnnotation())).build();
        return (TopLevelClass)logger.exit((Object)classData);
    }

    private void createAttributes(ClassData classData, ITypeInformation typeInformation) {
        logger.entry(new Object[]{classData});
        for (ITypeAttribute sourceAttribute : typeInformation.getAttributes()) {
            logger.debug("Transferring attribute {}", (Object)sourceAttribute.getJavaName());
            Optional<String> description = this.getAttributeDescription(sourceAttribute);
            Collection<IClassAttributeAnnotation> annotations = this.getAttributeAnnotations(sourceAttribute);
            Optional<TypeName> primitiveType = this.getAttributePrimitiveType(sourceAttribute);
            ClassAttribute classAttribute = ClassAttribute.builder().withName(sourceAttribute.getJavaName()).withFhirName(sourceAttribute.getFhirName()).withElementId(sourceAttribute.getElementId()).withAttributeType(sourceAttribute.getAttributeType()).withActualType(this.getActualAttributeType(sourceAttribute)).withCreationType(this.getAttributeCreationType(sourceAttribute)).withPrimitiveType(primitiveType).withModelTypes((Iterable<? extends IMappedType>)sourceAttribute.getModelTypes()).withPropertyTypes(this.getPropertyTypes(sourceAttribute)).withBaseCastingMethod(this.getBaseCastingMethod(sourceAttribute)).withAccessorGenerationMode(this.getAttributeAccessorGenerationMode(sourceAttribute, primitiveType)).withDescription(description).withDefinition(sourceAttribute.getDefinition()).withMin(sourceAttribute.getMin()).withMax(sourceAttribute.getMax()).withDerivedFromPrimitiveType(this.frameworkTypeLocator.isDerivedFromPrimitiveType(sourceAttribute.getAttributeType())).withExtensionUrl(sourceAttribute.getExtensionUrl()).withExtension(sourceAttribute.isExtension()).withModifierExtension(sourceAttribute.isModifier()).withAnnotations(annotations).build();
            classData.addAttribute(classAttribute);
        }
        logger.exit();
    }

    private void createNestedTypes(TopLevelClass topLevelClass, ITypeInformation typeInformation) {
        logger.entry(new Object[]{topLevelClass});
        for (ITypeInformation nestedType : typeInformation.getNestedTypes()) {
            logger.debug("Transferring nested type {}", (Object)nestedType.getTypeName());
            NestedClass nestedClass = this.createNestedClass(nestedType, (ClassName)nestedType.getTypeName());
            this.createAttributes(nestedClass, nestedType);
            this.createFixedValues(nestedClass, nestedType);
            topLevelClass.addNestedClass(nestedClass);
        }
        logger.exit();
    }

    private NestedClass createNestedClass(ITypeInformation typeInformation, ClassName className) {
        logger.entry(new Object[]{className});
        NestedClassConfiguration classConfig = typeInformation.getNestedConfiguration().orElseThrow();
        boolean isAbstract = classConfig.getInstantiation() == StructureClassInstantiation.ABSTRACT;
        TypeName superClassName = typeInformation.getParentTypeName().orElseThrow();
        ClassData classData = ((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((NestedClass.NestedClassBuilder)((ClassData.ClassDataBuilder)NestedClass.builder().withElementId(typeInformation.getElementId().orElseThrow())).withClassName(className)).withSuperclassName(superClassName)).withAbstractClass(isAbstract)).withStructureDefinitionURL(typeInformation.getResourceURI().toString())).withStructureDefinitionName(typeInformation.getDefinitionName())).withDerivedFromPrimitiveType(this.frameworkTypeLocator.isDerivedFromPrimitiveType(superClassName))).withClassAnnotation(typeInformation.getClassAnnotation())).build();
        return (NestedClass)logger.exit((Object)classData);
    }

    private Optional<String> getAttributeDescription(ITypeAttribute attribute) {
        logger.entry(new Object[]{attribute});
        StringBuilder descriptionBuilder = new StringBuilder();
        Optional<String> shortDefinition = attribute.getShortDefinition();
        Optional<String> definition = attribute.getDefinition();
        if (shortDefinition.isPresent()) {
            descriptionBuilder.append(shortDefinition.get());
        }
        if (shortDefinition.isPresent() && definition.isPresent()) {
            descriptionBuilder.append("\n\n");
        }
        if (definition.isPresent()) {
            descriptionBuilder.append(definition.get());
        }
        if (shortDefinition.isEmpty() && definition.isEmpty()) {
            descriptionBuilder.append(String.format("FHIR element %s (no further definition provided in the model).", attribute.getFhirName()));
        }
        Optional<String> description = Optional.of(descriptionBuilder.toString());
        return (Optional)logger.exit(description);
    }

    private Collection<IClassAttributeAnnotation> getAttributeAnnotations(ITypeAttribute attribute) {
        logger.entry(new Object[]{attribute});
        ArrayList<IClassAttributeAnnotation> result = new ArrayList<IClassAttributeAnnotation>();
        result.add(this.generateAttributeAnnotationChild(attribute));
        if (attribute.isExtension()) {
            result.add(this.generateAttributeAnnotationExtension(attribute));
        }
        if (attribute.getDefinition().isPresent() || attribute.getShortDefinition().isPresent()) {
            result.add(this.generateAttributeAnnotationDescription(attribute));
        }
        if (attribute.getBindingValueSet().isPresent()) {
            result.add(this.generateAttributeAnnotationBinding(attribute));
        }
        return (Collection)logger.exit(result);
    }

    private IClassAttributeAnnotation generateAttributeAnnotationChild(ITypeAttribute attribute) {
        ImmutableCollection<IMappedType> modelTypes;
        logger.entry(new Object[]{attribute});
        ClassAttributeAnnotation.ClassAttributeAnnotationBuilder childAnnotationBuilder = ClassAttributeAnnotation.builder().withAnnotation(ClassName.get(Child.class));
        childAnnotationBuilder.withParameter("name", attribute.getFhirName());
        if (attribute.getMin() != 0) {
            childAnnotationBuilder.withParameter("min", attribute.getMin());
        }
        if (attribute.getMax() != 1) {
            childAnnotationBuilder.withParameter("max", attribute.getMax());
        }
        if ((modelTypes = attribute.getModelTypes()).size() > 1) {
            childAnnotationBuilder.withParameter("type", modelTypes.stream().map(t -> t.getType()).filter(t -> t.isPresent()).map(t -> (TypeName)t.get()).toArray(TypeName[]::new));
        }
        if (attribute.isModifier()) {
            childAnnotationBuilder.withParameter("modifier", Boolean.TRUE);
        }
        return (IClassAttributeAnnotation)logger.exit((Object)childAnnotationBuilder.build());
    }

    private IClassAttributeAnnotation generateAttributeAnnotationExtension(ITypeAttribute attribute) {
        logger.entry(new Object[]{attribute});
        ClassAttributeAnnotation.ClassAttributeAnnotationBuilder extensionAnnotationBuilder = ClassAttributeAnnotation.builder().withAnnotation(ClassName.get(Extension.class));
        if (attribute.isModifier()) {
            extensionAnnotationBuilder.withParameter("isModifier", Boolean.TRUE);
        }
        extensionAnnotationBuilder.withParameter("url", attribute.getExtensionUrl().orElseThrow());
        return (IClassAttributeAnnotation)logger.exit((Object)extensionAnnotationBuilder.build());
    }

    private IClassAttributeAnnotation generateAttributeAnnotationDescription(ITypeAttribute attribute) {
        Optional<String> shortDefinition;
        logger.entry(new Object[]{attribute});
        ClassAttributeAnnotation.ClassAttributeAnnotationBuilder descriptionAnnotationBuilder = ClassAttributeAnnotation.builder().withAnnotation(ClassName.get(Description.class));
        Optional<String> definition = attribute.getDefinition();
        if (definition.isPresent()) {
            descriptionAnnotationBuilder.withParameter("value", definition.get());
        }
        if ((shortDefinition = attribute.getShortDefinition()).isPresent()) {
            descriptionAnnotationBuilder.withParameter("shortDefinition", shortDefinition.get());
        }
        return (IClassAttributeAnnotation)logger.exit((Object)descriptionAnnotationBuilder.build());
    }

    private IClassAttributeAnnotation generateAttributeAnnotationBinding(ITypeAttribute attribute) {
        logger.entry(new Object[]{attribute});
        return (IClassAttributeAnnotation)logger.exit((Object)ClassAttributeAnnotation.builder().withAnnotation(ClassName.get(Binding.class)).withParameter("valueSet", attribute.getBindingValueSet().orElseThrow()).build());
    }

    private Optional<TypeName> getAttributePrimitiveType(ITypeAttribute attribute) {
        logger.entry(new Object[]{attribute});
        if (attribute.getMax() != 1) {
            return (Optional)logger.exit(Optional.empty());
        }
        return (Optional)logger.exit(this.frameworkTypeLocator.determinePrimitiveType(attribute.getAttributeType()));
    }

    private TypeName getActualAttributeType(ITypeAttribute attribute) {
        return this.getAttributeCollectionType(attribute, ClassName.get(List.class));
    }

    private TypeName getAttributeCreationType(ITypeAttribute attribute) {
        return this.getAttributeCollectionType(attribute, ClassName.get(ArrayList.class));
    }

    private TypeName getAttributeCollectionType(ITypeAttribute attribute, ClassName collectionType) {
        logger.entry(new Object[]{attribute});
        if (attribute.getMax() != 1) {
            TypeName attributeType = attribute.getAttributeType();
            if (attributeType.isPrimitive()) {
                return (TypeName)logger.exit((Object)ParameterizedTypeName.get((ClassName)collectionType, (TypeName[])new TypeName[]{attributeType.box()}));
            }
            return (TypeName)logger.exit((Object)ParameterizedTypeName.get((ClassName)collectionType, (TypeName[])new TypeName[]{attributeType}));
        }
        return (TypeName)logger.exit((Object)attribute.getAttributeType());
    }

    private AccessorGenerationMode getAttributeAccessorGenerationMode(ITypeAttribute attribute, Optional<TypeName> primitiveType) {
        logger.entry(new Object[]{attribute});
        ImmutableCollection<IMappedType> modelTypes = attribute.getModelTypes();
        if (modelTypes.size() > 1) {
            if (attribute.getMax() != 1) {
                return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.MULTI_TYPE_REPEATING));
            }
            return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.MULTI_TYPE_NON_REPEATING));
        }
        if (attribute.getMax() != 1) {
            if (primitiveType.isPresent()) {
                return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.SINGLE_TYPE_REPEATING_PRIMITIVE));
            }
            return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.SINGLE_TYPE_REPEATING_ELEMENT));
        }
        if (primitiveType.isPresent()) {
            return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.SINGLE_TYPE_NON_REPEATING_PRIMITIVE));
        }
        return (AccessorGenerationMode)((Object)logger.exit((Object)AccessorGenerationMode.SINGLE_TYPE_NON_REPEATING_ELEMENT));
    }

    private Iterable<String> getPropertyTypes(ITypeAttribute sourceAttribute) {
        logger.entry(new Object[]{sourceAttribute});
        List<String> typeCodes = sourceAttribute.getModelTypes().stream().map(IMappedType::getTypeCode).filter(Optional::isPresent).map(Optional::get).toList();
        return (Iterable)logger.exit(typeCodes);
    }

    private Optional<String> getBaseCastingMethod(ITypeAttribute sourceAttribute) {
        logger.entry(new Object[]{sourceAttribute});
        Optional<String> result = this.frameworkTypeLocator.getBaseCastingMethod(sourceAttribute.getAttributeType());
        return (Optional)logger.exit(result);
    }

    private void createFixedValues(ClassData targetClass, ITypeInformation typeInformation) {
        logger.entry(new Object[]{targetClass});
        for (ITypeFixedValue fixedValue : typeInformation.getFixedValues()) {
            logger.debug("Transferring fixed value of element {}", (Object)fixedValue.getElementPath());
            targetClass.addFixedValueRule(this.createFixedValueRule(fixedValue, Optional.empty()));
        }
        logger.exit();
    }

    private IFixedValueRule createFixedValueRule(ITypeFixedValue fixedValue, Optional<String> prefix) {
        logger.entry(new Object[]{fixedValue});
        String elementId = fixedValue.getLocalName();
        FixedValueRule.FixedValueRuleBuilder ruleBuilder = FixedValueRule.builder().withPath(fixedValue.getElementPath()).withPropertyName(elementId).withPrefix(prefix).withPropertyType(fixedValue.getType());
        if (fixedValue.isComplex()) {
            String componentPrefix = prefix.isPresent() ? prefix.get() + "_" + elementId : elementId;
            for (ITypeFixedValue componentValue : fixedValue.getComponentValues()) {
                IFixedValueRule componentRule = this.createFixedValueRule(componentValue, Optional.of(componentPrefix));
                ruleBuilder.withProperty(componentRule);
            }
        } else {
            Optional<StringifiedValue> stringifiedValue = fixedValue.getValue();
            if (stringifiedValue.isPresent()) {
                ruleBuilder.withValue(Optional.of(stringifiedValue.get().getValue())).withLiteral(stringifiedValue.get().isLiteral());
            } else {
                logger.warn("Unable to obtain stringified fixed value for element {}", (Object)fixedValue.getElementId());
            }
        }
        return (IFixedValueRule)logger.exit((Object)ruleBuilder.build());
    }
}

