/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.generator;

import com.google.common.base.Strings;
import com.palantir.javapoet.ClassName;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.generator.IGeneratedTypeNameRegistry;
import de.fhlintstone.process.config.NestedClassConfiguration;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import de.fhlintstone.process.config.ValueSetEnumConfiguration;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.lang.model.SourceVersion;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
@Singleton
public class GeneratedTypeNameRegistry
implements IGeneratedTypeNameRegistry {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(GeneratedTypeNameRegistry.class);
    private final Map<URI, ClassName> enumNames = new HashMap<URI, ClassName>();
    private final Map<URI, ClassName> classNames = new HashMap<URI, ClassName>();

    @Override
    public void setConfiguration(ProcessConfiguration configuration) throws GeneratorException {
        logger.entry(new Object[]{configuration});
        this.enumNames.clear();
        this.classNames.clear();
        for (ValueSetEnumConfiguration valueSet : configuration.getValueSetEnums()) {
            this.processValueSet(configuration, valueSet);
        }
        for (StructureDefinitionClassConfiguration structureDefinition : configuration.getStructureDefinitionClasses()) {
            this.processStructureDefinition(configuration, structureDefinition);
        }
        logger.exit();
    }

    @Override
    public Optional<ClassName> getEnumName(URI valueSetURI) {
        logger.entry(new Object[]{valueSetURI});
        if (this.enumNames.containsKey(valueSetURI)) {
            return (Optional)logger.exit(Optional.of(this.enumNames.get(valueSetURI)));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    @Override
    public Optional<ClassName> getClassName(URI structureDefinitionURI) {
        logger.entry(new Object[]{structureDefinitionURI});
        if (this.classNames.containsKey(structureDefinitionURI)) {
            return (Optional)logger.exit(Optional.of(this.classNames.get(structureDefinitionURI)));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    @Override
    public Optional<ClassName> getNestedClassName(URI parentURI, String elementId) {
        logger.entry(new Object[]{parentURI, elementId});
        URI searchURI = this.buildNestedURI(parentURI, elementId);
        if (this.classNames.containsKey(searchURI)) {
            return (Optional)logger.exit(Optional.of(this.classNames.get(searchURI)));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    private void processValueSet(ProcessConfiguration configuration, ValueSetEnumConfiguration valueSet) throws GeneratorException {
        logger.entry(new Object[]{valueSet});
        URI valueSetURI = valueSet.getValueSet();
        this.validateName(valueSet.getEnumName());
        String namespace = this.determineNamespace(configuration, valueSet.getTargetNamespace());
        ClassName enumName = ClassName.get((String)namespace, (String)valueSet.getEnumName(), (String[])new String[0]);
        logger.debug("Storing enum name {} for ValueSet {}", (Object)enumName, (Object)valueSetURI);
        this.enumNames.put(valueSetURI, enumName);
        logger.exit();
    }

    private void processStructureDefinition(ProcessConfiguration configuration, StructureDefinitionClassConfiguration structureDefinition) throws GeneratorException {
        logger.entry(new Object[]{structureDefinition});
        URI structureDefinitionURI = structureDefinition.getStructureDefinition();
        this.validateName(structureDefinition.getClassName());
        String namespace = this.determineNamespace(configuration, structureDefinition.getTargetNamespace());
        ClassName className = ClassName.get((String)namespace, (String)structureDefinition.getClassName(), (String[])new String[0]);
        logger.debug("Storing class name {} for StructureDefinition {}", (Object)className, (Object)structureDefinitionURI);
        this.classNames.put(structureDefinitionURI, className);
        for (NestedClassConfiguration nestedClass : structureDefinition.getNestedClasses()) {
            this.validateName(nestedClass.getClassName());
            URI nestedClassURI = this.buildNestedURI(structureDefinitionURI, nestedClass.getElementId());
            ClassName nestedClassName = className.nestedClass(nestedClass.getClassName());
            logger.debug("Storing nested class name {} for StructureDefinition {}", (Object)nestedClassName, (Object)nestedClassURI);
            this.classNames.put(nestedClassURI, nestedClassName);
        }
        logger.exit();
    }

    private String determineNamespace(ProcessConfiguration configuration, Optional<String> localNamespace) throws GeneratorException {
        String namespace;
        logger.entry(new Object[]{configuration, localNamespace});
        if (localNamespace.isPresent()) {
            namespace = localNamespace.get();
        } else {
            Optional<String> globalNamespace = configuration.getDefaultNamespace();
            if (globalNamespace.isPresent()) {
                namespace = globalNamespace.get();
            } else {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException("The target namespace must be specified (either as global default or for each configuration entry individually."));
            }
        }
        return (String)logger.exit((Object)namespace);
    }

    private void validateName(String name) throws GeneratorException {
        logger.entry(new Object[]{name});
        if (Strings.isNullOrEmpty((String)name)) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException("The target name must be specified."));
        }
        if (!SourceVersion.isName(name)) {
            throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("The target name %s is not a valid Java type name.", name)));
        }
        logger.exit();
    }

    private URI buildNestedURI(URI parentURI, String elementId) {
        logger.entry(new Object[]{parentURI, elementId});
        try {
            return (URI)logger.exit((Object)new URI(parentURI.getScheme(), parentURI.getSchemeSpecificPart(), elementId));
        }
        catch (URISyntaxException e) {
            throw (RuntimeException)logger.throwing((Throwable)new RuntimeException(String.format("Unable to create URI for nested class of parent URI %s, element ID %s", parentURI, elementId), e));
        }
    }
}

