/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.elements;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.fhir.elements.ElementBaseRelationship;
import de.fhlintstone.fhir.elements.IElementTree;
import de.fhlintstone.fhir.elements.IElementTreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public final class ElementTreeNode
implements IElementTreeNode {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ElementTreeNode.class);
    private final IElementTree tree;
    private final IElementDefinitionAccessor snapshotElement;
    private final String localName;
    private final Optional<String> sliceName;
    private final Optional<IElementDefinitionAccessor> differentialElement;
    private final Optional<IElementDefinitionAccessor> baseElement;
    private final ElementBaseRelationship baseRelationship;
    private final Optional<IElementTreeNode> parent;
    private final List<IElementTreeNode> childNodes = new ArrayList<IElementTreeNode>();
    private final List<IElementTreeNode> sliceNodes = new ArrayList<IElementTreeNode>();
    private final Supplier<String> idSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        Optional<String> id = this.getSnapshotElement().getId();
        if (id.isPresent()) {
            return (String)logger.exit((Object)id.get());
        }
        throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException("Element.id is missing"));
    });
    private final LoadingCache<NodeListKey, ImmutableList<IElementTreeNode>> nodeListCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<NodeListKey, ImmutableList<IElementTreeNode>>(){

        public ImmutableList<IElementTreeNode> load(NodeListKey key) throws Exception {
            logger.entry(new Object[]{key});
            switch (key.ordinal()) {
                case 0: {
                    return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(ElementTreeNode.this.childNodes));
                }
                case 1: {
                    return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(ElementTreeNode.this.sliceNodes));
                }
            }
            throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException());
        }
    });
    private final LoadingCache<String, Optional<IElementTreeNode>> childByLocalNameCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<IElementTreeNode>>(){

        public Optional<IElementTreeNode> load(String key) throws Exception {
            logger.entry(new Object[]{key});
            return (Optional)logger.exit(ElementTreeNode.this.getChildren().stream().filter(n -> n.getLocalName().equals(key)).findFirst());
        }
    });
    private final LoadingCache<String, Optional<IElementTreeNode>> sliceByNameCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Optional<IElementTreeNode>>(){

        public Optional<IElementTreeNode> load(String key) throws Exception {
            logger.entry(new Object[]{key});
            return (Optional)logger.exit(ElementTreeNode.this.getSlices().stream().filter(n -> n.getSliceName().orElse("").equals(key)).findFirst());
        }
    });

    @Override
    public String getId() {
        return (String)this.idSupplier.get();
    }

    @Override
    public boolean hasChildren() {
        return !this.childNodes.isEmpty();
    }

    @Override
    public ImmutableList<IElementTreeNode> getChildren() {
        logger.entry(new Object[0]);
        try {
            return (ImmutableList)logger.exit((Object)((ImmutableList)this.nodeListCache.get((Object)NodeListKey.CHILDREN)));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)logger.throwing((Throwable)new RuntimeException("Unable to create immutable list of children", e));
        }
    }

    @Override
    public Optional<IElementTreeNode> getChild(String localName) {
        logger.entry(new Object[]{localName});
        try {
            return (Optional)logger.exit((Object)((Optional)this.childByLocalNameCache.get((Object)localName)));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)logger.throwing((Throwable)new RuntimeException("Unable to access cache of children by localName", e));
        }
    }

    void addChild(IElementTreeNode node) {
        logger.entry(new Object[]{node});
        this.childNodes.add(node);
        this.nodeListCache.invalidate((Object)NodeListKey.CHILDREN);
        this.childByLocalNameCache.invalidate((Object)node.getLocalName());
        logger.exit();
    }

    @Override
    public boolean hasSlices() {
        return !this.sliceNodes.isEmpty();
    }

    @Override
    public ImmutableList<IElementTreeNode> getSlices() {
        logger.entry(new Object[0]);
        try {
            return (ImmutableList)logger.exit((Object)((ImmutableList)this.nodeListCache.get((Object)NodeListKey.SLICES)));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)logger.throwing((Throwable)new RuntimeException("Unable to create immutable list of slices", e));
        }
    }

    @Override
    public Optional<IElementTreeNode> getSlice(String name) {
        logger.entry(new Object[]{this.localName});
        try {
            return (Optional)logger.exit((Object)((Optional)this.sliceByNameCache.get((Object)name)));
        }
        catch (ExecutionException e) {
            throw (RuntimeException)logger.throwing((Throwable)new RuntimeException("Unable to access cache of slices by name", e));
        }
    }

    void addSlice(IElementTreeNode node) {
        logger.entry(new Object[]{node});
        String nodeSliceName = node.getSliceName().orElseThrow(() -> new IllegalArgumentException("Nodes added as slice must have a slice name set"));
        this.sliceNodes.add(node);
        this.nodeListCache.invalidate((Object)NodeListKey.SLICES);
        this.sliceByNameCache.invalidate((Object)nodeSliceName);
        logger.exit();
    }

    public String toString() {
        return "ElementTreeNode [snapshotElement=" + String.valueOf(this.snapshotElement) + ", localName=" + this.localName + ", sliceName=" + String.valueOf(this.sliceName) + "]";
    }

    @Generated
    private static Optional<String> $default$sliceName() {
        return Optional.empty();
    }

    @Generated
    private static Optional<IElementDefinitionAccessor> $default$differentialElement() {
        return Optional.empty();
    }

    @Generated
    private static Optional<IElementDefinitionAccessor> $default$baseElement() {
        return Optional.empty();
    }

    @Generated
    private static Optional<IElementTreeNode> $default$parent() {
        return Optional.empty();
    }

    @Generated
    ElementTreeNode(IElementTree tree, IElementDefinitionAccessor snapshotElement, String localName, Optional<String> sliceName, Optional<IElementDefinitionAccessor> differentialElement, Optional<IElementDefinitionAccessor> baseElement, ElementBaseRelationship baseRelationship, Optional<IElementTreeNode> parent) {
        this.tree = tree;
        this.snapshotElement = snapshotElement;
        this.localName = localName;
        this.sliceName = sliceName;
        this.differentialElement = differentialElement;
        this.baseElement = baseElement;
        this.baseRelationship = baseRelationship;
        this.parent = parent;
    }

    @Generated
    public static ElementTreeNodeBuilder builder() {
        return new ElementTreeNodeBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementTreeNode)) {
            return false;
        }
        ElementTreeNode other = (ElementTreeNode)o;
        IElementTree this$tree = this.getTree();
        IElementTree other$tree = other.getTree();
        if (this$tree == null ? other$tree != null : !this$tree.equals(other$tree)) {
            return false;
        }
        IElementDefinitionAccessor this$snapshotElement = this.getSnapshotElement();
        IElementDefinitionAccessor other$snapshotElement = other.getSnapshotElement();
        if (this$snapshotElement == null ? other$snapshotElement != null : !this$snapshotElement.equals(other$snapshotElement)) {
            return false;
        }
        String this$localName = this.getLocalName();
        String other$localName = other.getLocalName();
        if (this$localName == null ? other$localName != null : !this$localName.equals(other$localName)) {
            return false;
        }
        Optional<String> this$sliceName = this.getSliceName();
        Optional<String> other$sliceName = other.getSliceName();
        if (this$sliceName == null ? other$sliceName != null : !((Object)this$sliceName).equals(other$sliceName)) {
            return false;
        }
        Optional<IElementDefinitionAccessor> this$differentialElement = this.getDifferentialElement();
        Optional<IElementDefinitionAccessor> other$differentialElement = other.getDifferentialElement();
        if (this$differentialElement == null ? other$differentialElement != null : !((Object)this$differentialElement).equals(other$differentialElement)) {
            return false;
        }
        Optional<IElementDefinitionAccessor> this$baseElement = this.getBaseElement();
        Optional<IElementDefinitionAccessor> other$baseElement = other.getBaseElement();
        if (this$baseElement == null ? other$baseElement != null : !((Object)this$baseElement).equals(other$baseElement)) {
            return false;
        }
        ElementBaseRelationship this$baseRelationship = this.getBaseRelationship();
        ElementBaseRelationship other$baseRelationship = other.getBaseRelationship();
        if (this$baseRelationship == null ? other$baseRelationship != null : !((Object)((Object)this$baseRelationship)).equals((Object)other$baseRelationship)) {
            return false;
        }
        Optional<IElementTreeNode> this$parent = this.getParent();
        Optional<IElementTreeNode> other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        List<IElementTreeNode> this$childNodes = this.childNodes;
        List<IElementTreeNode> other$childNodes = other.childNodes;
        if (this$childNodes == null ? other$childNodes != null : !((Object)this$childNodes).equals(other$childNodes)) {
            return false;
        }
        List<IElementTreeNode> this$sliceNodes = this.sliceNodes;
        List<IElementTreeNode> other$sliceNodes = other.sliceNodes;
        return !(this$sliceNodes == null ? other$sliceNodes != null : !((Object)this$sliceNodes).equals(other$sliceNodes));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IElementTree $tree = this.getTree();
        result = result * 59 + ($tree == null ? 43 : $tree.hashCode());
        IElementDefinitionAccessor $snapshotElement = this.getSnapshotElement();
        result = result * 59 + ($snapshotElement == null ? 43 : $snapshotElement.hashCode());
        String $localName = this.getLocalName();
        result = result * 59 + ($localName == null ? 43 : $localName.hashCode());
        Optional<String> $sliceName = this.getSliceName();
        result = result * 59 + ($sliceName == null ? 43 : ((Object)$sliceName).hashCode());
        Optional<IElementDefinitionAccessor> $differentialElement = this.getDifferentialElement();
        result = result * 59 + ($differentialElement == null ? 43 : ((Object)$differentialElement).hashCode());
        Optional<IElementDefinitionAccessor> $baseElement = this.getBaseElement();
        result = result * 59 + ($baseElement == null ? 43 : ((Object)$baseElement).hashCode());
        ElementBaseRelationship $baseRelationship = this.getBaseRelationship();
        result = result * 59 + ($baseRelationship == null ? 43 : ((Object)((Object)$baseRelationship)).hashCode());
        Optional<IElementTreeNode> $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        List<IElementTreeNode> $childNodes = this.childNodes;
        result = result * 59 + ($childNodes == null ? 43 : ((Object)$childNodes).hashCode());
        List<IElementTreeNode> $sliceNodes = this.sliceNodes;
        result = result * 59 + ($sliceNodes == null ? 43 : ((Object)$sliceNodes).hashCode());
        return result;
    }

    @Override
    @Generated
    public IElementTree getTree() {
        return this.tree;
    }

    @Override
    @Generated
    public IElementDefinitionAccessor getSnapshotElement() {
        return this.snapshotElement;
    }

    @Override
    @Generated
    public String getLocalName() {
        return this.localName;
    }

    @Override
    @Generated
    public Optional<String> getSliceName() {
        return this.sliceName;
    }

    @Override
    @Generated
    public Optional<IElementDefinitionAccessor> getDifferentialElement() {
        return this.differentialElement;
    }

    @Override
    @Generated
    public Optional<IElementDefinitionAccessor> getBaseElement() {
        return this.baseElement;
    }

    @Override
    @Generated
    public ElementBaseRelationship getBaseRelationship() {
        return this.baseRelationship;
    }

    @Override
    @Generated
    public Optional<IElementTreeNode> getParent() {
        return this.parent;
    }

    private static enum NodeListKey {
        CHILDREN,
        SLICES;

    }

    @Generated
    public static class ElementTreeNodeBuilder {
        @Generated
        private IElementTree tree;
        @Generated
        private IElementDefinitionAccessor snapshotElement;
        @Generated
        private String localName;
        @Generated
        private boolean sliceName$set;
        @Generated
        private Optional<String> sliceName$value;
        @Generated
        private boolean differentialElement$set;
        @Generated
        private Optional<IElementDefinitionAccessor> differentialElement$value;
        @Generated
        private boolean baseElement$set;
        @Generated
        private Optional<IElementDefinitionAccessor> baseElement$value;
        @Generated
        private ElementBaseRelationship baseRelationship;
        @Generated
        private boolean parent$set;
        @Generated
        private Optional<IElementTreeNode> parent$value;

        @Generated
        ElementTreeNodeBuilder() {
        }

        @Generated
        public ElementTreeNodeBuilder withTree(IElementTree tree) {
            this.tree = tree;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withSnapshotElement(IElementDefinitionAccessor snapshotElement) {
            this.snapshotElement = snapshotElement;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withLocalName(String localName) {
            this.localName = localName;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withSliceName(Optional<String> sliceName) {
            this.sliceName$value = sliceName;
            this.sliceName$set = true;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withDifferentialElement(Optional<IElementDefinitionAccessor> differentialElement) {
            this.differentialElement$value = differentialElement;
            this.differentialElement$set = true;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withBaseElement(Optional<IElementDefinitionAccessor> baseElement) {
            this.baseElement$value = baseElement;
            this.baseElement$set = true;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withBaseRelationship(ElementBaseRelationship baseRelationship) {
            this.baseRelationship = baseRelationship;
            return this;
        }

        @Generated
        public ElementTreeNodeBuilder withParent(Optional<IElementTreeNode> parent) {
            this.parent$value = parent;
            this.parent$set = true;
            return this;
        }

        @Generated
        public ElementTreeNode build() {
            Optional<String> sliceName$value = this.sliceName$value;
            if (!this.sliceName$set) {
                sliceName$value = ElementTreeNode.$default$sliceName();
            }
            Optional<IElementDefinitionAccessor> differentialElement$value = this.differentialElement$value;
            if (!this.differentialElement$set) {
                differentialElement$value = ElementTreeNode.$default$differentialElement();
            }
            Optional<IElementDefinitionAccessor> baseElement$value = this.baseElement$value;
            if (!this.baseElement$set) {
                baseElement$value = ElementTreeNode.$default$baseElement();
            }
            Optional<IElementTreeNode> parent$value = this.parent$value;
            if (!this.parent$set) {
                parent$value = ElementTreeNode.$default$parent();
            }
            return new ElementTreeNode(this.tree, this.snapshotElement, this.localName, sliceName$value, differentialElement$value, baseElement$value, this.baseRelationship, parent$value);
        }

        @Generated
        public String toString() {
            return "ElementTreeNode.ElementTreeNodeBuilder(tree=" + String.valueOf(this.tree) + ", snapshotElement=" + String.valueOf(this.snapshotElement) + ", localName=" + this.localName + ", sliceName$value=" + String.valueOf(this.sliceName$value) + ", differentialElement$value=" + String.valueOf(this.differentialElement$value) + ", baseElement$value=" + String.valueOf(this.baseElement$value) + ", baseRelationship=" + String.valueOf((Object)this.baseRelationship) + ", parent$value=" + String.valueOf(this.parent$value) + ")";
        }
    }
}

