/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.elements;

import de.fhlintstone.fhir.elements.IElementTreeNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class ElementTreeIterator
implements Iterator<IElementTreeNode> {
    private final Deque<IElementTreeNode> stack = new ArrayDeque<IElementTreeNode>();

    ElementTreeIterator(IElementTreeNode rootNode) {
        this.stack.addFirst(rootNode);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.isEmpty();
    }

    @Override
    public IElementTreeNode next() {
        if (this.stack.isEmpty()) {
            throw new NoSuchElementException();
        }
        IElementTreeNode nextElement = this.stack.removeFirst();
        nextElement.getChildren().reverse().forEach(this.stack::addFirst);
        return nextElement;
    }
}

