/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.elements;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.UnresolvableURIException;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.accessors.implementations.TypeLocatorException;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.fhir.elements.ElementBaseRelationship;
import de.fhlintstone.fhir.elements.ElementTree;
import de.fhlintstone.fhir.elements.ElementTreeNode;
import de.fhlintstone.fhir.elements.IElementTree;
import de.fhlintstone.fhir.elements.IElementTreeBuilder;
import de.fhlintstone.fhir.elements.IElementTreeNode;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class ElementTreeBuilder
implements IElementTreeBuilder {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ElementTreeBuilder.class);
    private final IAccessorProvider accessorProvider;
    private final IFrameworkTypeLocator frameworkTypeLocator;

    @Inject
    public ElementTreeBuilder(IAccessorProvider accessorProvider, IFrameworkTypeLocator frameworkTypeLocator) {
        this.accessorProvider = accessorProvider;
        this.frameworkTypeLocator = frameworkTypeLocator;
    }

    @Override
    public IElementTree buildElementTree(IStructureDefinitionAccessor structureDefinition) {
        logger.entry(new Object[]{structureDefinition});
        ElementTree tree = new ElementTree(structureDefinition);
        IElementTreeNode rootNode = this.buildTreeInternal(tree, structureDefinition, Optional.empty());
        tree.setRootNode(rootNode);
        return (IElementTree)logger.exit((Object)tree);
    }

    @Override
    public IElementTree buildElementTree(IStructureDefinitionAccessor structureDefinition, IStructureDefinitionAccessor baseStructure) {
        logger.entry(new Object[]{structureDefinition, baseStructure});
        ElementTree tree = new ElementTree(structureDefinition, baseStructure);
        IElementTreeNode rootNode = this.buildTreeInternal(tree, structureDefinition, Optional.of(baseStructure));
        tree.setRootNode(rootNode);
        return (IElementTree)logger.exit((Object)tree);
    }

    private IElementTreeNode buildTreeInternal(ElementTree tree, IStructureDefinitionAccessor structureDefinition, Optional<IStructureDefinitionAccessor> baseStructure) {
        logger.entry(new Object[0]);
        logger.debug("Building element tree for StructureDefinition {}", (Object)structureDefinition.getUrl().orElse("(no URL)"));
        this.validateStructures(structureDefinition, baseStructure);
        ElementLookupTables elementLookupTables = new ElementLookupTables(structureDefinition, baseStructure);
        ImmutableList<IElementDefinitionAccessor> snapshotElements = structureDefinition.getSnapshot().orElseThrow().getElement();
        ElementTreeNode rootNode = null;
        for (IElementDefinitionAccessor snapshotElement : snapshotElements) {
            String elementId = snapshotElement.getId().orElseThrow();
            Optional<IElementDefinitionAccessor> differentialElement = elementLookupTables.getDifferentialElement(elementId);
            Optional<IElementDefinitionAccessor> baseElement = elementLookupTables.getBaseElement(elementId);
            if (rootNode == null) {
                logger.debug("Creating root node {}", (Object)elementId);
                ElementBaseRelationship baseRelationship = this.determineBaseRelationship(structureDefinition, elementLookupTables, snapshotElement, Optional.empty());
                rootNode = ElementTreeNode.builder().withTree(tree).withSnapshotElement(snapshotElement).withLocalName(elementId).withDifferentialElement(differentialElement).withBaseElement(baseElement).withBaseRelationship(baseRelationship).build();
                continue;
            }
            logger.debug("Creating node {}", (Object)elementId);
            InsertionPoint insertionPoint = this.determineInsertionPoint(rootNode, snapshotElement);
            ElementBaseRelationship baseRelationship = this.determineBaseRelationship(structureDefinition, elementLookupTables, snapshotElement, Optional.of(insertionPoint));
            logger.debug("New node {} is a {} named {} of node {} with relationship {}", new Object[]{elementId, insertionPoint.mode(), insertionPoint.subId(), insertionPoint.parent().getId(), baseRelationship});
            this.addElementToTree(tree, insertionPoint, snapshotElement, differentialElement, baseElement, baseRelationship);
        }
        return (IElementTreeNode)logger.exit(rootNode);
    }

    private void validateStructures(IStructureDefinitionAccessor structureDefinition, Optional<IStructureDefinitionAccessor> baseStructure) {
        logger.entry(new Object[0]);
        if (structureDefinition.getSnapshot().isEmpty()) {
            throw new IllegalArgumentException(String.format("No snapshot is provided for StructureDefinition %s", structureDefinition.getUrl().orElse(structureDefinition.getName().orElse("???"))));
        }
        if (baseStructure.isPresent() && baseStructure.get().getSnapshot().isEmpty()) {
            IStructureDefinitionAccessor baseStructureDefinition = baseStructure.get();
            throw new IllegalArgumentException(String.format("No snapshot is provided for base StructureDefinition %s", baseStructureDefinition.getUrl().orElse(baseStructureDefinition.getName().orElse("???"))));
        }
        if (baseStructure.isPresent() && structureDefinition.getDifferential().isEmpty()) {
            throw new IllegalArgumentException(String.format("No differential is provided for StructureDefinition %s", structureDefinition.getUrl().orElse(structureDefinition.getName().orElse("???"))));
        }
        logger.exit();
    }

    private InsertionPoint determineInsertionPoint(ElementTreeNode currentNode, IElementDefinitionAccessor snapshotElement) {
        logger.entry(new Object[]{currentNode, snapshotElement});
        String currentId = currentNode.getId();
        String newId = snapshotElement.getId().orElseThrow();
        if (newId.startsWith(currentId)) {
            InsertionPoint insertionPoint;
            String newSubId = newId.substring(currentId.length());
            boolean isChild = newSubId.startsWith(".");
            boolean isSlice = newSubId.startsWith(":");
            newSubId = newSubId.substring(1);
            newSubId = this.determineLeadingIdFragment(newSubId);
            if (isChild) {
                Optional<IElementTreeNode> child = currentNode.getChild(newSubId);
                if (child.isPresent()) {
                    logger.trace("Handing element {} to existing child {}", (Object)newId, (Object)newSubId);
                    insertionPoint = this.determineInsertionPoint((ElementTreeNode)child.get(), snapshotElement);
                } else {
                    logger.trace("Locating element {} as child {} of {}", new Object[]{newId, newSubId, currentId});
                    insertionPoint = new InsertionPoint(currentNode, newSubId, InsertionMode.CHILD);
                }
            } else if (isSlice) {
                Optional<IElementTreeNode> slice = currentNode.getSlice(newSubId);
                if (slice.isPresent()) {
                    logger.trace("Handing element {} to existing slice {}", (Object)newId, (Object)newSubId);
                    insertionPoint = this.determineInsertionPoint((ElementTreeNode)slice.get(), snapshotElement);
                } else {
                    logger.trace("Locating element {} as slice {} of {}", new Object[]{newId, newSubId, currentId});
                    insertionPoint = new InsertionPoint(currentNode, newSubId, InsertionMode.SLICE);
                }
            } else {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException(String.format("Element with id %s arrived at id %s, but can not be identified as either slice or child (unknown separator)", newId, currentId)));
            }
            return (InsertionPoint)logger.exit((Object)insertionPoint);
        }
        throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException(String.format("Element with id %s arrived at id %s with completely different path - don't know how to handle this.", newId, currentId)));
    }

    private ElementBaseRelationship determineBaseRelationship(IStructureDefinitionAccessor structureDefinition, ElementLookupTables elementLookupTables, IElementDefinitionAccessor snapshotElement, Optional<InsertionPoint> insertionPoint) {
        logger.entry(new Object[]{snapshotElement});
        String elementId = snapshotElement.getId().orElseThrow();
        InsertionMode insertionMode = insertionPoint.map(InsertionPoint::mode).orElse(InsertionMode.CHILD);
        ElementTreeNode parent = insertionPoint.map(InsertionPoint::parent).orElse(null);
        ElementBaseRelationship baseRelationship = elementLookupTables.hasBaseStructure() ? (!elementLookupTables.hasBaseElement(elementId) ? (insertionMode == InsertionMode.CHILD ? (parent == null ? ElementBaseRelationship.ADDED : this.determineBaseRelationshipByParent(elementId, elementLookupTables, parent, structureDefinition)) : ElementBaseRelationship.ADDED) : (elementLookupTables.hasDifferentialElement(elementId) ? ElementBaseRelationship.CHANGED : ElementBaseRelationship.UNCHANGED)) : ElementBaseRelationship.NO_BASE;
        return (ElementBaseRelationship)((Object)logger.exit((Object)baseRelationship));
    }

    private ElementBaseRelationship determineBaseRelationshipByParent(String elementId, ElementLookupTables elementLookupTables, ElementTreeNode parent, IStructureDefinitionAccessor structureDefinition) {
        ElementBaseRelationship baseRelationship;
        logger.entry(new Object[]{elementId, parent});
        ImmutableList<IStructureDefinitionAccessor> parentTypeStructures = this.getTypesOfTreeNode(parent, structureDefinition);
        if (!parentTypeStructures.isEmpty()) {
            Pattern idShorteningPattern = Pattern.compile("^\\w+(\\..*)$");
            ArrayList<String> parentTypesElementIndex = new ArrayList<String>();
            for (IStructureDefinitionAccessor structure : parentTypeStructures) {
                ImmutableList<IElementDefinitionAccessor> parentSnapshotElements = structure.getSnapshot().orElseThrow().getElement();
                parentTypesElementIndex.addAll(parentSnapshotElements.stream().skip(1L).map(element -> element.getId().orElseThrow()).map(id -> {
                    Matcher elementIdMatcher = idShorteningPattern.matcher((CharSequence)id);
                    return elementIdMatcher.matches() ? elementIdMatcher.group(1) : elementId;
                }).toList());
            }
            Matcher searchIdMatcher = idShorteningPattern.matcher(elementId);
            String searchId = searchIdMatcher.matches() ? searchIdMatcher.group(1) : elementId;
            baseRelationship = parentTypesElementIndex.stream().noneMatch(searchId::endsWith) ? ElementBaseRelationship.ADDED : (elementLookupTables.hasDifferentialElement(elementId) ? ElementBaseRelationship.CHANGED : ElementBaseRelationship.UNCHANGED);
        } else {
            baseRelationship = ElementBaseRelationship.ADDED;
        }
        return (ElementBaseRelationship)((Object)logger.exit((Object)baseRelationship));
    }

    private ImmutableList<IStructureDefinitionAccessor> getTypesOfTreeNode(ElementTreeNode treeNode, IStructureDefinitionAccessor structureDefinition) {
        List<IStructureDefinitionAccessor> typeStructureDefinitions;
        ImmutableCollection<IMappedType> elementTypes;
        logger.entry(new Object[]{treeNode});
        IElementDefinitionAccessor snapshotElement = treeNode.getSnapshotElement();
        String elementId = snapshotElement.getId().orElse("(unknown)");
        try {
            elementTypes = this.frameworkTypeLocator.determineModelTypes(snapshotElement);
        }
        catch (TypeLocatorException e) {
            logger.error("Could not determine types of {}", (Object)elementId, (Object)e);
            return (ImmutableList)logger.exit((Object)ImmutableList.of());
        }
        if (elementTypes.isEmpty()) {
            Optional<String> baseDefinition = structureDefinition.getBaseDefinition();
            if (baseDefinition.isPresent()) {
                try {
                    URI baseDefinitionURI = this.frameworkTypeLocator.makeAbsoluteStructureDefinitionReference(baseDefinition.get());
                    IStructureDefinitionAccessor baseDefinitionAccessor = this.accessorProvider.provideStructureDefinitionAccessor(baseDefinitionURI);
                    logger.debug("No type set for element {}, falling back to base definition {}", (Object)elementId, (Object)baseDefinitionURI);
                    typeStructureDefinitions = List.of(baseDefinitionAccessor);
                }
                catch (UnresolvableURIException | URISyntaxException e) {
                    logger.warn("Unable to resolve baseDefinition {}, falling back to {}", new Object[]{baseDefinition.get(), structureDefinition, e});
                    typeStructureDefinitions = List.of(structureDefinition);
                }
            } else {
                logger.debug("No type set for element {} and no baseDefinition present, falling back to parent resource {}", (Object)elementId, (Object)structureDefinition);
                typeStructureDefinitions = List.of(structureDefinition);
            }
        } else {
            typeStructureDefinitions = this.loadStructureDefinitionForTypes((Collection<IMappedType>)elementTypes);
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(typeStructureDefinitions));
    }

    private List<IStructureDefinitionAccessor> loadStructureDefinitionForTypes(Collection<IMappedType> types) {
        logger.entry(new Object[]{types});
        ArrayList<IStructureDefinitionAccessor> typeStructureDefintions = new ArrayList<IStructureDefinitionAccessor>();
        for (IMappedType type : types) {
            if (type.getProfile().isPresent()) {
                try {
                    typeStructureDefintions.add(this.accessorProvider.provideStructureDefinitionAccessor(type.getProfileURI().orElseThrow()));
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Could not load Structure Definition for profile {}, {}", (Object)type.getProfile().orElse("(unknown)"), (Object)e.getMessage());
                }
                continue;
            }
            if (type.getTypeCode().isPresent()) {
                try {
                    typeStructureDefintions.add(this.accessorProvider.provideStructureDefinitionAccessor(type.getTypeCodeURI().orElseThrow()));
                }
                catch (IllegalArgumentException e) {
                    logger.warn("Could not load Structure Definition for type {}, {}", (Object)type.getTypeCode().orElse("(unknown)"), (Object)e.getMessage());
                }
                continue;
            }
            logger.warn("Type does contain neither a profile or type code, skipping");
        }
        return (List)logger.exit(typeStructureDefintions);
    }

    private void addElementToTree(ElementTree tree, InsertionPoint insertionPoint, IElementDefinitionAccessor snapshotElement, Optional<IElementDefinitionAccessor> differentialElement, Optional<IElementDefinitionAccessor> baseElement, ElementBaseRelationship baseRelationship) {
        logger.entry(new Object[]{insertionPoint.parent(), snapshotElement});
        InsertionMode mode = insertionPoint.mode();
        if (mode == InsertionMode.CHILD) {
            logger.trace("Adding element {} as child {} of {}", new Object[]{snapshotElement.getId().orElseThrow(), insertionPoint.subId(), insertionPoint.parent().getId()});
            ElementTreeNode childNode = ElementTreeNode.builder().withTree(tree).withSnapshotElement(snapshotElement).withLocalName(insertionPoint.subId()).withDifferentialElement(differentialElement).withBaseElement(baseElement).withBaseRelationship(baseRelationship).withParent(Optional.of(insertionPoint.parent())).build();
            insertionPoint.parent().addChild(childNode);
        } else if (mode == InsertionMode.SLICE) {
            logger.trace("Adding element {} as slice {} of {}", new Object[]{snapshotElement.getId().orElseThrow(), insertionPoint.subId(), insertionPoint.parent().getId()});
            ElementTreeNode sliceNode = ElementTreeNode.builder().withTree(tree).withSnapshotElement(snapshotElement).withLocalName(insertionPoint.parent().getLocalName()).withSliceName(Optional.of(insertionPoint.subId())).withDifferentialElement(differentialElement).withBaseElement(baseElement).withBaseRelationship(baseRelationship).withParent(Optional.of(insertionPoint.parent())).build();
            insertionPoint.parent().addSlice(sliceNode);
        }
        logger.exit();
    }

    private String determineLeadingIdFragment(String currentId) {
        logger.entry(new Object[]{currentId});
        int dotPosition = currentId.indexOf(46);
        int colonPosition = currentId.indexOf(58);
        if (dotPosition >= 0 || colonPosition >= 0) {
            currentId = dotPosition >= 0 && colonPosition < 0 ? currentId.substring(0, dotPosition) : (dotPosition < 0 && colonPosition >= 0 ? currentId.substring(0, colonPosition) : currentId.substring(0, Math.min(dotPosition, colonPosition)));
        }
        return (String)logger.exit((Object)currentId);
    }

    private static class ElementLookupTables {
        @Generated
        private static final XLogger logger = XLoggerFactory.getXLogger(ElementLookupTables.class);
        private final Map<String, IElementDefinitionAccessor> differentialElementIndex;
        private final Map<String, IElementDefinitionAccessor> baseElementIndex;

        public ElementLookupTables(IStructureDefinitionAccessor structureDefinition, Optional<IStructureDefinitionAccessor> baseStructure) {
            logger.entry(new Object[0]);
            ImmutableList<IElementDefinitionAccessor> snapshotElements = structureDefinition.getSnapshot().orElseThrow().getElement();
            this.differentialElementIndex = baseStructure.isPresent() ? structureDefinition.getDifferential().orElseThrow().getElement().stream().collect(Collectors.toMap(e -> e.getId().orElseThrow(), e -> e)) : new HashMap<String, IElementDefinitionAccessor>();
            this.baseElementIndex = baseStructure.isPresent() ? baseStructure.orElseThrow().getSnapshot().orElseThrow().getElement().stream().collect(Collectors.toMap(e -> e.getId().orElseThrow(), e -> e)) : new HashMap<String, IElementDefinitionAccessor>();
            logger.debug("snapshot: {} entries, differential element index: {} entries, base element index: {} entries", new Object[]{snapshotElements.size(), this.differentialElementIndex.size(), this.baseElementIndex.size()});
            logger.exit();
        }

        public boolean hasDifferentialElement(String elementId) {
            return this.differentialElementIndex.containsKey(elementId);
        }

        public Optional<IElementDefinitionAccessor> getDifferentialElement(String elementId) {
            return Optional.ofNullable(this.differentialElementIndex.get(elementId));
        }

        public boolean hasBaseStructure() {
            return !this.baseElementIndex.isEmpty();
        }

        public boolean hasBaseElement(String elementId) {
            return this.baseElementIndex.containsKey(elementId);
        }

        public Optional<IElementDefinitionAccessor> getBaseElement(String elementId) {
            return Optional.ofNullable(this.baseElementIndex.get(elementId));
        }
    }

    private record InsertionPoint(ElementTreeNode parent, String subId, InsertionMode mode) {
    }

    private static enum InsertionMode {
        CHILD,
        SLICE;

    }
}

