/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.elements;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.fhir.elements.ElementTreeIterator;
import de.fhlintstone.fhir.elements.IElementTree;
import de.fhlintstone.fhir.elements.IElementTreeNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public final class ElementTree
implements IElementTree {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ElementTree.class);
    private final IStructureDefinitionAccessor structureDefinition;
    private final Optional<IStructureDefinitionAccessor> baseStructureDefinition;
    private IElementTreeNode rootNode;
    private final Supplier<Map<IElementDefinitionAccessor, IElementTreeNode>> indexByElementSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        HashMap result = new HashMap();
        this.visitAllNodes(node -> {
            result.put(node.getSnapshotElement(), node);
            Optional<IElementDefinitionAccessor> differentialElement = node.getDifferentialElement();
            if (differentialElement.isPresent()) {
                result.put(differentialElement.get(), node);
            }
        });
        return (Map)logger.exit(result);
    });
    private final Supplier<Map<String, IElementTreeNode>> indexByIdSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        HashMap result = new HashMap();
        this.visitAllNodes(node -> result.put(node.getId(), node));
        return (Map)logger.exit(result);
    });

    public ElementTree(IStructureDefinitionAccessor structureDefinition) {
        this.structureDefinition = structureDefinition;
        this.baseStructureDefinition = Optional.empty();
    }

    public ElementTree(IStructureDefinitionAccessor structureDefinition, IStructureDefinitionAccessor baseStructureDefinition) {
        this.structureDefinition = structureDefinition;
        this.baseStructureDefinition = Optional.of(baseStructureDefinition);
    }

    @Override
    public IElementTreeNode getNode(IElementDefinitionAccessor element) throws IllegalArgumentException {
        logger.entry(new Object[]{element});
        Map index = (Map)this.indexByElementSupplier.get();
        if (index.containsKey(element)) {
            return (IElementTreeNode)logger.exit((Object)((IElementTreeNode)index.get(element)));
        }
        throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException("Element is not part of the element tree"));
    }

    @Override
    public Optional<IElementTreeNode> getNode(String id) {
        logger.entry(new Object[]{id});
        Map index = (Map)this.indexByIdSupplier.get();
        if (index.containsKey(id)) {
            return (Optional)logger.exit(Optional.of((IElementTreeNode)index.get(id)));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    void visitAllNodes(Consumer<IElementTreeNode> visitor) {
        logger.entry(new Object[0]);
        LinkedList<IElementTreeNode> remainingNodes = new LinkedList<IElementTreeNode>();
        remainingNodes.add(this.rootNode);
        while (!remainingNodes.isEmpty()) {
            IElementTreeNode node = (IElementTreeNode)remainingNodes.removeFirst();
            remainingNodes.addAll((Collection<IElementTreeNode>)node.getChildren());
            remainingNodes.addAll((Collection<IElementTreeNode>)node.getSlices());
            visitor.accept(node);
        }
        logger.exit();
    }

    public String toString() {
        return "ElementTree [structureDefinitionAccessor=" + String.valueOf(this.structureDefinition) + ", rootNode=" + String.valueOf(this.rootNode) + "]";
    }

    @Override
    public Iterator<IElementTreeNode> iterator() {
        return new ElementTreeIterator(this.rootNode);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementTree)) {
            return false;
        }
        ElementTree other = (ElementTree)o;
        IStructureDefinitionAccessor this$structureDefinition = this.getStructureDefinition();
        IStructureDefinitionAccessor other$structureDefinition = other.getStructureDefinition();
        if (this$structureDefinition == null ? other$structureDefinition != null : !this$structureDefinition.equals(other$structureDefinition)) {
            return false;
        }
        Optional<IStructureDefinitionAccessor> this$baseStructureDefinition = this.getBaseStructureDefinition();
        Optional<IStructureDefinitionAccessor> other$baseStructureDefinition = other.getBaseStructureDefinition();
        if (this$baseStructureDefinition == null ? other$baseStructureDefinition != null : !((Object)this$baseStructureDefinition).equals(other$baseStructureDefinition)) {
            return false;
        }
        IElementTreeNode this$rootNode = this.getRootNode();
        IElementTreeNode other$rootNode = other.getRootNode();
        return !(this$rootNode == null ? other$rootNode != null : !this$rootNode.equals(other$rootNode));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IStructureDefinitionAccessor $structureDefinition = this.getStructureDefinition();
        result = result * 59 + ($structureDefinition == null ? 43 : $structureDefinition.hashCode());
        Optional<IStructureDefinitionAccessor> $baseStructureDefinition = this.getBaseStructureDefinition();
        result = result * 59 + ($baseStructureDefinition == null ? 43 : ((Object)$baseStructureDefinition).hashCode());
        IElementTreeNode $rootNode = this.getRootNode();
        result = result * 59 + ($rootNode == null ? 43 : $rootNode.hashCode());
        return result;
    }

    @Override
    @Generated
    public IStructureDefinitionAccessor getStructureDefinition() {
        return this.structureDefinition;
    }

    @Override
    @Generated
    public Optional<IStructureDefinitionAccessor> getBaseStructureDefinition() {
        return this.baseStructureDefinition;
    }

    @Override
    @Generated
    public IElementTreeNode getRootNode() {
        return this.rootNode;
    }

    @Generated
    void setRootNode(IElementTreeNode rootNode) {
        this.rootNode = rootNode;
    }
}

