/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.dependencies;

import com.palantir.javapoet.TypeName;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import de.fhlintstone.packages.FhirResourceType;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;

public final class DependencyNode
implements IDependencyNode {
    private final URI resourceURI;
    private final Optional<IBaseResource> resource;
    private final Optional<FhirResourceType> resourceType;
    private final Optional<TypeName> frameworkType;

    public String toString() {
        if (this.frameworkType.isPresent()) {
            return "DependencyNode [resourceURI=" + String.valueOf(this.resourceURI) + ", frameworkType" + String.valueOf(this.frameworkType.get()) + "]";
        }
        return "DependencyNode [resourceURI=" + String.valueOf(this.resourceURI) + "]";
    }

    @Generated
    private static Optional<IBaseResource> $default$resource() {
        return Optional.empty();
    }

    @Generated
    private static Optional<FhirResourceType> $default$resourceType() {
        return Optional.empty();
    }

    @Generated
    private static Optional<TypeName> $default$frameworkType() {
        return Optional.empty();
    }

    @Generated
    DependencyNode(URI resourceURI, Optional<IBaseResource> resource, Optional<FhirResourceType> resourceType, Optional<TypeName> frameworkType) {
        this.resourceURI = resourceURI;
        this.resource = resource;
        this.resourceType = resourceType;
        this.frameworkType = frameworkType;
    }

    @Generated
    public static DependencyNodeBuilder builder() {
        return new DependencyNodeBuilder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyNode)) {
            return false;
        }
        DependencyNode other = (DependencyNode)o;
        URI this$resourceURI = this.getResourceURI();
        URI other$resourceURI = other.getResourceURI();
        if (this$resourceURI == null ? other$resourceURI != null : !((Object)this$resourceURI).equals(other$resourceURI)) {
            return false;
        }
        Optional<IBaseResource> this$resource = this.getResource();
        Optional<IBaseResource> other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource)) {
            return false;
        }
        Optional<FhirResourceType> this$resourceType = this.getResourceType();
        Optional<FhirResourceType> other$resourceType = other.getResourceType();
        if (this$resourceType == null ? other$resourceType != null : !((Object)this$resourceType).equals(other$resourceType)) {
            return false;
        }
        Optional<TypeName> this$frameworkType = this.getFrameworkType();
        Optional<TypeName> other$frameworkType = other.getFrameworkType();
        return !(this$frameworkType == null ? other$frameworkType != null : !((Object)this$frameworkType).equals(other$frameworkType));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        URI $resourceURI = this.getResourceURI();
        result = result * 59 + ($resourceURI == null ? 43 : ((Object)$resourceURI).hashCode());
        Optional<IBaseResource> $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        Optional<FhirResourceType> $resourceType = this.getResourceType();
        result = result * 59 + ($resourceType == null ? 43 : ((Object)$resourceType).hashCode());
        Optional<TypeName> $frameworkType = this.getFrameworkType();
        result = result * 59 + ($frameworkType == null ? 43 : ((Object)$frameworkType).hashCode());
        return result;
    }

    @Override
    @Generated
    public URI getResourceURI() {
        return this.resourceURI;
    }

    @Override
    @Generated
    public Optional<IBaseResource> getResource() {
        return this.resource;
    }

    @Override
    @Generated
    public Optional<FhirResourceType> getResourceType() {
        return this.resourceType;
    }

    @Override
    @Generated
    public Optional<TypeName> getFrameworkType() {
        return this.frameworkType;
    }

    @Generated
    public static class DependencyNodeBuilder {
        @Generated
        private URI resourceURI;
        @Generated
        private boolean resource$set;
        @Generated
        private Optional<IBaseResource> resource$value;
        @Generated
        private boolean resourceType$set;
        @Generated
        private Optional<FhirResourceType> resourceType$value;
        @Generated
        private boolean frameworkType$set;
        @Generated
        private Optional<TypeName> frameworkType$value;

        @Generated
        DependencyNodeBuilder() {
        }

        @Generated
        public DependencyNodeBuilder withResourceURI(URI resourceURI) {
            this.resourceURI = resourceURI;
            return this;
        }

        @Generated
        public DependencyNodeBuilder withResource(Optional<IBaseResource> resource) {
            this.resource$value = resource;
            this.resource$set = true;
            return this;
        }

        @Generated
        public DependencyNodeBuilder withResourceType(Optional<FhirResourceType> resourceType) {
            this.resourceType$value = resourceType;
            this.resourceType$set = true;
            return this;
        }

        @Generated
        public DependencyNodeBuilder withFrameworkType(Optional<TypeName> frameworkType) {
            this.frameworkType$value = frameworkType;
            this.frameworkType$set = true;
            return this;
        }

        @Generated
        public DependencyNode build() {
            Optional<IBaseResource> resource$value = this.resource$value;
            if (!this.resource$set) {
                resource$value = DependencyNode.$default$resource();
            }
            Optional<FhirResourceType> resourceType$value = this.resourceType$value;
            if (!this.resourceType$set) {
                resourceType$value = DependencyNode.$default$resourceType();
            }
            Optional<TypeName> frameworkType$value = this.frameworkType$value;
            if (!this.frameworkType$set) {
                frameworkType$value = DependencyNode.$default$frameworkType();
            }
            return new DependencyNode(this.resourceURI, resource$value, resourceType$value, frameworkType$value);
        }

        @Generated
        public String toString() {
            return "DependencyNode.DependencyNodeBuilder(resourceURI=" + String.valueOf(this.resourceURI) + ", resource$value=" + String.valueOf(this.resource$value) + ", resourceType$value=" + String.valueOf(this.resourceType$value) + ", frameworkType$value=" + String.valueOf(this.frameworkType$value) + ")";
        }
    }
}

