/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.dependencies;

import com.google.common.base.Strings;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.dependencies.IDependencyResourceVisitor;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.fhir.IResourceUtilities;
import de.fhlintstone.fhir.dependencies.Dependency;
import de.fhlintstone.fhir.dependencies.DependencyException;
import de.fhlintstone.fhir.dependencies.DependencyGraph;
import de.fhlintstone.fhir.dependencies.DependencyNode;
import de.fhlintstone.fhir.dependencies.IDependency;
import de.fhlintstone.fhir.dependencies.IDependencyCollector;
import de.fhlintstone.fhir.dependencies.IDependencyGraph;
import de.fhlintstone.fhir.dependencies.IDependencyGraphBuilder;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class DependencyGraphBuilder
implements IDependencyGraphBuilder {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(DependencyGraphBuilder.class);
    private final IPackageRegistry packageRegistry;
    private final IResourceUtilities resourceUtilities;
    private final IFrameworkTypeLocator frameworkTypeLocator;
    private final IDependencyResourceVisitor dependencyResourceVisitor;
    private final List<IDependencyNode> resourceNodes = new ArrayList<IDependencyNode>();

    @Inject
    public DependencyGraphBuilder(IPackageRegistry packageRegistry, IResourceUtilities resourceUtilities, IFrameworkTypeLocator frameworkTypeLocator, IDependencyResourceVisitor dependencyResourceVisitor) {
        this.packageRegistry = packageRegistry;
        this.resourceUtilities = resourceUtilities;
        this.frameworkTypeLocator = frameworkTypeLocator;
        this.dependencyResourceVisitor = dependencyResourceVisitor;
    }

    @Override
    public void addResource(IBaseResource resource) throws DependencyException {
        logger.entry(new Object[]{resource});
        if (this.resourceNodes.stream().anyMatch(n -> n.getResource().isPresent() && n.getResource().get().equals((Object)resource))) {
            throw new DependencyException(String.format("Resource %s has already been added to the dependency graph", resource));
        }
        this.resourceNodes.add(this.createNode(resource));
        logger.exit();
    }

    @Override
    public IDependencyGraph build() throws DependencyException {
        return new InternalDependencyGraphBuilder().build(this.resourceNodes);
    }

    private IDependencyNode createNode(URI resourceURI) {
        logger.entry(new Object[]{resourceURI});
        Optional<TypeName> frameworkType = this.frameworkTypeLocator.determineType(resourceURI);
        return (IDependencyNode)logger.exit((Object)DependencyNode.builder().withResourceURI(resourceURI).withFrameworkType(frameworkType).build());
    }

    private IDependencyNode createNode(IBaseResource resource) throws DependencyException {
        logger.entry(new Object[]{resource});
        try {
            IResourceUtilities.ResourceURIContents uriContents = this.resourceUtilities.readResourceURI(resource);
            if (uriContents.uri().isEmpty()) {
                throw (DependencyException)logger.throwing((Throwable)new DependencyException("Unable to determine URI for resource"));
            }
            Optional<TypeName> frameworkType = this.determineFrameworkType(resource);
            return (IDependencyNode)logger.exit((Object)DependencyNode.builder().withResource(Optional.of(resource)).withResourceType(Optional.of(FhirResourceType.fromResource(resource))).withResourceURI(uriContents.uri().orElseThrow()).withFrameworkType(frameworkType).build());
        }
        catch (IllegalArgumentException e) {
            throw (DependencyException)logger.throwing((Throwable)new DependencyException("Unable to create node for resource", e));
        }
    }

    private Optional<TypeName> determineFrameworkType(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        IResourceUtilities.ResourceURIContents uriContents = this.resourceUtilities.readResourceURI(resource);
        Optional<URI> uri = uriContents.uri();
        if (uri.isPresent()) {
            return this.frameworkTypeLocator.determineType(uri.get());
        }
        return (Optional)logger.exit(Optional.empty());
    }

    private class InternalDependencyGraphBuilder
    implements IDependencyCollector {
        private final Map<URI, IDependencyNode> dependencyNodes = new HashMap<URI, IDependencyNode>();
        private final Set<IDependency> dependencies = new HashSet<IDependency>();
        private final Deque<IDependencyNode> remainingNodes = new LinkedList<IDependencyNode>();
        private IDependencyNode currentNode = null;

        private InternalDependencyGraphBuilder() {
        }

        public IDependencyGraph build(List<IDependencyNode> initialNodes) throws DependencyException {
            logger.entry(new Object[0]);
            logger.debug("Starting dependency resolution with {} initial dependencyNodes", (Object)initialNodes.size());
            for (IDependencyNode initialNode : initialNodes) {
                this.remainingNodes.add(initialNode);
                this.dependencyNodes.put(initialNode.getResourceURI(), initialNode);
            }
            while (!this.remainingNodes.isEmpty()) {
                this.currentNode = this.remainingNodes.removeFirst();
                URI resourceURI = this.currentNode.getResourceURI();
                logger.debug("Visiting resource {} to determine dependencies", (Object)resourceURI);
                Optional<IBaseResource> resource = this.currentNode.getResource();
                if (resource.isPresent()) {
                    DependencyGraphBuilder.this.dependencyResourceVisitor.visit(resource.get(), this);
                    continue;
                }
                logger.warn("Unable to retrieve resource for URI {}, no dependencies determined", (Object)resourceURI);
            }
            return (IDependencyGraph)logger.exit((Object)new DependencyGraph(this.dependencyNodes.values(), this.dependencies));
        }

        @Override
        public void collect(String dependency, IDependency.Origin origin) throws DependencyException {
            this.collect(dependency, origin, null);
        }

        @Override
        public void collect(String dependency, IDependency.Origin origin, String fallback) throws DependencyException {
            logger.entry(new Object[]{dependency, origin, fallback});
            if (this.currentNode == null) {
                throw new IllegalStateException("Current node not set (implementation error)");
            }
            logger.debug("Adding dependency {} --> {} ({})", new Object[]{this.currentNode.getResourceURI(), dependency, origin});
            IDependencyNode dependencyNode = this.findOrCreateNode(dependency);
            Optional<IDependencyNode> fallbackNode = Strings.isNullOrEmpty((String)fallback) ? Optional.empty() : Optional.of(this.findOrCreateNode(fallback));
            this.dependencies.add(Dependency.builder().withDependent(this.currentNode).withDependency(dependencyNode).withOrigin(origin).withFallback(fallbackNode).build());
            logger.exit();
        }

        private IDependencyNode findOrCreateNode(String resourceURI) throws DependencyException {
            IDependencyNode dependencyNode;
            logger.entry(new Object[]{resourceURI});
            IResourceUtilities.ResourceURIContents uriContents = DependencyGraphBuilder.this.resourceUtilities.parseResourceURI(resourceURI);
            if (uriContents.uri().isEmpty()) {
                throw (DependencyException)logger.throwing((Throwable)new DependencyException(String.format("Resource URI %s cannot be parsed", resourceURI)));
            }
            URI uri = uriContents.uri().orElseThrow();
            if (this.dependencyNodes.containsKey(uri)) {
                dependencyNode = this.dependencyNodes.get(uri);
            } else {
                try {
                    Optional<IBaseResource> dependencyResource = DependencyGraphBuilder.this.packageRegistry.getUniqueResource(uri);
                    if (dependencyResource.isEmpty()) {
                        logger.warn("Unable to resolve resource {}", (Object)resourceURI);
                        dependencyNode = DependencyGraphBuilder.this.createNode(uri);
                    } else {
                        dependencyNode = DependencyGraphBuilder.this.createNode(dependencyResource.get());
                    }
                }
                catch (AmbiguousResourceURIException e) {
                    logger.warn("Unable to resolve resource {} unambiguously", (Object)resourceURI, (Object)e);
                    dependencyNode = DependencyGraphBuilder.this.createNode(uri);
                }
                logger.debug("Created node for resource {}", (Object)uri);
                this.dependencyNodes.put(uri, dependencyNode);
                if (dependencyNode.getFrameworkType().isEmpty()) {
                    this.remainingNodes.addLast(dependencyNode);
                }
            }
            return dependencyNode;
        }
    }
}

