/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir.dependencies;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import de.fhlintstone.fhir.dependencies.IDependency;
import de.fhlintstone.fhir.dependencies.IDependencyGraph;
import de.fhlintstone.fhir.dependencies.IDependencyNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public final class DependencyGraph
implements IDependencyGraph {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(DependencyGraph.class);
    private final ImmutableList<IDependencyNode> dependencyNodes;
    private final ImmutableList<IDependency> dependencies;
    private final Supplier<Multimap<URI, IDependencyNode>> indexByResourceURISupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        ListMultimap map = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IDependencyNode node : this.getNodes()) {
            map.put((Object)node.getResourceURI(), (Object)node);
        }
        return (Multimap)logger.exit((Object)map);
    });
    private final Supplier<ImmutableList<IDependencyNode>> orderedListSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        ArrayList<IDependencyNode> result = new ArrayList<IDependencyNode>();
        ArrayList<IDependencyNode> remainingNodes = new ArrayList<IDependencyNode>((Collection<IDependencyNode>)this.getNodes());
        ArrayList<IDependency> remainingDependencies = new ArrayList<IDependency>((Collection<IDependency>)this.getDependencies());
        while (!remainingNodes.isEmpty()) {
            Set dependentNodes = remainingDependencies.stream().map(IDependency::getDependent).collect(Collectors.toSet());
            HashSet<IDependencyNode> processedNodes = new HashSet<IDependencyNode>();
            for (IDependencyNode node : remainingNodes) {
                if (dependentNodes.contains(node)) continue;
                remainingDependencies.removeIf(dep -> dep.getDependency() == node);
                result.add(node);
                processedNodes.add(node);
            }
            remainingNodes.removeAll(processedNodes);
            if (!processedNodes.isEmpty()) continue;
            this.logUnresolvedDependencies(remainingNodes, remainingDependencies);
            throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException("Unable to resolve any more dependencies - is the dependency graph acyclic?"));
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    });
    private final LoadingCache<IDependencyNode, ImmutableList<IDependency>> nodeDependenciesCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IDependencyNode, ImmutableList<IDependency>>(){

        public ImmutableList<IDependency> load(IDependencyNode dependencyNode) throws Exception {
            return ImmutableList.copyOf(DependencyGraph.this.dependencies.stream().filter(d -> d.getDependent() == dependencyNode).toList());
        }
    });
    private final LoadingCache<IDependencyNode, ImmutableList<IDependency>> nodeDependentsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IDependencyNode, ImmutableList<IDependency>>(){

        public ImmutableList<IDependency> load(IDependencyNode dependencyNode) throws Exception {
            return ImmutableList.copyOf(DependencyGraph.this.dependencies.stream().filter(d -> d.getDependency() == dependencyNode).toList());
        }
    });
    private final LoadingCache<IDependencyNode, ImmutableSet<IDependency.Origin>> nodeDependentsOriginsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IDependencyNode, ImmutableSet<IDependency.Origin>>(){

        public ImmutableSet<IDependency.Origin> load(IDependencyNode dependencyNode) throws Exception {
            return ImmutableSet.copyOf((Collection)((ImmutableList)DependencyGraph.this.nodeDependentsCache.get((Object)dependencyNode)).stream().map(d -> d.getOrigin()).collect(Collectors.toSet()));
        }
    });

    DependencyGraph(Collection<IDependencyNode> dependencyNodes, Collection<IDependency> dependencies) {
        this.dependencyNodes = ImmutableList.copyOf(dependencyNodes);
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.checkConsistency();
    }

    @Override
    public ImmutableList<IDependencyNode> getNodes() {
        return this.dependencyNodes;
    }

    @Override
    public Optional<IDependencyNode> getNode(URI resourceURI) {
        logger.entry(new Object[]{resourceURI});
        Multimap index = (Multimap)this.indexByResourceURISupplier.get();
        if (index.containsKey((Object)resourceURI)) {
            Collection entries = index.get((Object)resourceURI);
            switch (entries.size()) {
                case 0: {
                    return (Optional)logger.exit(Optional.empty());
                }
                case 1: {
                    return (Optional)logger.exit(entries.stream().findAny());
                }
            }
            throw new IllegalStateException("Multiple dependencyNodes found for a single resource - something went wrong during the construction of the dependency graph");
        }
        return (Optional)logger.exit(Optional.empty());
    }

    @Override
    public ImmutableList<IDependency> getDependencies() {
        return this.dependencies;
    }

    private void checkConsistency() {
        for (IDependency dep : this.dependencies) {
            if (!this.dependencyNodes.contains((Object)dep.getDependency())) {
                throw new IllegalStateException(String.format("%s contains dependency node that is not in the node list", dep));
            }
            if (!this.dependencyNodes.contains((Object)dep.getDependent())) {
                throw new IllegalStateException(String.format("%s contains dependent node that is not in the node list", dep));
            }
            Optional<IDependencyNode> fallback = dep.getFallback();
            if (!fallback.isPresent() || this.dependencyNodes.contains((Object)fallback.get())) continue;
            throw new IllegalStateException(String.format("%s contains fallback node that is not in the node list", dep));
        }
    }

    private void logUnresolvedDependencies(ArrayList<IDependencyNode> remainingNodes, ArrayList<IDependency> remainingDependencies) {
        logger.entry(new Object[0]);
        logger.error("Unable to resolve any more dependencies - is the dependency graph acyclic?");
        logger.info("Remaining dependencyNodes:");
        int maxURILength = 0;
        for (IDependencyNode node : remainingNodes) {
            logger.info("  {}", (Object)node.getResourceURI());
            maxURILength = Math.max(maxURILength, node.getResourceURI().toString().length());
        }
        logger.info("Remaining dependencies:");
        remainingDependencies.sort((o1, o2) -> {
            int c1 = o1.getDependent().getResourceURI().compareTo(o2.getDependent().getResourceURI());
            if (c1 == 0) {
                return o1.getDependency().getResourceURI().compareTo(o2.getDependency().getResourceURI());
            }
            return c1;
        });
        for (IDependency dependency : remainingDependencies) {
            logger.info("  {} --> {}", (Object)this.padString(dependency.getDependent().getResourceURI().toString(), maxURILength), (Object)dependency.getDependency().getResourceURI().toString());
        }
        logger.exit();
    }

    @Override
    public ImmutableList<IDependencyNode> getOrderedNodeList() throws IllegalStateException {
        return (ImmutableList)this.orderedListSupplier.get();
    }

    @Override
    public ImmutableList<IDependency> getDependencies(IDependencyNode dependencyNode) {
        try {
            return (ImmutableList)this.nodeDependenciesCache.get((Object)dependencyNode);
        }
        catch (ExecutionException e) {
            logger.error("Error determining dependencies of {}", (Object)dependencyNode.getResourceURI(), (Object)e);
            return ImmutableList.of();
        }
    }

    @Override
    public ImmutableList<IDependency> getDependents(IDependencyNode dependencyNode) {
        try {
            return (ImmutableList)this.nodeDependentsCache.get((Object)dependencyNode);
        }
        catch (ExecutionException e) {
            logger.error("Error determining dependents of {}", (Object)dependencyNode.getResourceURI(), (Object)e);
            return ImmutableList.of();
        }
    }

    @Override
    public ImmutableSet<IDependency.Origin> getDependentOrigins(IDependencyNode dependencyNode) {
        try {
            return (ImmutableSet)this.nodeDependentsOriginsCache.get((Object)dependencyNode);
        }
        catch (ExecutionException e) {
            logger.error("Error determining origins of {}", (Object)dependencyNode.getResourceURI(), (Object)e);
            return ImmutableSet.of();
        }
    }

    private String padString(String input, int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%");
        stringBuilder.append(length);
        stringBuilder.append(".");
        stringBuilder.append(length);
        stringBuilder.append("s");
        return String.format(stringBuilder.toString(), input);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyGraph)) {
            return false;
        }
        DependencyGraph other = (DependencyGraph)o;
        ImmutableList<IDependencyNode> this$dependencyNodes = this.dependencyNodes;
        ImmutableList<IDependencyNode> other$dependencyNodes = other.dependencyNodes;
        if (this$dependencyNodes == null ? other$dependencyNodes != null : !this$dependencyNodes.equals(other$dependencyNodes)) {
            return false;
        }
        ImmutableList<IDependency> this$dependencies = this.getDependencies();
        ImmutableList<IDependency> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !this$dependencies.equals(other$dependencies));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ImmutableList<IDependencyNode> $dependencyNodes = this.dependencyNodes;
        result = result * 59 + ($dependencyNodes == null ? 43 : $dependencyNodes.hashCode());
        ImmutableList<IDependency> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : $dependencies.hashCode());
        return result;
    }
}

