/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.UnresolvableURIException;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IElementTypeRefComponentAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionDifferentialComponentAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionSnapshotComponentAccessor;
import de.fhlintstone.fhir.ClassAnnotation;
import de.fhlintstone.fhir.ExtensionType;
import de.fhlintstone.fhir.IStructureDefinitionIntrospector;
import de.fhlintstone.generator.GeneratorException;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.FhirResourceType;
import de.fhlintstone.packages.IPackageRegistry;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class StructureDefinitionIntrospector
implements IStructureDefinitionIntrospector {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(StructureDefinitionIntrospector.class);
    private final IAccessorProvider accessorProvider;
    private final IPackageRegistry packageRegistry;
    private final IFrameworkTypeLocator frameworkTypeLocator;
    private final LoadingCache<IStructureDefinitionAccessor, ExtensionType> extensionTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IStructureDefinitionAccessor, ExtensionType>(this){

        public ExtensionType load(IStructureDefinitionAccessor accessor) throws Exception {
            logger.entry(new Object[]{accessor});
            String url = accessor.getUrl().orElseThrow(() -> (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException("Unable to determine URL of StructureDefinition")));
            String type = accessor.getType().orElseThrow(() -> (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException("Unable to determine type of StructureDefinition")));
            if (type.equals("Extension")) {
                Optional<IStructureDefinitionSnapshotComponentAccessor> snapshot = accessor.getSnapshot();
                Optional<IStructureDefinitionDifferentialComponentAccessor> differential = accessor.getDifferential();
                if (snapshot.isPresent()) {
                    return (ExtensionType)((Object)logger.exit((Object)this.getExtensionTypeFromSnapshot(accessor)));
                }
                if (differential.isPresent()) {
                    return (ExtensionType)((Object)logger.exit((Object)this.getExtensionTypeFromDifferential(accessor)));
                }
                throw new IllegalArgumentException(String.format("StructureDefinition %s does not have snapshot or differential view", url));
            }
            return (ExtensionType)((Object)logger.exit((Object)ExtensionType.NONE));
        }

        private ExtensionType getExtensionTypeFromSnapshot(IStructureDefinitionAccessor accessor) {
            logger.entry(new Object[]{accessor});
            String url = accessor.getUrl().orElseThrow();
            ImmutableList<IElementDefinitionAccessor> elements = accessor.getSnapshot().orElseThrow().getElement();
            if (elements.isEmpty()) {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException(String.format("StructureDefinition %s has empty snapshot", url)));
            }
            IElementDefinitionAccessor extensionsElement = elements.stream().filter(e -> e.getId().orElseThrow().equals("Extension.extension")).findFirst().orElseThrow(() -> (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Extension.extension is missing in StructureDefinition %s", url))));
            IElementDefinitionAccessor valueElement = elements.stream().filter(e -> e.getId().orElseThrow().equals("Extension.value[x]")).findFirst().orElseThrow(() -> (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Extension.value[x] is missing in StructureDefinition %s", url))));
            String maxExtensions = extensionsElement.getMax().orElseThrow();
            String maxValues = valueElement.getMax().orElseThrow();
            return this.mapMaxValuesToExtensionType(url, maxExtensions, maxValues);
        }

        private ExtensionType getExtensionTypeFromDifferential(IStructureDefinitionAccessor accessor) {
            logger.entry(new Object[]{accessor});
            String url = accessor.getUrl().orElseThrow();
            ImmutableList<IElementDefinitionAccessor> elements = accessor.getDifferential().orElseThrow().getElement();
            if (elements.isEmpty()) {
                throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException(String.format("StructureDefinition %s has empty differential", url)));
            }
            Optional<IElementDefinitionAccessor> extensionsElement = elements.stream().filter(e -> e.getId().orElseThrow().equals("Extension.extension")).findFirst();
            String maxExtensions = extensionsElement.isPresent() ? extensionsElement.get().getMax().orElse("*") : "*";
            Optional<IElementDefinitionAccessor> valueElement = elements.stream().filter(e -> e.getId().orElseThrow().equals("Extension.value[x]")).findFirst();
            String maxValues = valueElement.isPresent() ? valueElement.get().getMax().orElse("1") : "1";
            return this.mapMaxValuesToExtensionType(url, maxExtensions, maxValues);
        }

        private ExtensionType mapMaxValuesToExtensionType(String url, String maxExtensions, String maxValues) {
            if (!maxValues.equals("0") && maxExtensions.equals("0")) {
                return (ExtensionType)((Object)logger.exit((Object)ExtensionType.SIMPLE));
            }
            if (maxValues.equals("0") && !maxExtensions.equals("0")) {
                return (ExtensionType)((Object)logger.exit((Object)ExtensionType.COMPLEX));
            }
            throw (IllegalStateException)logger.throwing((Throwable)new IllegalStateException(String.format("Unable to determine whether extension %s is simple or complex", url)));
        }
    });

    @Inject
    public StructureDefinitionIntrospector(IAccessorProvider accessorProvider, IPackageRegistry packageRegistry, IFrameworkTypeLocator frameworkTypeLocator) {
        this.accessorProvider = accessorProvider;
        this.packageRegistry = packageRegistry;
        this.frameworkTypeLocator = frameworkTypeLocator;
    }

    @Override
    public ExtensionType getExtensionType(IStructureDefinitionAccessor accessor) throws GeneratorException {
        try {
            return (ExtensionType)((Object)this.extensionTypeCache.get((Object)accessor));
        }
        catch (ExecutionException e) {
            throw new GeneratorException(String.format("Unable to determine extension type of StructureDefinition %s", accessor.getName().orElseThrow()), e);
        }
    }

    @Override
    public Optional<ClassAnnotation> getClassAnnotationForFrameworkType(TypeName frameworkType) {
        logger.entry(new Object[]{frameworkType});
        Optional<Object> classAnnotation = Optional.empty();
        if (frameworkType instanceof ClassName) {
            ClassName frameworkClass = (ClassName)frameworkType;
            String frameworkClassName = frameworkClass.reflectionName();
            try {
                Class<?> theClass = Class.forName(frameworkClassName);
                if (theClass.getAnnotation(ResourceDef.class) != null) {
                    classAnnotation = Optional.of(ClassAnnotation.RESOURCE);
                } else if (theClass.getAnnotation(DatatypeDef.class) != null) {
                    classAnnotation = Optional.of(ClassAnnotation.DATATYPE);
                } else if (theClass.getAnnotation(Block.class) != null) {
                    classAnnotation = Optional.of(ClassAnnotation.BLOCK);
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Unable to load framework class {}, assuming no annotation present", (Object)frameworkClassName, (Object)e);
            }
        } else {
            logger.warn("Unable to handle framework type {}, assuming no annotation present", (Object)frameworkType);
        }
        return (Optional)logger.exit(classAnnotation);
    }

    @Override
    public Optional<ClassAnnotation> getClassAnnotation(IStructureDefinitionAccessor structureDefinition) throws GeneratorException {
        logger.entry(new Object[]{structureDefinition});
        switch (this.getExtensionType(structureDefinition)) {
            case COMPLEX: {
                return (Optional)logger.exit(Optional.of(ClassAnnotation.BLOCK));
            }
            case SIMPLE: {
                return (Optional)logger.exit(Optional.empty());
            }
        }
        Optional result = this.seachBaseStructureHierarchy(structureDefinition, sd -> {
            URI uri = URI.create(sd.getUrl().orElseThrow());
            Optional<TypeName> frameworkType = this.frameworkTypeLocator.determineType(uri);
            if (frameworkType.isPresent()) {
                if (frameworkType.get().equals((Object)this.frameworkTypeLocator.getBackboneElementType())) {
                    return Optional.of(ClassAnnotation.BLOCK);
                }
                return this.getClassAnnotationForFrameworkType(frameworkType.get());
            }
            return Optional.empty();
        });
        return (Optional)logger.exit(result);
    }

    @Override
    public boolean isDerivedFromPrimitiveType(IElementDefinitionAccessor elementDefinition) throws GeneratorException {
        logger.entry(new Object[]{elementDefinition});
        Set typeCodes = elementDefinition.getType().stream().map(IElementTypeRefComponentAccessor::getCode).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        switch (typeCodes.size()) {
            case 0: {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Element %s does not have a type code assigned", elementDefinition.getId().orElse("(no ID)"))));
            }
            case 1: {
                String typeCode = (String)typeCodes.iterator().next();
                try {
                    URI typeReference = this.frameworkTypeLocator.makeAbsoluteStructureDefinitionReference(typeCode);
                    Optional<TypeName> frameworkType = this.frameworkTypeLocator.determineType(typeReference);
                    if (frameworkType.isPresent()) {
                        return (Boolean)logger.exit((Object)this.frameworkTypeLocator.isDerivedFromPrimitiveType(frameworkType.get()));
                    }
                    IStructureDefinitionAccessor structureDefinition = this.accessorProvider.provideStructureDefinitionAccessor(typeReference);
                    Optional<Boolean> result = this.seachBaseStructureHierarchy(structureDefinition, sd -> {
                        URI uri = URI.create(sd.getUrl().orElseThrow());
                        Optional<TypeName> type = this.frameworkTypeLocator.determineType(uri);
                        return type.isPresent() ? Optional.of(this.frameworkTypeLocator.isDerivedFromPrimitiveType(type.get())) : Optional.empty();
                    });
                    return result.orElse(false);
                }
                catch (UnresolvableURIException | URISyntaxException e) {
                    throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Unable to resolve type reference %s of element %s", typeCode, elementDefinition.getId().orElse("(no ID)")), e));
                }
            }
        }
        return (Boolean)logger.exit((Object)false);
    }

    private <T> Optional<T> seachBaseStructureHierarchy(IStructureDefinitionAccessor structureDefinition, Function<IStructureDefinitionAccessor, Optional<T>> operation) throws GeneratorException {
        logger.entry(new Object[]{structureDefinition});
        Optional<IStructureDefinitionAccessor> currentStructureDefinition = Optional.of(structureDefinition);
        while (currentStructureDefinition.isPresent()) {
            String structureName = currentStructureDefinition.get().getName().orElse("(no name)");
            logger.debug("Checking StructureDefinition {}", (Object)structureName);
            Optional<T> result = operation.apply(currentStructureDefinition.get());
            if (result.isPresent()) {
                return (Optional)logger.exit(result);
            }
            Optional<String> baseDefinition = currentStructureDefinition.get().getBaseDefinition();
            if (baseDefinition.isEmpty()) {
                logger.debug("StructureDefinition {} does not have a baseDefinition", (Object)structureName);
                return (Optional)logger.exit(Optional.empty());
            }
            try {
                URI baseDefinitionURI = URI.create(baseDefinition.get());
                Optional<IBaseResource> baseResource = this.packageRegistry.getUniqueResource(FhirResourceType.STRUCTURE_DEFINITION, baseDefinitionURI);
                if (baseResource.isPresent()) {
                    IStructureDefinitionAccessor baseAccessor = this.accessorProvider.provideStructureDefinitionAccessor(baseResource.get());
                    currentStructureDefinition = Optional.of(baseAccessor);
                    continue;
                }
                logger.warn("baseDefinition {} of StructureDefinition {} cannot be resolved", (Object)baseDefinitionURI, (Object)structureName);
                currentStructureDefinition = Optional.empty();
            }
            catch (AmbiguousResourceURIException e) {
                throw (GeneratorException)logger.throwing((Throwable)new GeneratorException(String.format("Ambiguous resource encountered when resolving bases of StructureDefinition %s", structureName), e));
            }
        }
        return (Optional)logger.exit(Optional.empty());
    }
}

