/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Strings;
import de.fhlintstone.accessors.UnsupportedFHIRVersionException;
import de.fhlintstone.fhir.IResourceUtilities;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.MetadataResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class ResourceUtilities
implements IResourceUtilities {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(ResourceUtilities.class);

    @Override
    public IResourceUtilities.ResourceURIContents readResourceURI(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        Optional<String> resourceURL = this.readResourceURL(resource);
        if (resourceURL.isPresent()) {
            return (IResourceUtilities.ResourceURIContents)logger.exit((Object)this.parseResourceURI(resourceURL.get()));
        }
        return (IResourceUtilities.ResourceURIContents)logger.exit((Object)new IResourceUtilities.ResourceURIContents(Optional.empty(), Optional.empty()));
    }

    @Override
    public Optional<String> readResourceURL(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        String uriString = "";
        FhirVersionEnum fhirVersion = resource.getStructureFhirVersionEnum();
        if (fhirVersion == null) {
            throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException("No FHIR version reported for resource"));
        }
        switch (fhirVersion) {
            case R4: {
                if (!(resource instanceof MetadataResource)) break;
                MetadataResource metadataResource = (MetadataResource)resource;
                uriString = metadataResource.getUrl();
                break;
            }
            case R4B: {
                if (!(resource instanceof org.hl7.fhir.r4b.model.MetadataResource)) break;
                org.hl7.fhir.r4b.model.MetadataResource metadataResource = (org.hl7.fhir.r4b.model.MetadataResource)resource;
                uriString = metadataResource.getUrl();
                break;
            }
            case R5: {
                if (!(resource instanceof org.hl7.fhir.r5.model.MetadataResource)) break;
                org.hl7.fhir.r5.model.MetadataResource metadataResource = (org.hl7.fhir.r5.model.MetadataResource)resource;
                uriString = metadataResource.getUrl();
                break;
            }
            default: {
                throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
            }
        }
        if (Strings.isNullOrEmpty((String)uriString)) {
            return (Optional)logger.exit(Optional.empty());
        }
        return (Optional)logger.exit(Optional.of(uriString));
    }

    @Override
    public IResourceUtilities.ResourceURIContents parseResourceURI(String resourceURL) {
        logger.entry(new Object[]{resourceURL});
        Optional<URI> resultURI = Optional.empty();
        Optional<String> resultVersion = Optional.empty();
        String uriString = resourceURL;
        int pipeIndex = uriString.indexOf("|");
        if (pipeIndex >= 0) {
            resultVersion = Optional.of(uriString.substring(pipeIndex + 1));
            uriString = uriString.substring(0, pipeIndex);
        }
        if (!uriString.isEmpty()) {
            try {
                URI uri = new URI(uriString);
                resultURI = Optional.of(uri);
            }
            catch (URISyntaxException e) {
                throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Malformed resource URI: %s", uriString), e));
            }
        }
        return (IResourceUtilities.ResourceURIContents)logger.exit((Object)new IResourceUtilities.ResourceURIContents(resultURI, resultVersion));
    }

    @Override
    public URI determineURIFromTypeCode(String typeCode) {
        logger.entry(new Object[]{typeCode});
        Object url = "";
        if (typeCode.startsWith("http://hl7.org/fhirpath/")) {
            switch (typeCode) {
                case "http://hl7.org/fhirpath/System.Boolean": {
                    url = "http://hl7.org/fhir/StructureDefinition/boolean";
                    break;
                }
                case "http://hl7.org/fhirpath/System.String": {
                    url = "http://hl7.org/fhir/StructureDefinition/string";
                    break;
                }
                case "http://hl7.org/fhirpath/System.Integer": {
                    url = "http://hl7.org/fhir/StructureDefinition/integer";
                    break;
                }
                case "http://hl7.org/fhirpath/System.Long": {
                    url = "http://hl7.org/fhir/StructureDefinition/integer64";
                    break;
                }
                case "http://hl7.org/fhirpath/System.Decimal": {
                    url = "http://hl7.org/fhir/StructureDefinition/decimal";
                    break;
                }
                case "http://hl7.org/fhirpath/System.DateTime": {
                    url = "http://hl7.org/fhir/StructureDefinition/dateTime";
                    break;
                }
                case "http://hl7.org/fhirpath/System.Time": {
                    url = "http://hl7.org/fhir/StructureDefinition/time";
                    break;
                }
                case "http://hl7.org/fhirpath/System.Quantity": {
                    url = "http://hl7.org/fhir/StructureDefinition/Quantity";
                    break;
                }
                default: {
                    throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Unknown FHIRpath type %s", typeCode)));
                }
            }
        } else {
            url = !typeCode.startsWith("http") ? "http://hl7.org/fhir/StructureDefinition/" + typeCode : typeCode;
        }
        URI result = URI.create((String)url);
        return (URI)logger.exit((Object)result);
    }
}

