/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.fhir;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.model.IConceptDefinitionComponentAccessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public final class FhirUtilities {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(FhirUtilities.class);

    private FhirUtilities() {
    }

    public static ImmutableList<IConceptDefinitionComponentAccessor> flattenConceptHierarchy(List<IConceptDefinitionComponentAccessor> concepts) {
        logger.entry(new Object[]{concepts});
        ArrayList<IConceptDefinitionComponentAccessor> result = new ArrayList<IConceptDefinitionComponentAccessor>();
        ArrayDeque<IConceptDefinitionComponentAccessor> queue = new ArrayDeque<IConceptDefinitionComponentAccessor>(concepts);
        while (!queue.isEmpty()) {
            IConceptDefinitionComponentAccessor current = queue.pop();
            result.add(current);
            queue.addAll((Collection<IConceptDefinitionComponentAccessor>)current.getChildConcept());
        }
        return (ImmutableList)logger.exit((Object)ImmutableList.copyOf(result));
    }

    public static Optional<String> getParentId(String elementId) {
        logger.entry(new Object[]{elementId});
        int childIndex = elementId.lastIndexOf(".");
        int sliceIndex = elementId.lastIndexOf(":");
        int lastElementIndex = Math.max(childIndex, sliceIndex);
        if (lastElementIndex <= 0) {
            return (Optional)logger.exit(Optional.empty());
        }
        return (Optional)logger.exit(Optional.of(elementId.substring(0, lastElementIndex)));
    }
}

