/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.CanonicalResourceAccessorR4B;
import de.fhlintstone.accessors.model.IExtensionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionDifferentialComponentAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionSnapshotComponentAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r4b.model.CanonicalResource;
import org.hl7.fhir.r4b.model.StructureDefinition;

public final class StructureDefinitionAccessorR4B
extends CanonicalResourceAccessorR4B
implements IStructureDefinitionAccessor {
    private final StructureDefinition structureDefinition;

    public StructureDefinitionAccessorR4B(IAccessorCache cache, StructureDefinition structureDefinition) {
        super(cache, (CanonicalResource)structureDefinition);
        this.structureDefinition = structureDefinition;
    }

    @Override
    public Optional<String> getName() {
        if (this.structureDefinition.hasName()) {
            return Optional.of(this.structureDefinition.getName());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getUrl() {
        if (this.structureDefinition.hasUrl()) {
            return Optional.of(this.structureDefinition.getUrl());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getDescription() {
        if (this.structureDefinition.hasDescription()) {
            return Optional.of(this.structureDefinition.getDescription());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getType() {
        if (this.structureDefinition.hasType()) {
            return Optional.of(this.structureDefinition.getType());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getBaseDefinition() {
        if (this.structureDefinition.hasBaseDefinition()) {
            return Optional.of(this.structureDefinition.getBaseDefinition());
        }
        return Optional.empty();
    }

    @Override
    public Optional<IStructureDefinitionSnapshotComponentAccessor> getSnapshot() {
        if (this.structureDefinition.hasSnapshot()) {
            return Optional.of(this.getCache().getAccessor(this.structureDefinition.getSnapshot(), IStructureDefinitionSnapshotComponentAccessor.class));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IStructureDefinitionDifferentialComponentAccessor> getDifferential() {
        if (this.structureDefinition.hasDifferential()) {
            return Optional.of(this.getCache().getAccessor(this.structureDefinition.getDifferential(), IStructureDefinitionDifferentialComponentAccessor.class));
        }
        return Optional.empty();
    }

    @Override
    public ImmutableList<IExtensionAccessor> getExtensions() {
        return (ImmutableList)this.structureDefinition.getExtension().stream().map(component -> this.getCache().getAccessor(component, IExtensionAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<IExtensionAccessor> getModifierExtensions() {
        return (ImmutableList)this.structureDefinition.getModifierExtension().stream().map(component -> this.getCache().getAccessor(component, IExtensionAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructureDefinitionAccessorR4B)) {
            return false;
        }
        StructureDefinitionAccessorR4B other = (StructureDefinitionAccessorR4B)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StructureDefinition this$structureDefinition = this.getStructureDefinition();
        StructureDefinition other$structureDefinition = other.getStructureDefinition();
        return !(this$structureDefinition == null ? other$structureDefinition != null : !this$structureDefinition.equals(other$structureDefinition));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StructureDefinitionAccessorR4B;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        StructureDefinition $structureDefinition = this.getStructureDefinition();
        result = result * 59 + ($structureDefinition == null ? 43 : $structureDefinition.hashCode());
        return result;
    }

    @Generated
    private StructureDefinition getStructureDefinition() {
        return this.structureDefinition;
    }
}

