/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.UnsupportedTypeException;
import de.fhlintstone.accessors.model.IPrimitiveTypeAccessor;
import de.fhlintstone.accessors.model.PrimitiveDatatype;
import de.fhlintstone.accessors.model.StringifiedValue;
import de.fhlintstone.accessors.model.TypeAccessorR5;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r5.model.Base64BinaryType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.InstantType;
import org.hl7.fhir.r5.model.Integer64Type;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.OidType;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.UnsignedIntType;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UuidType;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public class PrimitiveTypeAccessorR5<T>
extends TypeAccessorR5
implements IPrimitiveTypeAccessor {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(PrimitiveTypeAccessorR5.class);
    private final PrimitiveType<T> primitiveType;

    public PrimitiveTypeAccessorR5(IAccessorCache cache, PrimitiveType<T> type) {
        super(cache, (DataType)type);
        this.primitiveType = type;
    }

    @Override
    public boolean isType(PrimitiveDatatype checkType) {
        logger.entry(new Object[]{checkType});
        return (Boolean)logger.exit((Object)(switch (checkType) {
            case PrimitiveDatatype.BASE64BINARY -> this.primitiveType instanceof Base64BinaryType;
            case PrimitiveDatatype.BOOLEAN -> this.primitiveType instanceof BooleanType;
            case PrimitiveDatatype.CANONICAL -> this.primitiveType instanceof CanonicalType;
            case PrimitiveDatatype.CODE -> this.primitiveType instanceof CodeType;
            case PrimitiveDatatype.DATE -> this.primitiveType instanceof DateType;
            case PrimitiveDatatype.DATETIME -> this.primitiveType instanceof DateTimeType;
            case PrimitiveDatatype.DECIMAL -> this.primitiveType instanceof DecimalType;
            case PrimitiveDatatype.ID -> this.primitiveType instanceof IdType;
            case PrimitiveDatatype.INSTANT -> this.primitiveType instanceof InstantType;
            case PrimitiveDatatype.INTEGER64 -> this.primitiveType instanceof Integer64Type;
            case PrimitiveDatatype.INTEGER -> this.primitiveType instanceof IntegerType;
            case PrimitiveDatatype.MARKDOWN -> this.primitiveType instanceof MarkdownType;
            case PrimitiveDatatype.OID -> this.primitiveType instanceof OidType;
            case PrimitiveDatatype.POSITIVEINT -> this.primitiveType instanceof PositiveIntType;
            case PrimitiveDatatype.STRING -> this.primitiveType instanceof StringType;
            case PrimitiveDatatype.TIME -> this.primitiveType instanceof TimeType;
            case PrimitiveDatatype.UNSIGNEDINT -> this.primitiveType instanceof UnsignedIntType;
            case PrimitiveDatatype.URI -> this.primitiveType instanceof UriType;
            case PrimitiveDatatype.URL -> this.primitiveType instanceof UrlType;
            case PrimitiveDatatype.UUID -> this.primitiveType instanceof UuidType;
            default -> throw new IllegalArgumentException(String.format("Type %s is currently not supported.", new Object[]{checkType}));
        }));
    }

    @Override
    public Optional<StringifiedValue> getStringifiedValue() throws UnsupportedTypeException {
        logger.entry(new Object[0]);
        if (this.primitiveType.isEmpty()) {
            return (Optional)logger.exit(Optional.empty());
        }
        StringifiedValue.StringifiedValueBuilder value = StringifiedValue.builder().withSetterMethod("setValue");
        PrimitiveType<T> primitiveType = this.primitiveType;
        Objects.requireNonNull(primitiveType);
        PrimitiveType<T> primitiveType2 = primitiveType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanType.class, CanonicalType.class, CodeType.class, DecimalType.class, IdType.class, MarkdownType.class, OidType.class, PositiveIntType.class, UnsignedIntType.class, UrlType.class, UuidType.class, StringType.class, Integer64Type.class, IntegerType.class, UriType.class}, primitiveType2, n)) {
            case 0: {
                BooleanType booleanType = (BooleanType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.BOOLEAN).withValue(((Boolean)booleanType.getValue()).toString()).withLiteral(true);
                break;
            }
            case 1: {
                CanonicalType canonicalType = (CanonicalType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.CANONICAL).withValue((String)canonicalType.getValue()).withLiteral(false);
                break;
            }
            case 2: {
                CodeType codeType = (CodeType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.CODE).withValue((String)codeType.getValue()).withLiteral(false);
                break;
            }
            case 3: {
                DecimalType decimalType = (DecimalType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.DECIMAL).withValue(((BigDecimal)decimalType.getValue()).toString()).withLiteral(true);
                break;
            }
            case 4: {
                IdType idType = (IdType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.ID).withValue(idType.getValue()).withLiteral(false);
                break;
            }
            case 5: {
                MarkdownType markdownType = (MarkdownType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.MARKDOWN).withValue((String)markdownType.getValue()).withLiteral(false);
                break;
            }
            case 6: {
                OidType oidType = (OidType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.OID).withValue((String)oidType.getValue()).withLiteral(false);
                break;
            }
            case 7: {
                PositiveIntType positiveIntType = (PositiveIntType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.POSITIVEINT).withValue(((Integer)positiveIntType.getValue()).toString()).withLiteral(true);
                break;
            }
            case 8: {
                UnsignedIntType unsignedIntType = (UnsignedIntType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.UNSIGNEDINT).withValue(((Integer)unsignedIntType.getValue()).toString()).withLiteral(true);
                break;
            }
            case 9: {
                UrlType urlType = (UrlType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.URL).withValue((String)urlType.getValue()).withLiteral(false);
                break;
            }
            case 10: {
                UuidType uuidType = (UuidType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.UUID).withValue((String)uuidType.getValue()).withLiteral(false);
                break;
            }
            case 11: {
                StringType stringType = (StringType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.STRING).withValue((String)stringType.getValue()).withLiteral(false);
                break;
            }
            case 12: {
                Integer64Type integer64Type = (Integer64Type)primitiveType2;
                value.withDatatype(PrimitiveDatatype.INTEGER64).withValue(((Long)integer64Type.getValue()).toString()).withLiteral(true);
                break;
            }
            case 13: {
                IntegerType integerType = (IntegerType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.INTEGER).withValue(((Integer)integerType.getValue()).toString()).withLiteral(true);
                break;
            }
            case 14: {
                UriType uriType = (UriType)primitiveType2;
                value.withDatatype(PrimitiveDatatype.URI).withValue((String)uriType.getValue()).withLiteral(false);
                break;
            }
            default: {
                throw (UnsupportedTypeException)logger.throwing((Throwable)UnsupportedTypeException.forStringConversion(this.primitiveType));
            }
        }
        return Optional.ofNullable(value.build());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrimitiveTypeAccessorR5)) {
            return false;
        }
        PrimitiveTypeAccessorR5 other = (PrimitiveTypeAccessorR5)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PrimitiveType<T> this$primitiveType = this.primitiveType;
        PrimitiveType<T> other$primitiveType = other.primitiveType;
        return !(this$primitiveType == null ? other$primitiveType != null : !this$primitiveType.equals(other$primitiveType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PrimitiveTypeAccessorR5;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        PrimitiveType<T> $primitiveType = this.primitiveType;
        result = result * 59 + ($primitiveType == null ? 43 : $primitiveType.hashCode());
        return result;
    }
}

