/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

public enum FilterOperator {
    EQUAL,
    ISA,
    DESCENDENTOF,
    ISNOTA,
    REGEX,
    IN,
    NOTIN,
    GENERALIZES,
    CHILDOF,
    DESCENDENTLEAF,
    EXISTS;


    public static FilterOperator fromString(String value) {
        return switch (value) {
            case "=" -> EQUAL;
            case "is-a" -> ISA;
            case "descendent-of" -> DESCENDENTOF;
            case "is-not-a" -> ISNOTA;
            case "regex" -> REGEX;
            case "in" -> IN;
            case "not-in" -> NOTIN;
            case "generalizes" -> GENERALIZES;
            case "child-of" -> CHILDOF;
            case "descendent-leaf" -> DESCENDENTLEAF;
            case "exists" -> EXISTS;
            default -> throw new IllegalArgumentException(String.format("Unknown FilterOperator %s", value));
        };
    }

    public String toString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "equal";
            case 1 -> "is-a";
            case 2 -> "descendent-of";
            case 3 -> "is-not-a";
            case 4 -> "regex";
            case 5 -> "in";
            case 6 -> "not-in";
            case 7 -> "generalizes";
            case 10 -> "child-of";
            case 8 -> "descendent-leaf";
            case 9 -> "exists";
        };
    }
}

