/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.BindingStrength;
import de.fhlintstone.accessors.model.ElementAccessorR4B;
import de.fhlintstone.accessors.model.IElementDefinitionBindingComponentAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r4b.model.Element;
import org.hl7.fhir.r4b.model.ElementDefinition;
import org.hl7.fhir.r4b.model.Enumerations;

public final class ElementDefinitionBindingComponentAccessorR4B
extends ElementAccessorR4B
implements IElementDefinitionBindingComponentAccessor {
    private final ElementDefinition.ElementDefinitionBindingComponent bindingComponent;

    public ElementDefinitionBindingComponentAccessorR4B(IAccessorCache cache, ElementDefinition.ElementDefinitionBindingComponent bindingComponent) {
        super(cache, (Element)bindingComponent);
        this.bindingComponent = bindingComponent;
    }

    @Override
    public Optional<Boolean> isRequired() {
        if (this.bindingComponent.hasStrength()) {
            return Optional.of(this.bindingComponent.getStrength() == Enumerations.BindingStrength.REQUIRED);
        }
        return Optional.empty();
    }

    @Override
    public Optional<BindingStrength> getStrength() {
        if (this.bindingComponent.hasStrength()) {
            switch (this.bindingComponent.getStrength()) {
                case EXAMPLE: {
                    return Optional.of(BindingStrength.EXAMPLE);
                }
                case EXTENSIBLE: {
                    return Optional.of(BindingStrength.EXTENSIBLE);
                }
                case PREFERRED: {
                    return Optional.of(BindingStrength.PREFERRED);
                }
                case REQUIRED: {
                    return Optional.of(BindingStrength.REQUIRED);
                }
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getValueSet() {
        if (this.bindingComponent.hasValueSet()) {
            return Optional.of(this.bindingComponent.getValueSet());
        }
        return Optional.empty();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementDefinitionBindingComponentAccessorR4B)) {
            return false;
        }
        ElementDefinitionBindingComponentAccessorR4B other = (ElementDefinitionBindingComponentAccessorR4B)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElementDefinition.ElementDefinitionBindingComponent this$bindingComponent = this.bindingComponent;
        ElementDefinition.ElementDefinitionBindingComponent other$bindingComponent = other.bindingComponent;
        return !(this$bindingComponent == null ? other$bindingComponent != null : !this$bindingComponent.equals(other$bindingComponent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElementDefinitionBindingComponentAccessorR4B;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ElementDefinition.ElementDefinitionBindingComponent $bindingComponent = this.bindingComponent;
        result = result * 59 + ($bindingComponent == null ? 43 : $bindingComponent.hashCode());
        return result;
    }
}

