/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.BackboneTypeAccessorR5;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IElementDefinitionBindingComponentAccessor;
import de.fhlintstone.accessors.model.IElementTypeRefComponentAccessor;
import de.fhlintstone.accessors.model.ITypeAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r5.model.BackboneType;
import org.hl7.fhir.r5.model.ElementDefinition;

public final class ElementDefinitionAccessorR5
extends BackboneTypeAccessorR5
implements IElementDefinitionAccessor {
    private final ElementDefinition elementDefinition;

    public ElementDefinitionAccessorR5(IAccessorCache cache, ElementDefinition elementDefinition) {
        super(cache, (BackboneType)elementDefinition);
        this.elementDefinition = elementDefinition;
    }

    @Override
    public Optional<String> getId() {
        if (this.elementDefinition.hasId()) {
            return Optional.of(this.elementDefinition.getId());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getPath() {
        if (this.elementDefinition.hasPath()) {
            return Optional.of(this.elementDefinition.getPath());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getMin() {
        if (this.elementDefinition.hasMin()) {
            return Optional.of(this.elementDefinition.getMin());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getMax() {
        if (this.elementDefinition.hasMax()) {
            return Optional.of(this.elementDefinition.getMax());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getDefinition() {
        if (this.elementDefinition.hasDefinition()) {
            return Optional.of(this.elementDefinition.getDefinition());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getShort() {
        if (this.elementDefinition.hasShort()) {
            return Optional.of(this.elementDefinition.getShort());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ITypeAccessor> getFixed() {
        if (this.elementDefinition.hasFixed()) {
            return Optional.of(this.getCache().getAccessor(this.elementDefinition.getFixed(), ITypeAccessor.class));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ITypeAccessor> getPattern() {
        if (this.elementDefinition.hasPattern()) {
            return Optional.of(this.getCache().getAccessor(this.elementDefinition.getPattern(), ITypeAccessor.class));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IElementDefinitionBindingComponentAccessor> getBinding() {
        if (this.elementDefinition.hasBinding()) {
            return Optional.of(this.getCache().getAccessor(this.elementDefinition.getBinding(), IElementDefinitionBindingComponentAccessor.class));
        }
        return Optional.empty();
    }

    @Override
    public ImmutableList<IElementTypeRefComponentAccessor> getType() {
        return (ImmutableList)this.elementDefinition.getType().stream().map(component -> this.getCache().getAccessor(component, IElementTypeRefComponentAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElementDefinitionAccessorR5)) {
            return false;
        }
        ElementDefinitionAccessorR5 other = (ElementDefinitionAccessorR5)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ElementDefinition this$elementDefinition = this.getElementDefinition();
        ElementDefinition other$elementDefinition = other.getElementDefinition();
        return !(this$elementDefinition == null ? other$elementDefinition != null : !this$elementDefinition.equals(other$elementDefinition));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ElementDefinitionAccessorR5;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ElementDefinition $elementDefinition = this.getElementDefinition();
        result = result * 59 + ($elementDefinition == null ? 43 : $elementDefinition.hashCode());
        return result;
    }

    @Generated
    private ElementDefinition getElementDefinition() {
        return this.elementDefinition;
    }
}

