/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.BackboneElementAccessorR4B;
import de.fhlintstone.accessors.model.ICanonicalTypeAccessor;
import de.fhlintstone.accessors.model.IConceptReferenceComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetComponentAccessor;
import de.fhlintstone.accessors.model.IConceptSetFilterComponentAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r4b.model.BackboneElement;
import org.hl7.fhir.r4b.model.ValueSet;

public final class ConceptSetComponentAccessorR4B
extends BackboneElementAccessorR4B
implements IConceptSetComponentAccessor {
    private final ValueSet.ConceptSetComponent component;

    public ConceptSetComponentAccessorR4B(IAccessorCache cache, ValueSet.ConceptSetComponent component) {
        super(cache, (BackboneElement)component);
        this.component = component;
    }

    @Override
    public ImmutableList<IConceptReferenceComponentAccessor> getConcept() {
        return (ImmutableList)this.component.getConcept().stream().map(concept -> this.getCache().getAccessor(concept, IConceptReferenceComponentAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<IConceptSetFilterComponentAccessor> getFilter() {
        return (ImmutableList)this.component.getFilter().stream().map(filter -> this.getCache().getAccessor(filter, IConceptSetFilterComponentAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public ImmutableList<ICanonicalTypeAccessor> getValueSet() {
        return (ImmutableList)this.component.getValueSet().stream().map(filter -> this.getCache().getAccessor(filter, ICanonicalTypeAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<String> getSystem() {
        if (this.component.hasSystem()) {
            return Optional.of(this.component.getSystem());
        }
        return Optional.empty();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConceptSetComponentAccessorR4B)) {
            return false;
        }
        ConceptSetComponentAccessorR4B other = (ConceptSetComponentAccessorR4B)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValueSet.ConceptSetComponent this$component = this.getComponent();
        ValueSet.ConceptSetComponent other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !this$component.equals(other$component));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConceptSetComponentAccessorR4B;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ValueSet.ConceptSetComponent $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        return result;
    }

    @Generated
    private ValueSet.ConceptSetComponent getComponent() {
        return this.component;
    }
}

