/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.CanonicalResourceAccessorR5;
import de.fhlintstone.accessors.model.ICodeSystemAccessor;
import de.fhlintstone.accessors.model.IConceptDefinitionComponentAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;

public final class CodeSystemAccessorR5
extends CanonicalResourceAccessorR5
implements ICodeSystemAccessor {
    private final CodeSystem codeSystem;

    public CodeSystemAccessorR5(IAccessorCache cache, CodeSystem codeSystem) {
        super(cache, (CanonicalResource)codeSystem);
        this.codeSystem = codeSystem;
    }

    @Override
    public Optional<String> getName() {
        if (this.codeSystem.hasName()) {
            return Optional.of(this.codeSystem.getName());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getUrl() {
        if (this.codeSystem.hasUrl()) {
            return Optional.of(this.codeSystem.getUrl());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getDescription() {
        if (this.codeSystem.hasDescription()) {
            return Optional.of(this.codeSystem.getDescription());
        }
        return Optional.empty();
    }

    @Override
    public ImmutableList<IConceptDefinitionComponentAccessor> getConcept() {
        return (ImmutableList)this.codeSystem.getConcept().stream().map(component -> this.getCache().getAccessor(component, IConceptDefinitionComponentAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeSystemAccessorR5)) {
            return false;
        }
        CodeSystemAccessorR5 other = (CodeSystemAccessorR5)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CodeSystem this$codeSystem = this.getCodeSystem();
        CodeSystem other$codeSystem = other.getCodeSystem();
        return !(this$codeSystem == null ? other$codeSystem != null : !this$codeSystem.equals(other$codeSystem));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CodeSystemAccessorR5;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CodeSystem $codeSystem = this.getCodeSystem();
        result = result * 59 + ($codeSystem == null ? 43 : $codeSystem.hashCode());
        return result;
    }

    @Generated
    private CodeSystem getCodeSystem() {
        return this.codeSystem;
    }
}

