/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.model;

import com.google.common.collect.ImmutableList;
import de.fhlintstone.accessors.Accessor;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.model.IBaseAccessor;
import de.fhlintstone.accessors.model.IPropertyAccessor;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.r4b.model.Base;
import org.hl7.fhir.r4b.model.Property;

public class BaseAccessorR4B
extends Accessor
implements IBaseAccessor {
    private final Base base;

    public BaseAccessorR4B(IAccessorCache cache, Base base) {
        super(cache);
        this.base = base;
    }

    public String toString() {
        return this.base.toString();
    }

    @Override
    public ImmutableList<IPropertyAccessor> children() {
        return (ImmutableList)this.base.children().stream().map(child -> this.getCache().getAccessor(child, IPropertyAccessor.class)).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Optional<IPropertyAccessor> getChildByName(String name) {
        Property child = this.base.getChildByName(name);
        return child == null ? Optional.empty() : Optional.of(this.getCache().getAccessor(child, IPropertyAccessor.class));
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseAccessorR4B)) {
            return false;
        }
        BaseAccessorR4B other = (BaseAccessorR4B)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Base this$base = this.getBase();
        Base other$base = other.getBase();
        return !(this$base == null ? other$base != null : !this$base.equals(other$base));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseAccessorR4B;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Base $base = this.getBase();
        result = result * 59 + ($base == null ? 43 : $base.hashCode());
        return result;
    }

    @Generated
    private Base getBase() {
        return this.base;
    }
}

