/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.implementations;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableCollection;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.UnsupportedFHIRVersionException;
import de.fhlintstone.accessors.implementations.FrameworkTypeLocatorR4;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.accessors.implementations.TypeLocatorException;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.PrimitiveDatatype;
import de.fhlintstone.process.IContextProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public class LocatorSelector
implements IFrameworkTypeLocator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(LocatorSelector.class);
    private final IContextProvider contextProvider;
    private final Supplier<IFrameworkTypeLocator> locatorSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        FhirVersionEnum fhirVersion = this.getContextProvider().getFhirVersion().orElseThrow();
        return (IFrameworkTypeLocator)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> new FrameworkTypeLocatorR4(this.getContextProvider());
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    });

    @Inject
    public LocatorSelector(IContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public Optional<TypeName> determineType(URI resourceURI) {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).determineType(resourceURI);
    }

    @Override
    public ImmutableCollection<IMappedType> determineModelTypes(IElementDefinitionAccessor element) throws TypeLocatorException {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).determineModelTypes(element);
    }

    @Override
    public ImmutableCollection<IMappedType> determineModelTypes(IElementDefinitionAccessor element, Function<URI, Optional<TypeName>> preferredTypeMapper) throws TypeLocatorException {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).determineModelTypes(element, preferredTypeMapper);
    }

    @Override
    public TypeName getPrimitiveType(PrimitiveDatatype type) {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getPrimitiveType(type);
    }

    @Override
    public TypeName getConfigurationType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getConfigurationType();
    }

    @Override
    public TypeName getBackboneElementType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getBackboneElementType();
    }

    @Override
    public TypeName getExtensionType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getExtensionType();
    }

    @Override
    public TypeName getBaseType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getBaseType();
    }

    @Override
    public TypeName getGenericType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getGenericType();
    }

    @Override
    public TypeName getCodingType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getCodingType();
    }

    @Override
    public TypeName getPropertyType() {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getPropertyType();
    }

    @Override
    public boolean isDerivedFromPrimitiveType(TypeName type) {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).isDerivedFromPrimitiveType(type);
    }

    @Override
    public Optional<String> getBaseCastingMethod(TypeName targetType) {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).getBaseCastingMethod(targetType);
    }

    @Override
    public URI makeAbsoluteStructureDefinitionReference(String reference) throws URISyntaxException {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).makeAbsoluteStructureDefinitionReference(reference);
    }

    @Override
    public URI makeAbsoluteValueSetReference(String reference) throws URISyntaxException {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).makeAbsoluteValueSetReference(reference);
    }

    @Override
    public Optional<TypeName> determinePrimitiveType(TypeName frameworkType) {
        return ((IFrameworkTypeLocator)this.locatorSupplier.get()).determinePrimitiveType(frameworkType);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocatorSelector)) {
            return false;
        }
        LocatorSelector other = (LocatorSelector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IContextProvider this$contextProvider = this.getContextProvider();
        IContextProvider other$contextProvider = other.getContextProvider();
        if (this$contextProvider == null ? other$contextProvider != null : !this$contextProvider.equals(other$contextProvider)) {
            return false;
        }
        Supplier<IFrameworkTypeLocator> this$locatorSupplier = this.locatorSupplier;
        Supplier<IFrameworkTypeLocator> other$locatorSupplier = other.locatorSupplier;
        return !(this$locatorSupplier == null ? other$locatorSupplier != null : !this$locatorSupplier.equals(other$locatorSupplier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocatorSelector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IContextProvider $contextProvider = this.getContextProvider();
        result = result * 59 + ($contextProvider == null ? 43 : $contextProvider.hashCode());
        Supplier<IFrameworkTypeLocator> $locatorSupplier = this.locatorSupplier;
        result = result * 59 + ($locatorSupplier == null ? 43 : $locatorSupplier.hashCode());
        return result;
    }

    @Generated
    private IContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

