/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.implementations;

import com.palantir.javapoet.ArrayTypeName;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.implementations.FrameworkTypeLocatorBase;
import de.fhlintstone.accessors.model.PrimitiveDatatype;
import de.fhlintstone.process.IContextProvider;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.SimpleQuantity;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.codesystems.CompositionAttestationMode;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

class FrameworkTypeLocatorR4
extends FrameworkTypeLocatorBase {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(FrameworkTypeLocatorR4.class);
    private static final ClassName BACKBONE_ELEMENT = ClassName.get(BackboneElement.class);
    private static final ClassName BASE64_BINARY_TYPE = ClassName.get(Base64BinaryType.class);
    private static final ClassName BOOLEAN_TYPE = ClassName.get(BooleanType.class);
    private static final ClassName CANONICAL_TYPE = ClassName.get(CanonicalType.class);
    private static final ClassName CODE_TYPE = ClassName.get(CodeType.class);
    private static final ClassName DATE = ClassName.get(Date.class);
    private static final ClassName DATE_TIME_TYPE = ClassName.get(DateTimeType.class);
    private static final ClassName DATE_TYPE = ClassName.get(DateType.class);
    private static final ClassName DECIMAL_TYPE = ClassName.get(DecimalType.class);
    private static final ClassName ELEMENT = ClassName.get(Element.class);
    private static final ClassName ID_TYPE = ClassName.get(IdType.class);
    private static final ClassName INSTANT_TYPE = ClassName.get(InstantType.class);
    private static final ClassName INTEGER_TYPE = ClassName.get(IntegerType.class);
    private static final ClassName MARKDOWN_TYPE = ClassName.get(MarkdownType.class);
    private static final ClassName OID_TYPE = ClassName.get(OidType.class);
    private static final ClassName POSITIVE_INT_TYPE = ClassName.get(PositiveIntType.class);
    private static final ClassName RESOURCE = ClassName.get(Resource.class);
    private static final ClassName STRING = ClassName.get(String.class);
    private static final ClassName STRING_TYPE = ClassName.get(StringType.class);
    private static final ClassName TIME_TYPE = ClassName.get(TimeType.class);
    private static final ClassName UNSIGNED_INT_TYPE = ClassName.get(UnsignedIntType.class);
    private static final ClassName URI_TYPE = ClassName.get(UriType.class);
    private static final ClassName URL_TYPE = ClassName.get(UrlType.class);
    private static final ClassName UUID_TYPE = ClassName.get(UuidType.class);
    private static final ClassName ADDRESS = ClassName.get(Address.class);
    private static final ClassName ANNOTATION = ClassName.get(Annotation.class);
    private static final ClassName ATTACHMENT = ClassName.get(Attachment.class);
    private static final ClassName BIG_DECIMAL = ClassName.get(BigDecimal.class);
    private static final ClassName CODEABLE_CONCEPT = ClassName.get(CodeableConcept.class);
    private static final ClassName CODING = ClassName.get(Coding.class);
    private static final ClassName CONTACT_DETAIL = ClassName.get(ContactDetail.class);
    private static final ClassName CONTACT_POINT = ClassName.get(ContactPoint.class);
    private static final ClassName CONTRIBUTOR = ClassName.get(Contributor.class);
    private static final ClassName DATA_REQUIREMENT = ClassName.get(DataRequirement.class);
    private static final ClassName DOSAGE = ClassName.get(Dosage.class);
    private static final ClassName DURATION = ClassName.get(Duration.class);
    private static final ClassName ELEMENT_DEFINITION = ClassName.get(ElementDefinition.class);
    private static final ClassName EXPRESSION = ClassName.get(Expression.class);
    private static final ClassName EXTENSION = ClassName.get(Extension.class);
    private static final ClassName HUMAN_NAME = ClassName.get(HumanName.class);
    private static final ClassName IDENTIFIER = ClassName.get(Identifier.class);
    private static final ClassName MARKETING_STATUS = ClassName.get(MarketingStatus.class);
    private static final ClassName META = ClassName.get(Meta.class);
    private static final ClassName MONEY = ClassName.get(Money.class);
    private static final ClassName NARRATIVE = ClassName.get(Narrative.class);
    private static final ClassName PARAMETER_DEFINITION = ClassName.get(ParameterDefinition.class);
    private static final ClassName PERIOD = ClassName.get(Period.class);
    private static final ClassName POPULATION = ClassName.get(Population.class);
    private static final ClassName PROD_CHARACTERISTIC = ClassName.get(ProdCharacteristic.class);
    private static final ClassName PRODUCT_SHELF_LIFE = ClassName.get(ProductShelfLife.class);
    private static final ClassName QUANTITY = ClassName.get(Quantity.class);
    private static final ClassName RANGE = ClassName.get(Range.class);
    private static final ClassName RATIO = ClassName.get(Ratio.class);
    private static final ClassName REFERENCE = ClassName.get(Reference.class);
    private static final ClassName RELATED_ARTIFACT = ClassName.get(RelatedArtifact.class);
    private static final ClassName SAMPLED_DATA = ClassName.get(SampledData.class);
    private static final ClassName SIGNATURE = ClassName.get(Signature.class);
    private static final ClassName SIMPLE_QUANTITY = ClassName.get(SimpleQuantity.class);
    private static final ClassName SUBSTANCE_AMOUNT = ClassName.get(SubstanceAmount.class);
    private static final ClassName TIMING = ClassName.get(Timing.class);
    private static final ClassName TRIGGER_DEFINITION = ClassName.get(TriggerDefinition.class);
    private static final ClassName TYPE = ClassName.get(org.hl7.fhir.r4.model.Type.class);
    private static final ClassName USAGE_CONTEXT = ClassName.get(UsageContext.class);
    private static final ClassName XHTML_NODE = ClassName.get(XhtmlNode.class);

    public FrameworkTypeLocatorR4(IContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected Optional<TypeName> getWiredImplementation(String resourceURI) {
        logger.entry(new Object[]{resourceURI});
        ClassName className = switch (resourceURI) {
            case "http://hl7.org/fhir/StructureDefinition/boolean" -> BOOLEAN_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/integer" -> INTEGER_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/string" -> STRING_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/decimal" -> DECIMAL_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/uri" -> URI_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/url" -> URL_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/canonical" -> CANONICAL_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/base64Binary" -> BASE64_BINARY_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/instant" -> INSTANT_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/date" -> DATE_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/dateTime" -> DATE_TIME_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/time" -> TIME_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/code" -> CODE_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/oid" -> OID_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/id" -> ID_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/markdown" -> MARKDOWN_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/unsignedInt" -> UNSIGNED_INT_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/positiveInt" -> POSITIVE_INT_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/uuid" -> UUID_TYPE;
            case "http://hl7.org/fhirpath/System.Boolean" -> BOOLEAN_TYPE;
            case "http://hl7.org/fhirpath/System.String" -> STRING_TYPE;
            case "http://hl7.org/fhirpath/System.Integer" -> INTEGER_TYPE;
            case "http://hl7.org/fhirpath/System.Decimal" -> DECIMAL_TYPE;
            case "http://hl7.org/fhirpath/System.DateTime" -> DATE_TIME_TYPE;
            case "http://hl7.org/fhirpath/System.Time" -> TIME_TYPE;
            case "http://hl7.org/fhir/StructureDefinition/BackboneElement" -> BACKBONE_ELEMENT;
            case "http://hl7.org/fhir/StructureDefinition/Element" -> ELEMENT;
            case "http://hl7.org/fhir/StructureDefinition/Resource" -> RESOURCE;
            case "http://hl7.org/fhir/ValueSet/administrative-gender" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Enumerations.AdministrativeGender.class});
            case "http://hl7.org/fhir/ValueSet/bundle-type" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Bundle.BundleType.class});
            case "http://hl7.org/fhir/ValueSet/composition-attestation-mode" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{CompositionAttestationMode.class});
            case "http://hl7.org/fhir/ValueSet/composition-status" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Composition.CompositionStatus.class});
            case "http://hl7.org/fhir/ValueSet/contact-point-system" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{ContactPoint.ContactPointSystem.class});
            case "http://hl7.org/fhir/ValueSet/contact-point-use" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{ContactPoint.ContactPointUse.class});
            case "http://hl7.org/fhir/ValueSet/document-relationship-type" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Composition.DocumentRelationshipType.class});
            case "http://hl7.org/fhir/ValueSet/fm-status" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Coverage.CoverageStatus.class});
            case "http://hl7.org/fhir/ValueSet/http-verb" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Bundle.HTTPVerb.class});
            case "http://hl7.org/fhir/ValueSet/identifier-use" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Identifier.IdentifierUse.class});
            case "http://hl7.org/fhir/ValueSet/link-type" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Patient.LinkType.class});
            case "http://hl7.org/fhir/ValueSet/list-mode" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Composition.SectionMode.class});
            case "http://hl7.org/fhir/ValueSet/name-use" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{HumanName.NameUse.class});
            case "http://hl7.org/fhir/ValueSet/resource-types" -> URI_TYPE;
            case "http://hl7.org/fhir/ValueSet/search-entry-mode" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Bundle.SearchEntryMode.class});
            case "http://terminology.hl7.org/ValueSet/v3-ConfidentialityClassification" -> ParameterizedTypeName.get(Enumeration.class, (Type[])new Type[]{Composition.DocumentConfidentiality.class});
            default -> null;
        };
        Optional<Object> result = className == null ? Optional.empty() : Optional.of(className);
        return (Optional)logger.exit(result);
    }

    @Override
    public TypeName getPrimitiveType(PrimitiveDatatype type) {
        logger.entry(new Object[]{type});
        return (TypeName)logger.exit((Object)(switch (type) {
            case PrimitiveDatatype.BASE64BINARY -> ClassName.get(Base64BinaryType.class);
            case PrimitiveDatatype.BOOLEAN -> ClassName.get(BooleanType.class);
            case PrimitiveDatatype.CANONICAL -> ClassName.get(CanonicalType.class);
            case PrimitiveDatatype.CODE -> ClassName.get(CodeType.class);
            case PrimitiveDatatype.DATE -> ClassName.get(DateType.class);
            case PrimitiveDatatype.DATETIME -> ClassName.get(DateTimeType.class);
            case PrimitiveDatatype.DECIMAL -> ClassName.get(DecimalType.class);
            case PrimitiveDatatype.ID -> ClassName.get(IdType.class);
            case PrimitiveDatatype.INSTANT -> ClassName.get(InstantType.class);
            case PrimitiveDatatype.INTEGER -> ClassName.get(IntegerType.class);
            case PrimitiveDatatype.MARKDOWN -> ClassName.get(MarkdownType.class);
            case PrimitiveDatatype.OID -> ClassName.get(OidType.class);
            case PrimitiveDatatype.POSITIVEINT -> ClassName.get(PositiveIntType.class);
            case PrimitiveDatatype.STRING -> ClassName.get(StringType.class);
            case PrimitiveDatatype.TIME -> ClassName.get(TimeType.class);
            case PrimitiveDatatype.UNSIGNEDINT -> ClassName.get(UnsignedIntType.class);
            case PrimitiveDatatype.URI -> ClassName.get(UriType.class);
            case PrimitiveDatatype.URL -> ClassName.get(UrlType.class);
            case PrimitiveDatatype.UUID -> ClassName.get(UuidType.class);
            default -> throw new IllegalArgumentException(String.format("Type %s is currently not supported.", new Object[]{type}));
        }));
    }

    @Override
    public TypeName getConfigurationType() {
        return ClassName.get(Configuration.class);
    }

    @Override
    public TypeName getBackboneElementType() {
        return BACKBONE_ELEMENT;
    }

    @Override
    public TypeName getExtensionType() {
        return ClassName.get(Extension.class);
    }

    @Override
    public TypeName getBaseType() {
        return ClassName.get(Base.class);
    }

    @Override
    public TypeName getGenericType() {
        return ClassName.get(org.hl7.fhir.r4.model.Type.class);
    }

    @Override
    public TypeName getCodingType() {
        return ClassName.get(Coding.class);
    }

    @Override
    public TypeName getPropertyType() {
        return ClassName.get(Property.class);
    }

    @Override
    public boolean isDerivedFromPrimitiveType(TypeName typeName) {
        logger.entry(new Object[]{typeName});
        if (typeName instanceof ClassName) {
            ClassName className = (ClassName)typeName;
            try {
                Class<?> actualClass = Class.forName(className.canonicalName());
                return (Boolean)logger.exit((Object)PrimitiveType.class.isAssignableFrom(actualClass));
            }
            catch (ClassNotFoundException e) {
                logger.error("Unable to resolve class {}", (Object)className.canonicalName());
                return (Boolean)logger.exit((Object)false);
            }
        }
        return (Boolean)logger.exit((Object)false);
    }

    @Override
    public Optional<TypeName> determinePrimitiveType(TypeName frameworkType) {
        logger.entry(new Object[]{frameworkType});
        if (frameworkType == BASE64_BINARY_TYPE) {
            return (Optional)logger.exit(Optional.of(ArrayTypeName.of((TypeName)TypeName.BYTE)));
        }
        if (frameworkType == BOOLEAN_TYPE) {
            return (Optional)logger.exit(Optional.of(TypeName.BOOLEAN));
        }
        if (frameworkType == CANONICAL_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == CODE_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == DATE_TIME_TYPE) {
            return (Optional)logger.exit(Optional.of(DATE));
        }
        if (frameworkType == DATE_TYPE) {
            return (Optional)logger.exit(Optional.of(DATE));
        }
        if (frameworkType == DECIMAL_TYPE) {
            return (Optional)logger.exit(Optional.of(BIG_DECIMAL));
        }
        if (frameworkType == ID_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == INSTANT_TYPE) {
            return (Optional)logger.exit(Optional.of(DATE));
        }
        if (frameworkType == INTEGER_TYPE) {
            return (Optional)logger.exit(Optional.of(TypeName.INT));
        }
        if (frameworkType == MARKDOWN_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == OID_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == POSITIVE_INT_TYPE) {
            return (Optional)logger.exit(Optional.of(TypeName.INT));
        }
        if (frameworkType == STRING_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == TIME_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == UNSIGNED_INT_TYPE) {
            return (Optional)logger.exit(Optional.of(TypeName.INT));
        }
        if (frameworkType == URI_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        if (frameworkType == UUID_TYPE) {
            return (Optional)logger.exit(Optional.of(STRING));
        }
        return (Optional)logger.exit(Optional.empty());
    }

    @Override
    public Optional<String> getBaseCastingMethod(TypeName targetType) {
        logger.entry(new Object[]{targetType});
        if (targetType == ADDRESS) {
            return (Optional)logger.exit(Optional.of("castToAddress"));
        }
        if (targetType == ANNOTATION) {
            return (Optional)logger.exit(Optional.of("castToAnnotation"));
        }
        if (targetType == ATTACHMENT) {
            return (Optional)logger.exit(Optional.of("castToAttachment"));
        }
        if (targetType == BASE64_BINARY_TYPE) {
            return (Optional)logger.exit(Optional.of("castToBase64Binary"));
        }
        if (targetType == BOOLEAN_TYPE) {
            return (Optional)logger.exit(Optional.of("castToBoolean"));
        }
        if (targetType == CANONICAL_TYPE) {
            return (Optional)logger.exit(Optional.of("castToCanonical"));
        }
        if (targetType == CODEABLE_CONCEPT) {
            return (Optional)logger.exit(Optional.of("castToCodeableConcept"));
        }
        if (targetType == CODE_TYPE) {
            return (Optional)logger.exit(Optional.of("castToCode"));
        }
        if (targetType == CODING) {
            return (Optional)logger.exit(Optional.of("castToCoding"));
        }
        if (targetType == CONTACT_DETAIL) {
            return (Optional)logger.exit(Optional.of("castToContactDetail"));
        }
        if (targetType == CONTACT_POINT) {
            return (Optional)logger.exit(Optional.of("castToContactPoint"));
        }
        if (targetType == CONTRIBUTOR) {
            return (Optional)logger.exit(Optional.of("castToContributor"));
        }
        if (targetType == DATA_REQUIREMENT) {
            return (Optional)logger.exit(Optional.of("castToDataRequirement"));
        }
        if (targetType == DATE_TIME_TYPE) {
            return (Optional)logger.exit(Optional.of("castToDateTime"));
        }
        if (targetType == DATE_TYPE) {
            return (Optional)logger.exit(Optional.of("castToDate"));
        }
        if (targetType == DECIMAL_TYPE) {
            return (Optional)logger.exit(Optional.of("castToDecimal"));
        }
        if (targetType == DOSAGE) {
            return (Optional)logger.exit(Optional.of("castToDosage"));
        }
        if (targetType == DURATION) {
            return (Optional)logger.exit(Optional.of("castToDuration"));
        }
        if (targetType == ELEMENT_DEFINITION) {
            return (Optional)logger.exit(Optional.of("castToElementDefinition"));
        }
        if (targetType == EXPRESSION) {
            return (Optional)logger.exit(Optional.of("castToExpression"));
        }
        if (targetType == EXTENSION) {
            return (Optional)logger.exit(Optional.of("castToExtension"));
        }
        if (targetType == HUMAN_NAME) {
            return (Optional)logger.exit(Optional.of("castToHumanName"));
        }
        if (targetType == IDENTIFIER) {
            return (Optional)logger.exit(Optional.of("castToIdentifier"));
        }
        if (targetType == ID_TYPE) {
            return (Optional)logger.exit(Optional.of("castToId"));
        }
        if (targetType == INSTANT_TYPE) {
            return (Optional)logger.exit(Optional.of("castToInstant"));
        }
        if (targetType == INTEGER_TYPE) {
            return (Optional)logger.exit(Optional.of("castToInteger"));
        }
        if (targetType == MARKDOWN_TYPE) {
            return (Optional)logger.exit(Optional.of("castToMarkdown"));
        }
        if (targetType == MARKETING_STATUS) {
            return (Optional)logger.exit(Optional.of("castToMarketingStatus"));
        }
        if (targetType == META) {
            return (Optional)logger.exit(Optional.of("castToMeta"));
        }
        if (targetType == MONEY) {
            return (Optional)logger.exit(Optional.of("castToMoney"));
        }
        if (targetType == NARRATIVE) {
            return (Optional)logger.exit(Optional.of("castToNarrative"));
        }
        if (targetType == OID_TYPE) {
            return (Optional)logger.exit(Optional.of("castToOid"));
        }
        if (targetType == PARAMETER_DEFINITION) {
            return (Optional)logger.exit(Optional.of("castToParameterDefinition"));
        }
        if (targetType == PERIOD) {
            return (Optional)logger.exit(Optional.of("castToPeriod"));
        }
        if (targetType == POPULATION) {
            return (Optional)logger.exit(Optional.of("castToPopulation"));
        }
        if (targetType == POSITIVE_INT_TYPE) {
            return (Optional)logger.exit(Optional.of("castToPositiveInt"));
        }
        if (targetType == PROD_CHARACTERISTIC) {
            return (Optional)logger.exit(Optional.of("castToProdCharacteristic"));
        }
        if (targetType == PRODUCT_SHELF_LIFE) {
            return (Optional)logger.exit(Optional.of("castToProductShelfLife"));
        }
        if (targetType == QUANTITY) {
            return (Optional)logger.exit(Optional.of("castToQuantity"));
        }
        if (targetType == RANGE) {
            return (Optional)logger.exit(Optional.of("castToRange"));
        }
        if (targetType == RATIO) {
            return (Optional)logger.exit(Optional.of("castToRatio"));
        }
        if (targetType == REFERENCE) {
            return (Optional)logger.exit(Optional.of("castToReference"));
        }
        if (targetType == RELATED_ARTIFACT) {
            return (Optional)logger.exit(Optional.of("castToRelatedArtifact"));
        }
        if (targetType == RESOURCE) {
            return (Optional)logger.exit(Optional.of("castToResource"));
        }
        if (targetType == SAMPLED_DATA) {
            return (Optional)logger.exit(Optional.of("castToSampledData"));
        }
        if (targetType == SIGNATURE) {
            return (Optional)logger.exit(Optional.of("castToSignature"));
        }
        if (targetType == SIMPLE_QUANTITY) {
            return (Optional)logger.exit(Optional.of("castToSimpleQuantity"));
        }
        if (targetType == STRING) {
            return (Optional)logger.exit(Optional.of("castToXhtmlString"));
        }
        if (targetType == STRING_TYPE) {
            return (Optional)logger.exit(Optional.of("castToString"));
        }
        if (targetType == SUBSTANCE_AMOUNT) {
            return (Optional)logger.exit(Optional.of("castToSubstanceAmount"));
        }
        if (targetType == TIME_TYPE) {
            return (Optional)logger.exit(Optional.of("castToTime"));
        }
        if (targetType == TIMING) {
            return (Optional)logger.exit(Optional.of("castToTiming"));
        }
        if (targetType == TRIGGER_DEFINITION) {
            return (Optional)logger.exit(Optional.of("castToTriggerDefinition"));
        }
        if (targetType == TYPE) {
            return (Optional)logger.exit(Optional.of("castToType"));
        }
        if (targetType == UNSIGNED_INT_TYPE) {
            return (Optional)logger.exit(Optional.of("castToUnsignedInt"));
        }
        if (targetType == URI_TYPE) {
            return (Optional)logger.exit(Optional.of("castToUri"));
        }
        if (targetType == URL_TYPE) {
            return (Optional)logger.exit(Optional.of("castToUrl"));
        }
        if (targetType == USAGE_CONTEXT) {
            return (Optional)logger.exit(Optional.of("castToUsageContext"));
        }
        if (targetType == XHTML_NODE) {
            return (Optional)logger.exit(Optional.of("castToXhtml"));
        }
        return (Optional)logger.exit(Optional.empty());
    }
}

