/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.implementations;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeName;
import de.fhlintstone.accessors.implementations.IFrameworkTypeLocator;
import de.fhlintstone.accessors.implementations.IMappedType;
import de.fhlintstone.accessors.implementations.MappedType;
import de.fhlintstone.accessors.implementations.TypeLocatorException;
import de.fhlintstone.accessors.model.ICanonicalTypeAccessor;
import de.fhlintstone.accessors.model.IElementDefinitionAccessor;
import de.fhlintstone.accessors.model.IElementTypeRefComponentAccessor;
import de.fhlintstone.process.IContextProvider;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

abstract class FrameworkTypeLocatorBase
implements IFrameworkTypeLocator {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(FrameworkTypeLocatorBase.class);
    public static final String HL7_STRUCTURE_DEFINITION_PREFIX = "http://hl7.org/fhir/StructureDefinition/";
    public static final String HL7_VALUE_SET_PREFIX = "http://hl7.org/fhir/ValueSet/";
    private final IContextProvider contextProvider;

    FrameworkTypeLocatorBase(IContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public Optional<TypeName> determineType(URI resourceURI) {
        logger.entry(new Object[]{resourceURI});
        String uriString = resourceURI.toString();
        Optional<TypeName> result = this.getWiredImplementation(uriString);
        if (result.isEmpty() && uriString.startsWith(HL7_STRUCTURE_DEFINITION_PREFIX)) {
            Optional<RuntimeResourceDefinition> resourceDefinition;
            String name = uriString.substring(HL7_STRUCTURE_DEFINITION_PREFIX.length());
            Optional<BaseRuntimeElementDefinition<?>> elementDefinition = this.contextProvider.getElementDefinition(name);
            if (elementDefinition.isPresent()) {
                result = Optional.of(ClassName.get((Class)elementDefinition.get().getImplementingClass()));
            }
            if (result.isEmpty() && (resourceDefinition = this.contextProvider.getResourceDefinition(name)).isPresent()) {
                result = Optional.of(ClassName.get((Class)resourceDefinition.get().getImplementingClass()));
            }
        }
        return (Optional)logger.exit(result);
    }

    protected abstract Optional<TypeName> getWiredImplementation(String var1);

    @Override
    public URI makeAbsoluteStructureDefinitionReference(String reference) throws URISyntaxException {
        logger.entry(new Object[]{reference});
        URI typeCodeURI = new URI(reference);
        if (!typeCodeURI.isAbsolute()) {
            typeCodeURI = new URI(HL7_STRUCTURE_DEFINITION_PREFIX + reference);
        }
        return (URI)logger.exit((Object)typeCodeURI);
    }

    @Override
    public URI makeAbsoluteValueSetReference(String reference) throws URISyntaxException {
        logger.entry(new Object[]{reference});
        URI typeCodeURI = new URI(reference);
        if (!typeCodeURI.isAbsolute()) {
            typeCodeURI = new URI(HL7_VALUE_SET_PREFIX + reference);
        }
        return (URI)logger.exit((Object)typeCodeURI);
    }

    @Override
    public ImmutableCollection<IMappedType> determineModelTypes(IElementDefinitionAccessor element) throws TypeLocatorException {
        logger.entry(new Object[]{element});
        return (ImmutableCollection)logger.exit(this.determineModelTypes(element, uri -> Optional.empty()));
    }

    @Override
    public ImmutableCollection<IMappedType> determineModelTypes(IElementDefinitionAccessor element, Function<URI, Optional<TypeName>> preferredTypeMapper) throws TypeLocatorException {
        logger.entry(new Object[]{element});
        String elementId = element.getId().orElse("(no ID)");
        ImmutableList<IElementTypeRefComponentAccessor> types = element.getType();
        if (types.isEmpty()) {
            logger.debug("Element {} does not have any type information", (Object)elementId);
            return (ImmutableCollection)logger.exit((Object)ImmutableSet.of());
        }
        HashSet<IMappedType> result = new HashSet<IMappedType>();
        for (IElementTypeRefComponentAccessor type : types) {
            if (this.getModelTypesFromProfile(elementId, type, preferredTypeMapper, result)) continue;
            this.getModelTypesFromCode(elementId, type, preferredTypeMapper, result);
        }
        return (ImmutableCollection)logger.exit((Object)ImmutableSet.copyOf(result));
    }

    private boolean getModelTypesFromProfile(String elementId, IElementTypeRefComponentAccessor type, Function<URI, Optional<TypeName>> preferredTypeMapper, HashSet<IMappedType> result) throws TypeLocatorException {
        Optional<URI> typeCodeURI;
        logger.entry(new Object[]{elementId});
        Optional<String> typeCode = type.getCode();
        try {
            typeCodeURI = typeCode.isPresent() ? Optional.of(this.makeAbsoluteStructureDefinitionReference(typeCode.get())) : Optional.empty();
        }
        catch (URISyntaxException e) {
            logger.error("Unable to determine URI of type code {]", (Object)typeCode.get(), (Object)e);
            typeCodeURI = Optional.empty();
        }
        boolean typeFound = false;
        for (ICanonicalTypeAccessor profile : type.getProfile()) {
            try {
                URI profileURI = this.makeAbsoluteStructureDefinitionReference(profile.getValue().orElseThrow());
                Optional<TypeName> preferredType = preferredTypeMapper.apply(profileURI);
                if (preferredType.isPresent()) {
                    result.add(MappedType.builder().withProfile(profile.getValue()).withProfileURI(Optional.of(profileURI)).withTypeCode(typeCode).withTypeCodeURI(typeCodeURI).withPreferredType(preferredType).build());
                    typeFound = true;
                    continue;
                }
                Optional<TypeName> frameworkType = this.determineType(profileURI);
                if (frameworkType.isPresent()) {
                    result.add(MappedType.builder().withProfile(profile.getValue()).withProfileURI(Optional.of(profileURI)).withTypeCode(typeCode).withTypeCodeURI(typeCodeURI).withFrameworkType(frameworkType).build());
                    typeFound = true;
                    continue;
                }
                logger.debug("Type profile {} of element {} is neither a generated type nor a framework type", (Object)profile, (Object)elementId);
            }
            catch (URISyntaxException e) {
                throw (TypeLocatorException)logger.throwing((Throwable)new TypeLocatorException(String.format("Element %s has an invalid type profile URI", elementId), e));
            }
        }
        return (Boolean)logger.exit((Object)typeFound);
    }

    private void getModelTypesFromCode(String elementId, IElementTypeRefComponentAccessor type, Function<URI, Optional<TypeName>> preferredTypeMapper, HashSet<IMappedType> result) throws TypeLocatorException {
        logger.entry(new Object[]{elementId});
        Optional<String> typeCode = type.getCode();
        if (typeCode.isPresent()) {
            try {
                URI typeCodeURI = this.makeAbsoluteStructureDefinitionReference(typeCode.get());
                Optional<TypeName> preferredType = preferredTypeMapper.apply(typeCodeURI);
                if (preferredType.isPresent()) {
                    result.add(MappedType.builder().withTypeCode(typeCode).withTypeCodeURI(Optional.of(typeCodeURI)).withPreferredType(preferredType).build());
                }
                Optional<TypeName> frameworkType = this.determineType(typeCodeURI);
                if (frameworkType.isPresent()) {
                    result.add(MappedType.builder().withTypeCode(typeCode).withTypeCodeURI(Optional.of(typeCodeURI)).withFrameworkType(frameworkType).build());
                }
                logger.warn("Type code of element {} is neither a generated type nor a framework type", (Object)elementId);
            }
            catch (URISyntaxException e) {
                throw (TypeLocatorException)logger.throwing((Throwable)new TypeLocatorException(String.format("Element %s has an invalid type code URI", elementId), e));
            }
        } else {
            logger.warn("Element {} does not have a type code set", (Object)elementId);
        }
        logger.exit();
    }
}

