/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.dependencies;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.fhlintstone.accessors.UnsupportedFHIRVersionException;
import de.fhlintstone.accessors.dependencies.DependencyResourceVisitorR4;
import de.fhlintstone.accessors.dependencies.DependencyResourceVisitorR4B;
import de.fhlintstone.accessors.dependencies.DependencyResourceVisitorR5;
import de.fhlintstone.accessors.dependencies.IDependencyResourceVisitor;
import de.fhlintstone.fhir.dependencies.DependencyException;
import de.fhlintstone.fhir.dependencies.IDependencyCollector;
import de.fhlintstone.process.IContextProvider;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public final class VisitorSelector
implements IDependencyResourceVisitor {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(VisitorSelector.class);
    private final IContextProvider contextProvider;
    private final Supplier<IDependencyResourceVisitor> visitorSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        FhirVersionEnum fhirVersion = this.getContextProvider().getFhirVersion().orElseThrow();
        return (IDependencyResourceVisitor)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> new DependencyResourceVisitorR4();
            case FhirVersionEnum.R4B -> new DependencyResourceVisitorR4B();
            case FhirVersionEnum.R5 -> new DependencyResourceVisitorR5();
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    });

    @Inject
    public VisitorSelector(IContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    @Override
    public void visit(IBaseResource resource, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{resource});
        ((IDependencyResourceVisitor)this.visitorSupplier.get()).visit(resource, collector);
        logger.exit();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VisitorSelector)) {
            return false;
        }
        VisitorSelector other = (VisitorSelector)o;
        IContextProvider this$contextProvider = this.getContextProvider();
        IContextProvider other$contextProvider = other.getContextProvider();
        if (this$contextProvider == null ? other$contextProvider != null : !this$contextProvider.equals(other$contextProvider)) {
            return false;
        }
        Supplier<IDependencyResourceVisitor> this$visitorSupplier = this.visitorSupplier;
        Supplier<IDependencyResourceVisitor> other$visitorSupplier = other.visitorSupplier;
        return !(this$visitorSupplier == null ? other$visitorSupplier != null : !this$visitorSupplier.equals(other$visitorSupplier));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IContextProvider $contextProvider = this.getContextProvider();
        result = result * 59 + ($contextProvider == null ? 43 : $contextProvider.hashCode());
        Supplier<IDependencyResourceVisitor> $visitorSupplier = this.visitorSupplier;
        result = result * 59 + ($visitorSupplier == null ? 43 : $visitorSupplier.hashCode());
        return result;
    }

    @Generated
    private IContextProvider getContextProvider() {
        return this.contextProvider;
    }
}

