/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors.dependencies;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import de.fhlintstone.accessors.dependencies.IDependencyResourceVisitor;
import de.fhlintstone.fhir.dependencies.DependencyException;
import de.fhlintstone.fhir.dependencies.IDependency;
import de.fhlintstone.fhir.dependencies.IDependencyCollector;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

class DependencyResourceVisitorR4
implements IDependencyResourceVisitor {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(DependencyResourceVisitorR4.class);
    private final Supplier<ImmutableSet<String>> ignoredTypesSupplier = Suppliers.memoize(() -> ImmutableSet.of((Object)"boolean", (Object)"integer", (Object)"string", (Object)"decimal", (Object)"uri", (Object)"url", (Object[])new String[]{"canonical", "base64Binary", "instant", "date", "dateTime", "time", "code", "oid", "id", "markdown", "unsignedInt", "positiveInt", "uuid", "http://hl7.org/fhirpath/System.Boolean", "http://hl7.org/fhirpath/System.String", "http://hl7.org/fhirpath/System.Integer", "http://hl7.org/fhirpath/System.Long", "http://hl7.org/fhirpath/System.Decimal", "http://hl7.org/fhirpath/System.DateTime", "http://hl7.org/fhirpath/System.Time"}));

    @Override
    public void visit(IBaseResource resource, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{resource});
        IBaseResource iBaseResource = resource;
        Objects.requireNonNull(iBaseResource);
        IBaseResource iBaseResource2 = iBaseResource;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructureDefinition.class, ValueSet.class, CodeSystem.class}, (Object)iBaseResource2, n)) {
            case 0: {
                StructureDefinition structureDefinition = (StructureDefinition)iBaseResource2;
                this.visitStructureDefinition(structureDefinition, collector);
                break;
            }
            case 1: {
                ValueSet valueSet = (ValueSet)iBaseResource2;
                this.visitValueSet(valueSet, collector);
                break;
            }
            case 2: {
                CodeSystem codeSystem = (CodeSystem)iBaseResource2;
                this.visitCodeSystem(codeSystem, collector);
                break;
            }
            default: {
                logger.warn("Unknown resource implementation {} is not checked for dependencies", (Object)resource.getClass().getCanonicalName());
            }
        }
        logger.exit();
    }

    private void visitStructureDefinition(StructureDefinition structureDefinition, IDependencyCollector collector) throws DependencyException {
        String location;
        logger.entry(new Object[]{structureDefinition});
        if (structureDefinition.hasBaseDefinition()) {
            logger.debug("Found dependency: base type {}", (Object)structureDefinition.getBaseDefinition());
            collector.collect(structureDefinition.getBaseDefinition(), IDependency.Origin.BASE_DEFINITION);
        }
        if (structureDefinition.hasContextInvariant()) {
            logger.warn("Unchecked structure property ContextInvariant = {}, dependency graph may be incomplete", (Object)structureDefinition.getContextInvariant());
        }
        if (structureDefinition.hasDifferential()) {
            location = String.format("StructureDefinition[%s].differential", structureDefinition.getId());
            for (ElementDefinition differentialElement : structureDefinition.getDifferential().getElement()) {
                this.visitElementDefinition(differentialElement, collector, location);
            }
        }
        if (structureDefinition.hasSnapshot()) {
            location = String.format("StructureDefinition[%s].snapshot", structureDefinition.getId());
            for (ElementDefinition snapshotElement : structureDefinition.getSnapshot().getElement()) {
                this.visitElementDefinition(snapshotElement, collector, location);
            }
        }
        logger.exit();
    }

    private void visitElementDefinition(ElementDefinition elementDefinition, IDependencyCollector collector, String parentLocation) throws DependencyException {
        logger.entry(new Object[]{elementDefinition.getName()});
        String location = String.format("%s/ElementDefinition[%s]", parentLocation, elementDefinition.getId());
        if (elementDefinition.hasBinding()) {
            this.visitElementDefinitionBase(elementDefinition, collector, location);
        }
        if (elementDefinition.hasCode()) {
            logger.warn("Unchecked {}.Code = {}, dependency graph may be incomplete", (Object)location, (Object)elementDefinition.getCode());
        }
        if (elementDefinition.hasType()) {
            this.visitElementDefinitionType(elementDefinition, collector, location);
        }
        logger.exit();
    }

    public void visitElementDefinitionBase(ElementDefinition elementDefinition, IDependencyCollector collector, String location) throws DependencyException {
        logger.entry(new Object[]{elementDefinition});
        ElementDefinition.ElementDefinitionBindingComponent binding = elementDefinition.getBinding();
        Enumerations.BindingStrength strength = binding.hasStrength() ? binding.getStrength() : Enumerations.BindingStrength.NULL;
        switch (strength) {
            case NULL: {
                logger.warn("{}.binding.strength is not set, ignoring binding", (Object)location);
                break;
            }
            case EXAMPLE: {
                logger.debug("Ignoring example binding of {}.binding", (Object)location);
                break;
            }
            default: {
                if (binding.hasValueSet()) {
                    String valueSet = binding.getValueSet();
                    logger.debug("Found dependency: {}.binding ValueSet {}", (Object)location, (Object)valueSet);
                    collector.collect(valueSet, IDependency.Origin.BINDING_VALUE_SET);
                    break;
                }
                logger.warn("Unchecked {}.binding with strength {} without ValueSet, dependency graph may be incomplete", (Object)location, (Object)strength);
            }
        }
        logger.exit();
    }

    public void visitElementDefinitionType(ElementDefinition elementDefinition, IDependencyCollector collector, String location) throws DependencyException {
        logger.entry(new Object[]{elementDefinition});
        for (ElementDefinition.TypeRefComponent typeRefComponent : elementDefinition.getType()) {
            if (!typeRefComponent.hasCode()) {
                logger.warn("ElementDefinition {} does not have a type.code set.", (Object)elementDefinition.getId());
            } else {
                this.visitElementDefinitionType(typeRefComponent.getCode(), location, "type.code", IDependency.Origin.TYPE_CODE, collector);
            }
            for (CanonicalType profile : typeRefComponent.getProfile()) {
                this.visitElementDefinitionType((String)profile.getValue(), location, "type.profile", IDependency.Origin.TYPE_PROFILE, collector);
            }
            for (CanonicalType targetProfile : typeRefComponent.getTargetProfile()) {
                this.visitElementDefinitionType((String)targetProfile.getValue(), location, "type.targetProfile", IDependency.Origin.TYPE_TARGET_PROFILE, collector);
            }
        }
        logger.exit();
    }

    private void visitElementDefinitionType(String type, String location, String subAttribute, IDependency.Origin origin, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{type, location, subAttribute, origin});
        if (((ImmutableSet)this.ignoredTypesSupplier.get()).contains((Object)type)) {
            logger.debug("Ignored {}.{} because of type {}", new Object[]{location, subAttribute, type});
        } else {
            try {
                String typeURI = this.makeAbsoluteTypeReference(type);
                logger.debug("Found dependency: {}.{} = {}", new Object[]{location, subAttribute, typeURI});
                collector.collect(typeURI, origin);
            }
            catch (URISyntaxException e) {
                throw (DependencyException)logger.throwing((Throwable)new DependencyException(String.format("Invalid URI %s in %s.%s", type, location, subAttribute), e));
            }
        }
        logger.exit();
    }

    private void visitValueSet(ValueSet valueSet, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{valueSet});
        if (valueSet.hasCompose()) {
            this.visitValueSetCompose(valueSet, collector);
        }
        logger.exit();
    }

    public void visitValueSetCompose(ValueSet valueSet, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{valueSet});
        ValueSet.ValueSetComposeComponent valueSetCompose = valueSet.getCompose();
        if (valueSetCompose.hasInclude()) {
            this.visitValueSetComponents(collector, valueSetCompose.getInclude(), "include");
        }
        if (valueSetCompose.hasExclude()) {
            this.visitValueSetComponents(collector, valueSetCompose.getExclude(), "exclude");
        }
        logger.exit();
    }

    private void visitValueSetComponents(IDependencyCollector collector, List<ValueSet.ConceptSetComponent> components, String mode) throws DependencyException {
        for (ValueSet.ConceptSetComponent component : components) {
            if (component.hasSystem()) {
                logger.debug("Found dependency: ValueSet.compose.{}.system {}", (Object)mode, (Object)component.getSystem());
                collector.collect(component.getSystem(), IDependency.Origin.COMPOSE_CODE_SYSTEM);
            }
            if (!component.hasValueSet()) continue;
            for (CanonicalType vs : component.getValueSet()) {
                logger.debug("Found dependency: ValueSet.compose.{}.valueSet{}", (Object)mode, vs.getValue());
                collector.collect((String)vs.getValue(), IDependency.Origin.COMPOSE_VALUE_SET);
            }
        }
    }

    private void visitCodeSystem(CodeSystem codeSystem, IDependencyCollector collector) throws DependencyException {
        logger.entry(new Object[]{codeSystem});
        if (codeSystem.hasSupplements()) {
            String supplements = codeSystem.getSupplements();
            logger.debug("Found dependency: CodeSystem.valueSet = {}", (Object)supplements);
            collector.collect(supplements, IDependency.Origin.CODE_SYSTEM_SUPPLEMENTS);
        }
        logger.exit();
    }

    private String makeAbsoluteTypeReference(String typeReference) throws URISyntaxException {
        logger.entry(new Object[]{typeReference});
        URI typeCodeURI = new URI(typeReference);
        if (!typeCodeURI.isAbsolute()) {
            typeCodeURI = new URI("http://hl7.org/fhir/StructureDefinition/" + typeReference);
        }
        return (String)logger.exit((Object)typeCodeURI.toString());
    }
}

