/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors;

import ca.uhn.fhir.context.FhirVersionEnum;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import de.fhlintstone.accessors.AccessorCacheR4;
import de.fhlintstone.accessors.AccessorCacheR4B;
import de.fhlintstone.accessors.AccessorCacheR5;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.IAccessorProvider;
import de.fhlintstone.accessors.UnresolvableURIException;
import de.fhlintstone.accessors.UnsupportedFHIRVersionException;
import de.fhlintstone.accessors.model.ICodeSystemAccessor;
import de.fhlintstone.accessors.model.IStructureDefinitionAccessor;
import de.fhlintstone.accessors.model.IValueSetAccessor;
import de.fhlintstone.packages.AmbiguousResourceURIException;
import de.fhlintstone.packages.IPackageRegistry;
import de.fhlintstone.process.IContextProvider;
import java.net.URI;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ValueSet;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@Named
public final class AccessorProvider
implements IAccessorProvider {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(AccessorProvider.class);
    private final IContextProvider contextProvider;
    private final IPackageRegistry packageRegistry;
    private final Supplier<IAccessorCache> cacheSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        FhirVersionEnum fhirVersion = this.getContextProvider().getFhirVersion().orElseThrow();
        return (IAccessorCache)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> new AccessorCacheR4();
            case FhirVersionEnum.R4B -> new AccessorCacheR4B();
            case FhirVersionEnum.R5 -> new AccessorCacheR5();
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    });

    @Inject
    public AccessorProvider(IContextProvider contextProvider, IPackageRegistry packageRegistry) {
        this.contextProvider = contextProvider;
        this.packageRegistry = packageRegistry;
    }

    @Override
    public IStructureDefinitionAccessor provideStructureDefinitionAccessor(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        FhirVersionEnum fhirVersion = this.contextProvider.getFhirVersion().orElseThrow();
        return (IStructureDefinitionAccessor)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> {
                if (resource instanceof StructureDefinition) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IStructureDefinitionAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r4.model.StructureDefinition, actual type %s", resource.getClass().getCanonicalName()));
            }
            case FhirVersionEnum.R4B -> {
                if (resource instanceof org.hl7.fhir.r4b.model.StructureDefinition) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IStructureDefinitionAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r4b.model.StructureDefinition, actual type %s", resource.getClass().getCanonicalName()));
            }
            case FhirVersionEnum.R5 -> {
                if (resource instanceof org.hl7.fhir.r5.model.StructureDefinition) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IStructureDefinitionAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r5.model.StructureDefinition, actual type %s", resource.getClass().getCanonicalName()));
            }
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    }

    @Override
    public IStructureDefinitionAccessor provideStructureDefinitionAccessor(URI uri) throws UnresolvableURIException {
        logger.entry(new Object[]{uri});
        IBaseResource resource = this.resolveResource(uri);
        IStructureDefinitionAccessor accessor = this.provideStructureDefinitionAccessor(resource);
        return (IStructureDefinitionAccessor)logger.exit((Object)accessor);
    }

    @Override
    public IValueSetAccessor provideValueSetAccessor(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        FhirVersionEnum fhirVersion = this.contextProvider.getFhirVersion().orElseThrow();
        return (IValueSetAccessor)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> {
                if (resource instanceof org.hl7.fhir.r4.model.ValueSet) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IValueSetAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r4.model.ValueSet, actual type %s", resource.getClass().getCanonicalName()));
            }
            case FhirVersionEnum.R4B -> {
                if (resource instanceof org.hl7.fhir.r4b.model.ValueSet) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IValueSetAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r4b.model.ValueSet, actual type %s", resource.getClass().getCanonicalName()));
            }
            case FhirVersionEnum.R5 -> {
                if (resource instanceof ValueSet) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, IValueSetAccessor.class);
                }
                throw new IllegalArgumentException(String.format("Expected type org.hl7.fhir.r5.model.ValueSet, actual type %s", resource.getClass().getCanonicalName()));
            }
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    }

    @Override
    public IValueSetAccessor provideValueSetAccessor(URI uri) throws UnresolvableURIException {
        logger.entry(new Object[]{uri});
        IBaseResource resource = this.resolveResource(uri);
        IValueSetAccessor accessor = this.provideValueSetAccessor(resource);
        return (IValueSetAccessor)logger.exit((Object)accessor);
    }

    @Override
    public ICodeSystemAccessor provideCodeSystemAccessor(IBaseResource resource) {
        logger.entry(new Object[]{resource});
        FhirVersionEnum fhirVersion = this.contextProvider.getFhirVersion().orElseThrow();
        return (ICodeSystemAccessor)logger.exit((Object)(switch (fhirVersion) {
            case FhirVersionEnum.R4 -> {
                if (resource instanceof org.hl7.fhir.r4.model.CodeSystem) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, ICodeSystemAccessor.class);
                }
                throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Expected org.hl7.fhir.r4.model.CodeSystem, received %s", resource.getClass().getCanonicalName())));
            }
            case FhirVersionEnum.R4B -> {
                if (resource instanceof org.hl7.fhir.r4b.model.CodeSystem) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, ICodeSystemAccessor.class);
                }
                throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Expected org.hl7.fhir.r4b.model.CodeSystem, received %s", resource.getClass().getCanonicalName())));
            }
            case FhirVersionEnum.R5 -> {
                if (resource instanceof CodeSystem) {
                    yield ((IAccessorCache)this.cacheSupplier.get()).getAccessor(resource, ICodeSystemAccessor.class);
                }
                throw (IllegalArgumentException)logger.throwing((Throwable)new IllegalArgumentException(String.format("Expected org.hl7.fhir.r5.model.CodeSystem, received %s", resource.getClass().getCanonicalName())));
            }
            default -> throw (UnsupportedFHIRVersionException)logger.throwing((Throwable)new UnsupportedFHIRVersionException(fhirVersion));
        }));
    }

    @Override
    public ICodeSystemAccessor provideCodeSystemAccessor(URI uri) throws UnresolvableURIException {
        logger.entry(new Object[]{uri});
        IBaseResource resource = this.resolveResource(uri);
        ICodeSystemAccessor accessor = this.provideCodeSystemAccessor(resource);
        return (ICodeSystemAccessor)logger.exit((Object)accessor);
    }

    private IBaseResource resolveResource(URI uri) {
        logger.entry(new Object[]{uri});
        try {
            Optional<IBaseResource> resource = this.packageRegistry.getUniqueResource(uri);
            if (!resource.isPresent()) {
                throw (UnresolvableURIException)logger.throwing((Throwable)new UnresolvableURIException(String.format("Resource URI %s cannot be resolved", uri)));
            }
            return (IBaseResource)logger.exit((Object)resource.get());
        }
        catch (AmbiguousResourceURIException e) {
            throw (UnresolvableURIException)logger.throwing((Throwable)new UnresolvableURIException(String.format("Resource URI %s is not unique", uri), e));
        }
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccessorProvider)) {
            return false;
        }
        AccessorProvider other = (AccessorProvider)o;
        IContextProvider this$contextProvider = this.getContextProvider();
        IContextProvider other$contextProvider = other.getContextProvider();
        if (this$contextProvider == null ? other$contextProvider != null : !this$contextProvider.equals(other$contextProvider)) {
            return false;
        }
        IPackageRegistry this$packageRegistry = this.getPackageRegistry();
        IPackageRegistry other$packageRegistry = other.getPackageRegistry();
        if (this$packageRegistry == null ? other$packageRegistry != null : !this$packageRegistry.equals(other$packageRegistry)) {
            return false;
        }
        Supplier<IAccessorCache> this$cacheSupplier = this.cacheSupplier;
        Supplier<IAccessorCache> other$cacheSupplier = other.cacheSupplier;
        return !(this$cacheSupplier == null ? other$cacheSupplier != null : !this$cacheSupplier.equals(other$cacheSupplier));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IContextProvider $contextProvider = this.getContextProvider();
        result = result * 59 + ($contextProvider == null ? 43 : $contextProvider.hashCode());
        IPackageRegistry $packageRegistry = this.getPackageRegistry();
        result = result * 59 + ($packageRegistry == null ? 43 : $packageRegistry.hashCode());
        Supplier<IAccessorCache> $cacheSupplier = this.cacheSupplier;
        result = result * 59 + ($cacheSupplier == null ? 43 : $cacheSupplier.hashCode());
        return result;
    }

    @Generated
    private IContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @Generated
    private IPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }
}

