/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.accessors;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import de.fhlintstone.accessors.IAccessor;
import de.fhlintstone.accessors.IAccessorCache;
import de.fhlintstone.accessors.InvalidTypeException;
import de.fhlintstone.accessors.UnsupportedTypeException;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

public abstract class AccessorCache
implements IAccessorCache {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(AccessorCache.class);
    private final Supplier<LoadingCache<Object, IAccessor>> cacheSupplier = Suppliers.memoize(() -> {
        logger.entry(new Object[0]);
        logger.debug("Initializing new accessor cache");
        LoadingCache result = CacheBuilder.newBuilder().weakKeys().weakValues().build(this.provideCacheLoader());
        return (LoadingCache)logger.exit((Object)result);
    });

    protected AccessorCache() {
    }

    protected abstract CacheLoader<Object, IAccessor> provideCacheLoader();

    @Override
    public IAccessor getAccessor(Object modelObject) {
        IAccessor result;
        logger.entry(new Object[]{modelObject});
        try {
            result = (IAccessor)((LoadingCache)this.cacheSupplier.get()).get(modelObject);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw (UnsupportedTypeException)logger.throwing((Throwable)UnsupportedTypeException.forObjectType(modelObject));
        }
        return (IAccessor)logger.exit((Object)result);
    }

    @Override
    public <T extends IAccessor> T getAccessor(Object modelObject, Class<T> accessorType) {
        IAccessor result;
        logger.entry(new Object[]{modelObject});
        try {
            result = (IAccessor)((LoadingCache)this.cacheSupplier.get()).get(modelObject);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw (UnsupportedTypeException)logger.throwing((Throwable)UnsupportedTypeException.forObjectType(modelObject));
        }
        if (accessorType.isAssignableFrom(result.getClass())) {
            return (T)((IAccessor)logger.exit((Object)result));
        }
        throw new InvalidTypeException(modelObject, accessorType);
    }
}

