/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.cli.config;

import ca.uhn.fhir.context.FhirVersionEnum;
import de.fhlintstone.cli.config.NestedClass;
import de.fhlintstone.cli.config.PackageSource;
import de.fhlintstone.cli.config.StructureDefinitionClass;
import de.fhlintstone.cli.config.ValueSetEnum;
import de.fhlintstone.process.config.NestedClassConfiguration;
import de.fhlintstone.process.config.PackageSourceConfiguration;
import de.fhlintstone.process.config.ProcessConfiguration;
import de.fhlintstone.process.config.StructureDefinitionClassConfiguration;
import de.fhlintstone.process.config.ValueSetEnumConfiguration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;

@XmlRootElement(name="configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GeneratorConfiguration {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(GeneratorConfiguration.class);
    @XmlElement(name="fhirVersion", required=true)
    private FhirVersionEnum fhirVersion;
    @XmlElement(name="outputPath", required=true)
    private String outputPath;
    @XmlElement(name="defaultNamespace")
    private String defaultNamespace;
    @XmlElementWrapper(name="packageSources")
    @XmlElement(name="packageSource")
    private List<PackageSource> packageSources = new ArrayList<PackageSource>();
    @XmlElementWrapper(name="valueSetEnums")
    @XmlElement(name="valueSetEnum")
    private List<ValueSetEnum> valueSetEnums = new ArrayList<ValueSetEnum>();
    @XmlElementWrapper(name="structureDefinitionClasses")
    @XmlElement(name="structureDefinitionClass")
    private List<StructureDefinitionClass> structureDefinitionClasses = new ArrayList<StructureDefinitionClass>();

    public ProcessConfiguration toProcessorConfiguration() {
        logger.entry(new Object[0]);
        ArrayList<PackageSourceConfiguration> packageSourcesConfiguration = new ArrayList<PackageSourceConfiguration>();
        for (PackageSource packageSource : this.packageSources) {
            packageSourcesConfiguration.add(PackageSourceConfiguration.builder().withSourceFile(Optional.of(new File(packageSource.getSourceFile()))).build());
        }
        ArrayList<ValueSetEnumConfiguration> valueSetEnumConfigurations = new ArrayList<ValueSetEnumConfiguration>();
        for (ValueSetEnum valueSetEnum : this.valueSetEnums) {
            valueSetEnumConfigurations.add(ValueSetEnumConfiguration.builder().withValueSet(valueSetEnum.getValueSet()).withTargetNamespace(Optional.ofNullable(valueSetEnum.getTargetNamespace())).withEnumName(valueSetEnum.getEnumName()).build());
        }
        ArrayList<StructureDefinitionClassConfiguration> arrayList = new ArrayList<StructureDefinitionClassConfiguration>();
        for (StructureDefinitionClass structureDefinitionClass : this.structureDefinitionClasses) {
            StructureDefinitionClassConfiguration.StructureDefinitionClassConfigurationBuilder structureDefinitionClassBuilder = StructureDefinitionClassConfiguration.builder().withStructureDefinition(structureDefinitionClass.getStructureDefinition()).withTargetNamespace(Optional.ofNullable(structureDefinitionClass.getTargetNamespace())).withClassName(structureDefinitionClass.getClassName()).withInstantiation(structureDefinitionClass.getInstantiation()).withUseVersion(structureDefinitionClass.useVersion());
            for (NestedClass nestedClass : structureDefinitionClass.getNestedClasses()) {
                structureDefinitionClassBuilder.withNestedClass(NestedClassConfiguration.builder().withElementId(nestedClass.getElementId()).withClassName(nestedClass.getClassName()).withSuperClass(nestedClass.getSuperClass()).withInstantiation(nestedClass.getInstantiation()).build());
            }
            arrayList.add(structureDefinitionClassBuilder.build());
        }
        ProcessConfiguration processConfiguration = ProcessConfiguration.builder().withFhirVersion(this.fhirVersion).withOutputPath(this.outputPath).withDefaultNamespace(Optional.ofNullable(this.defaultNamespace)).withPackageSources(packageSourcesConfiguration).withValueSetEnums(valueSetEnumConfigurations).withStructureDefinitionClasses(arrayList).build();
        return (ProcessConfiguration)logger.exit((Object)processConfiguration);
    }

    @Generated
    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    @Generated
    public String getOutputPath() {
        return this.outputPath;
    }

    @Generated
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Generated
    public List<PackageSource> getPackageSources() {
        return this.packageSources;
    }

    @Generated
    public List<ValueSetEnum> getValueSetEnums() {
        return this.valueSetEnums;
    }

    @Generated
    public List<StructureDefinitionClass> getStructureDefinitionClasses() {
        return this.structureDefinitionClasses;
    }

    @Generated
    public void setFhirVersion(FhirVersionEnum fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    @Generated
    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    @Generated
    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    @Generated
    public void setPackageSources(List<PackageSource> packageSources) {
        this.packageSources = packageSources;
    }

    @Generated
    public void setValueSetEnums(List<ValueSetEnum> valueSetEnums) {
        this.valueSetEnums = valueSetEnums;
    }

    @Generated
    public void setStructureDefinitionClasses(List<StructureDefinitionClass> structureDefinitionClasses) {
        this.structureDefinitionClasses = structureDefinitionClasses;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeneratorConfiguration)) {
            return false;
        }
        GeneratorConfiguration other = (GeneratorConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FhirVersionEnum this$fhirVersion = this.getFhirVersion();
        FhirVersionEnum other$fhirVersion = other.getFhirVersion();
        if (this$fhirVersion == null ? other$fhirVersion != null : !this$fhirVersion.equals(other$fhirVersion)) {
            return false;
        }
        String this$outputPath = this.getOutputPath();
        String other$outputPath = other.getOutputPath();
        if (this$outputPath == null ? other$outputPath != null : !this$outputPath.equals(other$outputPath)) {
            return false;
        }
        String this$defaultNamespace = this.getDefaultNamespace();
        String other$defaultNamespace = other.getDefaultNamespace();
        if (this$defaultNamespace == null ? other$defaultNamespace != null : !this$defaultNamespace.equals(other$defaultNamespace)) {
            return false;
        }
        List<PackageSource> this$packageSources = this.getPackageSources();
        List<PackageSource> other$packageSources = other.getPackageSources();
        if (this$packageSources == null ? other$packageSources != null : !((Object)this$packageSources).equals(other$packageSources)) {
            return false;
        }
        List<ValueSetEnum> this$valueSetEnums = this.getValueSetEnums();
        List<ValueSetEnum> other$valueSetEnums = other.getValueSetEnums();
        if (this$valueSetEnums == null ? other$valueSetEnums != null : !((Object)this$valueSetEnums).equals(other$valueSetEnums)) {
            return false;
        }
        List<StructureDefinitionClass> this$structureDefinitionClasses = this.getStructureDefinitionClasses();
        List<StructureDefinitionClass> other$structureDefinitionClasses = other.getStructureDefinitionClasses();
        return !(this$structureDefinitionClasses == null ? other$structureDefinitionClasses != null : !((Object)this$structureDefinitionClasses).equals(other$structureDefinitionClasses));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GeneratorConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FhirVersionEnum $fhirVersion = this.getFhirVersion();
        result = result * 59 + ($fhirVersion == null ? 43 : $fhirVersion.hashCode());
        String $outputPath = this.getOutputPath();
        result = result * 59 + ($outputPath == null ? 43 : $outputPath.hashCode());
        String $defaultNamespace = this.getDefaultNamespace();
        result = result * 59 + ($defaultNamespace == null ? 43 : $defaultNamespace.hashCode());
        List<PackageSource> $packageSources = this.getPackageSources();
        result = result * 59 + ($packageSources == null ? 43 : ((Object)$packageSources).hashCode());
        List<ValueSetEnum> $valueSetEnums = this.getValueSetEnums();
        result = result * 59 + ($valueSetEnums == null ? 43 : ((Object)$valueSetEnums).hashCode());
        List<StructureDefinitionClass> $structureDefinitionClasses = this.getStructureDefinitionClasses();
        result = result * 59 + ($structureDefinitionClasses == null ? 43 : ((Object)$structureDefinitionClasses).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GeneratorConfiguration(fhirVersion=" + String.valueOf(this.getFhirVersion()) + ", outputPath=" + this.getOutputPath() + ", defaultNamespace=" + this.getDefaultNamespace() + ", packageSources=" + String.valueOf(this.getPackageSources()) + ", valueSetEnums=" + String.valueOf(this.getValueSetEnums()) + ", structureDefinitionClasses=" + String.valueOf(this.getStructureDefinitionClasses()) + ")";
    }

    @Generated
    public GeneratorConfiguration() {
    }
}

