/*
 * Decompiled with CFR 0.152.
 */
package de.fhlintstone.cli;

import de.fhlintstone.cli.config.GeneratorConfiguration;
import de.fhlintstone.cli.config.IConfigurationParser;
import de.fhlintstone.process.IProcessor;
import de.fhlintstone.process.ProcessException;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.inject.Named;
import lombok.Generated;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import picocli.CommandLine;

@Named
@CommandLine.Command(name="generate-code", description={"Generates the Java implementation as specified by the configuration file"})
public class GenerateCodeCommand
implements Callable<Integer> {
    @Generated
    private static final XLogger logger = XLoggerFactory.getXLogger(GenerateCodeCommand.class);
    private final IConfigurationParser configurationParser;
    private final IProcessor processor;
    @CommandLine.Parameters(index="0", arity="1", description={"the generator configuration file to use"})
    private File configFile;

    @Inject
    public GenerateCodeCommand(IConfigurationParser configurationParser, IProcessor processor) {
        this.configurationParser = configurationParser;
        this.processor = processor;
    }

    @Override
    public Integer call() {
        Integer rc = 0;
        logger.entry(new Object[0]);
        logger.info("Loading configuration from file {}", (Object)this.configFile.getName());
        GeneratorConfiguration configuration = null;
        try {
            configuration = this.configurationParser.parseGeneratorConfiguration(this.configFile);
        }
        catch (JAXBException e) {
            logger.error("Unable to parse configuration file", (Throwable)e);
            rc = 1;
        }
        if (configuration != null) {
            try {
                logger.info("Starting generator...");
                this.processor.execute(configuration.toProcessorConfiguration());
                logger.info("Done.");
            }
            catch (ProcessException e) {
                logger.error(e.getMessage(), (Throwable)e);
                rc = 2;
            }
        }
        return (Integer)logger.exit((Object)rc);
    }
}

