/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.fokus.nubomedia.paas;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VNFRServiceProfile {
    private static VNFRServiceProfile instance;
    private static final Logger logger;
    private String serverAddress;
    private int serverPort;
    private String vnfrId;
    private String serviceApiUrl;
    private String serviceBaseUrl;

    public VNFRServiceProfile() {
        logger.info("Instantiating the VNFR service profile with ff System Properties;\n VNFM_IP: " + System.getenv("VNFM_IP") + "\nVNFM_PORT: " + System.getenv("VNFM_PORT") + "\n" + System.getenv("VNFR_ID"));
        this.serverAddress = System.getenv("VNFM_IP");
        this.serverPort = Integer.parseInt(System.getenv("VNFM_PORT"));
        this.vnfrId = System.getenv("VNFR_ID");
        if (this.vnfrId == null) {
            instance = null;
        } else {
            this.serviceBaseUrl = "http://" + this.serverAddress + ":" + this.serverPort + "/vnfr";
            this.serviceApiUrl = this.serviceBaseUrl + "/" + this.vnfrId + "/app";
            instance = this;
        }
    }

    public static VNFRServiceProfile getInstance() {
        if (instance == null) {
            new VNFRServiceProfile();
        }
        return instance;
    }

    public String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }

    public String getVnfrId() {
        return this.vnfrId;
    }

    public void setVnfrId(String vnfrId) {
        this.vnfrId = vnfrId;
    }

    public static void setInstance(VNFRServiceProfile instance) {
        VNFRServiceProfile.instance = instance;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getServiceApiUrl() {
        return this.serviceApiUrl;
    }

    static {
        logger = LoggerFactory.getLogger(VNFRServiceProfile.class);
    }
}

