/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.fokus.nubomedia.paas;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.fhg.fokus.nubomedia.paas.ApplicationRecord;
import de.fhg.fokus.nubomedia.paas.ApplicationRecordBody;
import de.fhg.fokus.nubomedia.paas.VNFRService;
import de.fhg.fokus.nubomedia.paas.VNFRServiceProfile;
import de.fhg.fokus.nubomedia.paas.VirtualNetworkFunctionRecord;
import java.util.Arrays;
import java.util.List;
import org.kurento.client.internal.NotEnoughResourcesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class VNFRServiceImpl
implements VNFRService {
    private static final Logger logger = LoggerFactory.getLogger(VNFRServiceImpl.class);
    private VNFRServiceProfile serviceProfile = VNFRServiceProfile.getInstance();
    @Autowired
    private RestTemplate restTemplate = new RestTemplate();
    @Autowired
    private Gson mapper;

    @Override
    public ApplicationRecord registerApplication(String externalAppId, int points) throws NotEnoughResourcesException {
        try {
            if (this.serviceProfile == null) {
                logger.info("Service Profile not set. make sure the VNFR_ID, VNFM_IP and VNFM_PORT are available ");
                return null;
            }
            String URL2 = this.serviceProfile.getServiceApiUrl();
            ApplicationRecordBody bodyObj = new ApplicationRecordBody(externalAppId, points);
            Gson mapper = new GsonBuilder().create();
            String body = mapper.toJson((Object)bodyObj, ApplicationRecordBody.class);
            logger.info("registering new application: \nURL: " + URL2 + "\n + " + body);
            HttpHeaders creationHeader = new HttpHeaders();
            creationHeader.add("Accept", "application/json");
            creationHeader.add("Content-type", "application/json");
            HttpEntity registerEntity = new HttpEntity((Object)body, (MultiValueMap)creationHeader);
            ResponseEntity response = this.restTemplate.exchange(URL2, HttpMethod.POST, registerEntity, String.class, new Object[0]);
            logger.info("response from VNFM " + response);
            HttpStatus status = response.getStatusCode();
            if (status.equals((Object)HttpStatus.CREATED) || status.equals((Object)HttpStatus.OK)) {
                logger.info("Deployment status: " + status + " response: " + response);
                ApplicationRecord responseBody = (ApplicationRecord)mapper.fromJson((String)response.getBody(), ApplicationRecord.class);
                logger.info("returned object " + responseBody.toString());
                return responseBody;
            }
            if (status.equals((Object)HttpStatus.UNPROCESSABLE_ENTITY)) {
                throw new NotEnoughResourcesException("Not enough resource " + response.getBody());
            }
        }
        catch (NotEnoughResourcesException e) {
            logger.error(e.getMessage());
        }
        catch (RestClientException e) {
            logger.error("Error registering application to VNFR - " + e.getMessage());
        }
        return null;
    }

    @Override
    public void unregisterApplication(String internalAppId) {
        String webServiceUrl = this.serviceProfile.getServiceApiUrl() + "/" + internalAppId;
        logger.info("unregistering application " + webServiceUrl);
        ResponseEntity response = this.restTemplate.exchange(webServiceUrl, HttpMethod.DELETE, null, Void.class, new Object[0]);
        Void body = (Void)response.getBody();
    }

    @Override
    public List<VirtualNetworkFunctionRecord> getListRegisteredVNFR() {
        VirtualNetworkFunctionRecord[] list = (VirtualNetworkFunctionRecord[])this.restTemplate.getForObject(this.serviceProfile.getServiceBaseUrl(), VirtualNetworkFunctionRecord[].class, new Object[0]);
        return Arrays.asList(list);
    }

    @Override
    public List<ApplicationRecord> getListRegisteredApplications(String vnfrId) {
        ApplicationRecord[] list = (ApplicationRecord[])this.restTemplate.getForObject(this.serviceProfile.getServiceApiUrl(), ApplicationRecord[].class, new Object[0]);
        return Arrays.asList(list);
    }

    @Override
    public void sendHeartBeat(String internalAppId) {
        String webServiceUrl = this.serviceProfile.getServiceApiUrl() + "/" + internalAppId + "/heartbeat";
        logger.info("sending heartbeat to EMM " + webServiceUrl);
        ResponseEntity response = this.restTemplate.exchange(webServiceUrl, HttpMethod.PUT, null, Void.class, new Object[0]);
        Void body = (Void)response.getBody();
        logger.info("response :" + response);
    }
}

