/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.fokus.nubomedia.kmc;

import de.fhg.fokus.nubomedia.kmc.HeartBeatTimerTask;
import de.fhg.fokus.nubomedia.paas.ApplicationRecord;
import de.fhg.fokus.nubomedia.paas.VNFRService;
import de.fhg.fokus.nubomedia.paas.VNFRServiceImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.kurento.client.internal.KmsProvider;
import org.kurento.client.internal.NotEnoughResourcesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class KmsUrlProvider
implements KmsProvider {
    private static final Logger logger = LoggerFactory.getLogger(KmsUrlProvider.class);
    private VNFRService vnfrService;
    private Map<String, ApplicationRecord> record = new HashMap<String, ApplicationRecord>();
    private Map<String, TimerTask> timerTask = new HashMap<String, TimerTask>();
    private Timer timer = new Timer(true);
    private int timerDelay = 15000;
    private int timerPeriod = 60000;

    public KmsUrlProvider() {
        this.vnfrService = new VNFRServiceImpl();
    }

    public void releaseKms(String applicationId) throws NotEnoughResourcesException {
        try {
            logger.info("releasing KMS..." + applicationId);
            if (this.record.isEmpty()) {
                return;
            }
            this.vnfrService.unregisterApplication(this.record.get(applicationId).getInternalAppId());
            this.record.remove(applicationId);
            this.timerTask.get(applicationId).cancel();
        }
        catch (Exception e) {
            throw new NotEnoughResourcesException("An error occured in releasing the KMS - " + e.getMessage());
        }
    }

    public String reserveKms(String applicationId) throws NotEnoughResourcesException {
        return this.reserveKms(applicationId, 50);
    }

    public String reserveKms(String applicationId, int loadPoints) throws NotEnoughResourcesException {
        ApplicationRecord tmpRecord = this.vnfrService.registerApplication(applicationId, loadPoints);
        this.record.put(applicationId, tmpRecord);
        if (tmpRecord != null) {
            logger.info(tmpRecord.toString());
            HeartBeatTimerTask tmpTimerTask = new HeartBeatTimerTask(this.vnfrService, tmpRecord.getInternalAppId());
            this.timerTask.put(applicationId, tmpTimerTask);
            this.timer.schedule((TimerTask)tmpTimerTask, this.timerDelay, (long)this.timerPeriod);
            return "ws://" + tmpRecord.getIP() + ":8888/kurento";
        }
        throw new NotEnoughResourcesException("An error occured in reserving the KMS");
    }
}

