/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.fokus.nubomedia;

import de.fhg.fokus.nubomedia.kmc.KmsUrlProvider;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;

public class App
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(App.class);

    public static void main(String[] args) {
        SpringApplication.run(App.class, (String[])new String[0]);
    }

    public void run(String ... strings) throws Exception {
        this.registerApplication();
    }

    private void getEnvironmentVariabes() {
        String serverAddress = System.getenv("VNFM_IP");
        int serverPort = Integer.parseInt(System.getenv("VNFM_PORT"));
        String vnfrId = System.getenv("VNFR_ID");
        log.info("Instatiating the VNFR service profile with ff System Properties;\n VNFM_IP: " + serverAddress + "\nVNFM_PORT ....: " + serverPort + "\n" + vnfrId);
    }

    public void makeFile() {
        try {
            String fileName = System.getProperty("user.home") + "/.kurento/config.properties";
            log.info("saving the property file here : " + fileName);
            Properties p = new Properties();
            p.setProperty("kms.url.provider", "de.fhg.fokus.nubomedia.kmc.KmsProvider");
            File file = new File(fileName);
            FileOutputStream fileOut = new FileOutputStream(file);
            p.store(fileOut, "config.properties");
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("property file could not be found!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void registerApplication() {
        KmsUrlProvider provider = new KmsUrlProvider();
        String appId = "abcirephmfpf-098823";
        String url = provider.reserveKms(appId);
        if (url != null) {
            provider.releaseKms(appId);
        }
    }
}

