/*
 * Decompiled with CFR 0.152.
 */
package de.fhg.aisec.ids.idscp2.idscp_core.secure_channel;

import de.fhg.aisec.ids.idscp2.idscp_core.drivers.SecureChannelEndpoint;
import de.fhg.aisec.ids.idscp2.idscp_core.fsm.fsmListeners.ScFsmListener;
import de.fhg.aisec.ids.idscp2.idscp_core.secure_channel.SecureChannelListener;
import java.security.cert.X509Certificate;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel;", "Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannelListener;", "endpoint", "Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;", "peerCertificate", "Ljava/security/cert/X509Certificate;", "(Lde/fhg/aisec/ids/idscp2/idscp_core/drivers/SecureChannelEndpoint;Ljava/security/cert/X509Certificate;)V", "fsmPromise", "Ljava/util/concurrent/CompletableFuture;", "Lde/fhg/aisec/ids/idscp2/idscp_core/fsm/fsmListeners/ScFsmListener;", "isConnected", "", "()Z", "close", "", "onClose", "onError", "t", "", "onMessage", "data", "", "send", "msg", "setFsm", "fsm", "Companion", "idscp2"})
public final class SecureChannel
implements SecureChannelListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecureChannelEndpoint endpoint;
    @Nullable
    private final X509Certificate peerCertificate;
    @NotNull
    private final CompletableFuture<ScFsmListener> fsmPromise;
    private static final Logger LOG = LoggerFactory.getLogger(SecureChannel.class);

    public SecureChannel(@NotNull SecureChannelEndpoint endpoint, @Nullable X509Certificate peerCertificate) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        this.endpoint = endpoint;
        this.peerCertificate = peerCertificate;
        this.fsmPromise = new CompletableFuture();
    }

    public final void close() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Close secure channel");
        }
        this.endpoint.close();
    }

    public final boolean send(@NotNull byte[] msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Send message via secure channel");
        }
        return this.endpoint.send(msg);
    }

    @Override
    public void onMessage(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (LOG.isTraceEnabled()) {
            LOG.trace("New raw data has been received via the secure channel");
        }
        this.fsmPromise.thenAccept(arg_0 -> SecureChannel.onMessage$lambda-0(data, arg_0));
    }

    @Override
    public void onError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Error occurred in secure channel");
        }
        this.fsmPromise.thenAccept(arg_0 -> SecureChannel.onError$lambda-1(t, arg_0));
    }

    @Override
    public void onClose() {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Secure channel received EOF");
        }
        this.fsmPromise.thenAccept(SecureChannel::onClose$lambda-2);
    }

    public final boolean isConnected() {
        return this.endpoint.isConnected();
    }

    public final void setFsm(@NotNull ScFsmListener fsm) {
        Intrinsics.checkNotNullParameter((Object)fsm, (String)"fsm");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bind FSM to secure channel and pass peer certificate to FSM");
        }
        this.fsmPromise.complete(fsm);
        if (this.peerCertificate != null) {
            fsm.setPeerX509Certificate(this.peerCertificate);
        }
    }

    private static final void onMessage$lambda-0(byte[] $data, ScFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)$data, (String)"$data");
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        fsmListener.onMessage($data);
    }

    private static final void onError$lambda-1(Throwable $t, ScFsmListener fsmListener) {
        Intrinsics.checkNotNullParameter((Object)$t, (String)"$t");
        Intrinsics.checkNotNullParameter((Object)fsmListener, (String)"fsmListener");
        fsmListener.onError($t);
    }

    private static final void onClose$lambda-2(ScFsmListener obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.onClose();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lde/fhg/aisec/ids/idscp2/idscp_core/secure_channel/SecureChannel$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "idscp2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

